/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class DeltaRecord
extends Record {
    public static final short sid = 16;
    public static final double DEFAULT_VALUE = 0.001;
    private double field_1_max_change;

    public DeltaRecord() {
    }

    public DeltaRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 16) {
            throw new RecordFormatException("NOT A DELTA RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_max_change = in.readDouble();
    }

    public void setMaxChange(double maxChange) {
        this.field_1_max_change = maxChange;
    }

    public double getMaxChange() {
        return this.field_1_max_change;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DELTA]\n");
        buffer.append("    .maxchange      = ").append(this.getMaxChange()).append("\n");
        buffer.append("[/DELTA]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)16);
        LittleEndian.putShort(data, 2 + offset, (short)8);
        LittleEndian.putDouble(data, 4 + offset, this.getMaxChange());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 16;
    }

    public Object clone() {
        DeltaRecord rec = new DeltaRecord();
        rec.field_1_max_change = this.field_1_max_change;
        return rec;
    }
}

