/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLTools {
    public static final DocumentBuilderFactory DOC_FACTORY = DocumentBuilderFactory.newInstance();
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    public static final TransformerFactory TRANSFORM_FACTORY = TransformerFactory.newInstance();

    private XMLTools() {
    }

    public static Document parseDOM(File file2) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream is = new FileInputStream(file2);
        Document doc = XMLTools.parseDOM(is);
        ((InputStream)is).close();
        return doc;
    }

    public static Document parseDOM(String xml) throws ParserConfigurationException, SAXException, IOException {
        byte[] bytes = xml.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Document doc = XMLTools.parseDOM(is);
        ((InputStream)is).close();
        return doc;
    }

    public static Document parseDOM(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DOC_FACTORY.newDocumentBuilder();
        return db.parse(is);
    }

    public static String getXML(Document doc) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        Transformer transformer = TRANSFORM_FACTORY.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    public static String sanitizeXML(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isISOControl(c) && Character.isDefined(c) && c <= '~') continue;
            s = s.replace(c, ' ');
        }
        return s;
    }

    public static String indentXML(String xml) {
        return XMLTools.indentXML(xml, 3, false);
    }

    public static String indentXML(String xml, int spacing) {
        return XMLTools.indentXML(xml, spacing, false);
    }

    public static String indentXML(String xml, boolean preserveCData) {
        return XMLTools.indentXML(xml, 3, preserveCData);
    }

    public static String indentXML(String xml, int spacing, boolean preserveCData) {
        if (xml == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(xml, "<>", true);
        int indent = 0;
        int noSpace = 0;
        boolean first = true;
        boolean element = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals("")) continue;
            if (token.equals("<")) {
                element = true;
                continue;
            }
            if (element && token.equals(">")) {
                element = false;
                continue;
            }
            if (!element && preserveCData) {
                noSpace = 2;
            }
            if (noSpace == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
            }
            if (element && token.startsWith("/")) {
                indent -= spacing;
            }
            if (noSpace == 0) {
                for (int j = 0; j < indent; ++j) {
                    sb.append(" ");
                }
            }
            if (element) {
                sb.append("<");
            }
            sb.append(token);
            if (element) {
                sb.append(">");
            }
            if (!(noSpace != 0 || !element || token.startsWith("?") || token.startsWith("/") || token.endsWith("/") || token.startsWith("!"))) {
                indent += spacing;
            }
            if (noSpace <= 0) continue;
            --noSpace;
        }
        sb.append("\n");
        return sb.toString();
    }

    public static Hashtable<String, String> parseXML(String xml) throws IOException {
        MetadataHandler handler = new MetadataHandler();
        XMLTools.parseXML(xml, (DefaultHandler)handler);
        return handler.getMetadata();
    }

    public static void parseXML(String xml, DefaultHandler handler) throws IOException {
        XMLTools.parseXML(xml.getBytes(), handler);
    }

    public static void parseXML(RandomAccessInputStream stream, DefaultHandler handler) throws IOException {
        byte[] b = new byte[(int)(stream.length() - stream.getFilePointer())];
        stream.readFully(b);
        XMLTools.parseXML(b, handler);
        b = null;
    }

    public static void parseXML(byte[] xml, DefaultHandler handler) throws IOException {
        try {
            SAXParser parser = SAX_FACTORY.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(xml), handler);
        }
        catch (ParserConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        catch (SAXException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
    }

    public static Templates getStylesheet(String resourcePath, Class<?> sourceClass) {
        InputStream xsltStream;
        if (sourceClass == null) {
            try {
                xsltStream = new FileInputStream(resourcePath);
            }
            catch (IOException exc) {
                LogTools.traceDebug(exc);
                return null;
            }
        } else {
            xsltStream = sourceClass.getResourceAsStream(resourcePath);
        }
        StreamSource xsltSource = new StreamSource(xsltStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            return transformerFactory.newTemplates(xsltSource);
        }
        catch (TransformerConfigurationException exc) {
            LogTools.traceDebug(exc);
            return null;
        }
    }

    public static String transformXML(String xml, Templates xslt) throws IOException {
        return XMLTools.transformXML(new StreamSource(new StringReader(xml)), xslt);
    }

    public static String transformXML(Source xmlSource, Templates xslt) throws IOException {
        Transformer trans;
        try {
            trans = xslt.newTransformer();
        }
        catch (TransformerConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        StringWriter xmlWriter = new StringWriter();
        StreamResult xmlResult = new StreamResult(xmlWriter);
        try {
            trans.transform(xmlSource, xmlResult);
        }
        catch (TransformerException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        return xmlWriter.toString();
    }

    public static boolean validateXML(String xml) {
        return XMLTools.validateXML(xml, null);
    }

    public static boolean validateXML(String xml, String label) {
        if (label == null) {
            label = "XML";
        }
        Exception exception = null;
        LogTools.println("Parsing schema path");
        ValidationSAXHandler saxHandler = new ValidationSAXHandler();
        try {
            SAXParser saxParser = SAX_FACTORY.newSAXParser();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            saxParser.parse((InputStream)is, (DefaultHandler)saxHandler);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LogTools.println("Error parsing schema path from " + label + ":");
            LogTools.trace(exception);
            return false;
        }
        String schemaPath = saxHandler.getSchemaPath();
        if (schemaPath == null) {
            LogTools.println("No schema path found. Validation cannot continue.");
            return false;
        }
        LogTools.println(schemaPath);
        LogTools.println("Validating " + label);
        String xmlSchemaPath = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(xmlSchemaPath);
        URL schemaLocation = null;
        try {
            schemaLocation = new URL(schemaPath);
        }
        catch (MalformedURLException exc) {
            LogTools.println("Error accessing schema at " + schemaPath + ":");
            LogTools.trace(exc);
            return false;
        }
        Schema schema = null;
        try {
            schema = factory.newSchema(schemaLocation);
        }
        catch (SAXException exc) {
            LogTools.println("Error parsing schema at " + schemaPath + ":");
            LogTools.trace(exc);
            return false;
        }
        Validator validator = schema.newValidator();
        StringReader reader = new StringReader(xml);
        InputSource is = new InputSource(reader);
        SAXSource source = new SAXSource(is);
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(source);
        }
        catch (IOException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        if (exception != null) {
            LogTools.println("Error validating document:");
            LogTools.trace(exception);
            return false;
        }
        if (errorHandler.ok()) {
            LogTools.println("No validation errors found.");
        }
        return errorHandler.ok();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetadataHandler
    extends DefaultHandler {
        private String currentQName;
        private Hashtable<String, String> metadata = new Hashtable();

        private MetadataHandler() {
        }

        public Hashtable<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public void characters(char[] data, int start, int len) {
            this.metadata.put(this.currentQName, new String(data, start, len));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentQName = attributes.getLength() == 0 ? this.currentQName + " - " + qName : qName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.metadata.put(qName + " - " + attributes.getQName(i), attributes.getValue(i));
            }
        }
    }

    private static class ValidationErrorHandler
    implements ErrorHandler {
        private boolean ok = true;

        private ValidationErrorHandler() {
        }

        public boolean ok() {
            return this.ok;
        }

        public void error(SAXParseException e) {
            LogTools.println("error: " + e.getMessage());
            this.ok = false;
        }

        public void fatalError(SAXParseException e) {
            LogTools.println("fatal error: " + e.getMessage());
            this.ok = false;
        }

        public void warning(SAXParseException e) {
            LogTools.println("warning: " + e.getMessage());
            this.ok = false;
        }
    }

    private static class ValidationSAXHandler
    extends DefaultHandler {
        private String schemaPath;
        private boolean first;

        private ValidationSAXHandler() {
        }

        public String getSchemaPath() {
            return this.schemaPath;
        }

        public void startDocument() {
            this.schemaPath = null;
            this.first = true;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!this.first) {
                return;
            }
            this.first = false;
            int len = attributes.getLength();
            String xmlns = null;
            String xsiSchemaLocation = null;
            for (int i = 0; i < len; ++i) {
                String name = attributes.getQName(i);
                if (name.equals("xmlns")) {
                    xmlns = attributes.getValue(i);
                    continue;
                }
                if (!name.equals("schemaLocation") && !name.endsWith(":schemaLocation")) continue;
                xsiSchemaLocation = attributes.getValue(i);
            }
            if (xmlns == null || xsiSchemaLocation == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(xsiSchemaLocation);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!xmlns.equals(token)) continue;
                if (!st.hasMoreTokens()) break;
                this.schemaPath = st.nextToken();
                break;
            }
        }
    }
}

