/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import ij.gui.GenericDialog;
import loci.plugins.Updater;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;

public class UpgradeDialog
extends OptionsDialog {
    protected ImporterOptions options;

    public UpgradeDialog(ImporterOptions options) {
        super(options);
        this.options = options;
    }

    public int showDialog() {
        if (this.options.isQuiet()) {
            return 0;
        }
        if (this.options.isFirstTime()) {
            GenericDialog gd = new GenericDialog("Bio-Formats Upgrade Checker");
            gd.addMessage("One-time notice: The LOCI plugins for ImageJ can automatically check for upgrades\neach time they are run. If you wish to disable this feature, uncheck the box below.\nYou can toggle this behavior later in the LOCI Plugins Configuration's \"Upgrade\" tab.");
            this.addCheckbox(gd, "upgradeCheck");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return 1;
            }
        }
        if (this.options.doUpgradeCheck()) {
            boolean doUpgrade;
            IJ.showStatus((String)"Checking for new version...");
            if (Updater.newVersionAvailable() && (doUpgrade = IJ.showMessageWithCancel((String)"", (String)"A new stable version of Bio-Formats is available.\nClick 'OK' to upgrade now, or 'Cancel' to skip for now."))) {
                Updater.install("http://loci.wisc.edu/software/loci_tools.jar");
            }
        }
        return 0;
    }
}

