/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.DimensionSwapper;
import loci.formats.FileInfo;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.StatusListener;
import loci.formats.meta.MetadataStore;

public class FileStitcher
implements IFormatReader {
    private DimensionSwapper reader;
    private boolean patternIds = false;
    private String currentId;
    private FilePattern fp;
    private AxisGuesser[] ag;
    private String[][] files;
    private String[] usedFiles;
    private DimensionSwapper[][] readers;
    private byte[][] blankBytes;
    private byte[][] blankThumbBytes;
    private int[] imagesPerFile;
    private int[] sizeZ;
    private int[] sizeC;
    private int[] sizeT;
    private int[][] lenZ;
    private int[][] lenC;
    private int[][] lenT;
    private CoreMetadata[] core;
    private int series;
    private String[] originalOrder;
    private String[] seriesBlocks;
    private Vector fileVector;
    private Vector<String> seriesNames;
    private boolean seriesInFile;
    private boolean noStitch;
    private MetadataStore store;

    public FileStitcher() {
        this(new ImageReader());
    }

    public FileStitcher(boolean patternIds) {
        this(new ImageReader(), patternIds);
    }

    public FileStitcher(IFormatReader r) {
        this(r, false);
    }

    public FileStitcher(IFormatReader r, boolean patternIds) {
        this.reader = DimensionSwapper.makeDimensionSwapper(r);
        this.patternIds = patternIds;
    }

    public IFormatReader getReader() {
        return this.reader;
    }

    public IFormatReader getReader(int no) throws FormatException, IOException {
        if (this.noStitch) {
            return this.reader;
        }
        int[] q = this.computeIndices(no);
        int sno = this.seriesInFile ? 0 : this.getSeries();
        int fno = q[0];
        DimensionSwapper r = this.readers[sno][fno];
        if (this.seriesInFile) {
            r.setSeries(this.getSeries());
        }
        return r;
    }

    public int getAdjustedIndex(int no) throws FormatException, IOException {
        if (this.noStitch) {
            return no;
        }
        int[] q = this.computeIndices(no);
        int ino = q[1];
        return ino;
    }

    public int[] getAxisTypes() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.ag[this.getSeries()].getAxisTypes();
    }

    public void setAxisTypes(int[] axes) throws FormatException {
        FormatTools.assertId(this.currentId, true, 2);
        this.ag[this.getSeries()].setAxisTypes(axes);
        this.computeAxisLengths();
    }

    public FilePattern getFilePattern() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.fp;
    }

    public AxisGuesser getAxisGuesser() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.ag[this.getSeries()];
    }

    public FilePattern findPattern(String id) {
        FormatTools.assertId(this.currentId, true, 2);
        if (!this.patternIds) {
            HashMap<String, Object> map = Location.getIdMap();
            String pattern = null;
            if (map.containsKey(id)) {
                String[] idList = new String[map.size()];
                map.keySet().toArray(idList);
                pattern = FilePattern.findPattern(id, null, idList);
            } else {
                pattern = FilePattern.findPattern(new Location(id));
            }
            if (pattern != null) {
                id = pattern;
            }
        }
        return new FilePattern(id);
    }

    public boolean isThisType(String name, boolean open) {
        return this.reader.isThisType(name, open);
    }

    public boolean isThisType(byte[] block) {
        return this.reader.isThisType(block);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.reader.isThisType(stream);
    }

    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getImageCount() : this.core[this.getSeries()].imageCount;
    }

    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isRGB() : this.core[this.getSeries()].rgb;
    }

    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getSizeX() : this.core[this.getSeries()].sizeX;
    }

    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getSizeY() : this.core[this.getSeries()].sizeY;
    }

    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getSizeZ() : this.core[this.getSeries()].sizeZ;
    }

    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getSizeC() : this.core[this.getSeries()].sizeC;
    }

    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getSizeT() : this.core[this.getSeries()].sizeT;
    }

    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getPixelType() : this.core[this.getSeries()].pixelType;
    }

    public int getBitsPerPixel() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getBitsPerPixel() : this.core[this.getSeries()].bitsPerPixel;
    }

    public int getEffectiveSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getImageCount() / (this.getSizeZ() * this.getSizeT());
    }

    public int getRGBChannelCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getSizeC() / this.getEffectiveSizeC();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isIndexed() : this.core[this.getSeries()].indexed;
    }

    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isFalseColor() : this.core[this.getSeries()].falseColor;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.get8BitLookupTable() : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.get16BitLookupTable() : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].get16BitLookupTable();
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 2);
        if (this.noStitch) {
            return this.reader.getChannelDimLengths();
        }
        if (this.core[this.getSeries()].cLengths == null) {
            return new int[]{this.core[this.getSeries()].sizeC};
        }
        return this.core[this.getSeries()].cLengths;
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 2);
        if (this.noStitch) {
            return this.reader.getChannelDimTypes();
        }
        if (this.core[this.getSeries()].cTypes == null) {
            return new String[]{"Channel"};
        }
        return this.core[this.getSeries()].cTypes;
    }

    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getThumbSizeX() : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].getThumbSizeX();
    }

    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getThumbSizeY() : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].getThumbSizeY();
    }

    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isLittleEndian() : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].isLittleEndian();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 2);
        if (this.noStitch) {
            return this.reader.getDimensionOrder();
        }
        return this.originalOrder[this.getSeries()];
    }

    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isOrderCertain() : this.core[this.getSeries()].orderCertain;
    }

    public boolean isThumbnailSeries() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isThumbnailSeries() : this.core[this.getSeries()].thumbnail;
    }

    public boolean isInterleaved() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isInterleaved() : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.isInterleaved(subC) : this.readers[this.seriesInFile ? 0 : this.getSeries()][0].isInterleaved(subC);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        IFormatReader r = this.getReader(no);
        int ino = this.getAdjustedIndex(no);
        if (ino < r.getImageCount()) {
            return r.openBytes(ino, x, y, w, h);
        }
        int sno = this.getSeries();
        if (this.blankBytes[sno] == null) {
            int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
            this.blankBytes[sno] = new byte[w * h * bytes * this.getRGBChannelCount()];
        }
        return this.blankBytes[sno];
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        IFormatReader r = this.getReader(no);
        int ino = this.getAdjustedIndex(no);
        if (ino < r.getImageCount()) {
            return r.openBytes(ino, buf, x, y, w, h);
        }
        Arrays.fill(buf, (byte)0);
        return buf;
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        IFormatReader r = this.getReader(no);
        int ino = this.getAdjustedIndex(no);
        if (ino < r.getImageCount()) {
            return r.openPlane(ino, x, y, w, h);
        }
        return null;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        IFormatReader r = this.getReader(no);
        int ino = this.getAdjustedIndex(no);
        if (ino < r.getImageCount()) {
            return r.openThumbBytes(ino);
        }
        int sno = this.getSeries();
        if (this.blankThumbBytes[sno] == null) {
            int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
            this.blankThumbBytes[sno] = new byte[this.getThumbSizeX() * this.getThumbSizeY() * bytes * this.getRGBChannelCount()];
        }
        return this.blankThumbBytes[sno];
    }

    public void close(boolean fileOnly) throws IOException {
        if (this.readers == null) {
            this.reader.close(fileOnly);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                for (int j = 0; j < this.readers[i].length; ++j) {
                    this.readers[i][j].close(fileOnly);
                }
            }
        }
        if (!fileOnly) {
            this.noStitch = false;
            this.readers = null;
            this.blankBytes = null;
            this.currentId = null;
            this.fp = null;
            this.ag = null;
            this.files = null;
            this.usedFiles = null;
            this.blankThumbBytes = null;
            this.imagesPerFile = null;
            this.sizeT = null;
            this.sizeC = null;
            this.sizeZ = null;
            this.lenT = null;
            this.lenC = this.lenT;
            this.lenZ = this.lenT;
            this.core = null;
            this.series = 0;
            this.seriesBlocks = null;
            this.fileVector = null;
            this.seriesNames = null;
            this.seriesInFile = false;
            this.store = null;
            this.originalOrder = null;
        }
    }

    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getSeriesCount() : this.core.length;
    }

    public void setSeries(int no) {
        FormatTools.assertId(this.currentId, true, 2);
        int n = this.reader.getSeriesCount();
        if (n > 1) {
            this.reader.setSeries(no);
        } else {
            this.series = no;
        }
    }

    public int getSeries() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.seriesInFile || this.noStitch ? this.reader.getSeries() : this.series;
    }

    public void setGroupFiles(boolean group) {
        this.reader.setGroupFiles(group);
        for (int i = 0; i < this.readers.length; ++i) {
            for (int j = 0; j < this.readers[i].length; ++j) {
                this.readers[i][j].setGroupFiles(group);
            }
        }
    }

    public boolean isGroupFiles() {
        return this.reader.isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.reader.fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        return this.reader.isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 2);
        if (this.readers == null) {
            this.reader.setNormalized(normalize);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                for (int j = 0; j < this.readers[i].length; ++j) {
                    this.readers[i][j].setNormalized(normalize);
                }
            }
        }
    }

    public boolean isNormalized() {
        return this.reader.isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 2);
        if (this.readers == null) {
            this.reader.setMetadataCollected(collect);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                for (int j = 0; j < this.readers[i].length; ++j) {
                    this.readers[i][j].setMetadataCollected(collect);
                }
            }
        }
    }

    public boolean isMetadataCollected() {
        return this.reader.isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        if (this.readers == null) {
            this.reader.setOriginalMetadataPopulated(populate);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                for (int j = 0; j < this.readers[i].length; ++j) {
                    this.readers[i][j].setOriginalMetadataPopulated(populate);
                }
            }
        }
    }

    public boolean isOriginalMetadataPopulated() {
        return this.reader.isOriginalMetadataPopulated();
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 2);
        if (this.noStitch) {
            return this.reader.getUsedFiles();
        }
        if (this.reader.getUsedFiles().length > 1) {
            if (this.usedFiles == null) {
                int i;
                String[][][] used = new String[this.files.length][][];
                int total = 0;
                for (i = 0; i < this.files.length; ++i) {
                    used[i] = new String[this.files[i].length][];
                    for (int j = 0; j < this.files[i].length; ++j) {
                        try {
                            this.initReader(i, j);
                        }
                        catch (FormatException exc) {
                            LogTools.trace(exc);
                            return null;
                        }
                        catch (IOException exc) {
                            LogTools.trace(exc);
                            return null;
                        }
                        used[i][j] = this.readers[i][j].getUsedFiles();
                        total += used[i][j].length;
                    }
                }
                this.usedFiles = new String[total];
                int off = 0;
                for (i = 0; i < used.length; ++i) {
                    for (int j = 0; j < used[i].length; ++j) {
                        System.arraycopy(used[i][j], 0, this.usedFiles, off, used[i][j].length);
                        off += used[i][j].length;
                    }
                }
            }
            return this.usedFiles;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.files.length; ++i) {
            for (int j = 0; j < this.files[i].length; ++j) {
                v.add(this.files[i][j]);
            }
        }
        return v.toArray(new String[0]);
    }

    public String[] getUsedFiles(boolean noPixels) {
        return noPixels && this.noStitch ? this.reader.getUsedFiles(noPixels) : this.getUsedFiles();
    }

    public String[] getSeriesUsedFiles() {
        return this.getUsedFiles();
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        return this.getUsedFiles(noPixels);
    }

    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        String[] files = this.getUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            try {
                infos[i].reader = this.reader.unwrap().getClass();
            }
            catch (FormatException e) {
                LogTools.traceDebug(e);
            }
            catch (IOException e) {
                LogTools.traceDebug(e);
            }
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        String[] files = this.getSeriesUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            try {
                infos[i].reader = this.reader.unwrap().getClass();
            }
            catch (FormatException e) {
                LogTools.traceDebug(e);
            }
            catch (IOException e) {
                LogTools.traceDebug(e);
            }
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    public String getCurrentFile() {
        return this.currentId;
    }

    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 2);
        return FormatTools.getIndex(this, z, c, t);
    }

    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getZCTCoords(index) : FormatTools.getZCTCoords(this.core[this.getSeries()].dimensionOrder, this.getSizeZ(), this.getEffectiveSizeC(), this.getSizeT(), this.getImageCount(), index);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getMetadataValue(field);
    }

    public Hashtable getGlobalMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getGlobalMetadata();
    }

    public Hashtable getSeriesMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getSeriesMetadata();
    }

    public Hashtable getMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getMetadata();
    }

    public CoreMetadata[] getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getCoreMetadata() : this.core;
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 2);
        this.reader.setMetadataFiltered(filter);
    }

    public boolean isMetadataFiltered() {
        return this.reader.isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 2);
        this.reader.setMetadataStore(store);
    }

    public MetadataStore getMetadataStore() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getMetadataStore() : this.store;
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.noStitch ? this.reader.getMetadataStoreRoot() : this.store.getRoot();
    }

    public IFormatReader[] getUnderlyingReaders() {
        Vector<DimensionSwapper> v = new Vector<DimensionSwapper>();
        for (int i = 0; i < this.readers.length; ++i) {
            for (int j = 0; j < this.readers[i].length; ++j) {
                v.add(this.readers[i][j]);
            }
        }
        return v.toArray(new IFormatReader[0]);
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return this.reader.isSingleFile(id);
    }

    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.reader.getPossibleDomains(id);
    }

    public String[] getDomains() {
        return this.reader.getDomains();
    }

    public boolean isThisType(String name) {
        return this.reader.isThisType(name);
    }

    public String getFormat() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getFormat();
    }

    public String[] getSuffixes() {
        return this.reader.getSuffixes();
    }

    public Class getNativeDataType() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.reader.getNativeDataType();
    }

    public void setId(String id) throws FormatException, IOException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void addStatusListener(StatusListener l) {
        if (this.readers == null) {
            this.reader.addStatusListener(l);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                for (int j = 0; j < this.readers[i].length; ++j) {
                    this.readers[i][j].addStatusListener(l);
                }
            }
        }
    }

    public void removeStatusListener(StatusListener l) {
        if (this.readers == null) {
            this.reader.removeStatusListener(l);
        } else {
            for (int i = 0; i < this.readers.length; ++i) {
                for (int j = 0; j < this.readers[i].length; ++j) {
                    this.readers[i][j].removeStatusListener(l);
                }
            }
        }
    }

    public StatusListener[] getStatusListeners() {
        return this.reader.getStatusListeners();
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        LogTools.debug("initFile: " + id);
        this.close();
        this.currentId = id;
        this.fp = this.findPattern(this.currentId);
        boolean mustGroup = false;
        if (this.patternIds) {
            mustGroup = this.fp.isValid() && this.reader.fileGroupOption(this.fp.getFiles()[0]) == 0;
        } else {
            boolean bl = mustGroup = this.reader.fileGroupOption(id) == 0;
        }
        if (mustGroup) {
            this.noStitch = true;
            if (this.patternIds && this.fp.isValid()) {
                this.reader.setId(this.fp.getFiles()[0]);
            } else {
                this.reader.setId(this.currentId);
            }
            return;
        }
        if (!this.fp.isValid()) {
            throw new FormatException("Invalid file pattern: " + this.fp.getPattern());
        }
        this.reader.setId(this.fp.getFiles()[0]);
        if (this.reader.getUsedFiles().length > 1) {
            this.noStitch = true;
            return;
        }
        AxisGuesser guesser = new AxisGuesser(this.fp, this.reader.getDimensionOrder(), this.reader.getSizeZ(), this.reader.getSizeT(), this.reader.getEffectiveSizeC(), this.reader.isOrderCertain());
        this.reader.swapDimensions(guesser.getAdjustedOrder());
        int seriesCount = this.reader.getSeriesCount();
        this.seriesInFile = true;
        if (guesser.getAxisCountS() > 0) {
            int i2;
            int[] axes = guesser.getAxisTypes();
            this.seriesInFile = false;
            String[] blockPrefixes = this.fp.getPrefixes();
            Vector<String> sBlock = new Vector<String>();
            for (int i3 = 0; i3 < axes.length; ++i3) {
                if (axes[i3] != 4) continue;
                sBlock.add(blockPrefixes[i3]);
            }
            this.seriesBlocks = sBlock.toArray(new String[0]);
            this.fileVector = new Vector();
            this.seriesNames = new Vector();
            String file2 = this.fp.getFiles()[0];
            Location dir = new Location(file2).getAbsoluteFile().getParentFile();
            String dpath = dir.getAbsolutePath();
            String[] fs = dir.list();
            String ext = "";
            if (file2.indexOf(".") != -1) {
                ext = file2.substring(file2.lastIndexOf(".") + 1);
            }
            Vector<String> tmpFiles = new Vector<String>();
            for (i2 = 0; i2 < fs.length; ++i2) {
                if (!fs[i2].endsWith(ext)) continue;
                tmpFiles.add(fs[i2]);
            }
            this.setFiles(tmpFiles.toArray(new String[0]), this.seriesBlocks[0], this.fp.getFirst()[0], this.fp.getLast()[0], this.fp.getStep()[0], dpath, 0);
            seriesCount = this.fileVector.size();
            this.files = new String[seriesCount][];
            for (i2 = 0; i2 < seriesCount; ++i2) {
                this.files[i2] = (String[])this.fileVector.get(i2);
            }
        }
        String msg = " Please rename your files or disable file stitching.";
        if (!this.fp.isValid()) {
            throw new FormatException("Invalid " + (this.patternIds ? "file pattern" : "filename") + " (" + this.currentId + "): " + this.fp.getErrorMessage() + msg);
        }
        if (this.files == null) {
            this.files = new String[1][];
            this.files[0] = this.fp.getFiles();
        }
        if (this.files == null) {
            throw new FormatException("No files matching pattern (" + this.fp.getPattern() + "). " + msg);
        }
        for (int i4 = 0; i4 < this.files.length; ++i4) {
            for (int j = 0; j < this.files[i4].length; ++j) {
                if (new Location(this.files[i4][j]).exists()) continue;
                throw new FormatException("File #" + i4 + " (" + this.files[i4][j] + ") does not exist.");
            }
        }
        Class<?> readerClass = this.reader.unwrap(this.files[0][0]).getClass();
        this.readers = new DimensionSwapper[this.files.length][];
        for (int i5 = 0; i5 < this.readers.length; ++i5) {
            this.readers[i5] = new DimensionSwapper[this.files[i5].length];
            for (int j = 0; j < this.readers[i5].length; ++j) {
                this.readers[i5][j] = i5 == 0 && j == 0 ? this.reader : (DimensionSwapper)this.reader.duplicate(readerClass);
            }
        }
        this.ag = new AxisGuesser[seriesCount];
        this.blankBytes = new byte[seriesCount][];
        this.blankThumbBytes = new byte[seriesCount][];
        this.imagesPerFile = new int[seriesCount];
        this.sizeZ = new int[seriesCount];
        this.sizeC = new int[seriesCount];
        this.sizeT = new int[seriesCount];
        boolean[] certain = new boolean[seriesCount];
        this.lenZ = new int[seriesCount][];
        this.lenC = new int[seriesCount][];
        this.lenT = new int[seriesCount][];
        this.originalOrder = new String[seriesCount];
        this.core = new CoreMetadata[seriesCount];
        int oldSeries = this.reader.getSeries();
        DimensionSwapper rr = this.reader;
        for (i = 0; i < seriesCount; ++i) {
            if (this.seriesInFile) {
                rr.setSeries(i);
            } else {
                this.initReader(i, 0);
                rr = this.readers[i][0];
            }
            this.core[i] = new CoreMetadata();
            this.core[i].sizeX = rr.getSizeX();
            this.core[i].sizeY = rr.getSizeY();
            this.core[i].pixelType = rr.getPixelType();
            this.imagesPerFile[i] = rr.getImageCount();
            this.core[i].imageCount = this.imagesPerFile[i] * this.files[this.seriesInFile ? 0 : i].length;
            this.core[i].thumbSizeX = rr.getThumbSizeX();
            this.core[i].thumbSizeY = rr.getThumbSizeY();
            this.core[i].dimensionOrder = rr.getDimensionOrder();
            this.originalOrder[i] = rr.getDimensionOrder();
            this.core[i].rgb = rr.isRGB();
            this.core[i].littleEndian = rr.isLittleEndian();
            this.core[i].interleaved = rr.isInterleaved();
            this.core[i].seriesMetadata = rr.getSeriesMetadata();
            this.core[i].indexed = rr.isIndexed();
            this.core[i].falseColor = rr.isFalseColor();
            this.sizeZ[i] = rr.getSizeZ();
            this.sizeC[i] = rr.getSizeC();
            this.sizeT[i] = rr.getSizeT();
            certain[i] = rr.isOrderCertain();
        }
        this.reader.setSeries(oldSeries);
        for (i = 0; i < seriesCount; ++i) {
            this.ag[i] = new AxisGuesser(this.fp, this.core[i].dimensionOrder, this.sizeZ[i], this.sizeT[i], this.sizeC[i], certain[i]);
        }
        for (i = 0; i < seriesCount; ++i) {
            this.setSeries(i);
            this.core[i].dimensionOrder = this.ag[i].getAdjustedOrder();
            this.core[i].orderCertain = this.ag[i].isCertain();
            this.computeAxisLengths();
        }
        this.setSeries(oldSeries);
        this.store = this.reader.getMetadataStore();
        if (!this.seriesInFile || this.files.length > 1 || this.files[0].length > 1) {
            MetadataTools.populatePixels(this.store, this);
        }
        for (i = 0; i < this.core.length; ++i) {
            if (this.seriesNames == null || this.seriesInFile) continue;
            this.store.setImageName(this.seriesNames.get(i), i);
        }
    }

    protected void computeAxisLengths() throws FormatException {
        int i;
        int i2;
        int sno = this.seriesInFile ? 0 : this.getSeries();
        FilePattern p = new FilePattern(FilePattern.findPattern(this.files[sno][0], new Location(this.files[sno][0]).getAbsoluteFile().getParentFile().getPath(), this.files[sno]));
        int[] count = p.getCount();
        try {
            this.initReader(sno, 0);
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
        this.ag[this.getSeries()] = new AxisGuesser(p, this.readers[sno][0].getDimensionOrder(), this.readers[sno][0].getSizeZ(), this.readers[sno][0].getSizeT(), this.readers[sno][0].getSizeC(), this.readers[sno][0].isOrderCertain());
        sno = this.getSeries();
        int[] axes = this.ag[sno].getAxisTypes();
        int numZ = this.ag[sno].getAxisCountZ();
        int numC = this.ag[sno].getAxisCountC();
        int numT = this.ag[sno].getAxisCountT();
        this.core[sno].sizeZ = this.sizeZ[sno];
        this.core[sno].sizeC = this.sizeC[sno];
        this.core[sno].sizeT = this.sizeT[sno];
        this.lenZ[sno] = new int[numZ + 1];
        this.lenC[sno] = new int[numC + 1];
        this.lenT[sno] = new int[numT + 1];
        this.lenZ[sno][0] = this.sizeZ[sno];
        this.lenC[sno][0] = this.sizeC[sno];
        this.lenT[sno][0] = this.sizeT[sno];
        int z = 1;
        int c = 1;
        int t = 1;
        block8: for (int i3 = 0; i3 < count.length; ++i3) {
            switch (axes[i3]) {
                case 1: {
                    this.core[sno].sizeZ *= count[i3];
                    this.lenZ[sno][z++] = count[i3];
                    continue block8;
                }
                case 3: {
                    this.core[sno].sizeC *= count[i3];
                    this.lenC[sno][c++] = count[i3];
                    continue block8;
                }
                case 2: {
                    this.core[sno].sizeT *= count[i3];
                    this.lenT[sno][t++] = count[i3];
                    continue block8;
                }
                case 4: {
                    continue block8;
                }
                default: {
                    throw new FormatException("Unknown axis type for axis #" + i3 + ": " + axes[i3]);
                }
            }
        }
        int[] cLengths = this.reader.getChannelDimLengths();
        String[] cTypes = this.reader.getChannelDimTypes();
        int cCount = 0;
        for (i2 = 0; i2 < cLengths.length; ++i2) {
            if (cLengths[i2] <= 1) continue;
            ++cCount;
        }
        for (i2 = 1; i2 < this.lenC[sno].length; ++i2) {
            if (this.lenC[sno][i2] <= 1) continue;
            ++cCount;
        }
        if (cCount == 0) {
            this.core[sno].cLengths = new int[]{1};
            this.core[sno].cTypes = new String[]{"Channel"};
        } else {
            this.core[sno].cLengths = new int[cCount];
            this.core[sno].cTypes = new String[cCount];
        }
        int c2 = 0;
        for (i = 0; i < cLengths.length; ++i) {
            if (cLengths[i] == 1) continue;
            this.core[sno].cLengths[c2] = cLengths[i];
            this.core[sno].cTypes[c2] = cTypes[i];
            ++c2;
        }
        for (i = 1; i < this.lenC[sno].length; ++i) {
            if (this.lenC[sno][i] == 1) continue;
            this.core[sno].cLengths[c2] = this.lenC[sno][i];
            this.core[sno].cTypes[c2] = "Channel";
        }
    }

    protected int[] computeIndices(int no) throws FormatException, IOException {
        int ino;
        int sno = this.getSeries();
        int[] axes = this.ag[sno].getAxisTypes();
        int[] count = this.fp.getCount();
        int[] zct = this.getZCTCoords(no);
        int[] posZ = FormatTools.rasterToPosition(this.lenZ[sno], zct[0]);
        int[] posC = FormatTools.rasterToPosition(this.lenC[sno], zct[1]);
        int[] posT = FormatTools.rasterToPosition(this.lenT[sno], zct[2]);
        int[] tmpZ = new int[posZ.length];
        System.arraycopy(posZ, 0, tmpZ, 0, tmpZ.length);
        int[] tmpC = new int[posC.length];
        System.arraycopy(posC, 0, tmpC, 0, tmpC.length);
        int[] tmpT = new int[posT.length];
        System.arraycopy(posT, 0, tmpT, 0, tmpT.length);
        for (int i = 0; i < 3; ++i) {
            char originalAxis = this.core[sno].dimensionOrder.charAt(i + 2);
            char newAxis = this.originalOrder[sno].charAt(i + 2);
            if (newAxis == originalAxis) continue;
            int src = -1;
            if (originalAxis == 'Z') {
                src = tmpZ[tmpZ.length - 1];
            } else if (originalAxis == 'C') {
                src = tmpC[tmpC.length - 1];
            } else if (originalAxis == 'T') {
                src = tmpT[tmpT.length - 1];
            }
            if (newAxis == 'Z') {
                posZ[posZ.length - 1] = src;
                continue;
            }
            if (newAxis == 'C') {
                posC[posC.length - 1] = src;
                continue;
            }
            if (newAxis != 'T') continue;
            posT[posT.length - 1] = src;
        }
        int[] pos = new int[axes.length];
        int z = 1;
        int c = 1;
        int t = 1;
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i] == 1) {
                pos[i] = posZ[z++];
                continue;
            }
            if (axes[i] == 3) {
                pos[i] = posC[c++];
                continue;
            }
            if (axes[i] == 2) {
                pos[i] = posT[t++];
                continue;
            }
            throw new FormatException("Unknown axis type for axis #" + i + ": " + axes[i]);
        }
        int fno = FormatTools.positionToRaster(count, pos);
        if (this.seriesInFile) {
            sno = 0;
        }
        this.initReader(sno, fno);
        if (posZ[0] < this.readers[sno][fno].getSizeZ() && posC[0] < this.readers[sno][fno].getSizeC() && posT[0] < this.readers[sno][fno].getSizeT()) {
            if (this.readers[sno][fno].isRGB() && posC[0] * this.readers[sno][fno].getRGBChannelCount() >= this.lenC[sno][0]) {
                posC[0] = posC[0] / this.lenC[sno][0];
            }
            ino = FormatTools.getIndex(this.readers[sno][fno], posZ[0], posC[0], posT[0]);
        } else {
            ino = Integer.MAX_VALUE;
        }
        return new int[]{fno, ino};
    }

    protected int[] getIncludeList(int theC) throws FormatException, IOException {
        int[] include = new int[this.readers.length];
        Arrays.fill(include, -1);
        for (int t = 0; t < this.sizeT[this.getSeries()]; ++t) {
            for (int z = 0; z < this.sizeZ[this.getSeries()]; ++z) {
                int ino;
                int no = this.getIndex(z, theC, t);
                int[] q = this.computeIndices(no);
                int fno = q[0];
                include[fno] = ino = q[1];
            }
        }
        return include;
    }

    protected void initReader(int sno, int fno) throws FormatException, IOException {
        if (this.files[sno][fno].equals(this.readers[sno][fno].getCurrentFile())) {
            return;
        }
        this.readers[sno][fno].setId(this.files[sno][fno]);
        this.readers[sno][fno].setSeries(this.seriesInFile ? this.getSeries() : 0);
        this.readers[sno][fno].swapDimensions(this.reader.getInputOrder());
    }

    private FilePattern getPattern(String[] f, String dir, String block) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < f.length; ++i) {
            if (f[i].indexOf(File.separator) != -1) {
                f[i] = f[i].substring(f[i].lastIndexOf(File.separator) + 1);
            }
            f[i] = dir.endsWith(File.separator) ? dir + f[i] : dir + File.separator + f[i];
            if (f[i].indexOf(block) == -1 || !new Location(f[i]).exists()) continue;
            v.add(f[i].substring(f[i].lastIndexOf(File.separator) + 1));
        }
        f = v.toArray(new String[0]);
        return new FilePattern(FilePattern.findPattern(f[0], dir, f));
    }

    private void setFiles(String[] list, String prefix, BigInteger first, BigInteger last, BigInteger step, String dir, int blockNum) {
        long f = first.longValue();
        long l = last.longValue();
        long s = step.longValue();
        for (long i = f; i <= l; i += s) {
            FilePattern newPattern = this.getPattern(list, dir, prefix + i);
            if (blockNum == this.seriesBlocks.length - 1) {
                this.fileVector.add(newPattern.getFiles());
                String name = newPattern.getPattern();
                if (name.indexOf(File.separator) != -1) {
                    name = name.substring(name.lastIndexOf(File.separator) + 1);
                }
                this.seriesNames.add(name);
                continue;
            }
            String next = this.seriesBlocks[blockNum + 1];
            String[] blocks = newPattern.getPrefixes();
            BigInteger fi = null;
            BigInteger la = null;
            BigInteger st = null;
            for (int q = 0; q < blocks.length; ++q) {
                if (blocks[q].indexOf(next) == -1) continue;
                fi = newPattern.getFirst()[q];
                la = newPattern.getLast()[q];
                st = newPattern.getStep()[q];
                break;
            }
            this.setFiles(newPattern.getFiles(), next, fi, la, st, dir, blockNum + 1);
        }
    }
}

