/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContrastMethod implements Enumeration
{
    BRIGHTFIELD("Brightfield"),
    PHASE("Phase"),
    DIC("DIC"),
    HOFFMANMODULATION("HoffmanModulation"),
    OBLIQUEILLUMINATION("ObliqueIllumination"),
    POLARIZEDLIGHT("PolarizedLight"),
    DARKFIELD("Darkfield"),
    FLUORESCENCE("Fluorescence"),
    OTHER("Other");

    private final String value;

    private ContrastMethod(String value) {
        this.value = value;
    }

    public static ContrastMethod fromString(String value) throws EnumerationException {
        if ("Brightfield".equals(value)) {
            return BRIGHTFIELD;
        }
        if ("Phase".equals(value)) {
            return PHASE;
        }
        if ("DIC".equals(value)) {
            return DIC;
        }
        if ("HoffmanModulation".equals(value)) {
            return HOFFMANMODULATION;
        }
        if ("ObliqueIllumination".equals(value)) {
            return OBLIQUEILLUMINATION;
        }
        if ("PolarizedLight".equals(value)) {
            return POLARIZEDLIGHT;
        }
        if ("Darkfield".equals(value)) {
            return DARKFIELD;
        }
        if ("Fluorescence".equals(value)) {
            return FLUORESCENCE;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, ContrastMethod.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

