/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerFactory {
    private static final String HANDLER_PACKAGE = "loci.formats.enums.handler.";

    public static IEnumerationHandler getHandler(Class<? extends Enumeration> type) throws EnumerationException {
        String typeName = type.getSimpleName();
        String handlerName = HANDLER_PACKAGE + typeName + "EnumHandler";
        Exception cause = null;
        try {
            Class<?> handlerClass = Class.forName(handlerName);
            return (IEnumerationHandler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException c) {
            cause = c;
        }
        catch (ClassCastException c) {
            cause = c;
        }
        catch (InstantiationException i) {
            cause = i;
        }
        catch (IllegalAccessException i) {
            cause = i;
        }
        throw new EnumerationException("Could not find handler for enumeration " + type, cause);
    }
}

