/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.NamingConvention;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingConventionEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = NamingConventionEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*letter", "letter");
        p.put("^\\s*number", "number");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.matches(pattern)) continue;
            String v = patterns.get(pattern);
            return NamingConvention.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return NamingConvention.class;
    }
}

