/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class ARFReader
extends FormatReader {
    public ARFReader() {
        super("ARF", "arf");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        byte endian1 = stream.readByte();
        byte endian2 = stream.readByte();
        return (endian1 == 1 && endian2 == 0 || endian1 == 0 && endian2 == 1) && stream.readString(2).startsWith("AR");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(524 + no * FormatTools.getPlaneSize(this));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        boolean little;
        this.debug("ARFReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Reading file header");
        byte endian1 = this.in.readByte();
        byte endian2 = this.in.readByte();
        if (endian1 == 1 && endian2 == 0) {
            little = true;
        } else if (endian1 == 0 && endian2 == 1) {
            little = false;
        } else {
            throw new FormatException("Undefined endianness");
        }
        this.in.order(little);
        this.in.skipBytes(2);
        int version = this.in.readUnsignedShort();
        int width = this.in.readUnsignedShort();
        int height = this.in.readUnsignedShort();
        int bitsPerPixel = this.in.readUnsignedShort();
        int numImages = version == 2 ? this.in.readUnsignedShort() : 1;
        this.core[0].sizeX = width;
        this.core[0].sizeY = height;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = numImages;
        if (bitsPerPixel > 32) {
            throw new FormatException("Too many bits per pixel: " + bitsPerPixel);
        }
        this.core[0].pixelType = bitsPerPixel > 16 ? 5 : (bitsPerPixel > 8 ? 3 : 1);
        this.core[0].bitsPerPixel = bitsPerPixel;
        this.core[0].imageCount = numImages;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].orderCertain = true;
        this.core[0].littleEndian = little;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].metadataComplete = true;
        this.addGlobalMeta("Endianness", little ? "little" : "big");
        this.addGlobalMeta("Version", version);
        this.addGlobalMeta("Width", width);
        this.addGlobalMeta("Height", height);
        this.addGlobalMeta("Bits per pixel", bitsPerPixel);
        this.addGlobalMeta("Image count", numImages);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

