/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class FakeReader
extends FormatReader {
    private static final String TOKEN_SEPARATOR = "&";
    private static final int BOX_SIZE = 10;

    public FakeReader() {
        super("Simulated data", "fake");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int series = this.getSeries();
        int pixelType = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        boolean signed = FormatTools.isSigned(pixelType);
        boolean little = this.isLittleEndian();
        int[] zct = this.getZCTCoords(no);
        int zIndex = zct[0];
        int cIndex = zct[1];
        int tIndex = zct[2];
        for (int r = 0; r < h; ++r) {
            int yy = y + r;
            for (int c = 0; c < w; ++c) {
                long pixel;
                int index = bpp * (w * r + c);
                int xx = x + c;
                long l = pixel = signed ? (long)(-xx) : (long)xx;
                if (yy < 10) {
                    int grid = xx / 10;
                    switch (grid) {
                        case 0: {
                            pixel = series;
                            break;
                        }
                        case 1: {
                            pixel = no;
                            break;
                        }
                        case 2: {
                            pixel = zIndex;
                            break;
                        }
                        case 3: {
                            pixel = cIndex;
                            break;
                        }
                        case 4: {
                            pixel = tIndex;
                        }
                    }
                }
                switch (pixelType) {
                    case 6: {
                        pixel = Float.floatToIntBits(pixel);
                        break;
                    }
                    case 7: {
                        pixel = Double.doubleToLongBits(pixel);
                    }
                }
                DataTools.unpackBytes(pixel, buf, index, bpp, little);
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("FakeReader.initFile(" + id + ")");
        super.initFile(id);
        String noExt = id.substring(0, id.lastIndexOf("."));
        String[] tokens = noExt.split(TOKEN_SEPARATOR);
        String name = null;
        int sizeX = 512;
        int sizeY = 512;
        int sizeZ = 1;
        int sizeC = 1;
        int sizeT = 1;
        int thumbSizeX = 128;
        int thumbSizeY = 128;
        int pixelType = 1;
        int rgb = 1;
        Object cLengths = null;
        Object cTypes = null;
        String dimOrder = "XYZCT";
        boolean orderCertain = true;
        boolean little = true;
        boolean interleaved = false;
        boolean indexed = false;
        boolean falseColor = false;
        boolean metadataComplete = true;
        boolean thumbnail = false;
        int seriesCount = 1;
        for (String token : tokens) {
            if (name == null) {
                name = token;
                continue;
            }
            int equals = token.indexOf("=");
            if (equals < 0) {
                LogTools.debug("Warning: ignoring token: " + token);
                continue;
            }
            String key = token.substring(0, equals);
            String value = token.substring(equals + 1);
            boolean bool = value.equals("true");
            int num = -1;
            try {
                num = Integer.parseInt(value);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (key.equals("sizeX")) {
                sizeX = num;
                continue;
            }
            if (key.equals("sizeY")) {
                sizeY = num;
                continue;
            }
            if (key.equals("sizeZ")) {
                sizeZ = num;
                continue;
            }
            if (key.equals("sizeC")) {
                sizeC = num;
                continue;
            }
            if (key.equals("sizeT")) {
                sizeT = num;
                continue;
            }
            if (key.equals("thumbSizeX")) {
                thumbSizeX = num;
                continue;
            }
            if (key.equals("thumbSizeY")) {
                thumbSizeY = num;
                continue;
            }
            if (key.equals("pixelType")) {
                pixelType = FormatTools.pixelTypeFromString(value);
                continue;
            }
            if (key.equals("rgb")) {
                rgb = num;
                continue;
            }
            if (key.equals("dimOrder")) {
                dimOrder = value.toUpperCase();
                continue;
            }
            if (key.equals("orderCertain")) {
                orderCertain = bool;
                continue;
            }
            if (key.equals("little")) {
                little = bool;
                continue;
            }
            if (key.equals("interleaved")) {
                interleaved = bool;
                continue;
            }
            if (key.equals("indexed")) {
                indexed = bool;
                continue;
            }
            if (key.equals("falseColor")) {
                falseColor = bool;
                continue;
            }
            if (key.equals("metadataComplete")) {
                metadataComplete = bool;
                continue;
            }
            if (key.equals("thumbnail")) {
                thumbnail = bool;
                continue;
            }
            if (!key.equals("series")) continue;
            seriesCount = num;
        }
        int effSizeC = sizeC / rgb;
        this.core = new CoreMetadata[seriesCount];
        for (int s = 0; s < seriesCount; ++s) {
            this.core[s] = new CoreMetadata();
            this.core[s].sizeX = sizeX;
            this.core[s].sizeY = sizeY;
            this.core[s].sizeZ = sizeZ;
            this.core[s].sizeC = sizeC;
            this.core[s].sizeT = sizeT;
            this.core[s].thumbSizeX = thumbSizeX;
            this.core[s].thumbSizeY = thumbSizeY;
            this.core[s].pixelType = pixelType;
            this.core[s].imageCount = sizeZ * effSizeC * sizeT;
            this.core[s].rgb = rgb > 1;
            this.core[s].dimensionOrder = dimOrder;
            this.core[s].orderCertain = orderCertain;
            this.core[s].littleEndian = little;
            this.core[s].interleaved = interleaved;
            this.core[s].indexed = indexed;
            this.core[s].falseColor = falseColor;
            this.core[s].metadataComplete = metadataComplete;
            this.core[s].thumbnail = thumbnail;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int s = 0; s < seriesCount; ++s) {
            String imageName = s > 0 ? name + " " + (s + 1) : name;
            store.setImageName(imageName, s);
            MetadataTools.setDefaultCreationDate(store, id, s);
        }
    }
}

