/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.POITools;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class PCIReader
extends FormatReader {
    public static final int PCI_MAGIC_BYTES = -791735840;
    private HashMap<Integer, String> imageFiles;
    private POITools poi;
    private HashMap<Integer, Double> timestamps;
    private String creationDate;
    private int binning;

    public PCIReader() {
        super("Compix Simple-PCI", "cxd");
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        RandomAccessInputStream s = this.poi.getDocumentStream(this.imageFiles.get(new Integer(no)));
        TiffParser tp = new TiffParser(s);
        if (tp.isValidHeader()) {
            IFD ifd = tp.getFirstIFD();
            tp.getSamples(ifd, buf);
        } else {
            s.seek(0L);
            int planeSize = FormatTools.getPlaneSize(this);
            s.skipBytes((int)(s.length() - (long)planeSize));
            this.readPlane(s, x, y, w, h, buf);
        }
        s.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageFiles = null;
            this.timestamps = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.binning = 0;
            this.creationDate = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("PCIReader.initFile(" + id + ")");
        super.initFile(id);
        this.imageFiles = new HashMap();
        this.timestamps = new HashMap();
        this.poi = new POITools(Location.getMappedId(this.currentId));
        double scaleFactor = 1.0;
        Vector<String> allFiles = this.poi.getDocumentList();
        if (allFiles.size() == 0) {
            throw new FormatException("No files were found - the .cxd may be corrupt.");
        }
        for (String name : allFiles) {
            int separator = name.lastIndexOf(File.separator);
            String parent = name.substring(0, separator);
            String relativePath = name.substring(separator + 1);
            if (relativePath.equals("Field Count")) {
                byte[] b = this.poi.getDocumentBytes(name, 4);
                this.core[0].imageCount = DataTools.bytesToInt(b, true);
                continue;
            }
            if (relativePath.equals("File Has Image")) {
                byte[] b = this.poi.getDocumentBytes(name, 2);
                if (DataTools.bytesToInt(b, true) != 0) continue;
                throw new FormatException("This file does not contain image data.");
            }
            if (relativePath.equals("Comments")) {
                String[] lines;
                String comments = new String(this.poi.getDocumentBytes(name));
                for (String line : lines = comments.split("\n")) {
                    int eq = line.indexOf("=");
                    if (eq == -1) continue;
                    String key = line.substring(0, eq).trim();
                    String value = line.substring(eq + 1).trim();
                    this.addGlobalMeta(key, value);
                    if (!key.equals("factor")) continue;
                    if (value.indexOf(";") != -1) {
                        value = value.substring(0, value.indexOf(";"));
                    }
                    scaleFactor = Double.parseDouble(value.trim());
                }
                continue;
            }
            if (relativePath.startsWith("Bitmap") || relativePath.equals("Data")) {
                int space = parent.lastIndexOf(" ") + 1;
                if (space >= parent.length()) continue;
                int num = Integer.parseInt(parent.substring(space, parent.indexOf(File.separator, space))) - 1;
                this.imageFiles.put(new Integer(num), name);
                if (this.getSizeX() == 0 || this.getSizeY() == 0) continue;
                int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
                int plane = this.getSizeX() * this.getSizeY() * bpp;
                this.core[0].sizeC = this.poi.getFileSize(name) / plane;
                if (this.getSizeC() != 0) continue;
                this.core[0].sizeX /= 16;
                this.core[0].sizeY /= 16;
                this.core[0].sizeC = this.poi.getFileSize(name) / plane;
                continue;
            }
            if (relativePath.indexOf("Image_Depth") != -1) {
                int bits;
                byte[] b = this.poi.getDocumentBytes(name, 8);
                for (bits = (int)DataTools.bytesToDouble(b, true); bits % 8 != 0 || bits == 0; ++bits) {
                }
                switch (bits) {
                    case 8: {
                        this.core[0].pixelType = 1;
                        break;
                    }
                    case 16: {
                        this.core[0].pixelType = 3;
                        break;
                    }
                    case 32: {
                        this.core[0].pixelType = 5;
                        break;
                    }
                    case 48: {
                        this.core[0].pixelType = 3;
                        break;
                    }
                    default: {
                        throw new FormatException("Unsupported bits per pixel : " + bits);
                    }
                }
                continue;
            }
            if (relativePath.indexOf("Image_Height") != -1 && this.getSizeY() == 0) {
                byte[] b = this.poi.getDocumentBytes(name, 8);
                this.core[0].sizeY = (int)DataTools.bytesToDouble(b, true);
                continue;
            }
            if (relativePath.indexOf("Image_Width") != -1 && this.getSizeX() == 0) {
                byte[] b = this.poi.getDocumentBytes(name, 8);
                this.core[0].sizeX = (int)DataTools.bytesToDouble(b, true);
                continue;
            }
            if (relativePath.indexOf("Time_From_Start") != -1) {
                byte[] b = this.poi.getDocumentBytes(name, 8);
                Double v = new Double(DataTools.bytesToDouble(b, true));
                int space = parent.lastIndexOf(" ") + 1;
                if (space >= parent.length()) continue;
                int num = Integer.parseInt(parent.substring(space, parent.indexOf(File.separator, space))) - 1;
                this.timestamps.put(new Integer(num), v);
                continue;
            }
            if (relativePath.equals("First Field Date & Time")) {
                byte[] b = this.poi.getDocumentBytes(name);
                long date = (long)DataTools.bytesToDouble(b, true) * 1000L;
                this.creationDate = DateTools.convertDate(date, 1);
                continue;
            }
            if (relativePath.equals("First Field Start Clock")) {
                byte[] b = this.poi.getDocumentBytes(name);
                double v = DataTools.bytesToDouble(b, true);
                continue;
            }
            if (!relativePath.equals("Binning")) continue;
            byte[] b = this.poi.getDocumentBytes(name, 8);
            this.binning = (int)DataTools.bytesToDouble(b, true);
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.timestamps.size() > 0) {
            this.core[0].sizeZ = this.getImageCount() / this.timestamps.size();
            this.core[0].sizeT = this.timestamps.size();
        }
        if (this.timestamps.size() == 0 || this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
            this.core[0].sizeT = 1;
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYCTZ";
        this.core[0].littleEndian = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        if (this.creationDate != null) {
            store.setImageCreationDate(this.creationDate, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        store.setDimensionsPhysicalSizeX(new Double(scaleFactor), 0, 0);
        store.setDimensionsPhysicalSizeY(new Double(scaleFactor), 0, 0);
        for (int i = 0; i < this.timestamps.size(); ++i) {
            Double timestamp = new Double(this.timestamps.get(new Integer(i)));
            store.setPlaneTimingDeltaT(timestamp, 0, 0, i);
            if (i != 2) continue;
            double first = this.timestamps.get(new Integer(1));
            Double increment = new Double(timestamp - first);
            store.setDimensionsTimeIncrement(increment, 0, 0);
        }
        if (this.binning > 0) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            String detectorID = MetadataTools.createLSID("Detector", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setDetectorID(detectorID, 0, 0);
            store.setDetectorType("Unknown", 0, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                store.setDetectorSettingsDetector(detectorID, 0, c);
                store.setDetectorSettingsBinning(this.binning + "x" + this.binning, 0, c);
            }
        }
    }
}

