/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;

public abstract class ImageIOWriter
extends FormatWriter {
    protected String kind;
    protected RandomAccessOutputStream out;

    public ImageIOWriter(String format, String suffix, String kind) {
        super(format, suffix);
        this.kind = kind;
    }

    public ImageIOWriter(String format, String[] suffixes, String kind) {
        super(format, suffixes);
        this.kind = kind;
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        MetadataRetrieve meta = this.getMetadataRetrieve();
        BufferedImage image = AWTImageTools.makeImage(buf, this.interleaved, meta, series);
        this.savePlane(image, series, lastInSeries, last);
    }

    public void savePlane(Object plane, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (!(plane instanceof Image)) {
            throw new IllegalArgumentException("Object to save must be a java.awt.Image");
        }
        BufferedImage img = AWTImageTools.makeBuffered((Image)plane, this.cm);
        int type = AWTImageTools.getPixelType(img);
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != type) continue;
            this.out = new RandomAccessOutputStream(this.currentId);
            ImageIO.write((RenderedImage)img, this.kind, this.out);
            return;
        }
        throw new FormatException("Floating point data not supported.");
    }

    public int[] getPixelTypes() {
        return new int[]{1, 3};
    }

    public Class getNativeDataType() {
        return Image.class;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
    }
}

