/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTTiffTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;

public class TiffWriter
extends FormatWriter {
    public static final String COMPRESSION_UNCOMPRESSED = "Uncompressed";
    public static final String COMPRESSION_LZW = "LZW";
    public static final String COMPRESSION_J2K = "J2K";
    public static final String COMPRESSION_J2K_LOSSY = "J2K-Lossy";
    public static final String COMPRESSION_JPEG = "JPEG";
    protected long lastOffset = 0L;
    protected RandomAccessOutputStream out;
    protected Vector imageCounts;
    protected boolean isBigTiff;

    public TiffWriter() {
        this("Tagged Image File Format", new String[]{"tif", "tiff"});
    }

    public TiffWriter(String format, String[] exts) {
        super(format, exts);
        this.compressionTypes = new String[]{COMPRESSION_UNCOMPRESSED, COMPRESSION_LZW, COMPRESSION_J2K, COMPRESSION_J2K_LOSSY, COMPRESSION_JPEG};
        this.isBigTiff = false;
    }

    public void saveBytes(byte[] buf, IFD ifd, boolean last) throws IOException, FormatException {
        this.saveBytes(buf, ifd, 0, last, last);
    }

    public void saveBytes(byte[] buf, IFD ifd, int series, boolean lastInSeries, boolean last) throws IOException, FormatException {
        int type;
        int bytesPerPixel;
        int c;
        int plane;
        boolean littleEndian;
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(retrieve, series);
        Boolean bigEndian = retrieve.getPixelsBigEndian(series, 0);
        boolean bl = bigEndian == null ? false : (littleEndian = bigEndian == false);
        if (!this.initialized) {
            this.imageCounts = new Vector();
            this.initialized = true;
            this.out = new RandomAccessOutputStream(this.currentId);
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.currentId);
            if (tmp.length() == 0L) {
                TiffSaver tiffSaver = new TiffSaver(this.out);
                tiffSaver.writeHeader(littleEndian, this.isBigTiff);
                this.lastOffset = this.isBigTiff ? 16L : 8L;
            } else {
                TiffParser tiffParser = new TiffParser(tmp);
                tiffParser.checkHeader();
                long offset = tiffParser.getFirstOffset();
                long ifdMax = (tmp.length() - 8L) / 18L;
                for (long ifdNum = 0L; ifdNum < ifdMax; ++ifdNum) {
                    tiffParser.getIFD(ifdNum, offset);
                    offset = tmp.readInt();
                    if (offset <= 0L || offset >= tmp.length()) break;
                }
                this.lastOffset = offset;
            }
            tmp.close();
        }
        int width = retrieve.getPixelsSizeX(series, 0);
        int height = retrieve.getPixelsSizeY(series, 0);
        Integer channels = retrieve.getLogicalChannelSamplesPerPixel(series, 0);
        if (channels == null) {
            this.warn("SamplesPerPixel #0 is null.  It is assumed to be 1.");
        }
        if ((plane = width * height * (c = channels == null ? 1 : channels) * (bytesPerPixel = FormatTools.getBytesPerPixel(type = FormatTools.pixelTypeFromString(retrieve.getPixelsPixelType(series, 0))))) > buf.length) {
            c = buf.length / (width * height * bytesPerPixel);
            plane = width * height * c * bytesPerPixel;
        }
        if (bytesPerPixel > 1 && c != 1 && c != 3) {
            for (int i = 0; i < c; ++i) {
                byte[] b = ImageTools.splitChannels(buf, i, c, bytesPerPixel, false, this.interleaved);
                this.saveBytes(b, ifd, series, lastInSeries && i == c - 1, last && i == c - 1);
            }
            return;
        }
        ifd.put(new Integer(256), new Integer(width));
        ifd.put(new Integer(257), new Integer(height));
        if (!this.isBigTiff) {
            RandomAccessInputStream tmp = new RandomAccessInputStream(this.currentId);
            boolean bl2 = this.isBigTiff = tmp.length() + (long)(2 * plane) >= 0x100000000L;
            if (this.isBigTiff) {
                throw new FormatException("File is too large; call setBigTiff(true)");
            }
            tmp.close();
        }
        ifd.put(new Integer(0), new Boolean(littleEndian));
        this.out.seek(this.out.length());
        this.lastOffset += AWTTiffTools.writeImage(buf, ifd, this.out, this.lastOffset, last, this.isBigTiff, this.getColorModel(), type, this.interleaved);
        if (last) {
            this.close();
        }
    }

    public void saveBytes(byte[] buf, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        IFD h = new IFD();
        if (this.compression == null) {
            this.compression = "";
        }
        Integer compressType = new Integer(1);
        if (this.compression.equals(COMPRESSION_LZW)) {
            compressType = new Integer(5);
        } else if (this.compression.equals(COMPRESSION_J2K)) {
            compressType = new Integer(33003);
        } else if (this.compression.equals(COMPRESSION_J2K_LOSSY)) {
            compressType = new Integer(33004);
        } else if (this.compression.equals(COMPRESSION_JPEG)) {
            compressType = new Integer(7);
        }
        h.put(new Integer(259), compressType);
        this.saveBytes(buf, h, series, lastInSeries, last);
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        if (codec.startsWith(COMPRESSION_J2K) || codec.equals(COMPRESSION_JPEG)) {
            return new int[]{0, 1};
        }
        return super.getPixelTypes(codec);
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
        this.lastOffset = 0L;
        this.imageCounts = null;
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId(this.currentId, false, 1);
        this.isBigTiff = bigTiff;
    }
}

