/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.LZWCodec;
import loci.formats.codec.LuraWaveCodec;
import loci.formats.codec.NikonCodec;
import loci.formats.codec.PackbitsCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.tiff.IFD;

public final class TiffCompression {
    public static final int UNCOMPRESSED = 1;
    public static final int CCITT_1D = 2;
    public static final int GROUP_3_FAX = 3;
    public static final int GROUP_4_FAX = 4;
    public static final int LZW = 5;
    public static final int JPEG = 7;
    public static final int PACK_BITS = 32773;
    public static final int PROPRIETARY_DEFLATE = 32946;
    public static final int DEFLATE = 8;
    public static final int THUNDERSCAN = 32809;
    public static final int JPEG_2000 = 33003;
    public static final int JPEG_2000_LOSSY = 33004;
    public static final int ALT_JPEG_2000 = 33005;
    public static final int ALT_JPEG = 33007;
    public static final int NIKON = 34713;
    public static final int LURAWAVE = 65535;

    private TiffCompression() {
    }

    public static String getCodecName(int codec) {
        switch (codec) {
            case 1: {
                return "Uncompressed";
            }
            case 2: {
                return "CCITT Group 3 1-Dimensional Modified Huffman";
            }
            case 3: {
                return "CCITT T.4 bi-level encoding (Group 3 Fax)";
            }
            case 4: {
                return "CCITT T.6 bi-level encoding (Group 4 Fax)";
            }
            case 5: {
                return "LZW";
            }
            case 7: 
            case 33007: {
                return "JPEG";
            }
            case 32773: {
                return "PackBits";
            }
            case 8: 
            case 32946: {
                return "Deflate (Zlib)";
            }
            case 32809: {
                return "Thunderscan";
            }
            case 33003: {
                return "JPEG-2000";
            }
            case 33004: {
                return "JPEG-2000 Lossy";
            }
            case 33005: {
                return "Aperio JPEG-2000";
            }
            case 34713: {
                return "Nikon";
            }
            case 65535: {
                return "LuraWave";
            }
        }
        return null;
    }

    public static boolean isSupportedDecompression(int decompression) {
        return decompression == 1 || decompression == 5 || decompression == 7 || decompression == 33007 || decompression == 33003 || decompression == 33004 || decompression == 33005 || decompression == 32773 || decompression == 32946 || decompression == 8 || decompression == 34713 || decompression == 65535;
    }

    public static byte[] uncompress(byte[] input, int compression, CodecOptions options) throws FormatException, IOException {
        if (compression < 0) {
            compression += 65536;
        }
        if (!TiffCompression.isSupportedDecompression(compression)) {
            String compressionName = TiffCompression.getCodecName(compression);
            String message = null;
            message = compressionName != null ? "Sorry, " + compressionName + " compression mode is not supported" : "Unknown Compression type (" + compression + ")";
            throw new FormatException(message);
        }
        BaseCodec codec = null;
        if (compression == 1) {
            return input;
        }
        if (compression == 5) {
            codec = new LZWCodec();
        } else if (compression == 7 || compression == 33007) {
            codec = new JPEGCodec();
        } else if (compression == 33003 || compression == 33004 || compression == 33005) {
            codec = new JPEG2000Codec();
        } else if (compression == 32773) {
            codec = new PackbitsCodec();
        } else if (compression == 32946 || compression == 8) {
            codec = new ZlibCodec();
        } else if (compression == 34713) {
            codec = new NikonCodec();
        } else if (compression == 65535) {
            codec = new LuraWaveCodec();
        }
        if (codec != null) {
            return codec.decompress(input, options);
        }
        throw new FormatException("Unhandled compression (" + compression + ")");
    }

    public static void undifference(byte[] input, IFD ifd) throws FormatException {
        int predictor = ifd.getIFDIntValue(317, false, 1);
        if (predictor == 2) {
            LogTools.debug("reversing horizontal differencing");
            int[] bitsPerSample = ifd.getBitsPerSample();
            int len = bitsPerSample.length;
            long width = ifd.getImageWidth();
            boolean little = ifd.isLittleEndian();
            int planarConfig = ifd.getPlanarConfiguration();
            if (planarConfig == 2 || bitsPerSample[len - 1] == 0) {
                len = 1;
            }
            if (bitsPerSample[0] <= 8) {
                for (int b = 0; b < input.length; ++b) {
                    if ((long)(b / len) % width == 0L) continue;
                    int n = b;
                    input[n] = (byte)(input[n] + input[b - len]);
                }
            } else if (bitsPerSample[0] <= 16) {
                short[] s = (short[])DataTools.makeDataArray(input, 2, false, little);
                for (int b = 0; b < s.length; ++b) {
                    if ((long)(b / len) % width == 0L) continue;
                    int n = b;
                    s[n] = (short)(s[n] + s[b - len]);
                }
                for (int i = 0; i < s.length; ++i) {
                    DataTools.unpackBytes(s[i], input, i * 2, 2, little);
                }
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    public static boolean isSupportedCompression(int compression) {
        return compression == 1 || compression == 5 || compression == 7 || compression == 33003 || compression == 33004 || compression == 33005;
    }

    public static byte[] compress(byte[] input, IFD ifd) throws FormatException, IOException {
        int compression = ifd.getIFDIntValue(259, false, 1);
        if (!TiffCompression.isSupportedCompression(compression)) {
            String compressionName = TiffCompression.getCodecName(compression);
            if (compressionName != null) {
                throw new FormatException("Sorry, " + compressionName + " compression mode is not supported");
            }
            throw new FormatException("Unknown Compression type (" + compression + ")");
        }
        CodecOptions options = new CodecOptions();
        options.width = (int)ifd.getImageWidth();
        options.height = (int)ifd.getImageLength();
        options.bitsPerSample = ifd.getBitsPerSample()[0];
        options.channels = ifd.getSamplesPerPixel();
        options.littleEndian = ifd.isLittleEndian();
        options.interleaved = true;
        options.signed = false;
        if (compression == 1) {
            return input;
        }
        if (compression == 5) {
            return new LZWCodec().compress(input, options);
        }
        if (compression == 7) {
            return new JPEGCodec().compress(input, options);
        }
        if (compression == 33003 || compression == 33005) {
            options.lossless = true;
            JPEG2000CodecOptions j2kOptions = JPEG2000CodecOptions.getDefaultOptions(options);
            return new JPEG2000Codec().compress(input, (CodecOptions)j2kOptions);
        }
        if (compression == 33004) {
            options.lossless = false;
            JPEG2000CodecOptions j2kOptions = JPEG2000CodecOptions.getDefaultOptions(options);
            return new JPEG2000Codec().compress(input, (CodecOptions)j2kOptions);
        }
        throw new FormatException("Unhandled compression (" + compression + ")");
    }

    public static void difference(byte[] input, int[] bitsPerSample, long width, int planarConfig, int predictor) throws FormatException {
        if (predictor == 2) {
            LogTools.debug("performing horizontal differencing");
            for (int b = input.length - 1; b >= 0; --b) {
                if ((long)(b / bitsPerSample.length) % width == 0L) continue;
                int n = b;
                input[n] = (byte)(input[n] - input[b - bitsPerSample.length]);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }
}

