/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import loci.formats.IFormatReader;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.importer.ThumbLoader;
import loci.plugins.prefs.OptionsDialog;
import loci.plugins.util.WindowTools;

public class SeriesDialog
extends OptionsDialog
implements ActionListener {
    public static final int MAX_COMPONENTS = 256;
    protected ImporterOptions options;
    protected BufferedImageReader r;
    protected String[] seriesLabels;
    protected boolean[] series;
    protected Checkbox[] boxes;

    public SeriesDialog(ImporterOptions options, IFormatReader r, String[] seriesLabels, boolean[] series) {
        super(options);
        this.options = options;
        this.r = r instanceof BufferedImageReader ? (BufferedImageReader)r : new BufferedImageReader(r);
        this.seriesLabels = seriesLabels;
        this.series = series;
    }

    public int showDialog() {
        String seriesString = this.options.getSeries();
        if (this.options.isWindowless()) {
            if (seriesString != null) {
                if (seriesString.startsWith("[")) {
                    seriesString = seriesString.substring(1, seriesString.length() - 2);
                }
                Arrays.fill(this.series, false);
                StringTokenizer tokens = new StringTokenizer(seriesString, " ");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim();
                    int n = Integer.parseInt(token);
                    if (n >= this.series.length) continue;
                    this.series[n] = true;
                }
            }
            this.options.setSeries(seriesString);
            return 0;
        }
        int seriesCount = this.r.getSeriesCount();
        GenericDialog gd = new GenericDialog("Bio-Formats Series Options");
        GridBagLayout gdl = (GridBagLayout)gd.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        Panel[] p = new Panel[seriesCount];
        for (int i = 0; i < seriesCount; ++i) {
            this.r.setSeries(i);
            int sx = this.r.getThumbSizeX() + 10;
            int sy = this.r.getThumbSizeY();
            p[i] = new Panel();
            p[i].add(Box.createRigidArea(new Dimension(sx, sy)));
            if (!this.options.isForceThumbnails()) continue;
            IJ.showStatus((String)("Reading thumbnail for series #" + (i + 1)));
            int z = this.r.getSizeZ() / 2;
            int t = this.r.getSizeT() / 2;
            int ndx = this.r.getIndex(z, 0, t);
            try {
                BufferedImage img = this.r.openThumbImage(ndx);
                if (this.options.isAutoscale() && this.r.getPixelType() != 6) {
                    img = AWTImageTools.autoscale(img);
                }
                ImageIcon icon = new ImageIcon(img);
                p[i].removeAll();
                p[i].add(new JLabel(icon));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int nPanels = p.length / 256;
        if (nPanels * 256 < p.length) {
            ++nPanels;
        }
        int nextSeries = 0;
        for (int i = 0; i < nPanels; ++i) {
            int nRows = i == nPanels - 1 ? p.length % 256 : 256;
            String[] labels = new String[nRows];
            boolean[] defaultValues = new boolean[nRows];
            for (int row = 0; row < nRows; ++row) {
                labels[row] = this.seriesLabels[nextSeries];
                defaultValues[row] = this.series[nextSeries++];
            }
            gd.addCheckboxGroup(nRows, 1, labels, defaultValues);
        }
        this.boxes = gd.getCheckboxes().toArray(new Checkbox[0]);
        gd.removeAll();
        Panel masterPanel = new Panel(){

            protected void dispatchEventImpl(AWTEvent e) {
            }
        };
        masterPanel.setLayout(new GridLayout(seriesCount, 2));
        boolean nextComponent = false;
        for (int i = 0; i < seriesCount; ++i) {
            masterPanel.add(this.boxes[i]);
            masterPanel.add(p[i]);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gdl.setConstraints(masterPanel, gbc);
        gd.add((Component)masterPanel);
        WindowTools.addScrollBars((Container)gd);
        Panel buttons = new Panel();
        Button select = new Button("Select All");
        select.setActionCommand("select");
        select.addActionListener(this);
        Button deselect = new Button("Deselect All");
        deselect.setActionCommand("deselect");
        deselect.addActionListener(this);
        buttons.add(select);
        buttons.add(deselect);
        gbc.gridx = 2;
        gbc.gridy = nPanels;
        gbc.anchor = 13;
        gbc.insets = new Insets(15, 0, 0, 0);
        gdl.setConstraints(buttons, gbc);
        gd.add((Component)buttons);
        if (this.options.isForceThumbnails()) {
            gd.showDialog();
        } else {
            ThumbLoader loader = new ThumbLoader(this.r, p, (Dialog)gd, this.options.isAutoscale());
            gd.showDialog();
            loader.stop();
        }
        if (gd.wasCanceled()) {
            return 1;
        }
        seriesString = "[";
        for (int i = 0; i < seriesCount; ++i) {
            this.series[i] = gd.getNextBoolean();
            if (!this.series[i]) continue;
            seriesString = seriesString + i + " ";
        }
        seriesString = seriesString + "]";
        this.options.setSeries(seriesString);
        return 0;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("select".equals(cmd)) {
            for (int i = 0; i < this.boxes.length; ++i) {
                this.boxes[i].setState(true);
            }
            this.updateIfGlitched();
        } else if ("deselect".equals(cmd)) {
            for (int i = 0; i < this.boxes.length; ++i) {
                this.boxes[i].setState(false);
            }
            this.updateIfGlitched();
        }
    }

    private void updateIfGlitched() {
        if (IS_GLITCHED) {
            this.sleep(200L);
            for (int i = 0; i < this.boxes.length; ++i) {
                this.boxes[i].repaint();
            }
        }
    }
}

