/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.util.Parameter;

public class GridWriter {
    private static boolean debug = false;

    public static NetcdfFile writeToFile(GridDatatype grid, String fileOutName, int timeIdx) throws IOException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew(fileOutName, false);
        if (debug) {
            System.out.println("GridWriter write " + grid.getName() + " to " + fileOutName);
        }
        ncfile.addGlobalAttribute("Conventions", "_Coordinates");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis1DTime taxis = gcs.getTimeAxis1D();
        ncfile.addGlobalAttribute("time", taxis.getCoordName(timeIdx));
        Dimension timeDim = grid.getTimeDimension();
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : grid.getDimensions()) {
            if (oldD.equals(timeDim)) continue;
            Dimension newD = ncfile.addDimension(oldD.getName(), oldD.isUnlimited() ? -1 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(newD.getName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        GridWriter.defineVariable(ncfile, grid.getVariable(), dimHash, timeDim);
        GridWriter.defineVariable(ncfile, gcs.getXHorizAxis(), dimHash, timeDim);
        GridWriter.defineVariable(ncfile, gcs.getYHorizAxis(), dimHash, timeDim);
        GridWriter.defineVariable(ncfile, gcs.getVerticalAxis(), dimHash, timeDim);
        ProjectionImpl proj = grid.getProjection();
        if (proj != null) {
            if (proj instanceof LambertConformal) {
                LambertConformal lc = (LambertConformal)proj;
                ncfile.addGlobalAttribute("spatial_ref", lc.toWKS());
            }
            GridWriter.defineProjection(ncfile, proj);
        }
        ncfile.create();
        if (debug) {
            System.out.println("File Out= " + ncfile.toString());
        }
        Array data = grid.readVolumeData(timeIdx);
        try {
            ncfile.write(grid.getName(), data);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        GridWriter.writeVariable(ncfile, gcs.getXHorizAxis());
        GridWriter.writeVariable(ncfile, gcs.getYHorizAxis());
        GridWriter.writeVariable(ncfile, gcs.getVerticalAxis());
        ncfile.flush();
        if (debug) {
            System.out.println("FileWriter done");
        }
        return ncfile;
    }

    private static void defineVariable(NetcdfFileWriteable ncfile, VariableEnhanced oldVar, HashMap dimHash, Dimension timeDim) {
        if (oldVar == null) {
            return;
        }
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        List<Dimension> dimvList = oldVar.getDimensions();
        for (int j = 0; j < dimvList.size(); ++j) {
            Dimension oldD = dimvList.get(j);
            if (oldD.equals(timeDim)) continue;
            dims.add((Dimension)dimHash.get(oldD.getName()));
        }
        ncfile.addVariable(oldVar.getName(), oldVar.getDataType(), dims);
        if (debug) {
            System.out.println("add var= " + oldVar.getName());
        }
        List<Attribute> attList = oldVar.getAttributes();
        for (int j = 0; j < attList.size(); ++j) {
            Attribute att = attList.get(j);
            if (att.isString()) {
                ncfile.addVariableAttribute(oldVar.getName(), att.getName(), att.getStringValue());
                continue;
            }
            if (att.isArray()) {
                ncfile.addVariableAttribute(oldVar.getName(), att.getName(), att.getValues());
                continue;
            }
            ncfile.addVariableAttribute(oldVar.getName(), att.getName(), att.getNumericValue());
        }
    }

    private static void defineProjection(NetcdfFileWriteable ncfile, Projection proj) {
        String varName = "Projection";
        ncfile.addVariable("Projection", DataType.CHAR, new ArrayList<Dimension>());
        List params = proj.getProjectionParameters();
        for (int i = 0; i < params.size(); ++i) {
            Parameter p = (Parameter)params.get(i);
            if (p.isString()) {
                ncfile.addVariableAttribute(varName, p.getName(), p.getStringValue());
                continue;
            }
            double[] data = p.getNumericValues();
            Array dataA = Array.factory(Double.TYPE, new int[]{data.length}, (Object)data);
            ncfile.addVariableAttribute(varName, p.getName(), dataA);
        }
        ncfile.addVariableAttribute(varName, "_CoordinateTransformType", TransformType.Projection.toString());
        ncfile.addVariableAttribute(varName, "_CoordinateAxisTypes", "GeoX GeoY");
    }

    private static void writeVariable(NetcdfFileWriteable ncfile, VariableEnhanced oldVar) throws IOException {
        if (oldVar == null) {
            return;
        }
        Array data = oldVar.read();
        try {
            ncfile.write(oldVar.getName(), data);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arg) throws MalformedURLException, IOException {
        String datasetIn = arg.length > 0 ? arg[0] : "C:/Program Files/Apache Group/jakarta-tomcat-5.0.28/content/thredds/wcs/testdata/eta.nc";
        String filenameOut = arg.length > 1 ? arg[1] : "C:/temp/thredds/testGridWriter.nc";
        GridDataset gridDs = GridDataset.open(datasetIn);
        GridDatatype grid = gridDs.findGridDatatype("T");
        NetcdfFile ncfileOut = GridWriter.writeToFile(grid, filenameOut, 0);
        gridDs.close();
        ncfileOut.close();
    }
}

