/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.WRFEtaTransformBuilder;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.util.StringUtil;

public class WRFConvention
extends CoordSysBuilder {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
    private double centerX = 0.0;
    private double centerY = 0.0;
    private ProjectionCT projCT = null;

    public static boolean isMine(NetcdfFile ncfile) {
        return null != ncfile.findGlobalAttribute("MAP_PROJ") && null != ncfile.findDimension("south_north");
    }

    public WRFConvention() {
        this.conventionName = "WRF";
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        if (null != ds.findVariable("x")) {
            return;
        }
        List<Variable> vlist = ds.getVariables();
        for (Variable v : vlist) {
            Attribute att = v.findAttributeIgnoreCase("units");
            if (att == null) continue;
            String units = att.getStringValue();
            v.addAttribute(new Attribute("units", this.normalize(units)));
        }
        Attribute att = ds.findGlobalAttribute("MAP_PROJ");
        int projType = att.getNumericValue().intValue();
        if (projType == 203) {
            Variable glat = ds.findVariable("GLAT");
            glat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            glat.setDimensions("south_north west_east");
            glat.setCachedData(this.convertToDegrees(glat), false);
            glat.addAttribute(new Attribute("units", "degrees_north"));
            Variable glon = ds.findVariable("GLON");
            glon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            glon.setDimensions("south_north west_east");
            glon.setCachedData(this.convertToDegrees(glon), false);
            glon.addAttribute(new Attribute("units", "degrees_east"));
            VariableDS v = new VariableDS(ds, null, null, "LatLonCoordSys", DataType.CHAR, "", null, null);
            v.addAttribute(new Attribute("_CoordinateAxes", "GLAT GLON Time"));
            Array data = Array.factory(DataType.CHAR.getPrimitiveClassType(), new int[0], (Object)new char[]{' '});
            v.setCachedData(data, true);
            ds.addVariable(null, v);
            Variable dataVar = ds.findVariable("LANDMASK");
            dataVar.addAttribute(new Attribute("_CoordinateSystems", "LatLonCoordSys"));
        } else {
            double lat1 = this.findAttributeDouble(ds, "TRUELAT1");
            double lat2 = this.findAttributeDouble(ds, "TRUELAT2");
            double centralLat = this.findAttributeDouble(ds, "CEN_LAT");
            double centralLon = this.findAttributeDouble(ds, "CEN_LON");
            double standardLon = this.findAttributeDouble(ds, "STAND_LON");
            double standardLat = this.findAttributeDouble(ds, "MOAD_CEN_LAT");
            ProjectionImpl proj = null;
            switch (projType) {
                case 1: {
                    proj = new LambertConformal(standardLat, standardLon, lat1, lat2);
                    this.projCT = new ProjectionCT("Lambert", "FGDC", proj);
                    break;
                }
                case 2: {
                    double lon0 = Double.isNaN(standardLon) ? centralLon : standardLon;
                    double scaleFactor = (1.0 + Math.abs(Math.sin(Math.toRadians(lat1)))) / 2.0;
                    proj = new Stereographic(lat2, lon0, scaleFactor);
                    this.projCT = new ProjectionCT("Stereographic", "FGDC", proj);
                    break;
                }
                case 3: {
                    proj = new Mercator(standardLat, standardLon, standardLat);
                    this.projCT = new ProjectionCT("Mercator", "FGDC", proj);
                    break;
                }
                default: {
                    this.parseInfo.append("ERROR: unknown projection type = ").append(projType);
                }
            }
            if (proj != null) {
                LatLonPointImpl lpt1 = new LatLonPointImpl(centralLat, centralLon);
                ProjectionPoint ppt1 = ((ProjectionImpl)proj).latLonToProj(lpt1, new ProjectionPointImpl());
                this.centerX = ppt1.getX();
                this.centerY = ppt1.getY();
                if (this.debug) {
                    System.out.println("centerX=" + this.centerX);
                    System.out.println("centerY=" + this.centerY);
                }
            }
            ds.addCoordinateAxis(this.makeXCoordAxis(ds, "x", ds.findDimension("west_east")));
            ds.addCoordinateAxis(this.makeXCoordAxis(ds, "x_stag", ds.findDimension("west_east_stag")));
            ds.addCoordinateAxis(this.makeYCoordAxis(ds, "y", ds.findDimension("south_north")));
            ds.addCoordinateAxis(this.makeYCoordAxis(ds, "y_stag", ds.findDimension("south_north_stag")));
            ds.addCoordinateAxis(this.makeZCoordAxis(ds, "z", ds.findDimension("bottom_top")));
            ds.addCoordinateAxis(this.makeZCoordAxis(ds, "z_stag", ds.findDimension("bottom_top_stag")));
            if (this.projCT != null) {
                VariableDS v = this.makeCoordinateTransformVariable(ds, this.projCT);
                v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
                ds.addVariable(null, v);
            }
        }
        if (ds.findVariable("Time") == null) {
            CoordinateAxis taxis = this.makeTimeCoordAxis(ds, "Time", ds.findDimension("Time"));
            if (taxis == null) {
                taxis = this.makeTimeCoordAxis(ds, "Time", ds.findDimension("Times"));
            }
            if (taxis != null) {
                ds.addCoordinateAxis(taxis);
            }
        }
        ds.addCoordinateAxis(this.makeSoilDepthCoordAxis(ds, "ZS"));
        ds.finish();
    }

    private Array convertToDegrees(Variable v) {
        Array data;
        try {
            data = v.read();
            data = data.reduce();
        }
        catch (IOException ioe) {
            throw new RuntimeException("data read failed on " + v.getName() + "=" + ioe.getMessage());
        }
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(Math.toDegrees(ii.getDoubleNext()));
        }
        return data;
    }

    private String normalize(String units) {
        if (units.equals("fraction")) {
            units = "";
        } else if (units.equals("dimensionless")) {
            units = "";
        } else if (units.equals("NA")) {
            units = "";
        } else if (units.equals("-")) {
            units = "";
        } else {
            units = StringUtil.substitute(units, "**", "^");
            units = StringUtil.remove(units, 125);
            units = StringUtil.remove(units, 123);
        }
        return units;
    }

    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        if (this.projCT != null) {
            CoordSysBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName());
            vp.isCoordinateTransform = true;
            vp.ct = this.projCT;
        }
        super.makeCoordinateTransforms(ds);
    }

    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getName();
        if (vname.equalsIgnoreCase("x") || vname.equalsIgnoreCase("x_stag")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || vname.equalsIgnoreCase("y_stag")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("z") || vname.equalsIgnoreCase("z_stag")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("Z")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time") || vname.equalsIgnoreCase("times")) {
            return AxisType.Time;
        }
        String unit = ve.getUnitsString();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return null;
    }

    public String getZisPositive(CoordinateAxis v) {
        return "down";
    }

    private CoordinateAxis makeLonCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dx = 4.0 * this.findAttributeDouble(ds, "DX");
        int nx = dim.getLength();
        double startx = this.centerX - dx * (double)(nx - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getName(), "degrees_east", "synthesized longitude coordinate");
        ds.setValues(v, nx, startx, dx);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lon"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        return v;
    }

    private CoordinateAxis makeLatCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dy = this.findAttributeDouble(ds, "DY");
        int ny = dim.getLength();
        double starty = this.centerY - dy * (double)(ny - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getName(), "degrees_north", "synthesized latitude coordinate");
        ds.setValues(v, ny, starty, dy);
        v.addAttribute(new Attribute("_CoordinateAxisType", "Lat"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        return v;
    }

    private CoordinateAxis makeXCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dx = this.findAttributeDouble(ds, "DX") / 1000.0;
        int nx = dim.getLength();
        double startx = this.centerX - dx * (double)(nx - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getName(), "km", "synthesized GeoX coordinate from DX attribute");
        ds.setValues(v, nx, startx, dx);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        return v;
    }

    private CoordinateAxis makeYCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        double dy = this.findAttributeDouble(ds, "DY") / 1000.0;
        int ny = dim.getLength();
        double starty = this.centerY - dy * (double)(ny - 1) / 2.0;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getName(), "km", "synthesized GeoY coordinate from DY attribute");
        ds.setValues(v, ny, starty, dy);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        return v;
    }

    private CoordinateAxis makeZCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        Variable etaVar;
        if (dim == null) {
            return null;
        }
        String fromWhere = axisName.endsWith("stag") ? "ZNW" : "ZNU";
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getName(), "", "eta values from variable " + fromWhere);
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        if ((etaVar = ds.findVariable(fromWhere)) == null) {
            return this.makeFakeCoordAxis(ds, axisName, dim);
        }
        int n = etaVar.getShape()[1];
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{1, n};
        try {
            Array array = etaVar.read(origin, shape);
            ArrayDouble.D1 newArray = new ArrayDouble.D1(n);
            IndexIterator it = array.getIndexIterator();
            int count = 0;
            while (it.hasNext()) {
                double d = it.getDoubleNext();
                newArray.set(count++, d);
            }
            v.setCachedData(newArray, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private CoordinateAxis makeFakeCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        if (dim == null) {
            return null;
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.SHORT, dim.getName(), "", "synthesized coordinate: only an index");
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        ds.setValues(v, dim.getLength(), 0.0, 1.0);
        return v;
    }

    private CoordinateAxis makeTimeCoordAxis(NetcdfDataset ds, String axisName, Dimension dim) {
        Object iter;
        Array timeData;
        if (dim == null) {
            return null;
        }
        int nt = dim.getLength();
        Variable timeV = ds.findVariable("Times");
        if (timeV == null) {
            return null;
        }
        try {
            timeData = timeV.read();
        }
        catch (IOException ioe) {
            return null;
        }
        ArrayDouble.D1 values = new ArrayDouble.D1(nt);
        int count = 0;
        if (timeData instanceof ArrayChar) {
            iter = ((ArrayChar)timeData).getStringIterator();
            while (((ArrayChar.StringIterator)iter).hasNext()) {
                String dateS = ((ArrayChar.StringIterator)iter).next();
                try {
                    Date d = dateFormat.parse(dateS);
                    values.set(count++, (double)d.getTime() / 1000.0);
                }
                catch (ParseException e) {
                    this.parseInfo.append("ERROR: cant parse Time string = <").append(dateS).append("> err=").append(e.getMessage()).append("\n");
                    String startAtt = ds.findAttValueIgnoreCase(null, "START_DATE", null);
                    if (nt != 1 || null == startAtt) continue;
                    try {
                        Date d = dateFormat.parse(startAtt);
                        values.set(0, (double)d.getTime() / 1000.0);
                    }
                    catch (ParseException e2) {
                        this.parseInfo.append("ERROR: cant parse global attribute START_DATE = <").append(startAtt).append("> err=").append(e2.getMessage()).append("\n");
                    }
                }
            }
        } else {
            iter = timeData.getIndexIterator();
            while (iter.hasNext()) {
                String dateS = (String)iter.next();
                try {
                    Date d = dateFormat.parse(dateS);
                    values.set(count++, (double)d.getTime() / 1000.0);
                }
                catch (ParseException e) {
                    this.parseInfo.append("ERROR: cant parse Time string = ").append(dateS);
                }
            }
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, DataType.DOUBLE, dim.getName(), "secs since 1970-01-01 00:00:00", "synthesized time coordinate from Times(time)");
        v.addAttribute(new Attribute("_CoordinateAxisType", "Time"));
        if (!axisName.equals(dim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", dim.getName()));
        }
        v.setCachedData(values, true);
        return v;
    }

    private VariableDS makeSoilDepthCoordAxis(NetcdfDataset ds, String coordVarName) {
        Variable coordVar = ds.findVariable(coordVarName);
        if (null == coordVar) {
            return null;
        }
        Dimension soilDim = null;
        List<Dimension> dims = coordVar.getDimensions();
        for (Dimension d : dims) {
            if (!d.getName().startsWith("soil_layers")) continue;
            soilDim = d;
        }
        if (null == soilDim) {
            return null;
        }
        if (coordVar.getRank() == 1) {
            coordVar.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
            if (!coordVarName.equals(soilDim.getName())) {
                coordVar.addAttribute(new Attribute("_CoordinateAliasForDimension", soilDim.getName()));
            }
            return (VariableDS)coordVar;
        }
        String units = ds.findAttValueIgnoreCase(coordVar, "units", "");
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, "soilDepth", DataType.SHORT, soilDim.getName(), units, "soil depth");
        v.addAttribute(new Attribute("_CoordinateAxisType", "GeoZ"));
        v.addAttribute(new Attribute("units", "units"));
        if (!v.getShortName().equals(soilDim.getName())) {
            v.addAttribute(new Attribute("_CoordinateAliasForDimension", soilDim.getName()));
        }
        int n = coordVar.getShape()[1];
        int[] origin = new int[]{0, 0};
        int[] shape = new int[]{1, n};
        try {
            Array array = coordVar.read(origin, shape);
            ArrayDouble.D1 newArray = new ArrayDouble.D1(n);
            IndexIterator it = array.getIndexIterator();
            int count = 0;
            while (it.hasNext()) {
                double d = it.getDoubleNext();
                newArray.set(count++, d);
            }
            v.setCachedData(newArray, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    private double findAttributeDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (att == null) {
            return Double.NaN;
        }
        return att.getNumericValue().doubleValue();
    }

    protected void assignCoordinateTransforms(NetcdfDataset ncDataset) {
        super.assignCoordinateTransforms(ncDataset);
        List<CoordinateSystem> csys = ncDataset.getCoordinateSystems();
        for (CoordinateSystem cs : csys) {
            String units;
            if (cs.getZaxis() == null || (units = cs.getZaxis().getUnitsString()) != null && units.trim().length() != 0) continue;
            VerticalCT vct = this.makeWRFEtaVerticalCoordinateTransform(ncDataset, cs);
            if (vct != null) {
                cs.addCoordinateTransform(vct);
            }
            this.parseInfo.append("***Added WRFEta verticalCoordinateTransform to ").append(cs.getName()).append("\n");
        }
    }

    private VerticalCT makeWRFEtaVerticalCoordinateTransform(NetcdfDataset ds, CoordinateSystem cs) {
        if (null == ds.findVariable("PH") || null == ds.findVariable("PHB") || null == ds.findVariable("P") || null == ds.findVariable("PB")) {
            return null;
        }
        WRFEtaTransformBuilder builder = new WRFEtaTransformBuilder(cs);
        return (VerticalCT)builder.makeCoordinateTransform(ds, null);
    }

    public static void main(String[] args) throws IOException, InvalidRangeException {
        double val;
        NetcdfFile ncd = NetcdfDataset.openFile("R:/testdata/wrf/WRFOU~C@", null);
        Variable glat = ncd.findVariable("GLAT");
        Array glatData = glat.read();
        IndexIterator ii = glatData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(Math.toDegrees(ii.getDoubleNext()));
        }
        NCdump.printArray(glatData, "GLAT", System.out, null);
        Variable glon = ncd.findVariable("GLON");
        Array glonData = glon.read();
        ii = glonData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setDoubleCurrent(Math.toDegrees(ii.getDoubleNext()));
        }
        NCdump.printArray(glonData, "GLON", System.out, null);
        Index index = glatData.getIndex();
        Index index2 = glatData.getIndex();
        int[] vshape = glatData.getShape();
        int ny = vshape[1];
        int nx = vshape[2];
        ArrayDouble.D1 diff_y = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{ny});
        ArrayDouble.D1 diff_x = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{nx});
        for (int y = 0; y < ny - 1; ++y) {
            val = glatData.getDouble(index.set(0, y, 0)) - glatData.getDouble(index2.set(0, y + 1, 0));
            diff_y.set(y, val);
        }
        for (int x = 0; x < nx - 1; ++x) {
            val = glatData.getDouble(index.set(0, 0, x)) - glatData.getDouble(index2.set(0, 0, x + 1));
            diff_x.set(x, val);
        }
        NCdump.printArray((Array)diff_y, "diff_y", System.out, null);
        NCdump.printArray((Array)diff_x, "diff_x", System.out, null);
        ncd.close();
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

