/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import loci.common.Log;

public final class LogTools {
    private static boolean debug = false;
    private static int debugLevel = 1;
    private static Log log = new Log();

    private LogTools() {
    }

    public static void setLog(Log log) {
        LogTools.log = log;
    }

    public static Log getLog() {
        return log;
    }

    public static void print(boolean x) {
        log.print(x);
    }

    public static void print(char x) {
        log.print(x);
    }

    public static void print(double x) {
        log.print(x);
    }

    public static void print(float x) {
        log.print(x);
    }

    public static void print(int x) {
        log.print(x);
    }

    public static void print(long x) {
        log.print(x);
    }

    public static void print(Object x) {
        log.print(x);
    }

    public static void print(String x) {
        log.print(x);
    }

    public static void println() {
        log.println();
    }

    public static void println(boolean x) {
        log.println(x);
    }

    public static void println(char x) {
        log.println(x);
    }

    public static void println(double x) {
        log.println(x);
    }

    public static void println(float x) {
        log.println(x);
    }

    public static void println(int x) {
        log.println(x);
    }

    public static void println(long x) {
        log.println(x);
    }

    public static void println(Object x) {
        log.println(x);
    }

    public static void println(String x) {
        log.println(x);
    }

    public static void trace(String s) {
        log.trace(s);
    }

    public static void trace(Throwable t) {
        log.trace(t);
    }

    public static void flush() {
        log.flush();
    }

    public static void setDebug(boolean debug) {
        LogTools.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebugLevel(int debugLevel) {
        LogTools.debugLevel = debugLevel;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void debug(String s) {
        LogTools.debug(s, 0);
    }

    public static void debug(String s, int minLevel) {
        String prefix;
        if (!debug || debugLevel < minLevel) {
            return;
        }
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String className = "";
        for (StackTraceElement ste : trace) {
            String cn = ste.getClassName();
            String mn = ste.getMethodName();
            if (cn.equals(LogTools.class.getName()) && mn.equals("debug")) continue;
            className = cn;
            break;
        }
        if (className.startsWith(prefix = "loci.")) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        String msg = System.currentTimeMillis() + ": " + className + ": " + s;
        if (debugLevel > 3) {
            LogTools.trace(msg);
        } else {
            LogTools.println(msg);
        }
    }

    public static void traceDebug(String s) {
        LogTools.traceDebug(s, 0);
    }

    public static void traceDebug(Throwable t) {
        LogTools.traceDebug(t, 0);
    }

    public static void traceDebug(String s, int minLevel) {
        if (debug && debugLevel >= minLevel) {
            LogTools.trace(s);
        }
    }

    public static void traceDebug(Throwable t, int minLevel) {
        if (debug && debugLevel >= minLevel) {
            LogTools.trace(t);
        }
    }

    public static void warnDebug(String message) {
        if (debug) {
            LogTools.println("Warning: " + message);
        }
    }
}

