/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.config;

import java.awt.Component;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import loci.plugins.config.IFormatWidgets;

public class FormatEntry
implements Comparable {
    private Object reader;
    private String formatName;
    protected String readerName;
    protected String[] suffixes;
    protected String[] labels;
    protected Component[] widgets;

    public FormatEntry(PrintWriter log, Object reader) {
        IFormatWidgets fw;
        block4: {
            this.reader = reader;
            Class<?> readerClass = reader.getClass();
            String n = readerClass.getName();
            this.readerName = n.substring(n.lastIndexOf(".") + 1, n.length() - 6);
            try {
                Method getFormat = readerClass.getMethod("getFormat", new Class[0]);
                this.formatName = (String)getFormat.invoke(this.reader, new Object[0]);
                Method getSuffixes = readerClass.getMethod("getSuffixes", new Class[0]);
                this.suffixes = (String[])getSuffixes.invoke(this.reader, new Object[0]);
                log.println("Successfully queried " + this.readerName + " reader.");
            }
            catch (Throwable t) {
                log.println("Error querying " + this.readerName + " reader:");
                t.printStackTrace(log);
                log.println();
                this.suffixes = new String[0];
            }
            fw = null;
            String fwClassName = "loci.plugins.config." + this.readerName + "Widgets";
            try {
                Class<?> fwClass = Class.forName(fwClassName);
                fw = (IFormatWidgets)fwClass.newInstance();
                log.println("Initialized extra widgets for " + this.readerName + " reader.");
            }
            catch (Throwable t) {
                if (t instanceof ClassNotFoundException) break block4;
                log.println("Error constructing widgets for " + this.readerName + " reader:");
                t.printStackTrace(log);
            }
        }
        this.labels = fw == null ? new String[]{} : fw.getLabels();
        this.widgets = fw == null ? new Component[]{} : fw.getWidgets();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return "<html>" + this.formatName;
    }
}

