/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResolutionBox
extends Box {
    private short numV;
    private short numH;
    private short denomV;
    private short denomH;
    private byte expV;
    private byte expH;
    private float hRes;
    private float vRes;

    public ResolutionBox(int type, byte[] data) {
        super(18, type, data);
    }

    public ResolutionBox(int type, float hRes, float vRes) {
        super(18, type, null);
        int temp;
        this.hRes = hRes;
        this.vRes = vRes;
        this.denomV = 1;
        this.denomH = 1;
        this.expV = 0;
        if (vRes >= 32768.0f) {
            for (temp = (int)vRes; temp >= 32768; temp /= 10) {
                this.expV = (byte)(this.expV + 1);
            }
            this.numV = (short)(temp & 0xFFFF);
        } else {
            this.numV = (short)vRes;
        }
        this.expH = 0;
        if (hRes >= 32768.0f) {
            for (temp = (int)hRes; temp >= 32768; temp /= 10) {
                this.expH = (byte)(this.expH + 1);
            }
            this.numH = (short)(temp & 0xFFFF);
        } else {
            this.numH = (short)hRes;
        }
    }

    public ResolutionBox(Node node2) throws IIOInvalidTreeException {
        super(node2);
        NodeList children = node2.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("VerticalResolutionNumerator".equals(name)) {
                this.numV = Box.getShortElementValue(child);
            }
            if ("VerticalResolutionDenominator".equals(name)) {
                this.denomV = Box.getShortElementValue(child);
            }
            if ("HorizontalResolutionNumerator".equals(name)) {
                this.numH = Box.getShortElementValue(child);
            }
            if ("HorizontalResolutionDenominator".equals(name)) {
                this.denomH = Box.getShortElementValue(child);
            }
            if ("VerticalResolutionExponent".equals(name)) {
                this.expV = Box.getByteElementValue(child);
            }
            if (!"HorizontalResolutionExponent".equals(name)) continue;
            this.expH = Box.getByteElementValue(child);
        }
    }

    public float getHorizontalResolution() {
        return this.hRes;
    }

    public float getVerticalResolution() {
        return this.vRes;
    }

    protected void parse(byte[] data) {
        this.numV = (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        this.denomV = (short)((data[2] & 0xFF) << 8 | data[3] & 0xFF);
        this.numH = (short)((data[4] & 0xFF) << 8 | data[5] & 0xFF);
        this.denomH = (short)((data[6] & 0xFF) << 8 | data[7] & 0xFF);
        this.expV = data[8];
        this.expH = data[9];
        this.vRes = (float)((double)(this.numV & 0xFFFF) * Math.pow(10.0, this.expV) / (double)(this.denomV & 0xFFFF));
        this.hRes = (float)((double)(this.numH & 0xFFFF) * Math.pow(10.0, this.expH) / (double)(this.denomH & 0xFFFF));
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode node2 = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(node2);
        IIOMetadataNode child = new IIOMetadataNode("VerticalResolutionNumerator");
        child.setUserObject(new Short(this.numV));
        child.setNodeValue("" + this.numV);
        node2.appendChild(child);
        child = new IIOMetadataNode("VerticalResolutionDenominator");
        child.setUserObject(new Short(this.denomV));
        child.setNodeValue("" + this.denomV);
        node2.appendChild(child);
        child = new IIOMetadataNode("HorizontalResolutionNumerator");
        child.setUserObject(new Short(this.numH));
        child.setNodeValue("" + this.numH);
        node2.appendChild(child);
        child = new IIOMetadataNode("HorizontalResolutionDenominator");
        child.setUserObject(new Short(this.denomH));
        child.setNodeValue("" + this.denomH);
        node2.appendChild(child);
        child = new IIOMetadataNode("VerticalResolutionExponent");
        child.setUserObject(new Byte(this.expV));
        child.setNodeValue("" + this.expV);
        node2.appendChild(child);
        child = new IIOMetadataNode("HorizontalResolutionExponent");
        child.setUserObject(new Byte(this.expH));
        child.setNodeValue("" + this.expH);
        node2.appendChild(child);
        return node2;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[10];
        this.data[0] = (byte)(this.numV >> 8);
        this.data[1] = (byte)(this.numV & 0xFF);
        this.data[2] = (byte)(this.denomV >> 8);
        this.data[3] = (byte)(this.denomV & 0xFF);
        this.data[4] = (byte)(this.numH >> 8);
        this.data[5] = (byte)(this.numH & 0xFF);
        this.data[6] = (byte)(this.denomH >> 8);
        this.data[7] = (byte)(this.denomH & 0xFF);
        this.data[8] = this.expV;
        this.data[9] = this.expH;
    }
}

