/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import loci.common.RandomAccessInputStream;

public final class DataTools {
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private static ThreadLocal<byte[]> eightBytes = new ThreadLocal<byte[]>(){

        @Override
        protected synchronized byte[] initialValue() {
            return new byte[8];
        }
    };

    private DataTools() {
    }

    public static String readFile(String id) throws IOException {
        RandomAccessInputStream in = new RandomAccessInputStream(id);
        long idLen = in.length();
        if (idLen > Integer.MAX_VALUE) {
            throw new IOException("File too large");
        }
        int len = (int)idLen;
        String data = in.readString(len);
        in.close();
        return data;
    }

    public static byte readSignedByte(DataInput in) throws IOException {
        byte[] b = eightBytes.get();
        in.readFully(b, 0, 1);
        return b[0];
    }

    public static short readUnsignedByte(DataInput in) throws IOException {
        short q = DataTools.readSignedByte(in);
        if (q < 0) {
            q = (short)(q + 256);
        }
        return q;
    }

    public static short read2SignedBytes(DataInput in, boolean little) throws IOException {
        byte[] b = eightBytes.get();
        in.readFully(b, 0, 2);
        return DataTools.bytesToShort(b, little);
    }

    public static int read2UnsignedBytes(DataInput in, boolean little) throws IOException {
        int q = DataTools.read2SignedBytes(in, little);
        if (q < 0) {
            q += 65536;
        }
        return q;
    }

    public static int read4SignedBytes(DataInput in, boolean little) throws IOException {
        byte[] b = eightBytes.get();
        in.readFully(b, 0, 4);
        return DataTools.bytesToInt(b, little);
    }

    public static long read4UnsignedBytes(DataInput in, boolean little) throws IOException {
        long q = DataTools.read4SignedBytes(in, little);
        if (q < 0L) {
            q += 0x100000000L;
        }
        return q;
    }

    public static long read8SignedBytes(DataInput in, boolean little) throws IOException {
        byte[] b = eightBytes.get();
        in.readFully(b, 0, 8);
        return DataTools.bytesToLong(b, little);
    }

    public static float readFloat(DataInput in, boolean little) throws IOException {
        return Float.intBitsToFloat(DataTools.read4SignedBytes(in, little));
    }

    public static double readDouble(DataInput in, boolean little) throws IOException {
        return Double.longBitsToDouble(DataTools.read8SignedBytes(in, little));
    }

    public static void writeString(DataOutput out, String s) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        out.write(b);
    }

    public static void writeDouble(DataOutput out, double v, boolean little) throws IOException {
        DataTools.writeLong(out, Double.doubleToLongBits(v), little);
    }

    public static void writeLong(DataOutput out, long v, boolean little) throws IOException {
        for (int i = 0; i < 8; ++i) {
            int shift = little ? i * 8 : 64 - (i + 1) * 8;
            out.write((int)(v >>> shift & 0xFFL));
        }
    }

    public static void writeFloat(DataOutput out, float v, boolean little) throws IOException {
        DataTools.writeInt(out, Float.floatToIntBits(v), little);
    }

    public static void writeInt(DataOutput out, int v, boolean little) throws IOException {
        for (int i = 0; i < 4; ++i) {
            int shift = little ? i * 8 : 32 - (i + 1) * 8;
            out.write(v >>> shift & 0xFF);
        }
    }

    public static void writeShort(DataOutput out, int v, boolean little) throws IOException {
        for (int i = 0; i < 2; ++i) {
            int shift = little ? i * 8 : 16 - (i + 1) * 8;
            out.write(v >>> shift & 0xFF);
        }
    }

    public static short bytesToShort(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        short total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total = (short)(total | (bytes[ndx] < 0 ? 256 + bytes[ndx] : bytes[ndx]) << (little ? i : len - i - 1) * 8);
            ++i;
            ++ndx;
        }
        return total;
    }

    public static short bytesToShort(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToShort(bytes, off, 2, little);
    }

    public static short bytesToShort(byte[] bytes, boolean little) {
        return DataTools.bytesToShort(bytes, 0, 2, little);
    }

    public static short bytesToShort(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        short total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total = (short)(total | bytes[ndx] << (little ? i : len - i - 1) * 8);
            ++i;
            ++ndx;
        }
        return total;
    }

    public static short bytesToShort(short[] bytes, int off, boolean little) {
        return DataTools.bytesToShort(bytes, off, 2, little);
    }

    public static short bytesToShort(short[] bytes, boolean little) {
        return DataTools.bytesToShort(bytes, 0, 2, little);
    }

    public static int bytesToInt(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        int total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (bytes[ndx] < 0 ? 256 + bytes[ndx] : bytes[ndx]) << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static int bytesToInt(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToInt(bytes, off, 4, little);
    }

    public static int bytesToInt(byte[] bytes, boolean little) {
        return DataTools.bytesToInt(bytes, 0, 4, little);
    }

    public static int bytesToInt(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        int total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= bytes[ndx] << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static int bytesToInt(short[] bytes, int off, boolean little) {
        return DataTools.bytesToInt(bytes, off, 4, little);
    }

    public static int bytesToInt(short[] bytes, boolean little) {
        return DataTools.bytesToInt(bytes, 0, 4, little);
    }

    public static float bytesToFloat(byte[] bytes, int off, int len, boolean little) {
        return Float.intBitsToFloat(DataTools.bytesToInt(bytes, off, len, little));
    }

    public static float bytesToFloat(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToFloat(bytes, off, 4, little);
    }

    public static float bytesToFloat(byte[] bytes, boolean little) {
        return DataTools.bytesToFloat(bytes, 0, 4, little);
    }

    public static float bytesToFloat(short[] bytes, int off, int len, boolean little) {
        return Float.intBitsToFloat(DataTools.bytesToInt(bytes, off, len, little));
    }

    public static float bytesToFloat(short[] bytes, int off, boolean little) {
        return DataTools.bytesToInt(bytes, off, 4, little);
    }

    public static float bytesToFloat(short[] bytes, boolean little) {
        return DataTools.bytesToInt(bytes, 0, 4, little);
    }

    public static long bytesToLong(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        long total = 0L;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (bytes[ndx] < 0 ? 256L + (long)bytes[ndx] : (long)bytes[ndx]) << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static long bytesToLong(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToLong(bytes, off, 8, little);
    }

    public static long bytesToLong(byte[] bytes, boolean little) {
        return DataTools.bytesToLong(bytes, 0, 8, little);
    }

    public static long bytesToLong(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        long total = 0L;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (long)bytes[ndx] << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static long bytesToLong(short[] bytes, int off, boolean little) {
        return DataTools.bytesToLong(bytes, off, 8, little);
    }

    public static long bytesToLong(short[] bytes, boolean little) {
        return DataTools.bytesToLong(bytes, 0, 8, little);
    }

    public static double bytesToDouble(byte[] bytes, int off, int len, boolean little) {
        return Double.longBitsToDouble(DataTools.bytesToLong(bytes, off, len, little));
    }

    public static double bytesToDouble(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToDouble(bytes, off, 8, little);
    }

    public static double bytesToDouble(byte[] bytes, boolean little) {
        return DataTools.bytesToDouble(bytes, 0, 8, little);
    }

    public static double bytesToDouble(short[] bytes, int off, int len, boolean little) {
        return Double.longBitsToDouble(DataTools.bytesToLong(bytes, off, len, little));
    }

    public static double bytesToDouble(short[] bytes, int off, boolean little) {
        return DataTools.bytesToDouble(bytes, off, 8, little);
    }

    public static double bytesToDouble(short[] bytes, boolean little) {
        return DataTools.bytesToDouble(bytes, 0, 8, little);
    }

    public static byte[] shortToBytes(short value, boolean little) {
        byte[] v = new byte[2];
        DataTools.unpackBytes(value, v, 0, 2, little);
        return v;
    }

    public static byte[] intToBytes(int value, boolean little) {
        byte[] v = new byte[4];
        DataTools.unpackBytes(value, v, 0, 4, little);
        return v;
    }

    public static byte[] floatToBytes(float value, boolean little) {
        byte[] v = new byte[4];
        DataTools.unpackBytes(Float.floatToIntBits(value), v, 0, 4, little);
        return v;
    }

    public static byte[] longToBytes(long value, boolean little) {
        byte[] v = new byte[8];
        DataTools.unpackBytes(value, v, 0, 8, little);
        return v;
    }

    public static byte[] doubleToBytes(double value, boolean little) {
        byte[] v = new byte[8];
        DataTools.unpackBytes(Double.doubleToLongBits(value), v, 0, 8, little);
        return v;
    }

    public static byte[] shortsToBytes(short[] values, boolean little) {
        byte[] v = new byte[values.length * 2];
        for (int i = 0; i < values.length; ++i) {
            DataTools.unpackBytes(values[i], v, i * 2, 2, little);
        }
        return v;
    }

    public static byte[] intsToBytes(int[] values, boolean little) {
        byte[] v = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            DataTools.unpackBytes(values[i], v, i * 4, 4, little);
        }
        return v;
    }

    public static byte[] floatsToBytes(float[] values, boolean little) {
        byte[] v = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            DataTools.unpackBytes(Float.floatToIntBits(values[i]), v, i * 4, 4, little);
        }
        return v;
    }

    public static byte[] longsToBytes(long[] values, boolean little) {
        byte[] v = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            DataTools.unpackBytes(values[i], v, i * 8, 8, little);
        }
        return v;
    }

    public static byte[] doublesToBytes(long[] values, boolean little) {
        byte[] v = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            DataTools.unpackBytes(Double.doubleToLongBits(values[i]), v, i * 8, 8, little);
        }
        return v;
    }

    public static void unpackShort(short value, byte[] buf, int ndx, boolean little) {
        DataTools.unpackBytes(value, buf, ndx, 2, little);
    }

    public static void unpackBytes(long value, byte[] buf, int ndx, int nBytes, boolean little) {
        if (little) {
            for (int i = 0; i < nBytes; ++i) {
                buf[ndx + i] = (byte)(value >> 8 * i & 0xFFL);
            }
        } else {
            for (int i = 0; i < nBytes; ++i) {
                buf[ndx + i] = (byte)(value >> 8 * (nBytes - i - 1) & 0xFFL);
            }
        }
    }

    public static Object makeDataArray(byte[] b, int bpp, boolean fp, boolean little) {
        if (bpp == 1) {
            return b;
        }
        if (bpp == 2) {
            short[] s = new short[b.length / 2];
            for (int i = 0; i < s.length; ++i) {
                s[i] = DataTools.bytesToShort(b, i * 2, 2, little);
            }
            return s;
        }
        if (bpp == 4 && fp) {
            float[] f = new float[b.length / 4];
            for (int i = 0; i < f.length; ++i) {
                f[i] = DataTools.bytesToFloat(b, i * 4, 4, little);
            }
            return f;
        }
        if (bpp == 4) {
            int[] i = new int[b.length / 4];
            for (int j = 0; j < i.length; ++j) {
                i[j] = DataTools.bytesToInt(b, j * 4, 4, little);
            }
            return i;
        }
        if (bpp == 8 && fp) {
            double[] d = new double[b.length / 8];
            for (int i = 0; i < d.length; ++i) {
                d[i] = DataTools.bytesToDouble(b, i * 8, 8, little);
            }
            return d;
        }
        if (bpp == 8) {
            long[] l = new long[b.length / 8];
            for (int i = 0; i < l.length; ++i) {
                l[i] = DataTools.bytesToLong(b, i * 8, 8, little);
            }
            return l;
        }
        return null;
    }

    public static Object makeDataArray(byte[] b, int bpp, boolean fp, boolean little, boolean signed) {
        return DataTools.makeDataArray(b, bpp, fp, little);
    }

    public static short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    public static char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    public static int swap(int x) {
        return DataTools.swap((short)x) << 16 | DataTools.swap((short)(x >> 16)) & 0xFFFF;
    }

    public static long swap(long x) {
        return (long)DataTools.swap((int)x) << 32 | (long)DataTools.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public static float swap(float x) {
        return Float.intBitsToFloat(DataTools.swap(Float.floatToIntBits(x)));
    }

    public static double swap(double x) {
        return Double.longBitsToDouble(DataTools.swap(Double.doubleToLongBits(x)));
    }

    public static String stripString(String toStrip) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < toStrip.length(); ++i) {
            if (toStrip.charAt(i) == '\u0000') continue;
            s.append(toStrip.charAt(i));
        }
        return s.toString().trim();
    }

    public static boolean samePrefix(String s1, String s2) {
        String sub2;
        if (s1 == null || s2 == null) {
            return false;
        }
        int n1 = s1.indexOf(".");
        int n2 = s2.indexOf(".");
        if (n1 == -1 || n2 == -1) {
            return false;
        }
        int slash1 = s1.lastIndexOf(File.pathSeparator);
        int slash2 = s2.lastIndexOf(File.pathSeparator);
        String sub1 = s1.substring(slash1 + 1, n1);
        return sub1.equals(sub2 = s2.substring(slash2 + 1, n2)) || sub1.startsWith(sub2) || sub2.startsWith(sub1);
    }

    public static String sanitize(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(s);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c == '\t' || c == '\n' || c >= ' ' && c <= '~') continue;
            buf = buf.deleteCharAt(i--);
        }
        return buf.toString();
    }

    public static float[] normalizeFloats(float[] data) {
        int i;
        float[] rtn = new float[data.length];
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (i = 0; i < data.length; ++i) {
            if (data[i] == Float.POSITIVE_INFINITY || data[i] == Float.NEGATIVE_INFINITY) continue;
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i] == Float.POSITIVE_INFINITY) {
                data[i] = max;
                continue;
            }
            if (data[i] != Float.NEGATIVE_INFINITY) continue;
            data[i] = min;
        }
        float range = max - min;
        for (int i2 = 0; i2 < rtn.length; ++i2) {
            rtn[i2] = (data[i2] - min) / range;
        }
        return rtn;
    }

    public static double[] normalizeDoubles(double[] data) {
        int i;
        double[] rtn = new double[data.length];
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (i = 0; i < data.length; ++i) {
            if (data[i] == Double.POSITIVE_INFINITY || data[i] == Double.NEGATIVE_INFINITY) continue;
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i] == Double.POSITIVE_INFINITY) {
                data[i] = max;
                continue;
            }
            if (data[i] != Double.NEGATIVE_INFINITY) continue;
            data[i] = min;
        }
        double range = max - min;
        for (int i2 = 0; i2 < rtn.length; ++i2) {
            rtn[i2] = (data[i2] - min) / range;
        }
        return rtn;
    }

    public static boolean containsValue(int[] array, int value) {
        return DataTools.indexOf(array, value) != -1;
    }

    public static int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (!(value == null ? array[i] == null : value.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static byte[] makeSigned(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(b[i] + 128);
        }
        return b;
    }

    public static short[] makeSigned(short[] s) {
        for (int i = 0; i < s.length; ++i) {
            s[i] = (short)(s[i] + 32768);
        }
        return s;
    }

    public static int[] makeSigned(int[] i) {
        for (int j = 0; j < i.length; ++j) {
            i[j] = (int)((long)i[j] + 0x80000000L);
        }
        return i;
    }
}

