/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;

public abstract class FormatWriter
extends FormatHandler
implements IFormatWriter {
    protected int fps = 10;
    protected ColorModel cm;
    protected String[] compressionTypes;
    protected String compression;
    protected boolean initialized;
    protected boolean interleaved;
    protected MetadataRetrieve metadataRetrieve = new DummyMetadata();

    public FormatWriter(String format, String suffix) {
        super(format, suffix);
    }

    public FormatWriter(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void saveBytes(byte[] bytes, boolean last) throws FormatException, IOException {
        this.saveBytes(bytes, 0, last, last);
    }

    public void savePlane(Object plane, boolean last) throws FormatException, IOException {
        this.savePlane(plane, 0, last, last);
    }

    public void savePlane(Object plane, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        if (!(plane instanceof byte[])) {
            throw new IllegalArgumentException("Object to save must be a byte[]");
        }
        this.saveBytes((byte[])plane, series, lastInSeries, last);
    }

    public void setInterleaved(boolean interleaved) {
        this.interleaved = interleaved;
    }

    public boolean isInterleaved() {
        return this.interleaved;
    }

    public boolean canDoStacks() {
        return false;
    }

    public void setMetadataRetrieve(MetadataRetrieve retrieve) {
        FormatTools.assertId(this.currentId, false, 1);
        if (retrieve == null) {
            throw new IllegalArgumentException("Metadata object is null");
        }
        this.metadataRetrieve = retrieve;
    }

    public MetadataRetrieve getMetadataRetrieve() {
        return this.metadataRetrieve;
    }

    public void setColorModel(ColorModel model) {
        this.cm = model;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public void setFramesPerSecond(int rate) {
        this.fps = rate;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public String[] getCompressionTypes() {
        return this.compressionTypes;
    }

    public void setCompression(String compress) throws FormatException {
        for (int i = 0; i < this.compressionTypes.length; ++i) {
            if (!this.compressionTypes[i].equals(compress)) continue;
            this.compression = compress;
            return;
        }
        throw new FormatException("Invalid compression type: " + compress);
    }

    public String getCompression() {
        return this.compression;
    }

    public int[] getPixelTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    public int[] getPixelTypes(String codec) {
        return this.getPixelTypes();
    }

    public boolean isSupportedType(int type) {
        int[] types = this.getPixelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            return true;
        }
        return false;
    }

    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        this.close();
        this.currentId = id;
        this.initialized = false;
    }
}

