/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.LosslessJPEGCodec;
import loci.formats.gui.AWTImageTools;

public class JPEGCodec
extends BaseCodec {
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (options.bitsPerSample > 8) {
            throw new FormatException("> 8 bit data cannot be compressed with JPEG.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = AWTImageTools.makeImage(data, options.width, options.height, options.channels, options.interleaved, options.bitsPerSample / 8, false, options.littleEndian, options.signed);
        try {
            ImageIO.write((RenderedImage)img, "jpeg", out);
        }
        catch (IOException e) {
            throw new FormatException("Could not write JPEG data", e);
        }
        return out.toByteArray();
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        BufferedImage b;
        long fp = in.getFilePointer();
        try {
            try {
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
            }
            catch (EOFException e) {
                in.seek(fp);
            }
            b = ImageIO.read(new BufferedInputStream(new DataInputStream(in), 8192));
        }
        catch (IOException exc) {
            in.seek(fp);
            return new LosslessJPEGCodec().decompress(in, options);
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[][] buf = AWTImageTools.getPixelBytes(b, options.littleEndian);
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else if (options.interleaved) {
            int next = 0;
            for (int i = 0; i < buf[0].length; ++i) {
                for (int j = 0; j < buf.length; ++j) {
                    rtn[next++] = buf[j][i];
                }
            }
        } else {
            for (int i = 0; i < buf.length; ++i) {
                System.arraycopy(buf[i], 0, rtn, i * buf[0].length, buf[i].length);
            }
        }
        return rtn;
    }
}

