/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;

public class RPZACodec
extends BaseCodec {
    private int totalBlocks;
    private int pixelPtr;
    private int rowPtr;
    private int stride;

    public byte[] compress(byte[] input, CodecOptions options) throws FormatException {
        throw new FormatException("RPZA compression not supported.");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        in.skipBytes(8);
        int plane = options.width * options.height;
        this.stride = options.width;
        int rowInc = this.stride - 4;
        int colorA = 0;
        int[] color4 = new int[4];
        int blockPtr = 0;
        this.pixelPtr = 0;
        this.rowPtr = 0;
        int[] pixels = new int[plane];
        byte[] rtn = new byte[plane * 3];
        while (in.read() != -31) {
        }
        in.skipBytes(3);
        this.totalBlocks = (options.width + 3) / 4 * ((options.height + 3) / 4);
        while (in.getFilePointer() + 2L < in.length()) {
            int opcode = in.readByte();
            int nBlocks = (opcode & 0x1F) + 1;
            if ((opcode & 0x80) == 0) {
                if (in.getFilePointer() >= in.length()) break;
                colorA = opcode << 8 | in.read();
                opcode = 0;
                if (in.getFilePointer() >= in.length()) break;
                if ((in.read() & 0x80) != 0) {
                    opcode = 32;
                    nBlocks = 1;
                }
                in.seek(in.getFilePointer() - 1L);
            }
            switch (opcode & 0xE0) {
                case 128: {
                    while (nBlocks-- > 0) {
                        this.updateBlock(options.width);
                    }
                    break;
                }
                case 160: {
                    short s;
                    int pixelX;
                    int pixelY;
                    if (in.getFilePointer() + 2L >= in.length()) break;
                    colorA = in.readShort();
                    while (nBlocks-- > 0) {
                        blockPtr = this.rowPtr + this.pixelPtr;
                        for (pixelY = 0; pixelY < 4; ++pixelY) {
                            for (pixelX = 0; pixelX < 4 && blockPtr < pixels.length; ++blockPtr, ++pixelX) {
                                pixels[blockPtr] = colorA;
                                s = (short)(pixels[blockPtr] & Short.MAX_VALUE);
                                this.unpack(s, rtn, blockPtr, pixels.length);
                            }
                            blockPtr += rowInc;
                        }
                        this.updateBlock(options.width);
                    }
                    break;
                }
                case 32: 
                case 192: {
                    short s;
                    int pixelX;
                    int pixelY;
                    if (in.getFilePointer() + 2L >= in.length()) break;
                    if ((opcode & 0xE0) == 192) {
                        colorA = in.readShort();
                    }
                    short colorB = in.readShort();
                    color4[0] = colorB;
                    color4[1] = 0;
                    color4[2] = 0;
                    color4[3] = colorA;
                    int ta = colorA >> 10 & 0x1F;
                    int tb = colorB >> 10 & 0x1F;
                    color4[1] = color4[1] | 11 * ta + 21 * tb >> 5 << 10;
                    color4[2] = color4[2] | 21 * ta + 11 * tb >> 5 << 10;
                    ta = colorA >> 5 & 0x1F;
                    tb = colorB >> 5 & 0x1F;
                    color4[1] = color4[1] | 11 * ta + 21 * tb >> 5 << 5;
                    color4[2] = color4[2] | 21 * ta + 11 * tb >> 5 << 5;
                    ta = colorA & 0x1F;
                    tb = colorB & 0x1F;
                    color4[1] = color4[1] | 11 * ta + 21 * tb >> 5;
                    color4[2] = color4[2] | 21 * ta + 11 * tb >> 5;
                    while (nBlocks-- > 0) {
                        blockPtr = this.rowPtr + this.pixelPtr;
                        for (pixelY = 0; pixelY < 4 && in.getFilePointer() < in.length(); ++pixelY) {
                            int index = in.read();
                            for (pixelX = 0; pixelX < 4; ++pixelX) {
                                int idx = index >> 2 * (3 - pixelX) & 3;
                                if (blockPtr >= pixels.length) break;
                                pixels[blockPtr] = color4[idx];
                                s = (short)(pixels[blockPtr] & Short.MAX_VALUE);
                                this.unpack(s, rtn, blockPtr, pixels.length);
                                ++blockPtr;
                            }
                            blockPtr += rowInc;
                        }
                        this.updateBlock(options.width);
                    }
                    break;
                }
                case 0: {
                    short s;
                    int pixelX;
                    int pixelY;
                    blockPtr = this.rowPtr + this.pixelPtr;
                    for (pixelY = 0; pixelY < 4; ++pixelY) {
                        for (pixelX = 0; pixelX < 4; ++pixelX) {
                            if (pixelY != 0 || pixelX != 0) {
                                if (in.getFilePointer() + 2L >= in.length()) break;
                                colorA = in.readShort();
                            }
                            if (blockPtr >= pixels.length) break;
                            pixels[blockPtr] = colorA;
                            s = (short)(pixels[blockPtr] & Short.MAX_VALUE);
                            this.unpack(s, rtn, blockPtr, pixels.length);
                            ++blockPtr;
                        }
                        blockPtr += rowInc;
                    }
                    this.updateBlock(options.width);
                }
            }
        }
        return rtn;
    }

    private void unpack(short s, byte[] array, int offset, int len) {
        array[offset] = (byte)(255 - ((s & 0x7C00) >> 10));
        array[offset + len] = (byte)(255 - ((s & 0x3E0) >> 5));
        array[offset + 2 * len] = (byte)(255 - (s & 0x1F));
    }

    private void updateBlock(int width) {
        this.pixelPtr += 4;
        if (this.pixelPtr >= width) {
            this.pixelPtr = 0;
            this.rowPtr += this.stride * 4;
        }
        --this.totalBlocks;
    }
}

