/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class FitsReader
extends FormatReader {
    private int count;

    public FitsReader() {
        super("Flexible Image Transport System", "fits");
        this.domains = new String[]{"Astronomy", "Graphics"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(2880 * ((this.count * 80 - 1) / 2880 + 1));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.count = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("FitsReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.count = 1;
        String line = this.in.readString(80);
        if (!line.startsWith("SIMPLE")) {
            throw new FormatException("Unsupported FITS file.");
        }
        String key = "";
        String value = "";
        while (true) {
            int ndx;
            ++this.count;
            line = this.in.readString(80);
            int comment = line.indexOf("/", ndx = line.indexOf("="));
            if (comment < 0) {
                comment = line.length();
            }
            if (ndx >= 0) {
                key = line.substring(0, ndx).trim();
                value = line.substring(ndx + 1, comment).trim();
            } else {
                key = line.trim();
            }
            if (key.equals("END") && this.getSizeX() > 0) break;
            if (key.equals("BITPIX")) {
                int bits = Integer.parseInt(value);
                switch (bits) {
                    case 8: {
                        this.core[0].pixelType = 1;
                        break;
                    }
                    case 16: {
                        this.core[0].pixelType = 2;
                        break;
                    }
                    case 32: {
                        this.core[0].pixelType = 4;
                        break;
                    }
                    case -32: {
                        this.core[0].pixelType = 6;
                        break;
                    }
                    case -64: {
                        this.core[0].pixelType = 7;
                        break;
                    }
                    default: {
                        throw new FormatException("Unsupported pixel type: " + bits);
                    }
                }
            } else if (key.equals("NAXIS1")) {
                this.core[0].sizeX = Integer.parseInt(value);
            } else if (key.equals("NAXIS2")) {
                this.core[0].sizeY = Integer.parseInt(value);
            } else if (key.equals("NAXIS3")) {
                this.core[0].sizeZ = Integer.parseInt(value);
            }
            this.addGlobalMeta(key, value);
        }
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        this.core[0].imageCount = this.core[0].sizeZ;
        this.core[0].rgb = false;
        this.core[0].littleEndian = false;
        this.core[0].interleaved = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

