/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class GatanReader
extends FormatReader {
    public static final int DM3_MAGIC_BYTES = 3;
    private static final int GROUP = 20;
    private static final int VALUE = 21;
    private static final int ARRAY = 15;
    private static final int SHORT = 2;
    private static final int USHORT = 4;
    private static final int INT = 3;
    private static final int UINT = 5;
    private static final int FLOAT = 6;
    private static final int DOUBLE = 7;
    private static final int BYTE = 8;
    private static final int UBYTE = 9;
    private static final int CHAR = 10;
    private long pixelOffset;
    private Vector<String> pixelSizes;
    private int bytesPerPixel;
    private int pixelDataNum = 0;
    private int numPixelBytes;
    private boolean signed;
    private long timestamp;
    private float gamma;
    private float mag;
    private float voltage;
    private String info;

    public GatanReader() {
        super("Gatan Digital Micrograph", "dm3");
        this.domains = new String[]{"Electron Microscopy (EM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 3;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
            this.numPixelBytes = 0;
            this.pixelDataNum = 0;
            this.bytesPerPixel = 0;
            this.pixelSizes = null;
            this.signed = false;
            this.timestamp = 0L;
            this.voltage = 0.0f;
            this.mag = 0.0f;
            this.gamma = 0.0f;
            this.info = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("GatanReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixelOffset = 0L;
        this.status("Verifying Gatan format");
        this.core[0].littleEndian = false;
        this.pixelSizes = new Vector();
        this.in.order(false);
        if (this.in.readInt() != 3) {
            throw new FormatException("invalid header");
        }
        this.status("Reading tags");
        this.in.skipBytes(4);
        this.core[0].littleEndian = this.in.readInt() == 1;
        this.in.order(!this.isLittleEndian());
        this.in.skipBytes(2);
        int numTags = this.in.readInt();
        this.debug("tags (" + numTags + ") {");
        this.parseTags(numTags, null, "  ");
        this.debug("}");
        this.status("Populating metadata");
        this.core[0].littleEndian = true;
        if (this.getSizeX() == 0 || this.getSizeY() == 0) {
            throw new FormatException("Dimensions information not found");
        }
        int bytes = this.numPixelBytes / (this.getSizeX() * this.getSizeY());
        switch (bytes) {
            case 1: {
                this.core[0].pixelType = this.signed ? 0 : 1;
                break;
            }
            case 2: {
                this.core[0].pixelType = this.signed ? 2 : 3;
                break;
            }
            case 4: {
                this.core[0].pixelType = this.signed ? 4 : 5;
                break;
            }
            default: {
                throw new FormatException("Unsupported pixel type");
            }
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].imageCount = 1;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        Float pixX = new Float(1.0f);
        Float pixY = new Float(1.0f);
        Float pixZ = new Float(1.0f);
        if (this.pixelSizes.size() > 0) {
            pixX = new Float(this.pixelSizes.get(0));
        }
        if (this.pixelSizes.size() > 1) {
            pixY = new Float(this.pixelSizes.get(1));
        }
        if (this.pixelSizes.size() > 2) {
            pixZ = new Float(this.pixelSizes.get(2));
        }
        store.setDimensionsPhysicalSizeX(pixX, 0, 0);
        store.setDimensionsPhysicalSizeY(pixY, 0, 0);
        store.setDimensionsPhysicalSizeZ(pixZ, 0, 0);
        for (int i = 0; i < this.getSizeC(); ++i) {
        }
        if (this.info == null) {
            this.info = "";
        }
        StringTokenizer scopeInfo = new StringTokenizer(this.info, "(");
        while (scopeInfo.hasMoreTokens()) {
            String token = scopeInfo.nextToken().trim();
            if (token.startsWith("Microscope") || !token.startsWith("Mode")) continue;
            String mode = (token = token.substring(token.indexOf(" ")).trim()).substring(0, token.indexOf(" ")).trim();
            if (mode.equals("TEM")) {
                mode = "Other";
            }
            store.setLogicalChannelMode(mode, 0, 0);
        }
    }

    private void parseTags(int numTags, String parent, String indent) throws FormatException, IOException {
        for (int i = 0; i < numTags; ++i) {
            byte type = this.in.readByte();
            int length = this.in.readShort();
            String labelString = null;
            String value = null;
            if (type == 21) {
                int j;
                int numFields;
                labelString = this.in.readString(length);
                int skip = this.in.readInt();
                int n = this.in.readInt();
                int dataType = this.in.readInt();
                String sb = labelString;
                if (sb.length() > 32) {
                    sb = sb.substring(0, 20) + "... (" + sb.length() + ")";
                }
                this.debug(indent + i + ": n=" + n + ", dataType=" + dataType + ", label=" + sb);
                if (skip != 0x25252525) {
                    this.warn("Skip mismatch: " + skip);
                }
                if (n == 1) {
                    if ("Dimensions".equals(parent) && labelString.length() == 0) {
                        this.in.order(!this.in.isLittleEndian());
                        if (i == 0) {
                            this.core[0].sizeX = this.in.readInt();
                        } else if (i == 1) {
                            this.core[0].sizeY = this.in.readInt();
                        }
                        this.in.order(!this.in.isLittleEndian());
                    } else {
                        value = String.valueOf(this.readValue(dataType));
                    }
                } else if (n == 2) {
                    if (dataType == 18) {
                        length = this.in.readInt();
                    } else {
                        this.warn("dataType mismatch: " + dataType);
                    }
                    value = this.in.readString(length);
                } else if (n == 3) {
                    if (dataType == 20) {
                        dataType = this.in.readInt();
                        length = this.in.readInt();
                        if (labelString.equals("Data")) {
                            this.pixelOffset = this.in.getFilePointer();
                            this.in.skipBytes(this.getNumBytes(dataType) * length);
                            this.numPixelBytes = (int)(this.in.getFilePointer() - this.pixelOffset);
                        } else if (dataType == 10) {
                            this.in.skipBytes(length);
                        } else {
                            value = DataTools.stripString(this.in.readString(length * 2));
                        }
                    } else {
                        this.warn("dataType mismatch: " + dataType);
                    }
                } else if (dataType == 15) {
                    boolean lastTag;
                    this.in.skipBytes(4);
                    numFields = this.in.readInt();
                    StringBuffer s = new StringBuffer();
                    this.in.skipBytes(4);
                    for (j = 0; j < numFields; ++j) {
                        dataType = this.in.readInt();
                        s.append(this.readValue(dataType));
                        if (j >= numFields - 1) continue;
                        s.append(", ");
                    }
                    value = s.toString();
                    boolean bl = lastTag = parent == null && i == numTags - 1;
                    if (!lastTag) {
                        int b = 0;
                        int[] jumps = new int[]{4, 7, 5, 9};
                        for (int j2 = 0; j2 < jumps.length; ++j2) {
                            this.in.skipBytes(jumps[j2]);
                            b = this.in.readByte();
                            if (b == 20 || b == 21) break;
                        }
                        if (b != 20 && b != 21) {
                            throw new FormatException("Cannot find next tag (pos=" + this.in.getFilePointer() + ", label=" + labelString + ")");
                        }
                        this.in.seek(this.in.getFilePointer() - 1L);
                    }
                } else if (dataType == 20) {
                    dataType = this.in.readInt();
                    if (dataType == 15) {
                        this.in.skipBytes(4);
                        numFields = this.in.readInt();
                        int[] dataTypes = new int[numFields];
                        for (j = 0; j < numFields; ++j) {
                            this.in.skipBytes(4);
                            dataTypes[j] = this.in.readInt();
                        }
                        int len = this.in.readInt();
                        double[][] values = new double[numFields][len];
                        for (int k = 0; k < len; ++k) {
                            for (int q = 0; q < numFields; ++q) {
                                values[q][k] = this.readValue(dataTypes[q]);
                            }
                        }
                    } else {
                        this.warn("dataType mismatch: " + dataType);
                    }
                }
            } else if (type == 20) {
                labelString = this.in.readString(length);
                this.in.skipBytes(2);
                int num = this.in.readInt();
                this.debug(indent + i + ": group (" + num + ") {");
                this.parseTags(num, labelString, indent + "  ");
                this.debug(indent + "}");
            } else {
                this.debug(indent + i + ": unknown type: " + type);
            }
            if (value == null) continue;
            this.addGlobalMeta(labelString, value);
            if (labelString.equals("Scale")) {
                if (value.indexOf(",") == -1) {
                    this.pixelSizes.add(value);
                } else {
                    float start = Float.parseFloat(value.substring(0, value.indexOf(",")));
                    float end = Float.parseFloat(value.substring(value.indexOf(",") + 2));
                    this.pixelSizes.add(String.valueOf(end - start));
                }
            } else if (labelString.equals("LowLimit")) {
                this.signed = Float.parseFloat(value) < 0.0f;
            } else if (labelString.equals("Acquisition Start Time (epoch)")) {
                this.timestamp = (long)Double.parseDouble(value);
            } else if (labelString.equals("Voltage")) {
                this.voltage = Float.parseFloat(value);
            } else if (labelString.equals("Microscope Info")) {
                this.info = value;
            } else if (labelString.equals("Indicated Magnification")) {
                this.mag = Float.parseFloat(value);
            } else if (labelString.equals("Gamma")) {
                this.gamma = Float.parseFloat(value);
            }
            value = null;
        }
    }

    private double readValue(int type) throws IOException {
        switch (type) {
            case 2: 
            case 4: {
                return this.in.readShort();
            }
            case 3: 
            case 5: {
                return this.in.readInt();
            }
            case 6: {
                this.in.order(!this.in.isLittleEndian());
                float f = this.in.readFloat();
                this.in.order(!this.in.isLittleEndian());
                return f;
            }
            case 7: {
                this.in.order(!this.in.isLittleEndian());
                double dbl = this.in.readDouble();
                this.in.order(!this.in.isLittleEndian());
                return dbl;
            }
            case 8: 
            case 9: 
            case 10: {
                return this.in.readByte();
            }
        }
        return 0.0;
    }

    private int getNumBytes(int type) {
        switch (type) {
            case 2: 
            case 4: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
        }
        return 0;
    }
}

