/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.FilterMetadata;

public abstract class ImageIOReader
extends FormatReader {
    public ImageIOReader(String name, String suffix) {
        super(name, suffix);
        this.domains = new String[]{"Graphics"};
    }

    public ImageIOReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        BufferedImage data = (BufferedImage)this.openPlane(no, x, y, w, h);
        byte[] t = AWTImageTools.getBytes(data, false);
        System.arraycopy(t, 0, buf, 0, Math.min(t.length, buf.length));
        return buf;
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        RandomAccessInputStream ras = new RandomAccessInputStream(this.currentId);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(ras, 4096));
        BufferedImage b = ImageIO.read(dis);
        ras.close();
        dis.close();
        return b.getSubimage(x, y, w, h);
    }

    public Class getNativeDataType() {
        return BufferedImage.class;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("ImageIOReader.initFile(" + id + ")");
        super.initFile(id);
        this.status("Populating metadata");
        this.core[0].imageCount = 1;
        BufferedImage img = ImageIO.read(new DataInputStream(new RandomAccessInputStream(this.currentId)));
        if (img == null) {
            throw new FormatException("Invalid image stream");
        }
        this.core[0].sizeX = img.getWidth();
        this.core[0].sizeY = img.getHeight();
        this.core[0].rgb = img.getRaster().getNumBands() > 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.isRGB() ? 3 : 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = AWTImageTools.getPixelType(img);
        this.core[0].interleaved = false;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

