/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.LeicaHandler;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LIFReader
extends FormatReader {
    public static final byte LIF_MAGIC_BYTE = 112;
    public static final byte LIF_MEMORY_BYTE = 42;
    private static final Hashtable<String, Integer> CHANNEL_PRIORITIES = LIFReader.createChannelPriorities();
    private static final byte[][][] BYTE_LUTS = LIFReader.createByteLUTs();
    private static final short[][][] SHORT_LUTS = LIFReader.createShortLUTs();
    private Vector<Long> offsets;
    private int[][] realChannel;
    private int lastChannel = -1;

    private static Hashtable<String, Integer> createChannelPriorities() {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        h.put("red", new Integer(0));
        h.put("green", new Integer(1));
        h.put("blue", new Integer(2));
        h.put("cyan", new Integer(3));
        h.put("magenta", new Integer(4));
        h.put("yellow", new Integer(5));
        h.put("black", new Integer(6));
        h.put("gray", new Integer(7));
        h.put("", new Integer(8));
        return h;
    }

    private static byte[][][] createByteLUTs() {
        byte[][][] lut = new byte[9][3][256];
        for (int i = 0; i < 256; ++i) {
            lut[0][0][i] = (byte)(i & 0xFF);
            lut[1][1][i] = (byte)(i & 0xFF);
            lut[2][2][i] = (byte)(i & 0xFF);
            lut[3][1][i] = (byte)(i & 0xFF);
            lut[3][2][i] = (byte)(i & 0xFF);
            lut[4][0][i] = (byte)(i & 0xFF);
            lut[4][2][i] = (byte)(i & 0xFF);
            lut[5][0][i] = (byte)(i & 0xFF);
            lut[5][1][i] = (byte)(i & 0xFF);
            lut[6][0][i] = (byte)(i & 0xFF);
            lut[6][1][i] = (byte)(i & 0xFF);
            lut[6][2][i] = (byte)(i & 0xFF);
            lut[7][0][i] = (byte)(i & 0xFF);
            lut[7][1][i] = (byte)(i & 0xFF);
            lut[7][2][i] = (byte)(i & 0xFF);
            lut[8][0][i] = (byte)(i & 0xFF);
            lut[8][1][i] = (byte)(i & 0xFF);
            lut[8][2][i] = (byte)(i & 0xFF);
        }
        return lut;
    }

    private static short[][][] createShortLUTs() {
        short[][][] lut = new short[9][3][65536];
        for (int i = 0; i < 65536; ++i) {
            lut[0][0][i] = (short)(i & 0xFFFF);
            lut[1][1][i] = (short)(i & 0xFFFF);
            lut[2][2][i] = (short)(i & 0xFFFF);
            lut[3][1][i] = (short)(i & 0xFFFF);
            lut[3][2][i] = (short)(i & 0xFFFF);
            lut[4][0][i] = (short)(i & 0xFFFF);
            lut[4][2][i] = (short)(i & 0xFFFF);
            lut[5][0][i] = (short)(i & 0xFFFF);
            lut[5][1][i] = (short)(i & 0xFFFF);
            lut[6][0][i] = (short)(i & 0xFFFF);
            lut[6][1][i] = (short)(i & 0xFFFF);
            lut[6][2][i] = (short)(i & 0xFFFF);
            lut[7][0][i] = (short)(i & 0xFFFF);
            lut[7][1][i] = (short)(i & 0xFFFF);
            lut[7][2][i] = (short)(i & 0xFFFF);
            lut[8][0][i] = (short)(i & 0xFFFF);
            lut[8][1][i] = (short)(i & 0xFFFF);
            lut[8][2][i] = (short)(i & 0xFFFF);
        }
        return lut;
    }

    public LIFReader() {
        super("Leica Image File Format", "lif");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean blockLen = true;
        if (!FormatTools.validStream(stream, 1, true)) {
            return false;
        }
        return stream.read() == 112;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || this.lastChannel == -1) {
            return null;
        }
        return this.lastChannel < BYTE_LUTS.length ? BYTE_LUTS[this.lastChannel] : (byte[][])null;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 3 || this.lastChannel == -1) {
            return null;
        }
        return this.lastChannel < SHORT_LUTS.length ? SHORT_LUTS[this.lastChannel] : (short[][])null;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (!this.isRGB()) {
            int[] pos = this.getZCTCoords(no);
            this.lastChannel = this.realChannel[this.series][pos[1]];
        }
        long offset = this.offsets.get(this.series);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int bpp = bytes * this.getRGBChannelCount();
        long planeSize = (long)this.getSizeX() * (long)this.getSizeY() * (long)bpp;
        long nextOffset = this.series + 1 < this.offsets.size() ? this.offsets.get(this.series + 1).longValue() : this.in.length();
        int bytesToSkip = (int)(nextOffset - offset - planeSize * (long)this.getImageCount());
        bytesToSkip /= this.getSizeY();
        if (this.getSizeX() % 4 == 0) {
            bytesToSkip = 0;
        }
        this.in.seek(offset + planeSize * (long)no);
        this.in.skipBytes(bytesToSkip * this.getSizeY() * no);
        if (bytesToSkip == 0) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.in.skipBytes(y * (this.getSizeX() * bpp + bytesToSkip));
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * bpp);
                this.in.read(buf, row * w * bpp, w * bpp);
                this.in.skipBytes(bpp * (this.getSizeX() - w - x) + bytesToSkip);
            }
        }
        if (this.getRGBChannelCount() == 3) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), bytes, this.getRGBChannelCount());
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.realChannel = null;
            this.lastChannel = -1;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        this.debug("LIFReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.offsets = new Vector();
        this.in.order(true);
        this.status("Reading header");
        byte checkOne = this.in.readByte();
        this.in.skipBytes(2);
        byte checkTwo = this.in.readByte();
        if (checkOne != 112 && checkTwo != 112) {
            throw new FormatException(id + " is not a valid Leica LIF file");
        }
        this.in.skipBytes(4);
        if (this.in.read() != 42) {
            throw new FormatException("Invalid XML description");
        }
        int nc = this.in.readInt();
        String xml = DataTools.stripString(this.in.readString(nc * 2));
        this.status("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            if (this.in.readInt() != 112) {
                throw new FormatException("Invalid Memory Block");
            }
            this.in.skipBytes(4);
            if (this.in.read() != 42) {
                throw new FormatException("Invalid Memory Description");
            }
            long blockLength = this.in.readInt();
            if (this.in.read() != 42) {
                this.in.seek(this.in.getFilePointer() - 5L);
                blockLength = this.in.readLong();
                if (this.in.read() != 42) {
                    throw new FormatException("Invalid Memory Description");
                }
            }
            int descrLength = this.in.readInt() * 2;
            if (blockLength > 0L) {
                this.offsets.add(new Long(this.in.getFilePointer() + (long)descrLength));
            }
            this.in.seek(this.in.getFilePointer() + (long)descrLength + blockLength);
        }
        this.initMetadata(xml);
        xml = null;
    }

    private void initMetadata(String xml) throws FormatException, IOException {
        LeicaHandler handler = new LeicaHandler(new DummyMetadata());
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>" + xml + "</LEICA>";
        xml = XMLTools.sanitizeXML(xml);
        XMLTools.parseXML(xml, (DefaultHandler)handler);
        this.metadata = handler.getGlobalMetadata();
        Vector<String> lutNames = handler.getLutNames();
        this.core = handler.getCoreMetadata().toArray(new CoreMetadata[0]);
        this.realChannel = new int[this.getSeriesCount()][];
        int nextLut = 0;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.realChannel[i] = new int[this.core[i].sizeC];
            for (int q = 0; q < this.core[i].sizeC; ++q) {
                String lut;
                if (!CHANNEL_PRIORITIES.containsKey(lut = lutNames.get(nextLut++).toLowerCase())) {
                    lut = "";
                }
                this.realChannel[i][q] = CHANNEL_PRIORITIES.get(lut);
            }
            int[] sorted = new int[this.core[i].sizeC];
            Arrays.fill(sorted, -1);
            for (int q = 0; q < sorted.length; ++q) {
                int min = Integer.MAX_VALUE;
                int minIndex = -1;
                for (int n = 0; n < this.core[i].sizeC; ++n) {
                    if (this.realChannel[i][n] >= min || DataTools.containsValue(sorted, n)) continue;
                    min = this.realChannel[i][n];
                    minIndex = n;
                }
                sorted[q] = minIndex;
            }
        }
        this.status("Populating metadata");
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            MetadataTools.setDefaultCreationDate(store, this.getCurrentFile(), i);
        }
        XMLTools.parseXML(xml, (DefaultHandler)new LeicaHandler(store));
    }
}

