/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitWriter;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIASReader
extends FormatReader {
    private String[][] tiffs;
    private MinimalTiffReader[][] readers;
    private String resultFile = null;
    private Vector<AnalysisFile> analysisFiles;
    private int[] wellNumber;
    private int tileRows;
    private int tileCols;
    private int tileWidth;
    private int tileHeight;
    private int wellColumns;
    private int[] bpp;
    private String templateFile;
    private Hashtable<String, String> overlayFiles = new Hashtable();
    private Hashtable<String, Integer> overlayPlanes = new Hashtable();
    private boolean parseMasks = false;
    private byte[] cachedTileBuffer;

    public MIASReader() {
        super("MIAS", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"High-Content Screening (HCS)"};
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String filename, boolean open) {
        if (!open) {
            return super.isThisType(filename, open);
        }
        Location baseFile = new Location(filename).getAbsoluteFile();
        Location wellDir = baseFile.getParentFile();
        Location experiment = null;
        try {
            experiment = wellDir.getParentFile().getParentFile();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (experiment == null) {
            return false;
        }
        String wellName = wellDir.getName();
        boolean validName = wellName.startsWith("Well") || wellName.equals("results") || wellName.length() == 1 && wellName.replaceAll("\\d", "").length() == 0;
        return validName && super.isThisType(filename, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        Object s = ifd.getIFDValue(305);
        if (s == null) {
            return false;
        }
        String software = null;
        software = s instanceof String[] ? ((String[])s)[0] : s.toString();
        return software.startsWith("eaZYX") || software.startsWith("SCIL_Image") || software.startsWith("IDL");
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.readers[0][0].getCurrentFile() == null) {
            return null;
        }
        return this.readers[0][0].get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.readers == null || this.readers[0][0].getCurrentFile() == null) {
            return null;
        }
        return this.readers[0][0].get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.tileRows == 1 && this.tileCols == 1) {
            this.readers[this.getSeries()][no].setId(this.tiffs[this.getSeries()][no]);
            this.readers[this.getSeries()][no].openBytes(0, buf, x, y, w, h);
            return buf;
        }
        int outputRowLen = w * this.bpp[this.getSeries()];
        Region image = new Region(x, y, w, h);
        int outputRow = 0;
        int outputCol = 0;
        Region intersection = null;
        byte[] tileBuf = null;
        for (int row = 0; row < this.tileRows; ++row) {
            for (int col = 0; col < this.tileCols; ++col) {
                Region tile = new Region(col * this.tileWidth, row * this.tileHeight, this.tileWidth, this.tileHeight);
                if (!tile.intersects(image)) continue;
                intersection = tile.intersection(image);
                int tileIndex = (no * this.tileRows + row) * this.tileCols + col;
                tileBuf = this.getTile(this.getSeries(), no, row, col, intersection);
                int rowLen = tileBuf.length / intersection.height;
                int outputOffset = outputRow * outputRowLen + outputCol;
                for (int trow = 0; trow < intersection.height; ++trow) {
                    System.arraycopy(tileBuf, trow * rowLen, buf, outputOffset, rowLen);
                    outputOffset += outputRowLen;
                }
                outputCol += rowLen;
            }
            if (intersection == null) continue;
            outputRow += intersection.height;
            outputCol = 0;
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<Object> files = new Vector<Object>();
        if (!noPixels) {
            Object[] f = new String[this.tiffs[this.getSeries()].length];
            System.arraycopy(this.tiffs[this.getSeries()], 0, f, 0, f.length);
            Arrays.sort(f);
            files.addAll(Arrays.asList(f));
        }
        for (AnalysisFile file2 : this.analysisFiles) {
            if (file2.plate > 0 || file2.well != this.getSeries() && file2.well >= 0 && this.wellNumber[this.getSeries()] != file2.well) continue;
            files.add(file2.filename);
        }
        if (this.templateFile != null) {
            files.add(this.templateFile);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.readers != null) {
            MinimalTiffReader[][] arr$ = this.readers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                MinimalTiffReader[] images;
                for (MinimalTiffReader r : images = arr$[i$]) {
                    if (r == null) continue;
                    r.close(fileOnly);
                }
            }
        }
        if (!fileOnly) {
            this.readers = null;
            this.tiffs = null;
            this.tileCols = 0;
            this.tileRows = 0;
            this.resultFile = null;
            this.analysisFiles = null;
            this.wellNumber = null;
            this.tileHeight = 0;
            this.tileWidth = 0;
            this.wellColumns = 0;
            this.bpp = null;
            this.cachedTileBuffer = null;
            this.templateFile = null;
            this.overlayFiles.clear();
            this.overlayPlanes.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        this.debug("MIASReader.initFile(" + id + ")");
        super.initFile(id);
        this.analysisFiles = new Vector();
        this.status("Building list of TIFF files");
        Location baseFile = new Location(id).getAbsoluteFile();
        Location plate = baseFile.getParentFile().getParentFile();
        String plateName = plate.getName();
        if (!(plateName.length() == 3 || plateName.length() > 3 && plateName.replaceAll("\\d", "").startsWith("-"))) {
            plate = plate.getParentFile();
            plateName = plate.getName();
        }
        int plateNumber = Integer.parseInt(plateName.substring(0, 3));
        Location experiment = plate.getParentFile();
        Object[] directories = experiment.list(true);
        Arrays.sort(directories);
        for (Object dir : directories) {
            String[] results;
            Location f = new Location(experiment, (String)dir);
            if (!((String)dir).equals("Batchresults")) continue;
            for (String result : results = f.list(true)) {
                int plateIndex;
                Location file2 = new Location(f, result);
                if (result.startsWith("NEO_Results")) {
                    this.resultFile = file2.getAbsolutePath();
                    AnalysisFile af = new AnalysisFile();
                    af.filename = this.resultFile;
                    this.analysisFiles.add(af);
                    continue;
                }
                if (!result.startsWith("NEO_PlateOutput_") || (plateIndex = Integer.parseInt(result.substring(16, 19))) != plateNumber) continue;
                AnalysisFile af = new AnalysisFile();
                af.filename = file2.getAbsolutePath();
                af.plate = 0;
                this.analysisFiles.add(af);
            }
        }
        Object[] list = plate.list(true);
        Arrays.sort(list);
        Vector<String> wellDirectories = new Vector<String>();
        for (Object dir : list) {
            Location f = new Location(plate, (String)dir);
            if (f.getName().startsWith("Well") || f.getName().length() == 4) {
                String[] wellList = f.list(true);
                if (wellList == null) continue;
                boolean validWell = false;
                for (String potentialTIFF : wellList) {
                    if (!potentialTIFF.toLowerCase().endsWith(".tif") && !new Location(f, potentialTIFF).isDirectory()) continue;
                    validWell = true;
                    break;
                }
                if (!validWell) continue;
                wellDirectories.add(f.getAbsolutePath());
                continue;
            }
            if (f.getName().equals("results")) {
                String[] resultsList;
                for (String result : resultsList = f.list(true)) {
                    if (result.endsWith(".sav") || result.endsWith(".dsv")) continue;
                    Location r = new Location(f, result);
                    AnalysisFile af = new AnalysisFile();
                    af.filename = r.getAbsolutePath();
                    af.plate = 0;
                    if (result.toLowerCase().startsWith("well")) {
                        af.well = Integer.parseInt(result.substring(4, 8)) - 1;
                    }
                    this.analysisFiles.add(af);
                }
                continue;
            }
            if (!f.getName().equals("Nugenesistemplate.txt")) continue;
            this.templateFile = f.getAbsolutePath();
        }
        int nWells = wellDirectories.size();
        this.debug("Found " + nWells + " wells.");
        this.readers = new MinimalTiffReader[nWells][];
        this.tiffs = new String[nWells][];
        int[] zCount = new int[nWells];
        int[] cCount = new int[nWells];
        int[] tCount = new int[nWells];
        String[] order = new String[nWells];
        this.wellNumber = new int[nWells];
        Object[] wells = wellDirectories.toArray(new String[nWells]);
        Arrays.sort(wells);
        for (int j = 0; j < nWells; ++j) {
            Location well = new Location((String)wells[j]);
            String wellName = well.getName().replaceAll("Well", "");
            this.wellNumber[j] = Integer.parseInt(wellName) - 1;
            Object[] tiffFiles = well.list(true);
            Vector<String> tmpFiles = new Vector<String>();
            for (String string : tiffFiles) {
                String name = string.toLowerCase();
                if (!name.endsWith(".tif") && !name.endsWith(".tiff")) continue;
                tmpFiles.add(new Location(well, string).getAbsolutePath());
            }
            if (tmpFiles.size() == 0) {
                this.debug("No TIFFs in well directory " + (String)wells[j]);
                for (String string : tiffFiles) {
                    String[] tiffs;
                    Location file3 = new Location(well, string);
                    if (string.length() != 1 || !file3.isDirectory()) continue;
                    int n = j;
                    cCount[n] = cCount[n] + 1;
                    for (String tiff : tiffs = file3.list(true)) {
                        String name = tiff.toLowerCase();
                        if (!name.endsWith(".tif") && !name.endsWith(".tiff")) continue;
                        tmpFiles.add(new Location(file3, tiff).getAbsolutePath());
                    }
                }
            }
            tiffFiles = tmpFiles.toArray(new String[0]);
            Location firstTiff = new Location(tiffFiles[0]);
            FilePattern fp = new FilePattern(firstTiff.getName(), firstTiff.getParentFile().getAbsolutePath());
            String[] blocks = fp.getPrefixes();
            BigInteger[] bigIntegerArray = fp.getFirst();
            BigInteger[] lastNumber = fp.getLast();
            BigInteger[] step = fp.getStep();
            order[j] = "XY";
            for (int block = blocks.length - 1; block >= 0; --block) {
                blocks[block] = blocks[block].toLowerCase();
                blocks[block] = blocks[block].substring(blocks[block].lastIndexOf("_") + 1);
                BigInteger tmp = lastNumber[block].subtract(bigIntegerArray[block]);
                tmp = tmp.add(BigInteger.ONE).divide(step[block]);
                int count = tmp.intValue();
                if (blocks[block].equals("z")) {
                    zCount[j] = count;
                    int n = j;
                    order[n] = order[n] + "Z";
                    continue;
                }
                if (blocks[block].equals("t")) {
                    tCount[j] = count;
                    int n = j;
                    order[n] = order[n] + "T";
                    continue;
                }
                if (blocks[block].equals("mode")) {
                    cCount[j] = count;
                    int n = j;
                    order[n] = order[n] + "C";
                    continue;
                }
                if (blocks[block].equals("im")) {
                    this.tileRows = count;
                    continue;
                }
                if (blocks[block].equals("")) {
                    this.tileCols = count;
                    continue;
                }
                if (blocks[block].replaceAll("\\d", "").length() == 0) {
                    if (block == 3) {
                        this.tileRows = count;
                        continue;
                    }
                    if (block == 2) {
                        this.tileCols = count;
                        continue;
                    }
                    if (block == 0) {
                        zCount[j] = count;
                        int n = j;
                        order[n] = order[n] + "Z";
                        continue;
                    }
                    if (block != 1) continue;
                    tCount[j] = count;
                    int n = j;
                    order[n] = order[n] + "T";
                    continue;
                }
                throw new FormatException("Unsupported block '" + blocks[block]);
            }
            Arrays.sort(tiffFiles);
            this.tiffs[j] = tiffFiles;
            this.debug("Well " + j + " has " + tiffFiles.length + " files.");
            this.readers[j] = new MinimalTiffReader[tiffFiles.length];
            for (int k = 0; k < tiffFiles.length; ++k) {
                this.readers[j][k] = new MinimalTiffReader();
            }
        }
        this.status("Populating core metadata");
        int nSeries = this.tiffs.length;
        this.core = new CoreMetadata[nSeries];
        this.bpp = new int[nSeries];
        if (this.readers.length == 0) {
            throw new FormatException("No wells were found.");
        }
        this.readers[0][0].setId(this.tiffs[0][0]);
        this.tileWidth = this.readers[0][0].getSizeX();
        this.tileHeight = this.readers[0][0].getSizeY();
        if (this.tileCols == 0) {
            this.tileCols = 1;
        }
        if (this.tileRows == 0) {
            this.tileRows = 1;
        }
        for (int i = 0; i < this.core.length; ++i) {
            this.core[i] = new CoreMetadata();
            this.core[i].sizeZ = zCount[i];
            this.core[i].sizeC = cCount[i];
            this.core[i].sizeT = tCount[i];
            if (this.core[i].sizeZ == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.core[i].sizeC == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.core[i].sizeT == 0) {
                this.core[i].sizeT = 1;
            }
            this.core[i].sizeX = this.tileWidth * this.tileCols;
            this.core[i].sizeY = this.tileHeight * this.tileRows;
            this.core[i].pixelType = this.readers[0][0].getPixelType();
            this.core[i].sizeC *= this.readers[0][0].getSizeC();
            this.core[i].rgb = this.readers[0][0].isRGB();
            this.core[i].littleEndian = this.readers[0][0].isLittleEndian();
            this.core[i].interleaved = this.readers[0][0].isInterleaved();
            this.core[i].indexed = this.readers[0][0].isIndexed();
            this.core[i].falseColor = this.readers[0][0].isFalseColor();
            this.core[i].dimensionOrder = order[i];
            if (this.core[i].dimensionOrder.indexOf("Z") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
            }
            if (this.core[i].dimensionOrder.indexOf("C") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
            }
            if (this.core[i].dimensionOrder.indexOf("T") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
            }
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeT * cCount[i];
            if (this.core[i].imageCount == 0) {
                this.core[i].imageCount = 1;
            }
            this.bpp[i] = FormatTools.getBytesPerPixel(this.core[i].pixelType);
        }
        this.status("Populating metadata hashtable");
        if (this.resultFile != null && this.isMetadataCollected()) {
            String[] lines;
            String[] cols = null;
            Vector<String> rows = new Vector<String>();
            boolean doKeyValue = true;
            int nStarLines = 0;
            String analysisResults = DataTools.readFile(this.resultFile);
            for (String line : lines = analysisResults.split("\n")) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("******") && line.endsWith("******")) {
                    ++nStarLines;
                }
                if (doKeyValue) {
                    String[] n = line.split("\t");
                    if (n[0].endsWith(":")) {
                        n[0] = n[0].substring(0, n[0].length() - 1);
                    }
                    if (n.length >= 2) {
                        this.addGlobalMeta(n[0], n[1]);
                    }
                } else if (cols == null) {
                    cols = line.split("\t");
                } else {
                    rows.add(line);
                }
                if (nStarLines != 2) continue;
                doKeyValue = false;
            }
            for (String string : rows) {
                String[] d = string.split("\t");
                for (int col = 3; col < cols.length; ++col) {
                    this.addGlobalMeta("Plate " + d[0] + ", Well " + d[2] + " " + cols[col], d[col]);
                    if (!cols[col].equals("AreaCode")) continue;
                    String wellID = d[col].replaceAll("\\D", "");
                    this.wellColumns = Integer.parseInt(wellID);
                }
            }
        }
        if (this.isMetadataCollected()) {
            this.status("Populating MetadataStore");
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            MetadataTools.populatePixels(store, this, true);
            store.setExperimentID("Experiment:" + experiment.getName(), 0);
            store.setExperimentType("Other", 0);
            store.setPlateColumnNamingConvention("1", 0);
            store.setPlateRowNamingConvention("A", 0);
            this.parseTemplateFile(store);
            plateName = plateName.substring(plateName.indexOf("-") + 1);
            store.setPlateName(plateName, 0);
            store.setPlateExternalIdentifier(plateName, 0);
            if (this.wellColumns == 0) {
                if (nWells == 96) {
                    this.wellColumns = 12;
                } else if (nWells == 384) {
                    this.wellColumns = 24;
                } else {
                    this.warn("Could not determine the plate dimensions.");
                    this.wellColumns = 24;
                }
            }
            for (int well = 0; well < nWells; ++well) {
                int wellIndex = this.wellNumber[well];
                int row = wellIndex / this.wellColumns;
                int wellCol = wellIndex % this.wellColumns + 1;
                store.setWellRow(new Integer(row), 0, well);
                store.setWellColumn(new Integer(wellCol - 1), 0, well);
                String imageID = MetadataTools.createLSID("Image", well);
                store.setWellSampleImageRef(imageID, 0, well, 0);
                store.setWellSampleIndex(new Integer(well), 0, well, 0);
                store.setImageExperimentRef("Experiment:" + experiment.getName(), well);
                char wellRow = (char)(65 + row);
                store.setImageID(imageID, well);
                store.setImageName("Well " + wellRow + wellCol, well);
                String string = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(string, 0);
                store.setImageInstrumentRef(string, well);
                MetadataTools.setDefaultCreationDate(store, id, well);
            }
            String[] colors = new String[this.getSizeC()];
            int nextROI = 0;
            for (AnalysisFile af : this.analysisFiles) {
                String file4 = af.filename;
                String name = new Location(file4).getName();
                if (!name.startsWith("Well")) continue;
                int[] nArray = this.getPositionFromFile(file4);
                int well = nArray[0];
                if (name.endsWith("detail.txt")) {
                    int start;
                    String data = DataTools.readFile(file4);
                    String[] lines = data.split("\n");
                    for (start = 0; start < lines.length && !lines[start].startsWith("Label"); ++start) {
                    }
                    if (start >= lines.length) continue;
                    String[] columns = lines[start].split("\t");
                    List<String> columnNames = Arrays.asList(columns);
                    for (int j = start + 1; j < lines.length; ++j) {
                        this.populateROI(columnNames, lines[j].split("\t"), well, nextROI++, nArray[1], nArray[2], store);
                    }
                    continue;
                }
                if (name.endsWith("AllModesOverlay.tif")) {
                    if (colors[nArray[3]] != null) continue;
                    try {
                        colors[nArray[3]] = this.getChannelColorFromFile(file4);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (colors[nArray[3]] == null) continue;
                    for (int s = 0; s < this.getSeriesCount(); ++s) {
                        store.setChannelComponentColorDomain(colors[nArray[3]], s, nArray[3], 0);
                    }
                    if (nArray[3] != 0) continue;
                    nextROI += this.parseMasks(store, well, nextROI, file4);
                    continue;
                }
                if (!name.endsWith("overlay.tif")) continue;
                nextROI += this.parseMasks(store, well, nextROI, file4);
            }
        }
    }

    private String getChannelColorFromFile(String file2) throws FormatException, IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(file2);
        TiffParser tp = new TiffParser(s);
        IFD ifd = tp.getFirstIFD();
        s.close();
        int[] colorMap = ifd.getIFDIntArray(320, false);
        if (colorMap == null) {
            return null;
        }
        int nEntries = colorMap.length / 3;
        int max = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (int c = 0; c < 3; ++c) {
            int v = colorMap[c * nEntries] >> 8 & 0xFF;
            if (v > max) {
                max = v;
                maxIndex = c;
                continue;
            }
            if (v != max) continue;
            return "gray";
        }
        switch (maxIndex) {
            case 0: {
                return "R";
            }
            case 1: {
                return "G";
            }
            case 2: {
                return "B";
            }
        }
        return null;
    }

    private int[] getPositionFromFile(String file2) {
        int[] position = new int[4];
        file2 = file2.substring(file2.lastIndexOf(File.separator) + 1);
        String wellIndex = file2.substring(4, file2.indexOf("_"));
        position[0] = Integer.parseInt(wellIndex) - 1;
        int tIndex = file2.indexOf("_t") + 2;
        String t = file2.substring(tIndex, file2.indexOf("_", tIndex));
        position[1] = Integer.parseInt(t);
        int zIndex = file2.indexOf("_z") + 2;
        String zValue = file2.substring(zIndex, file2.indexOf("_", zIndex));
        position[2] = Integer.parseInt(zValue);
        int cIndex = file2.indexOf("mode") + 4;
        String cValue = file2.substring(cIndex, file2.indexOf("_", cIndex));
        position[3] = Integer.parseInt(cValue) - 1;
        return position;
    }

    private void populateROI(List<String> columns, String[] data, int series, int roi, int time, int z, MetadataStore store) {
        double cx = Double.parseDouble(data[columns.indexOf("Col")]);
        double cy = Double.parseDouble(data[columns.indexOf("Row")]);
        Integer tv = new Integer(time);
        Integer zv = new Integer(z);
        store.setROIT0(tv, series, roi);
        store.setROIT1(tv, series, roi);
        store.setROIZ0(zv, series, roi);
        store.setROIZ1(zv, series, roi);
        store.setShapeText(data[columns.indexOf("Label")], series, roi, 0);
        store.setShapeTheT(tv, series, roi, 0);
        store.setShapeTheZ(zv, series, roi, 0);
        store.setCircleCx(data[columns.indexOf("Col")], series, roi, 0);
        store.setCircleCy(data[columns.indexOf("Row")], series, roi, 0);
        double diam = Double.parseDouble(data[columns.indexOf("Cell Diam.")]);
        String radius = String.valueOf(diam / 2.0);
        store.setCircleR(radius, series, roi, 0);
    }

    private byte[] getTile(int well, int no, int row, int col, Region intersection) throws FormatException, IOException {
        intersection.x %= this.tileWidth;
        intersection.y %= this.tileHeight;
        int tileIndex = (no * this.tileRows + row) * this.tileCols + col;
        this.readers[well][tileIndex].setId(this.tiffs[well][tileIndex]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int ch = this.getRGBChannelCount();
        int bufferSize = intersection.width * intersection.height * ch * bpp;
        if (this.cachedTileBuffer == null || this.cachedTileBuffer.length != bufferSize) {
            this.cachedTileBuffer = new byte[bufferSize];
        }
        byte[] buf = this.readers[well][tileIndex].openBytes(0, this.cachedTileBuffer, intersection.x, intersection.y, intersection.width, intersection.height);
        return buf;
    }

    private void parseTemplateFile(MetadataStore store) throws IOException {
        String[] lines;
        if (this.templateFile == null) {
            return;
        }
        Float physicalSizeX = null;
        Float physicalSizeY = null;
        Float exposure = null;
        Vector<String> channelNames = new Vector<String>();
        String date = null;
        String data = DataTools.readFile(this.templateFile);
        for (String line : lines = data.split("\r\n")) {
            int eq = line.indexOf("=");
            if (eq == -1) continue;
            String key = line.substring(0, eq);
            String value = line.substring(eq + 1);
            if (key.equals("Barcode")) {
                store.setPlateExternalIdentifier(value, 0);
                continue;
            }
            if (key.equals("Carrier")) {
                store.setPlateName(value, 0);
                continue;
            }
            if (key.equals("Pixel_X")) {
                physicalSizeX = new Float(value);
                continue;
            }
            if (key.equals("Pixel_Y")) {
                physicalSizeY = new Float(value);
                continue;
            }
            if (key.equals("Objective_ID")) {
                store.setObjectiveModel(value, 0, 0);
                continue;
            }
            if (key.equals("Magnification")) {
                int mag = (int)Double.parseDouble(value);
                store.setObjectiveNominalMagnification(new Integer(mag), 0, 0);
                continue;
            }
            if (key.startsWith("Mode_")) {
                channelNames.add(value);
                continue;
            }
            if (key.equals("Date")) {
                date = value;
                continue;
            }
            if (key.equals("Time")) {
                date = date + " " + value;
                continue;
            }
            if (!key.equals("Exposure")) continue;
            exposure = new Float(value);
        }
        for (int well = 0; well < this.tiffs.length; ++well) {
            if (physicalSizeX != null) {
                store.setDimensionsPhysicalSizeX(physicalSizeX, well, 0);
            }
            if (physicalSizeY != null) {
                store.setDimensionsPhysicalSizeY(physicalSizeY, well, 0);
            }
            for (int c = 0; c < channelNames.size(); ++c) {
                if (c >= this.getEffectiveSizeC()) continue;
                store.setLogicalChannelName((String)channelNames.get(c), well, c);
            }
            date = DateTools.formatDate(date, "dd/MM/yyyy HH:mm:ss");
            store.setImageCreationDate(date, well);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneTimingExposureTime(exposure, well, 0, i);
            }
        }
    }

    private int parseMasks(MetadataStore store, int series, int roi, String overlayTiff) throws FormatException, IOException {
        if (!this.parseMasks) {
            return 0;
        }
        int nOverlays = 0;
        for (int i = 0; i < 3; ++i) {
            String id = MetadataTools.createLSID("Mask", series, roi + nOverlays, 0);
            this.overlayFiles.put(id, overlayTiff);
            this.overlayPlanes.put(id, new Integer(i));
            boolean validMask = this.populateMaskPixels(series, roi + nOverlays, 0);
            if (!validMask) continue;
            store.setMaskX("0", series, roi + nOverlays, 0);
            store.setMaskY("0", series, roi + nOverlays, 0);
            store.setMaskWidth(String.valueOf(this.getSizeX()), series, roi + nOverlays, 0);
            store.setMaskHeight(String.valueOf(this.getSizeY()), series, roi + nOverlays, 0);
            store.setMaskPixelsBigEndian(new Boolean(!this.isLittleEndian()), series, roi + nOverlays, 0);
            store.setMaskPixelsSizeX(new Integer(this.getSizeX()), series, roi + nOverlays, 0);
            store.setMaskPixelsSizeY(new Integer(this.getSizeY()), series, roi + nOverlays, 0);
            store.setMaskPixelsExtendedPixelType("bit", series, roi + nOverlays, 0);
            String color = String.valueOf(0xFF000000 | 255 << 8 * (2 - i));
            store.setShapeStrokeColor(color, series, roi + nOverlays, 0);
            ++nOverlays;
        }
        return nOverlays;
    }

    public boolean populateMaskPixels(int imageIndex, int roiIndex, int shapeIndex) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        String id = MetadataTools.createLSID("Mask", imageIndex, roiIndex, shapeIndex);
        String maskFile = this.overlayFiles.get(id);
        if (maskFile == null) {
            this.warnDebug("Could not find an overlay file matching " + id);
            return false;
        }
        MinimalTiffReader r = new MinimalTiffReader();
        r.setId(maskFile);
        int index = this.overlayPlanes.get(id);
        byte[] plane = r.openBytes(0);
        Object planes = null;
        if (r.isIndexed()) {
            planes = ImageTools.indexedToRGB(r.get8BitLookupTable(), plane);
        } else {
            int bpp = FormatTools.getBytesPerPixel(r.getPixelType());
            planes = new byte[r.getRGBChannelCount()][];
            for (int c = 0; c < ((byte[][])planes).length; ++c) {
                planes[c] = ImageTools.splitChannels(plane, c, r.getRGBChannelCount(), bpp, false, r.isInterleaved());
            }
        }
        for (int i = 0; i < planes[0].length; ++i) {
            int c;
            boolean channelsEqual = true;
            for (c = 1; c < ((byte[][])planes).length; ++c) {
                if (planes[c][i] == planes[0][i]) continue;
                channelsEqual = false;
                break;
            }
            if (!channelsEqual) continue;
            for (c = 0; c < ((byte[][])planes).length; ++c) {
                planes[c][i] = 0;
            }
        }
        boolean validMask = false;
        BitWriter bits = null;
        if (((byte[][])planes).length > index) {
            bits = new BitWriter(planes[index].length / 8);
            for (int p = 0; p < planes[index].length; ++p) {
                bits.write(planes[index][p] == 0 ? 0 : 1, 1);
                if (planes[index][p] == 0) continue;
                validMask = true;
            }
        }
        if (validMask) {
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            store.setMaskPixelsBinData(bits.toByteArray(), imageIndex, roiIndex, shapeIndex);
        } else {
            this.debug("Did not populate MaskPixels.BinData for " + id);
        }
        return validMask;
    }

    public void setAutomaticallyParseMasks(boolean parse) throws FormatException {
        FormatTools.assertId(this.currentId, false, 1);
        this.parseMasks = parse;
    }

    class AnalysisFile {
        public String filename;
        public int plate = -1;
        public int well = -1;

        AnalysisFile() {
        }
    }
}

