/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.FilterMetadata;

public class MNGReader
extends FormatReader {
    public static final long MNG_MAGIC_BYTES = -8481036456200365558L;
    private Vector[] offsets;
    private Vector[] lengths;

    public MNGReader() {
        super("Multiple Network Graphics", "mng");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readLong() == -8481036456200365558L;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        BufferedImage data = (BufferedImage)this.openPlane(no, x, y, w, h);
        byte[] tmp = AWTImageTools.getBytes(data, true);
        System.arraycopy(tmp, 0, buf, 0, Math.min(tmp.length, buf.length));
        return buf;
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        long offset = (Long)this.offsets[this.series].get(no);
        this.in.seek(offset);
        long end = (Long)this.lengths[this.series].get(no);
        byte[] b = new byte[(int)(end - offset + 8L)];
        this.in.read(b, 8, b.length - 8);
        b[0] = -119;
        b[1] = 80;
        b[2] = 78;
        b[3] = 71;
        b[4] = 13;
        b[5] = 10;
        b[6] = 26;
        b[7] = 10;
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(b));
        img = img.getSubimage(x, y, w, h);
        int pixelType = this.getPixelType();
        boolean little = this.isLittleEndian();
        byte[][] pix = AWTImageTools.getPixelBytes(img, little);
        img = AWTImageTools.makeImage(pix, w, h, FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), little, FormatTools.isSigned(pixelType));
        return img;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lengths = null;
            this.offsets = null;
        }
    }

    public Class getNativeDataType() {
        return BufferedImage.class;
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("MNGReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(false);
        this.status("Verifying MNG format");
        this.offsets = new Vector[1];
        this.lengths = new Vector[1];
        this.offsets[0] = new Vector();
        this.lengths[0] = new Vector();
        this.in.skipBytes(12);
        if (!"MHDR".equals(this.in.readString(4))) {
            throw new FormatException("Invalid MNG file.");
        }
        this.status("Reading dimensions");
        this.in.skipBytes(32);
        Vector<Long> stack = new Vector<Long>();
        int maxIterations = 0;
        int currentIteration = 0;
        this.status("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            int len = this.in.readInt();
            String code = this.in.readString(4);
            long fp = this.in.getFilePointer();
            if (code.equals("IHDR")) {
                this.offsets[0].add(new Long(fp - 8L));
            } else if (code.equals("IEND")) {
                this.lengths[0].add(new Long(fp + (long)len + 4L));
            } else if (code.equals("LOOP")) {
                stack.add(new Long(fp + (long)len + 4L));
                this.in.skipBytes(1);
                maxIterations = this.in.readInt();
            } else if (code.equals("ENDL")) {
                long seek = (Long)stack.get(stack.size() - 1);
                if (currentIteration < maxIterations) {
                    this.in.seek(seek);
                    ++currentIteration;
                } else {
                    stack.remove(stack.size() - 1);
                    maxIterations = 0;
                    currentIteration = 0;
                }
            }
            this.in.seek(fp + (long)len + 4L);
        }
        this.status("Populating metadata");
        Hashtable<String, Vector> seriesOffsets = new Hashtable<String, Vector>();
        Hashtable<String, Vector> seriesLengths = new Hashtable<String, Vector>();
        for (int i = 0; i < this.offsets[0].size(); ++i) {
            long offset = (Long)this.offsets[0].get(i);
            this.in.seek(offset);
            long end = (Long)this.lengths[0].get(i);
            if (end < offset) continue;
            byte[] b = new byte[(int)(end - offset + 8L)];
            this.in.read(b, 8, b.length - 8);
            b[0] = -119;
            b[1] = 80;
            b[2] = 78;
            b[3] = 71;
            b[4] = 13;
            b[5] = 10;
            b[6] = 26;
            b[7] = 10;
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(b));
            String data = img.getWidth() + "-" + img.getHeight() + "-" + img.getRaster().getNumBands() + "-" + AWTImageTools.getPixelType(img);
            Vector v = new Vector();
            if (seriesOffsets.containsKey(data)) {
                v = (Vector)seriesOffsets.get(data);
            }
            v.add(new Long(offset));
            seriesOffsets.put(data, v);
            v = new Vector();
            if (seriesLengths.containsKey(data)) {
                v = (Vector)seriesLengths.get(data);
            }
            v.add(new Long(end));
            seriesLengths.put(data, v);
        }
        String[] keys = seriesOffsets.keySet().toArray(new String[0]);
        if (keys.length == 0) {
            throw new FormatException("Pixel data not found.");
        }
        this.core = new CoreMetadata[keys.length];
        this.offsets = new Vector[keys.length];
        this.lengths = new Vector[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.core[i] = new CoreMetadata();
            StringTokenizer st = new StringTokenizer(keys[i], "-");
            this.core[i].sizeX = Integer.parseInt(st.nextToken());
            this.core[i].sizeY = Integer.parseInt(st.nextToken());
            this.core[i].sizeC = Integer.parseInt(st.nextToken());
            this.core[i].pixelType = Integer.parseInt(st.nextToken());
            this.core[i].rgb = this.core[i].sizeC > 1;
            this.offsets[i] = (Vector)seriesOffsets.get(keys[i]);
            this.core[i].sizeT = this.core[i].imageCount = this.offsets[i].size();
            this.lengths[i] = (Vector)seriesLengths.get(keys[i]);
            this.core[i].sizeZ = 1;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].interleaved = false;
            this.core[i].metadataComplete = true;
            this.core[i].indexed = false;
            this.core[i].littleEndian = false;
            this.core[i].falseColor = false;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            MetadataTools.setDefaultCreationDate(store, id, i);
        }
    }
}

