/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.NikonCodec;
import loci.formats.codec.NikonCodecOptions;
import loci.formats.in.BaseTiffReader;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;

public class NikonReader
extends BaseTiffReader {
    public static final String[] NEF_SUFFIX = new String[]{"nef"};
    private static final int EXIF_IFD_POINTER = 34665;
    private static final int TIFF_EPS_STANDARD = 37398;
    private static final int CFA_REPEAT_DIM = 33421;
    private static final int EXPOSURE_TIME = 33434;
    private static final int APERTURE = 33437;
    private static final int EXPOSURE_PROGRAM = 34850;
    private static final int DATE_TIME_DIGITIZED = 36867;
    private static final int DATE_TIME_ORIGINAL = 36868;
    private static final int EXPOSURE_BIAS_VALUE = 37380;
    private static final int MAX_APERTURE_VALUE = 37381;
    private static final int METERING_MODE = 37383;
    private static final int LIGHT_SOURCE = 37384;
    private static final int FLASH = 37385;
    private static final int FOCAL_LENGTH = 37386;
    private static final int SENSING_METHOD = 37399;
    private static final int MAKER_NOTE = 37500;
    private static final int USER_COMMENT = 37510;
    private static final int SUBSEC_TIME = 37520;
    private static final int SUBSEC_TIME_ORIGINAL = 37521;
    private static final int SUBSEC_TIME_DIGITIZED = 37522;
    private static final int COLOR_SPACE = 40961;
    private static final int FILE_SOURCE = 41728;
    private static final int SCENE_TYPE = 41729;
    private static final int CFA_PATTERN = 41730;
    private static final int CUSTOM_RENDERED = 41985;
    private static final int EXPOSURE_MODE = 41986;
    private static final int WHITE_BALANCE = 41987;
    private static final int DIGITAL_ZOOM_RATIO = 41988;
    private static final int FOCAL_LENGTH_35MM_FILM = 41989;
    private static final int SCENE_CAPTURE_TYPE = 41990;
    private static final int GAIN_CONTROL = 41991;
    private static final int CONTRAST = 41992;
    private static final int SATURATION = 41993;
    private static final int SHARPNESS = 41994;
    private static final int SUBJECT_DISTANCE_RANGE = 41996;
    private static final int FIRMWARE_VERSION = 1;
    private static final int ISO = 2;
    private static final int QUALITY = 4;
    private static final int MAKER_WHITE_BALANCE = 5;
    private static final int SHARPENING = 6;
    private static final int FOCUS_MODE = 7;
    private static final int FLASH_SETTING = 8;
    private static final int FLASH_MODE = 9;
    private static final int WHITE_BALANCE_FINE = 11;
    private static final int WHITE_BALANCE_RGB_COEFFS = 12;
    private static final int FLASH_COMPENSATION = 18;
    private static final int TONE_COMPENSATION = 129;
    private static final int LENS_TYPE = 131;
    private static final int LENS = 132;
    private static final int FLASH_USED = 135;
    private static final int CURVE = 140;
    private static final int COLOR_MODE = 141;
    private static final int LIGHT_TYPE = 144;
    private static final int HUE = 146;
    private static final int CAPTURE_EDITOR_DATA = 3585;
    private static final int SUB_IFD = 330;
    protected int makerNoteOffset;
    protected IFD original;
    private TiffRational[] whiteBalance;
    private Object cfaPattern;
    private int[] curve;
    private int[] vPredictor;
    private boolean lossyCompression;
    private int split = -1;

    public NikonReader() {
        super("Nikon NEF", new String[]{"nef", "tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(String name, boolean open) {
        if (NikonReader.checkSuffix(name, NEF_SUFFIX)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(new Integer(37398));
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean compressed;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        IFD ifd = (IFD)this.ifds.get(no);
        int dataSize = ifd.getBitsPerSample()[0];
        long[] byteCounts = ifd.getStripByteCounts();
        long[] offsets = ifd.getStripOffsets();
        long[] rowsPerStrip = ifd.getRowsPerStrip();
        float bytesPerSample = (float)dataSize / 8.0f;
        boolean maybeCompressed = ifd.getCompression() == 34713;
        boolean bl = compressed = this.vPredictor != null && this.curve != null && maybeCompressed;
        if (!maybeCompressed && dataSize == 14) {
            dataSize = 16;
        }
        ByteArrayOutputStream src = new ByteArrayOutputStream();
        NikonCodec codec = new NikonCodec();
        NikonCodecOptions options = new NikonCodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = dataSize;
        options.curve = this.curve;
        if (this.vPredictor != null) {
            options.vPredictor = new int[this.vPredictor.length];
        }
        options.lossy = this.lossyCompression;
        options.split = this.split;
        for (int i = 0; i < byteCounts.length; ++i) {
            byte[] t = new byte[(int)byteCounts[i]];
            this.in.seek(offsets[i]);
            this.in.read(t);
            if (compressed) {
                options.maxBytes = (int)byteCounts[i];
                System.arraycopy(this.vPredictor, 0, options.vPredictor, 0, this.vPredictor.length);
                t = codec.decompress(t, (CodecOptions)options);
            }
            src.write(t);
        }
        BitBuffer bb = new BitBuffer(src.toByteArray());
        short[] pix = new short[this.getSizeX() * this.getSizeY() * 3];
        src.close();
        int[] colorMap = new int[4];
        short[] s = (short[])ifd.get(new Integer(33422));
        for (int q = 0; q < colorMap.length; ++q) {
            colorMap[q] = s[q];
            if (colorMap[q] <= 2) continue;
            colorMap[0] = 1;
            colorMap[1] = 0;
            colorMap[2] = 2;
            colorMap[3] = 1;
            break;
        }
        boolean interleaveRows = offsets.length == 1 && !maybeCompressed;
        for (int row = 0; row < this.getSizeY(); ++row) {
            int realRow = interleaveRows ? (row < this.getSizeY() / 2 ? row * 2 : (row - this.getSizeY() / 2) * 2 + 1) : row;
            for (int col = 0; col < this.getSizeX(); ++col) {
                short val = (short)(bb.getBits(dataSize) & 0xFFFF);
                int mapIndex = realRow % 2 * 2 + col % 2;
                int redOffset = realRow * this.getSizeX() + col;
                int greenOffset = (this.getSizeY() + realRow) * this.getSizeX() + col;
                int blueOffset = (2 * this.getSizeY() + realRow) * this.getSizeX() + col;
                if (colorMap[mapIndex] == 0) {
                    pix[redOffset] = this.adjustForWhiteBalance(val, 0);
                } else if (colorMap[mapIndex] == 1) {
                    pix[greenOffset] = this.adjustForWhiteBalance(val, 1);
                } else if (colorMap[mapIndex] == 2) {
                    pix[blueOffset] = this.adjustForWhiteBalance(val, 2);
                }
                if (!maybeCompressed || compressed) continue;
                int toSkip = 0;
                if (col % 10 == 9) {
                    toSkip = 1;
                }
                if (col == this.getSizeX() - 1) {
                    toSkip = 10;
                }
                bb.skipBits(toSkip * 8);
            }
        }
        return ImageTools.interpolate(pix, buf, colorMap, this.getSizeX(), this.getSizeY(), this.isLittleEndian());
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.makerNoteOffset = 0;
            this.original = null;
            this.split = -1;
            this.whiteBalance = null;
            this.cfaPattern = null;
            this.curve = null;
            this.vPredictor = null;
            this.lossyCompression = false;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        IFD exifIFD;
        int exif;
        super.initStandardMetadata();
        this.original = (IFD)this.ifds.get(0);
        long[] subIFDOffsets = this.original.getIFDLongArray(330, false);
        if (subIFDOffsets != null) {
            IFDList tmpIFDs = new IFDList();
            for (int i = 0; i < subIFDOffsets.length; ++i) {
                IFD ifd = this.tiffParser.getIFD(i, subIFDOffsets[i]);
                if (ifd.getIFDIntValue(254) != 0) continue;
                tmpIFDs.add(ifd);
            }
            this.ifds = tmpIFDs;
            this.core[0].imageCount = this.ifds.size();
            IFD firstIFD = (IFD)this.ifds.get(0);
            int photo = firstIFD.getPhotometricInterpretation();
            int samples = firstIFD.getSamplesPerPixel();
            boolean bl = this.core[0].rgb = samples > 1 || photo == 2 || photo == 32803;
            if (photo == 32803) {
                samples = 3;
            }
            this.core[0].sizeX = (int)firstIFD.getImageWidth();
            this.core[0].sizeY = (int)firstIFD.getImageLength();
            this.core[0].sizeZ = 1;
            this.core[0].sizeC = this.isRGB() ? samples : 1;
            this.core[0].sizeT = this.ifds.size();
            this.core[0].pixelType = firstIFD.getPixelType();
            this.core[0].indexed = false;
        }
        if ((exif = this.original.getIFDIntValue(34665)) != -1 && (exifIFD = this.tiffParser.getIFD(0L, exif)) != null) {
            for (Integer key : exifIFD.keySet()) {
                int tag = key;
                if (tag == 41730) {
                    byte[] cfa = (byte[])exifIFD.get(key);
                    int[] colorMap = new int[cfa.length];
                    for (int i = 0; i < cfa.length; ++i) {
                        colorMap[i] = cfa[i];
                    }
                    this.addGlobalMeta(this.getTagName(tag), colorMap);
                    this.cfaPattern = colorMap;
                    continue;
                }
                this.addGlobalMeta(this.getTagName(tag), exifIFD.get(key));
                if (!this.getTagName(tag).equals("Offset to maker note")) continue;
                byte[] b = (byte[])exifIFD.get(key);
                int extra = new String(b, 0, 10).startsWith("Nikon") ? 10 : 0;
                byte[] buf = new byte[b.length];
                System.arraycopy(b, extra, buf, 0, buf.length - extra);
                RandomAccessInputStream makerNote = new RandomAccessInputStream(buf);
                TiffParser tp = new TiffParser(makerNote);
                IFD note = null;
                try {
                    note = tp.getFirstIFD();
                }
                catch (Exception e) {
                    this.traceDebug(e);
                }
                if (note != null) {
                    for (Integer nextKey : note.keySet()) {
                        int nextTag = nextKey;
                        this.addGlobalMeta(this.getTagName(nextTag), note.get(nextKey));
                        if (nextTag == 150) {
                            b = (byte[])note.get(nextKey);
                            RandomAccessInputStream s = new RandomAccessInputStream(b);
                            byte check1 = s.readByte();
                            byte check2 = s.readByte();
                            this.lossyCompression = check1 != 70;
                            this.vPredictor = new int[4];
                            for (int q = 0; q < this.vPredictor.length; ++q) {
                                this.vPredictor[q] = s.readShort();
                            }
                            this.curve = new int[16385];
                            int bps = ((IFD)this.ifds.get(0)).getBitsPerSample()[0];
                            int max = 1 << bps & Short.MAX_VALUE;
                            int step = 0;
                            int csize = s.readShort();
                            if (csize > 1) {
                                step = max / (csize - 1);
                            }
                            if (check1 == 68 && check2 == 32 && step > 0) {
                                int i;
                                for (i = 0; i < csize; ++i) {
                                    this.curve[i * step] = s.readShort();
                                }
                                for (i = 0; i < max; ++i) {
                                    int n = i % step;
                                    this.curve[i] = (this.curve[i - n] * (step - n) + this.curve[i - n + step] * n) / step;
                                }
                                s.seek(562L);
                                this.split = s.readShort();
                            } else {
                                int maxValue = (int)Math.pow(2.0, bps) - 1;
                                Arrays.fill(this.curve, maxValue);
                                int nElements = (int)(s.length() - s.getFilePointer()) / 2;
                                if (nElements < 100) {
                                    for (int i = 0; i < this.curve.length; ++i) {
                                        this.curve[i] = (short)i;
                                    }
                                } else {
                                    for (int q = 0; q < nElements; ++q) {
                                        this.curve[q] = s.readShort();
                                    }
                                }
                            }
                            s.close();
                            continue;
                        }
                        if (nextTag != 12) continue;
                        this.whiteBalance = (TiffRational[])note.get(nextKey);
                    }
                }
                makerNote.close();
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("NikonReader.initFile(" + id + ")");
        super.initFile(id);
        this.original = (IFD)this.ifds.get(0);
        if (this.cfaPattern != null) {
            this.original.put(new Integer(320), (int[])this.cfaPattern);
        }
        this.ifds.set(0, this.original);
        this.core[0].imageCount = 1;
        this.core[0].interleaved = true;
    }

    private short adjustForWhiteBalance(short val, int index) {
        if (this.whiteBalance != null && this.whiteBalance.length == 3) {
            return (short)((double)val * this.whiteBalance[index].doubleValue());
        }
        return val;
    }

    private String getTagName(int tag) {
        switch (tag) {
            case 33421: {
                return "CFA Repeat Dimensions";
            }
            case 33434: {
                return "Exposure Time";
            }
            case 33437: {
                return "Aperture";
            }
            case 34850: {
                return "Exposure Program";
            }
            case 36867: {
                return "Date/Time Digitized";
            }
            case 36868: {
                return "Date/Time Original";
            }
            case 37380: {
                return "Exposure Bias Value";
            }
            case 37381: {
                return "Max Aperture Value";
            }
            case 37383: {
                return "Metering Mode";
            }
            case 37384: {
                return "Light Source";
            }
            case 37385: {
                return "Flash Enabled?";
            }
            case 37386: {
                return "Focal length of lens";
            }
            case 37399: {
                return "Sensing Method";
            }
            case 37500: {
                return "Offset to maker note";
            }
            case 37510: {
                return "User comment";
            }
            case 37520: {
                return "Subsec. Sampling for Date/Time field";
            }
            case 37521: {
                return "Subsec. Sampling for original date";
            }
            case 37522: {
                return "Subsec. Sampling for digitized date";
            }
            case 40961: {
                return "Color space";
            }
            case 41728: {
                return "File source";
            }
            case 41729: {
                return "Scene type";
            }
            case 41730: {
                return "CFA pattern";
            }
            case 41985: {
                return "Custom Rendered?";
            }
            case 41986: {
                return "Exposure mode";
            }
            case 41987: {
                return "White Balance";
            }
            case 41988: {
                return "Digital Zoom Ratio";
            }
            case 41989: {
                return "Focal Length of 35mm lens";
            }
            case 41990: {
                return "Scene Capture Type";
            }
            case 41991: {
                return "Gain Control";
            }
            case 41992: {
                return "Contrast";
            }
            case 41993: {
                return "Saturation";
            }
            case 41994: {
                return "Sharpness";
            }
            case 41996: {
                return "Subject Distance Range";
            }
            case 1: {
                return "Firmware version";
            }
            case 2: {
                return "ISO";
            }
            case 4: {
                return "Quality";
            }
            case 5: {
                return "White Balance (Maker)";
            }
            case 6: {
                return "Sharpening";
            }
            case 7: {
                return "Focus Mode";
            }
            case 8: {
                return "Flash Setting";
            }
            case 9: {
                return "Flash Mode";
            }
            case 11: {
                return "White Balance Fine";
            }
            case 12: {
                return "White Balance (RGB coefficients)";
            }
            case 18: {
                return "Flash compensation";
            }
            case 129: {
                return "Tone compensation";
            }
            case 131: {
                return "Lens type";
            }
            case 132: {
                return "Lens";
            }
            case 135: {
                return "Flash used?";
            }
            case 140: {
                return "Curve";
            }
            case 141: {
                return "Color mode";
            }
            case 144: {
                return "Light type";
            }
            case 146: {
                return "Hue";
            }
            case 3585: {
                return "Capture Editor Data";
            }
        }
        return "" + tag;
    }
}

