/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class SlidebookReader
extends FormatReader {
    public static final long SLD_MAGIC_BYTES = 30399297506330880L;
    private Vector<Long> metadataOffsets;
    private Vector<Long> pixelOffsets;
    private Vector<Long> pixelLengths;
    private Vector<Float> ndFilters;

    public SlidebookReader() {
        super("Olympus Slidebook", "sld");
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readLong() == 30399297506330880L;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int plane = FormatTools.getPlaneSize(this);
        long offset = this.pixelOffsets.get(this.series) + (long)(plane * no);
        this.in.seek(offset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelLengths = null;
            this.pixelOffsets = null;
            this.metadataOffsets = null;
            this.ndFilters = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int q;
        int i2;
        this.debug("SlidebookReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Finding offsets to pixel data");
        this.in.skipBytes(4);
        this.core[0].littleEndian = this.in.read() == 73;
        this.in.order(this.isLittleEndian());
        this.metadataOffsets = new Vector();
        this.pixelOffsets = new Vector();
        this.pixelLengths = new Vector();
        this.ndFilters = new Vector();
        this.in.seek(0L);
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            this.in.skipBytes(4);
            int checkOne = this.in.read();
            int checkTwo = this.in.read();
            if (checkOne == 73 && checkTwo == 73 || checkOne == 77 && checkTwo == 77) {
                this.metadataOffsets.add(new Long(this.in.getFilePointer() - 6L));
                this.in.skipBytes(this.in.readShort() - 8);
                continue;
            }
            if (checkOne == -1 && checkTwo == -1) {
                boolean foundBlock = false;
                byte[] block = new byte[8192];
                this.in.read(block);
                while (!foundBlock) {
                    for (int i3 = 0; i3 < block.length - 2; ++i3) {
                        if ((block[i3] != 77 || block[i3 + 1] != 77) && (block[i3] != 73 || block[i3 + 1] != 73)) continue;
                        foundBlock = true;
                        this.in.seek(this.in.getFilePointer() - (long)block.length + (long)i3 - 2L);
                        this.metadataOffsets.add(new Long(this.in.getFilePointer() - 2L));
                        this.in.skipBytes(this.in.readShort() - 5);
                        break;
                    }
                    if (foundBlock) continue;
                    block[0] = block[block.length - 2];
                    block[1] = block[block.length - 1];
                    this.in.read(block, 2, block.length - 2);
                }
                continue;
            }
            String s = null;
            long fp = this.in.getFilePointer() - 6L;
            this.in.seek(fp);
            int len = this.in.read();
            if (len > 0 && len <= 32) {
                s = this.in.readString(len);
            }
            if (s != null && s.indexOf("Annotation") != -1) {
                if (s.equals("CTimelapseAnnotation")) {
                    this.in.skipBytes(41);
                    if (this.in.read() == 0) {
                        this.in.skipBytes(10);
                        continue;
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CIntensityBarAnnotation")) {
                    this.in.skipBytes(56);
                    int n = this.in.read();
                    while (n == 0 || n < 6 || n > 128) {
                        n = this.in.read();
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CCubeAnnotation")) {
                    this.in.skipBytes(66);
                    int n = this.in.read();
                    if (n == 0) continue;
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (!s.equals("CScaleBarAnnotation")) continue;
                this.in.skipBytes(38);
                int extra = this.in.read();
                if (extra <= 16) {
                    this.in.skipBytes(3 + extra);
                    continue;
                }
                this.in.skipBytes(2);
                continue;
            }
            if (s != null && s.indexOf("Decon") != -1) {
                this.in.seek(fp);
                while (this.in.read() != 93) {
                }
                continue;
            }
            if (fp % 2L == 1L) {
                fp -= 2L;
            }
            this.in.seek(fp);
            String checkString = this.in.readString(64);
            if (checkString.indexOf("II") != -1 || checkString.indexOf("MM") != -1) {
                int index = checkString.indexOf("II");
                if (index == -1) {
                    index = checkString.indexOf("MM");
                }
                this.in.seek(fp + (long)index - 4L);
                continue;
            }
            this.in.seek(fp);
            this.pixelOffsets.add(new Long(fp));
            try {
                byte[] buf = new byte[8192];
                boolean found = false;
                int n = this.in.read(buf);
                while (!found && this.in.getFilePointer() < this.in.length()) {
                    for (int i4 = 0; i4 < n - 6; ++i4) {
                        if ((buf[i4] != 104 || buf[i4 + 1] != 0 || buf[i4 + 4] != 73 || buf[i4 + 5] != 73) && (buf[i4] != 0 || buf[i4 + 1] != 104 || buf[i4 + 4] != 77 || buf[i4 + 5] != 77)) continue;
                        found = true;
                        this.in.seek(this.in.getFilePointer() - (long)n + (long)i4 - 20L);
                        break;
                    }
                    if (found) continue;
                    byte[] tmp = buf;
                    buf = new byte[8192];
                    System.arraycopy(tmp, tmp.length - 20, buf, 0, 20);
                    n = this.in.read(buf, 20, buf.length - 20);
                }
                if (this.in.getFilePointer() <= this.in.length()) {
                    this.pixelLengths.add(new Long(this.in.getFilePointer() - fp));
                    continue;
                }
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
            catch (EOFException e) {
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
        }
        for (int i5 = 0; i5 < this.pixelOffsets.size(); ++i5) {
            long offset;
            long length = this.pixelLengths.get(i5);
            if (length + (offset = this.pixelOffsets.get(i5).longValue()) + 6L < this.in.length()) continue;
            this.pixelOffsets.remove(i5);
            this.pixelLengths.remove(i5);
            --i5;
        }
        if (this.pixelOffsets.size() > 1) {
            boolean little = this.isLittleEndian();
            this.core = new CoreMetadata[this.pixelOffsets.size()];
            for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
                this.core[i6] = new CoreMetadata();
                this.core[i6].littleEndian = little;
            }
        }
        this.status("Determining dimensions");
        float pixelSize = 1.0f;
        String objective = null;
        Vector<Float> pixelSizeZ = new Vector<Float>();
        long pixelBytes = 0L;
        for (int i7 = 0; i7 < this.pixelLengths.size(); ++i7) {
            pixelBytes += this.pixelLengths.get(i7).longValue();
        }
        String[] imageNames = new String[this.getSeriesCount()];
        Vector<String> channelNames = new Vector<String>();
        int nextName = 0;
        int iCount = 0;
        int hCount = 0;
        int uCount = 0;
        int prevSeries = -1;
        int prevSeriesU = -1;
        boolean nextChannel = false;
        for (i2 = 0; i2 < this.metadataOffsets.size(); ++i2) {
            long off = this.metadataOffsets.get(i2);
            this.in.seek(off);
            long next = i2 == this.metadataOffsets.size() - 1 ? this.in.length() : this.metadataOffsets.get(i2 + 1).longValue();
            int totalBlocks = (int)((next - off) / 128L);
            if (totalBlocks > 100) {
                totalBlocks = 1;
            }
            block13: for (q = 0; q < totalBlocks && !this.withinPixels(off + (long)(q * 128)); ++q) {
                this.in.seek(off + (long)(q * 128));
                char n = (char)this.in.readShort();
                if (n == 'i') {
                    ++iCount;
                    this.in.skipBytes(94);
                    pixelSizeZ.add(new Float(this.in.readFloat()));
                    this.in.seek(this.in.getFilePointer() - 20L);
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long end;
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (this.core[j].sizeX == 0) {
                            this.core[j].sizeX = this.in.readShort();
                            this.core[j].sizeY = this.in.readShort();
                            short checkX = this.in.readShort();
                            short checkY = this.in.readShort();
                            short div = this.in.readShort();
                            this.core[j].sizeX = this.core[j].sizeX / (div == 0 ? (short)1 : div);
                            div = this.in.readShort();
                            this.core[j].sizeY = this.core[j].sizeY / (div == 0 ? (short)1 : div);
                        }
                        if (prevSeries != j) {
                            iCount = 1;
                        }
                        prevSeries = j;
                        this.core[j].sizeC = iCount;
                        continue block13;
                    }
                    continue;
                }
                if (n == 'u') {
                    ++uCount;
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long end;
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (prevSeriesU != j) {
                            uCount = 1;
                        }
                        prevSeriesU = j;
                        this.core[j].sizeZ = uCount;
                        continue block13;
                    }
                    continue;
                }
                if (n == 'h') {
                    ++hCount;
                    continue;
                }
                if (n == 'j') {
                    this.in.skipBytes(2);
                    String check = this.in.readString(2);
                    if (!check.equals("II") && !check.equals("MM")) continue;
                    this.in.skipBytes(10);
                    if (nextName < imageNames.length) {
                        imageNames[nextName++] = this.in.readCString().trim();
                    }
                    if (this.core[nextName - 1].sizeX != 0 && this.core[nextName - 1].sizeY != 0) continue;
                    this.in.skipBytes(123);
                    this.core[nextName - 1].sizeX = this.in.readInt();
                    this.core[nextName - 1].sizeY = this.in.readInt();
                    int div = this.in.readInt();
                    this.core[nextName - 1].sizeX = this.core[nextName - 1].sizeX / (div == 0 ? 1 : div);
                    div = this.in.readInt();
                    this.core[nextName - 1].sizeY = this.core[nextName - 1].sizeY / (div == 0 ? 1 : div);
                    continue;
                }
                if (n == 'm') {
                    if (this.in.getFilePointer() <= this.pixelOffsets.get(0)) continue;
                    this.in.skipBytes(14);
                    channelNames.add(this.in.readCString().trim());
                    continue;
                }
                if (n == 'd') {
                    this.in.skipBytes(6);
                    long fp = this.in.getFilePointer();
                    objective = this.in.readCString();
                    this.in.seek(fp + 144L);
                    pixelSize = this.in.readFloat();
                    continue;
                }
                if (n == 'e') {
                    this.in.skipBytes(174);
                    this.ndFilters.add(new Float(this.in.readFloat()));
                    this.in.skipBytes(40);
                    this.setSeries(nextName);
                    this.addSeriesMeta("channel " + this.ndFilters.size() + " intensification", this.in.readShort());
                    continue;
                }
                if (n != 'k') continue;
                this.in.skipBytes(14);
                this.setSeries(nextName - 1);
                this.addSeriesMeta("Mag. changer", this.in.readCString());
            }
        }
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            this.setSeries(i2);
            long pixels = this.pixelLengths.get(i2) / 2L;
            boolean x = true;
            while ((long)(this.getSizeX() * this.getSizeY() * this.getSizeC() * this.getSizeZ()) > pixels) {
                if (x) {
                    this.core[i2].sizeX /= 2;
                } else {
                    this.core[i2].sizeY /= 2;
                }
                x = !x;
            }
            if (this.getSizeC() == 0) {
                this.core[i2].sizeC = 1;
            }
            if (this.getSizeZ() == 0) {
                this.core[i2].sizeZ = 1;
            }
            int nPlanes = this.getSizeZ() * this.getSizeC();
            this.core[i2].sizeT = (int)(pixels / (long)(this.getSizeX() * this.getSizeY() * nPlanes));
            if (this.getSizeT() == 0) {
                this.core[i2].sizeT = 1;
            }
            this.core[i2].imageCount = nPlanes * this.getSizeT();
            this.core[i2].pixelType = 3;
            this.core[i2].dimensionOrder = "XYZTC";
            this.core[i2].indexed = false;
            this.core[i2].falseColor = false;
            this.core[i2].metadataComplete = true;
        }
        this.setSeries(0);
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        int index = 0;
        store.setObjectiveModel(objective, 0, 0);
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setObjectiveSettingsObjective(objectiveID, 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (imageNames[i] != null) {
                store.setImageName(imageNames[i], i);
            }
            MetadataTools.setDefaultCreationDate(store, id, i);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setDimensionsPhysicalSizeX(new Float(pixelSize), i, 0);
            store.setDimensionsPhysicalSizeY(new Float(pixelSize), i, 0);
            int idx = 0;
            for (q = 0; q < i; ++q) {
                idx += this.core[q].sizeC;
            }
            if (idx >= pixelSizeZ.size() || pixelSizeZ.get(idx) == null) continue;
            store.setDimensionsPhysicalSizeZ((Float)pixelSizeZ.get(idx), i, 0);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            for (int c = 0; c < this.getSizeC(); ++c) {
                if (index < channelNames.size() && channelNames.get(index) != null) {
                    store.setLogicalChannelName((String)channelNames.get(index), i, c);
                    this.addSeriesMeta("channel " + c, channelNames.get(index));
                }
                if (index < this.ndFilters.size() && this.ndFilters.get(index) != null) {
                    store.setLogicalChannelNdFilter(this.ndFilters.get(index), i, c);
                    this.addSeriesMeta("channel " + c + " Neutral density", this.ndFilters.get(index));
                }
                ++index;
            }
        }
        this.setSeries(0);
    }

    private boolean withinPixels(long offset) {
        for (int i = 0; i < this.pixelOffsets.size(); ++i) {
            long pixelOffset = this.pixelOffsets.get(i);
            long pixelLength = this.pixelLengths.get(i);
            if (offset < pixelOffset || offset >= pixelOffset + pixelLength) continue;
            return true;
        }
        return false;
    }
}

