/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;

public class TiffReader
extends BaseTiffReader {
    public static final String[] TIFF_SUFFIXES = new String[]{"tif", "tiff", "tf2", "tf8", "btf"};
    public static final String[] COMPANION_SUFFIXES = new String[]{"xml", "txt"};
    private String companionFile;
    private String description;

    public TiffReader() {
        super("Tagged Image File Format", TIFF_SUFFIXES);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            String[] stringArray;
            if (this.companionFile == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.companionFile;
            }
            return stringArray;
        }
        if (this.companionFile != null) {
            return new String[]{this.companionFile, this.currentId};
        }
        return new String[]{this.currentId};
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.companionFile = null;
            this.description = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        String[] files;
        boolean metamorph;
        Integer[] tags;
        super.initStandardMetadata();
        String comment = ((IFD)this.ifds.get(0)).getComment();
        this.status("Checking comment style");
        if (this.ifds.size() > 1) {
            this.core[0].orderCertain = false;
        }
        this.description = null;
        for (Integer tag : tags = ((IFD)this.ifds.get(0)).keySet().toArray(new Integer[0])) {
            Object value;
            if (tag < 65000 || !((value = ((IFD)this.ifds.get(0)).get(tag)) instanceof short[])) continue;
            short[] s = (short[])value;
            byte[] b = new byte[s.length];
            for (int i = 0; i < b.length; ++i) {
                b[i] = (byte)s[i];
            }
            String metadata = DataTools.stripString(new String(b));
            if (metadata.indexOf("xml") != -1) {
                metadata = metadata.substring(metadata.indexOf("<"));
                metadata = "<root>" + XMLTools.sanitizeXML(metadata) + "</root>";
                Hashtable<String, String> xmlMetadata = XMLTools.parseXML(metadata);
                for (String key : xmlMetadata.keySet()) {
                    this.addGlobalMeta(key, xmlMetadata.get(key));
                }
                continue;
            }
            this.addGlobalMeta(tag.toString(), metadata);
        }
        boolean ij = this.checkCommentImageJ(comment);
        if (ij) {
            this.parseCommentImageJ(comment);
        }
        if (metamorph = this.checkCommentMetamorph(comment)) {
            this.parseCommentMetamorph(comment);
        }
        this.put("MetaMorph", metamorph ? "yes" : "no");
        if (!ij && !metamorph) {
            this.parseCommentGeneric(comment);
        }
        Location currentFile = new Location(this.currentId).getAbsoluteFile();
        String currentName = currentFile.getName();
        Location directory = currentFile.getParentFile();
        for (String file2 : files = directory.list(true)) {
            String name = file2;
            if (name.indexOf(".") != -1) {
                name = name.substring(0, name.indexOf("."));
            }
            if (!currentName.startsWith(name) || !TiffReader.checkSuffix(name, COMPANION_SUFFIXES)) continue;
            this.companionFile = new Location(directory, file2).getAbsolutePath();
            break;
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        if (this.description != null) {
            FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
            store.setImageDescription(this.description, 0);
        }
    }

    private boolean checkCommentImageJ(String comment) {
        return comment != null && comment.startsWith("ImageJ=");
    }

    private boolean checkCommentMetamorph(String comment) {
        Object software = ((IFD)this.ifds.get(0)).getIFDValue(305);
        String check = software instanceof String ? (String)software : (software instanceof String[] ? ((String[])software)[0] : null);
        return comment != null && software != null && check.indexOf("MetaMorph") != -1;
    }

    private void parseCommentImageJ(String comment) throws FormatException, IOException {
        int nl = comment.indexOf("\n");
        this.put("ImageJ", nl < 0 ? comment.substring(7) : comment.substring(7, nl));
        this.metadata.remove("Comment");
        this.description = "";
        int z = 1;
        int t = 1;
        int c = this.getSizeC();
        StringTokenizer st = new StringTokenizer(comment, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int value = 0;
            int eq = token.indexOf("=");
            if (eq != -1 && eq + 1 < token.length()) {
                try {
                    value = Integer.parseInt(token.substring(eq + 1));
                }
                catch (NumberFormatException e) {
                    this.traceDebug(e);
                }
            }
            if (token.startsWith("channels=")) {
                c = value;
                continue;
            }
            if (token.startsWith("slices=")) {
                z = value;
                continue;
            }
            if (!token.startsWith("frames=")) continue;
            t = value;
        }
        if (z * c * t == c) {
            t = this.getImageCount();
        }
        this.core[0].dimensionOrder = "XYCZT";
        if (z * t * (this.isRGB() ? 1 : c) == this.ifds.size()) {
            this.core[0].sizeZ = z;
            this.core[0].sizeT = t;
            this.core[0].sizeC = c;
        } else if (this.ifds.size() == 1 && z * t > this.ifds.size() && ((IFD)this.ifds.get(0)).getCompression() == 1) {
            IFD firstIFD = (IFD)this.ifds.get(0);
            int planeSize = this.getSizeX() * this.getSizeY() * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
            long[] stripOffsets = firstIFD.getStripOffsets();
            long[] stripByteCounts = firstIFD.getStripByteCounts();
            long endOfFirstPlane = stripOffsets[stripOffsets.length - 1] + stripByteCounts[stripByteCounts.length - 1];
            long totalBytes = this.in.length() - endOfFirstPlane;
            int totalPlanes = (int)(totalBytes / (long)planeSize) + 1;
            this.ifds = new IFDList();
            this.ifds.add(firstIFD);
            for (int i = 1; i < totalPlanes; ++i) {
                IFD ifd = new IFD(firstIFD);
                this.ifds.add(ifd);
                long[] prevOffsets = ((IFD)this.ifds.get(i - 1)).getStripOffsets();
                long[] offsets = new long[stripOffsets.length];
                offsets[0] = prevOffsets[prevOffsets.length - 1] + stripByteCounts[stripByteCounts.length - 1];
                for (int j = 1; j < offsets.length; ++j) {
                    offsets[j] = offsets[j - 1] + stripByteCounts[j - 1];
                }
                ifd.put(new Integer(273), offsets);
            }
            if (z * c * t == this.ifds.size()) {
                this.core[0].sizeZ = z;
                this.core[0].sizeT = t;
                this.core[0].sizeC = c;
            } else {
                this.core[0].sizeZ = this.ifds.size();
            }
            this.core[0].imageCount = this.ifds.size();
        } else {
            this.core[0].sizeT = this.ifds.size();
            this.core[0].imageCount = this.ifds.size();
        }
    }

    private void parseCommentMetamorph(String comment) {
        StringTokenizer st = new StringTokenizer(comment, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int colon = line.indexOf(":");
            if (colon < 0) {
                this.addGlobalMeta("Comment", line);
                this.description = line;
                continue;
            }
            String key = line.substring(0, colon);
            String value = line.substring(colon + 1);
            this.addGlobalMeta(key, value);
        }
    }

    private void parseCommentGeneric(String comment) {
        if (comment == null) {
            return;
        }
        String[] lines = comment.split("\n");
        if (lines.length > 1) {
            comment = "";
            for (String line : lines) {
                int eq = line.indexOf("=");
                if (eq != -1) {
                    String key = line.substring(0, eq).trim();
                    String value = line.substring(eq + 1).trim();
                    this.addGlobalMeta(key, value);
                    continue;
                }
                if (line.startsWith("[")) continue;
                comment = comment + line + "\n";
            }
            this.addGlobalMeta("Comment", comment);
            this.description = comment;
        }
    }
}

