/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import loci.common.DataTools;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffTools;

public class TiffSaver {
    protected RandomAccessOutputStream out;

    public TiffSaver(RandomAccessOutputStream out) {
        this.out = out;
    }

    public RandomAccessOutputStream getStream() {
        return this.out;
    }

    public void writeHeader(boolean littleEndian, boolean bigTiff) throws IOException {
        if (littleEndian) {
            this.out.writeByte(73);
            this.out.writeByte(73);
        } else {
            this.out.writeByte(77);
            this.out.writeByte(77);
        }
        if (bigTiff) {
            DataTools.writeShort(this.out, 43, littleEndian);
        } else {
            DataTools.writeShort(this.out, 42, littleEndian);
        }
        DataTools.writeInt(this.out, 8, littleEndian);
        if (bigTiff) {
            DataTools.writeLong(this.out, 16L, littleEndian);
        }
    }

    public static void writeIFDValue(DataOutput ifdOut, ByteArrayOutputStream extraBuf, DataOutputStream extraOut, long offset, int tag, Object value, boolean bigTiff, boolean littleEndian) throws FormatException, IOException {
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        int dataLength = bigTiff ? 8 : 4;
        DataTools.writeShort(ifdOut, tag, littleEndian);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            DataTools.writeShort(ifdOut, 1, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            DataTools.writeShort(ifdOut, 2, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length + 1, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length + 1, littleEndian);
            }
            if (q.length < dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    ifdOut.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    ifdOut.writeByte(0);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            DataTools.writeShort(ifdOut, 3, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength / 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    DataTools.writeShort(ifdOut, q[i], littleEndian);
                }
                for (i = q.length; i < dataLength / 2; ++i) {
                    DataTools.writeShort(ifdOut, 0, littleEndian);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeShort(extraOut, q[i], littleEndian);
                }
            }
        } else if (value instanceof long[]) {
            long[] q = (long[])value;
            if (bigTiff) {
                DataTools.writeShort(ifdOut, 16, littleEndian);
                DataTools.writeLong(ifdOut, q.length, littleEndian);
                if (q.length <= dataLength / 4) {
                    int i;
                    for (i = 0; i < q.length; ++i) {
                        DataTools.writeLong(ifdOut, q[0], littleEndian);
                    }
                    for (i = q.length; i < dataLength / 4; ++i) {
                        DataTools.writeLong(ifdOut, 0L, littleEndian);
                    }
                } else {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                    for (int i = 0; i < q.length; ++i) {
                        DataTools.writeLong(extraOut, q[i], littleEndian);
                    }
                }
            } else {
                DataTools.writeShort(ifdOut, 4, littleEndian);
                DataTools.writeInt(ifdOut, q.length, littleEndian);
                if (q.length <= dataLength / 4) {
                    int i;
                    for (i = 0; i < q.length; ++i) {
                        DataTools.writeInt(ifdOut, (int)q[0], littleEndian);
                    }
                    for (i = q.length; i < dataLength / 4; ++i) {
                        DataTools.writeInt(ifdOut, 0, littleEndian);
                    }
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                    for (int i = 0; i < q.length; ++i) {
                        DataTools.writeInt(extraOut, (int)q[i], littleEndian);
                    }
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            DataTools.writeShort(ifdOut, 5, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (bigTiff && q.length == 1) {
                DataTools.writeInt(ifdOut, (int)((TiffRational)q[0]).getNumerator(), littleEndian);
                DataTools.writeInt(ifdOut, (int)((TiffRational)q[0]).getDenominator(), littleEndian);
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeInt(extraOut, (int)((TiffRational)q[i]).getNumerator(), littleEndian);
                    DataTools.writeInt(extraOut, (int)((TiffRational)q[i]).getDenominator(), littleEndian);
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            DataTools.writeShort(ifdOut, 11, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    DataTools.writeFloat(ifdOut, q[0], littleEndian);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    DataTools.writeInt(ifdOut, 0, littleEndian);
                }
            } else {
                if (bigTiff) {
                    DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
                } else {
                    DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
                }
                for (int i = 0; i < q.length; ++i) {
                    DataTools.writeFloat(extraOut, q[i], littleEndian);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            DataTools.writeShort(ifdOut, 12, littleEndian);
            if (bigTiff) {
                DataTools.writeLong(ifdOut, q.length, littleEndian);
            } else {
                DataTools.writeInt(ifdOut, q.length, littleEndian);
            }
            if (bigTiff) {
                DataTools.writeLong(ifdOut, offset + (long)extraBuf.size(), littleEndian);
            } else {
                DataTools.writeInt(ifdOut, (int)(offset + (long)extraBuf.size()), littleEndian);
            }
            for (int i = 0; i < q.length; ++i) {
                DataTools.writeDouble(extraOut, q[i], littleEndian);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public static void overwriteIFDValue(String file2, int ifd, int tag, Object value) throws FormatException, IOException {
        int i;
        LogTools.debug("overwriteIFDValue (ifd=" + ifd + "; tag=" + tag + "; value=" + value + ")");
        byte[] header = new byte[4];
        RandomAccessInputStream raf = new RandomAccessInputStream(file2);
        raf.seek(0L);
        raf.readFully(header);
        if (!TiffTools.isValidHeader(header)) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = header[0] == 73 && header[1] == 73;
        boolean bigTiff = header[2] == 43 || header[3] == 43;
        long offset = bigTiff ? 8L : 4L;
        long num = 0L;
        int baseOffset = bigTiff ? 8 : 2;
        int bytesPerEntry = bigTiff ? 20 : 12;
        raf.seek(offset);
        for (i = 0; i <= ifd; ++i) {
            long l = offset = bigTiff ? DataTools.read8SignedBytes(raf, little) : DataTools.read4UnsignedBytes(raf, little);
            if (offset <= 0L) {
                throw new FormatException("No such IFD (" + ifd + " of " + i + ")");
            }
            raf.seek(offset);
            long l2 = num = bigTiff ? DataTools.read8SignedBytes(raf, little) : (long)DataTools.read2UnsignedBytes(raf, little);
            if (i >= ifd) continue;
            raf.seek(offset + (long)baseOffset + (long)bytesPerEntry * num);
        }
        i = 0;
        while ((long)i < num) {
            long oldOffset;
            int oldTag = DataTools.read2UnsignedBytes(raf, little);
            int oldType = DataTools.read2UnsignedBytes(raf, little);
            int oldCount = bigTiff ? (int)(DataTools.read8SignedBytes(raf, little) & 0xFFFFFFFFFFFFFFFFL) : DataTools.read4SignedBytes(raf, little);
            long l = oldOffset = bigTiff ? DataTools.read8SignedBytes(raf, little) : (long)DataTools.read4SignedBytes(raf, little);
            if (oldTag == tag) {
                long newOffset;
                int newCount;
                ByteArrayOutputStream ifdBuf = new ByteArrayOutputStream(bytesPerEntry);
                DataOutputStream ifdOut = new DataOutputStream(ifdBuf);
                ByteArrayOutputStream extraBuf = new ByteArrayOutputStream();
                DataOutputStream extraOut = new DataOutputStream(extraBuf);
                TiffSaver.writeIFDValue(ifdOut, extraBuf, extraOut, oldOffset, tag, value, bigTiff, little);
                byte[] bytes = ifdBuf.toByteArray();
                byte[] extra = extraBuf.toByteArray();
                int newTag = DataTools.bytesToInt(bytes, 0, 2, little);
                int newType = DataTools.bytesToInt(bytes, 2, 2, little);
                if (bigTiff) {
                    newCount = (int)(DataTools.bytesToLong(bytes, 4, little) & 0xFFFFFFFFFFFFFFFFL);
                    newOffset = DataTools.bytesToLong(bytes, 12, little);
                } else {
                    newCount = DataTools.bytesToInt(bytes, 4, little);
                    newOffset = DataTools.bytesToInt(bytes, 8, little);
                }
                boolean terminate = false;
                LogTools.debug("overwriteIFDValue:\n\told: (tag=" + oldTag + "; type=" + oldType + "; count=" + oldCount + "; offset=" + oldOffset + ");\n\tnew: (tag=" + newTag + "; type=" + newType + "; count=" + newCount + "; offset=" + newOffset + ")");
                if (extra.length == 0) {
                    LogTools.debug("overwriteIFDValue: new entry is inline");
                } else if (oldOffset + (long)(oldCount * IFD.getIFDTypeLength(oldType)) == raf.length()) {
                    newOffset = oldOffset;
                    terminate = true;
                    LogTools.debug("overwriteIFDValue: old entry is at EOF");
                } else if (newCount <= oldCount) {
                    newOffset = oldOffset;
                    LogTools.debug("overwriteIFDValue: new entry is <= old entry");
                } else {
                    newOffset = raf.length();
                    LogTools.debug("overwriteIFDValue: old entry will be orphaned");
                }
                long filePointer = raf.getFilePointer();
                raf.close();
                RandomAccessOutputStream out = new RandomAccessOutputStream(file2);
                out.seek(filePointer - (long)(bigTiff ? 18 : 10));
                DataTools.writeShort(out, newType, little);
                if (bigTiff) {
                    DataTools.writeLong(out, newCount, little);
                } else {
                    DataTools.writeInt(out, newCount, little);
                }
                if (bigTiff) {
                    DataTools.writeLong(out, newOffset, little);
                } else {
                    DataTools.writeInt(out, (int)newOffset, little);
                }
                if (extra.length > 0) {
                    out.seek(newOffset);
                    out.write(extra);
                }
                return;
            }
            ++i;
        }
        throw new FormatException("Tag not found (" + IFD.getIFDTagName(tag) + ")");
    }

    public static void overwriteComment(String id, Object value) throws FormatException, IOException {
        TiffSaver.overwriteIFDValue(id, 0, 270, value);
    }
}

