/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import loci.common.Location;
import loci.common.LogTools;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.out.TiffWriter;

public final class ImageConverter {
    private ImageConverter() {
    }

    public static boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        IFormatWriter w;
        String in = null;
        String out = null;
        String map = null;
        String compression = null;
        boolean stitch = false;
        boolean separate = false;
        boolean merge = false;
        boolean fill = false;
        boolean bigtiff = false;
        int series = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-debug")) {
                        LogTools.setDebug(true);
                        continue;
                    }
                    if (args[i].equals("-stitch")) {
                        stitch = true;
                        continue;
                    }
                    if (args[i].equals("-separate")) {
                        separate = true;
                        continue;
                    }
                    if (args[i].equals("-merge")) {
                        merge = true;
                        continue;
                    }
                    if (args[i].equals("-expand")) {
                        fill = true;
                        continue;
                    }
                    if (args[i].equals("-bigtiff")) {
                        bigtiff = true;
                        continue;
                    }
                    if (args[i].equals("-map")) {
                        map = args[++i];
                        continue;
                    }
                    if (args[i].equals("-compression")) {
                        compression = args[++i];
                        continue;
                    }
                    if (args[i].equals("-series")) {
                        try {
                            series = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    LogTools.println("Ignoring unknown command flag: " + args[i]);
                    continue;
                }
                if (in == null) {
                    in = args[i];
                    continue;
                }
                if (out == null) {
                    out = args[i];
                    continue;
                }
                LogTools.println("Ignoring unknown argument: " + args[i]);
            }
        }
        if (LogTools.isDebug()) {
            LogTools.println("Debugging at level " + LogTools.getDebugLevel());
        }
        if (in == null || out == null) {
            String[] s = new String[]{"To convert a file between formats, run:", "  bfconvert [-debug] [-stitch] [-separate] [-merge] [-expand]", "    [-bigtiff] [-compression codec] [-series series] [-map id]", "    in_file out_file", "", "      -debug: turn on debugging output", "     -stitch: stitch input files with similar names", "   -separate: split RGB images into separate channels", "      -merge: combine separate channels into RGB image", "     -expand: expand indexed color to RGB", "    -bigtiff: force BigTIFF files to be written", "-compression: specify the codec to use when saving images", "     -series: specify which image series to convert", "        -map: specify file on disk to which name should be mapped", "", "If any of the following patterns are present in out_file, they will", "be replaced with the indicated metadata value from the input file.", "", "   Pattern:\tMetadata value:", "   ---------------------------", "   %s\t\tseries index", "   %n\t\tseries name", "   %c\t\tchannel index", "   %w\t\tchannel name", "   %z\t\tZ index", "   %t\t\tT index", "", "If any of these patterns are present, then the images to be saved", "will be split into multiple files.  For example, if the input file", "contains 5 Z sections and 3 timepoints, and out_file is", "", "  converted_Z%z_T%t.tiff", "", "then 15 files will be created, with the names", "", "  converted_Z0_T0.tiff", "  converted_Z0_T1.tiff", "  converted_Z0_T2.tiff", "  converted_Z1_T0.tiff", "  ...", "  converted_Z4_T2.tiff", "", "Each file would have a single image plane."};
            for (int i = 0; i < s.length; ++i) {
                LogTools.println(s[i]);
            }
            return false;
        }
        if (map != null) {
            Location.mapId(in, map);
        }
        long start = System.currentTimeMillis();
        LogTools.print(in + " ");
        IFormatReader reader = new ImageReader();
        if (stitch) {
            reader = new FileStitcher(reader);
        }
        if (separate) {
            reader = new ChannelSeparator(reader);
        }
        if (merge) {
            reader = new ChannelMerger(reader);
        }
        if (fill) {
            reader = new ChannelFiller(reader);
        }
        reader.setMetadataFiltered(true);
        reader.setOriginalMetadataPopulated(true);
        MetadataStore store = MetadataTools.createOMEXMLMetadata();
        if (store == null) {
            LogTools.println("OME-XML Java library not found.");
        } else {
            reader.setMetadataStore(store);
        }
        reader.setId(in);
        LogTools.print("[" + reader.getFormat() + "] -> " + out + " ");
        store = reader.getMetadataStore();
        MetadataRetrieve retrieve = MetadataTools.asRetrieve(store);
        if (retrieve != null) {
            writer.setMetadataRetrieve(retrieve);
        }
        if (writer instanceof TiffWriter) {
            ((TiffWriter)writer).setBigTiff(bigtiff);
        } else if (writer instanceof ImageWriter && (w = ((ImageWriter)writer).getWriter(out)) instanceof TiffWriter) {
            ((TiffWriter)w).setBigTiff(bigtiff);
        }
        String format = writer.getFormat();
        LogTools.print("[" + format + "] ");
        long mid = System.currentTimeMillis();
        if (format.equals("OME-TIFF") && (out.indexOf("%s") > 0 || out.indexOf("%n") > 0 || out.indexOf("%c") > 0 || out.indexOf("%w") > 0 || out.indexOf("%z") > 0 || out.indexOf("%t") > 0)) {
            LogTools.println();
            LogTools.println("Sorry, conversion to multiple OME-TIFF files is not yet supported.");
            return false;
        }
        int total = 0;
        int num = writer.canDoStacks() ? reader.getSeriesCount() : 1;
        long read = 0L;
        long write = 0L;
        int first = series == -1 ? 0 : series;
        int last = series == -1 ? num : series + 1;
        for (int q = first; q < last; ++q) {
            reader.setSeries(q);
            writer.setInterleaved(reader.isInterleaved());
            int numImages = writer.canDoStacks() ? reader.getImageCount() : 1;
            total += numImages;
            for (int i = 0; i < numImages; ++i) {
                writer.setId(FormatTools.getFilename(q, i, reader, out));
                if (compression != null) {
                    writer.setCompression(compression);
                }
                long s = System.currentTimeMillis();
                byte[] buf = reader.openBytes(i);
                byte[][] lut = reader.get8BitLookupTable();
                if (lut != null) {
                    IndexColorModel model = new IndexColorModel(8, lut[0].length, lut[0], lut[1], lut[2]);
                    writer.setColorModel(model);
                }
                long m = System.currentTimeMillis();
                boolean lastInSeries = i == numImages - 1;
                writer.saveBytes(buf, q, lastInSeries, q == last - 1 && lastInSeries);
                long e = System.currentTimeMillis();
                LogTools.print(".");
                read += m - s;
                write += e - m;
            }
        }
        writer.close();
        long end = System.currentTimeMillis();
        LogTools.println(" [done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)total;
        float writeAvg = (float)write / (float)total;
        LogTools.println(sec + "s elapsed (" + readAvg + "+" + writeAvg + "ms per plane, " + initial + "ms overhead)");
        return true;
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (!ImageConverter.testConvert(new ImageWriter(), args)) {
            System.exit(1);
        }
        System.exit(0);
    }
}

