/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;
import loci.formats.gui.ImageViewer;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.tools.StatusEchoer;

public class ImageInfo {
    private String id = null;
    private boolean printVersion = false;
    private boolean pixels = true;
    private boolean doCore = true;
    private boolean doMeta = true;
    private boolean filter = true;
    private boolean thumbs = false;
    private boolean minmax = false;
    private boolean merge = false;
    private boolean stitch = false;
    private boolean separate = false;
    private boolean expand = false;
    private boolean omexml = false;
    private boolean normalize = false;
    private boolean fastBlit = false;
    private boolean autoscale = false;
    private boolean preload = false;
    private String omexmlVersion = null;
    private int start = 0;
    private int end = Integer.MAX_VALUE;
    private int series = 0;
    private int xCoordinate = 0;
    private int yCoordinate = 0;
    private int width = 0;
    private int height = 0;
    private String swapOrder = null;
    private String shuffleOrder = null;
    private String map = null;
    private String format = null;
    private IFormatReader reader;
    private MinMaxCalculator minMaxCalc;
    private DimensionSwapper dimSwapper;
    private BufferedImageReader biReader;
    private StatusEchoer status;
    private String seriesLabel = null;
    private Double[] preGlobalMin = null;
    private Double[] preGlobalMax = null;
    private Double[] preKnownMin = null;
    private Double[] preKnownMax = null;
    private Double[] prePlaneMin = null;
    private Double[] prePlaneMax = null;
    private boolean preIsMinMaxPop = false;

    public void parseArgs(String[] args) {
        this.id = null;
        this.printVersion = false;
        this.pixels = true;
        this.doCore = true;
        this.doMeta = true;
        this.filter = true;
        this.thumbs = false;
        this.minmax = false;
        this.merge = false;
        this.stitch = false;
        this.separate = false;
        this.expand = false;
        this.omexml = false;
        this.normalize = false;
        this.fastBlit = false;
        this.autoscale = false;
        this.preload = false;
        this.omexmlVersion = null;
        this.start = 0;
        this.end = Integer.MAX_VALUE;
        this.series = 0;
        this.xCoordinate = 0;
        this.yCoordinate = 0;
        this.width = 0;
        this.height = 0;
        this.swapOrder = null;
        this.shuffleOrder = null;
        this.map = null;
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-nopix")) {
                    this.pixels = false;
                    continue;
                }
                if (args[i].equals("-version")) {
                    this.printVersion = true;
                    continue;
                }
                if (args[i].equals("-nocore")) {
                    this.doCore = false;
                    continue;
                }
                if (args[i].equals("-nometa")) {
                    this.doMeta = false;
                    continue;
                }
                if (args[i].equals("-nofilter")) {
                    this.filter = false;
                    continue;
                }
                if (args[i].equals("-thumbs")) {
                    this.thumbs = true;
                    continue;
                }
                if (args[i].equals("-minmax")) {
                    this.minmax = true;
                    continue;
                }
                if (args[i].equals("-merge")) {
                    this.merge = true;
                    continue;
                }
                if (args[i].equals("-stitch")) {
                    this.stitch = true;
                    continue;
                }
                if (args[i].equals("-separate")) {
                    this.separate = true;
                    continue;
                }
                if (args[i].equals("-expand")) {
                    this.expand = true;
                    continue;
                }
                if (args[i].equals("-omexml")) {
                    this.omexml = true;
                    continue;
                }
                if (args[i].equals("-normalize")) {
                    this.normalize = true;
                    continue;
                }
                if (args[i].equals("-fast")) {
                    this.fastBlit = true;
                    continue;
                }
                if (args[i].equals("-autoscale")) {
                    this.autoscale = true;
                    continue;
                }
                if (args[i].equals("-debug")) {
                    LogTools.setDebug(true);
                    continue;
                }
                if (args[i].equals("-preload")) {
                    this.preload = true;
                    continue;
                }
                if (args[i].equals("-xmlversion")) {
                    this.omexmlVersion = args[++i];
                    continue;
                }
                if (args[i].equals("-crop")) {
                    StringTokenizer st = new StringTokenizer(args[++i], ",");
                    this.xCoordinate = Integer.parseInt(st.nextToken());
                    this.yCoordinate = Integer.parseInt(st.nextToken());
                    this.width = Integer.parseInt(st.nextToken());
                    this.height = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (args[i].equals("-level")) {
                    try {
                        LogTools.setDebugLevel(Integer.parseInt(args[++i]));
                    }
                    catch (NumberFormatException exc) {}
                    continue;
                }
                if (args[i].equals("-range")) {
                    try {
                        this.start = Integer.parseInt(args[++i]);
                        this.end = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException exc) {}
                    continue;
                }
                if (args[i].equals("-series")) {
                    try {
                        this.series = Integer.parseInt(args[++i]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (args[i].equals("-swap")) {
                    this.swapOrder = args[++i].toUpperCase();
                    continue;
                }
                if (args[i].equals("-shuffle")) {
                    this.shuffleOrder = args[++i].toUpperCase();
                    continue;
                }
                if (args[i].equals("-map")) {
                    this.map = args[++i];
                    continue;
                }
                if (args[i].equals("-format")) {
                    this.format = args[++i];
                    continue;
                }
                LogTools.println("Ignoring unknown command flag: " + args[i]);
                continue;
            }
            if (this.id == null) {
                this.id = args[i];
                continue;
            }
            LogTools.println("Ignoring unknown argument: " + args[i]);
        }
    }

    public void printUsage() {
        String className = this.reader.getClass().getName();
        String fmt = this.reader instanceof ImageReader ? "any" : this.reader.getFormat();
        String[] s = new String[]{"To test read a file in " + fmt + " format, run:", "  showinf file [-nopix] [-nocore] [-nometa] [-thumbs] [-minmax] ", "    [-merge] [-stitch] [-separate] [-expand] [-omexml]", "    [-normalize] [-fast] [-debug] [-range start end] [-series num]", "    [-swap inputOrder] [-shuffle outputOrder] [-map id] [-preload]", "    [-xmlversion v] [-crop x,y,w,h] [-autoscale] [-format Format]", "", "   -version: print the library version and exit", "       file: the image file to read", "     -nopix: read metadata only, not pixels", "    -nocore: do not output core metadata", "    -nometa: do not parse format-specific metadata table", "  -nofilter: do not filter metadata fields", "    -thumbs: read thumbnails instead of normal pixels", "    -minmax: compute min/max statistics", "     -merge: combine separate channels into RGB image", "    -stitch: stitch files with similar names", "  -separate: split RGB image into separate channels", "    -expand: expand indexed color to RGB", "    -omexml: populate OME-XML metadata", " -normalize: normalize floating point images*", "      -fast: paint RGB images as quickly as possible*", "     -debug: turn on debugging output", "     -range: specify range of planes to read (inclusive)", "    -series: specify which image series to read", "      -swap: override the default input dimension order", "   -shuffle: override the default output dimension order", "       -map: specify file on disk to which name should be mapped", "   -preload: pre-read entire file into a buffer; significantly", "             reduces the time required to read the images, but", "             requires more memory", "-xmlversion: specify which OME-XML version should be generated", "      -crop: crop images before displaying; argument is 'x,y,w,h'", " -autoscale: used in combination with '-fast' to automatically adjust", "             brightness and contrast", "    -format: read file with a particular reader (e.g., ZeissZVI)", "", "* = may result in loss of precision", ""};
        for (int i = 0; i < s.length; ++i) {
            LogTools.println(s[i]);
        }
    }

    public void createReader() {
        if (this.format != null) {
            try {
                Class<?> c = Class.forName("loci.formats.in." + this.format + "Reader");
                this.reader = (IFormatReader)c.newInstance();
            }
            catch (ClassNotFoundException exc) {
                LogTools.println("Warning: unknown reader: " + this.format);
                LogTools.traceDebug(exc);
            }
            catch (InstantiationException exc) {
                LogTools.println("Warning: cannot instantiate reader: " + this.format);
                LogTools.traceDebug(exc);
            }
            catch (IllegalAccessException exc) {
                LogTools.println("Warning: cannot access reader: " + this.format);
                LogTools.traceDebug(exc);
            }
        }
        if (this.reader == null) {
            this.reader = new ImageReader();
        }
    }

    public void mapLocation() throws IOException {
        if (this.map != null) {
            Location.mapId(this.id, this.map);
        } else if (this.preload) {
            RandomAccessInputStream f = new RandomAccessInputStream(this.id);
            byte[] b = new byte[(int)f.length()];
            f.read(b);
            f.close();
            ByteArrayHandle file2 = new ByteArrayHandle(b);
            Location.mapFile(this.id, file2);
        }
    }

    public void configureReaderPreInit() throws FormatException, IOException {
        if (this.omexml) {
            this.reader.setOriginalMetadataPopulated(true);
            IMetadata store = MetadataTools.createOMEXMLMetadata(null, this.omexmlVersion);
            if (store != null) {
                this.reader.setMetadataStore(store);
            }
        }
        if (this.reader instanceof ImageReader) {
            ImageReader ir = (ImageReader)this.reader;
            LogTools.print("Checking file format ");
            LogTools.println("[" + ir.getFormat(this.id) + "]");
        } else {
            LogTools.print("Checking " + this.reader.getFormat() + " format ");
            LogTools.println(this.reader.isThisType(this.id) ? "[yes]" : "[no]");
        }
        LogTools.println("Initializing reader");
        if (this.stitch) {
            this.reader = new FileStitcher(this.reader, true);
            String pat = FilePattern.findPattern(new Location(this.id));
            if (pat != null) {
                this.id = pat;
            }
        }
        if (this.expand) {
            this.reader = new ChannelFiller(this.reader);
        }
        if (this.separate) {
            this.reader = new ChannelSeparator(this.reader);
        }
        if (this.merge) {
            this.reader = new ChannelMerger(this.reader);
        }
        this.minMaxCalc = null;
        if (this.minmax || this.autoscale) {
            this.minMaxCalc = new MinMaxCalculator(this.reader);
            this.reader = this.minMaxCalc;
        }
        this.dimSwapper = null;
        if (this.swapOrder != null || this.shuffleOrder != null) {
            this.dimSwapper = new DimensionSwapper(this.reader);
            this.reader = this.dimSwapper;
        }
        this.biReader = new BufferedImageReader(this.reader);
        this.reader = this.biReader;
        this.status = new StatusEchoer();
        this.reader.addStatusListener(this.status);
        this.reader.close();
        this.reader.setNormalized(this.normalize);
        this.reader.setMetadataFiltered(this.filter);
        this.reader.setMetadataCollected(this.doMeta);
    }

    public void configureReaderPostInit() {
        if (this.swapOrder != null) {
            this.dimSwapper.swapDimensions(this.swapOrder);
        }
        if (this.shuffleOrder != null) {
            this.dimSwapper.setOutputOrder(this.shuffleOrder);
        }
    }

    public void checkWarnings() {
        if (!(this.normalize || this.reader.getPixelType() != 6 && this.reader.getPixelType() != 7)) {
            LogTools.println("Warning: Java does not support display of unnormalized floating point data.");
            LogTools.println("Please use the '-normalize' option to avoid receiving a cryptic exception.");
        }
        if (this.reader.isRGB() && this.reader.getRGBChannelCount() > 4) {
            LogTools.println("Warning: Java does not support merging more than 4 channels.");
            LogTools.println("Please use the '-separate' option to avoid receiving a cryptic exception.");
        }
    }

    public void readCoreMetadata() throws FormatException, IOException {
        int u;
        String[] used;
        boolean usedValid;
        if (!this.doCore) {
            return;
        }
        LogTools.println();
        LogTools.println("Reading core metadata");
        LogTools.println(this.stitch ? "File pattern = " + this.id : "Filename = " + this.reader.getCurrentFile());
        if (this.map != null) {
            LogTools.println("Mapped filename = " + this.map);
        }
        boolean bl = usedValid = (used = this.reader.getUsedFiles()) != null && used.length > 0;
        if (usedValid) {
            for (u = 0; u < used.length; ++u) {
                if (used[u] != null) continue;
                usedValid = false;
                break;
            }
        }
        if (!usedValid) {
            LogTools.println("************ Warning: invalid used files list ************");
        }
        if (used == null) {
            LogTools.println("Used files = null");
        } else if (used.length == 0) {
            LogTools.println("Used files = []");
        } else if (used.length > 1) {
            LogTools.println("Used files:");
            for (u = 0; u < used.length; ++u) {
                LogTools.println("\t" + used[u]);
            }
        } else if (!this.id.equals(used[0])) {
            LogTools.println("Used files = [" + used[0] + "]");
        }
        int seriesCount = this.reader.getSeriesCount();
        LogTools.println("Series count = " + seriesCount);
        MetadataStore ms = this.reader.getMetadataStore();
        MetadataRetrieve mr = MetadataTools.asRetrieve(ms);
        for (int j = 0; j < seriesCount; ++j) {
            int[] indices;
            this.reader.setSeries(j);
            int imageCount = this.reader.getImageCount();
            boolean rgb = this.reader.isRGB();
            int sizeX = this.reader.getSizeX();
            int sizeY = this.reader.getSizeY();
            int sizeZ = this.reader.getSizeZ();
            int sizeC = this.reader.getSizeC();
            int sizeT = this.reader.getSizeT();
            int pixelType = this.reader.getPixelType();
            int effSizeC = this.reader.getEffectiveSizeC();
            int rgbChanCount = this.reader.getRGBChannelCount();
            boolean indexed = this.reader.isIndexed();
            boolean falseColor = this.reader.isFalseColor();
            byte[][] table8 = this.reader.get8BitLookupTable();
            short[][] table16 = this.reader.get16BitLookupTable();
            int[] cLengths = this.reader.getChannelDimLengths();
            String[] cTypes = this.reader.getChannelDimTypes();
            int thumbSizeX = this.reader.getThumbSizeX();
            int thumbSizeY = this.reader.getThumbSizeY();
            boolean little = this.reader.isLittleEndian();
            String dimOrder = this.reader.getDimensionOrder();
            boolean orderCertain = this.reader.isOrderCertain();
            boolean thumbnail = this.reader.isThumbnailSeries();
            boolean interleaved = this.reader.isInterleaved();
            boolean metadataComplete = this.reader.isMetadataComplete();
            String seriesName = mr == null ? null : mr.getImageName(j);
            LogTools.println("Series #" + j + (seriesName == null ? "" : " -- " + seriesName) + ":");
            LogTools.println("\tImage count = " + imageCount);
            LogTools.print("\tRGB = " + rgb + " (" + rgbChanCount + ")");
            if (this.merge) {
                LogTools.print(" (merged)");
            } else if (this.separate) {
                LogTools.print(" (separated)");
            }
            LogTools.println();
            if (rgb != (rgbChanCount != 1)) {
                LogTools.println("\t************ Warning: RGB mismatch ************");
            }
            LogTools.println("\tInterleaved = " + interleaved);
            LogTools.print("\tIndexed = " + indexed + " (" + (falseColor ? "false" : "true") + " color");
            if (table8 != null) {
                LogTools.print(", 8-bit LUT: " + table8.length + " x ");
                LogTools.print(table8[0] == null ? "null" : "" + table8[0].length);
            }
            if (table16 != null) {
                LogTools.print(", 16-bit LUT: " + table16.length + " x ");
                LogTools.print(table16[0] == null ? "null" : "" + table16[0].length);
            }
            LogTools.println(")");
            if (table8 != null && table16 != null) {
                LogTools.println("\t************ Warning: multiple LUTs ************");
            }
            LogTools.println("\tWidth = " + sizeX);
            LogTools.println("\tHeight = " + sizeY);
            LogTools.println("\tSizeZ = " + sizeZ);
            LogTools.println("\tSizeT = " + sizeT);
            LogTools.print("\tSizeC = " + sizeC);
            if (sizeC != effSizeC) {
                LogTools.print(" (effectively " + effSizeC + ")");
            }
            int cProduct = 1;
            if (cLengths.length == 1 && "Channel".equals(cTypes[0])) {
                cProduct = cLengths[0];
            } else {
                LogTools.print(" (");
                for (int i = 0; i < cLengths.length; ++i) {
                    if (i > 0) {
                        LogTools.print(" x ");
                    }
                    LogTools.print(cLengths[i] + " " + cTypes[i]);
                    cProduct *= cLengths[i];
                }
                LogTools.print(")");
            }
            LogTools.println();
            if (cLengths.length == 0 || cProduct != sizeC) {
                LogTools.println("\t************ Warning: C dimension mismatch ************");
            }
            if (imageCount != sizeZ * effSizeC * sizeT) {
                LogTools.println("\t************ Warning: ZCT mismatch ************");
            }
            LogTools.println("\tThumbnail size = " + thumbSizeX + " x " + thumbSizeY);
            LogTools.println("\tEndianness = " + (little ? "intel (little)" : "motorola (big)"));
            LogTools.println("\tDimension order = " + dimOrder + (orderCertain ? " (certain)" : " (uncertain)"));
            LogTools.println("\tPixel type = " + FormatTools.getPixelTypeString(pixelType));
            LogTools.println("\tMetadata complete = " + metadataComplete);
            LogTools.println("\tThumbnail series = " + thumbnail);
            if (!this.doMeta) continue;
            LogTools.println("\t-----");
            if (imageCount > 6) {
                int q = imageCount / 2;
                indices = new int[]{0, q - 2, q - 1, q, q + 1, q + 2, imageCount - 1};
            } else {
                indices = imageCount > 2 ? new int[]{0, imageCount / 2, imageCount - 1} : (imageCount > 1 ? new int[]{0, 1} : new int[]{0});
            }
            int[][] zct = new int[indices.length][];
            int[] indices2 = new int[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                zct[i] = this.reader.getZCTCoords(indices[i]);
                indices2[i] = this.reader.getIndex(zct[i][0], zct[i][1], zct[i][2]);
                LogTools.print("\tPlane #" + indices[i] + " <=> Z " + zct[i][0] + ", C " + zct[i][1] + ", T " + zct[i][2]);
                if (indices[i] != indices2[i]) {
                    LogTools.println(" [mismatch: " + indices2[i] + "]");
                    continue;
                }
                LogTools.println();
            }
        }
    }

    public void initPreMinMaxValues() throws FormatException, IOException {
        this.preGlobalMax = null;
        this.preGlobalMin = null;
        this.preKnownMax = null;
        this.preKnownMin = null;
        this.prePlaneMax = null;
        this.prePlaneMin = null;
        this.preIsMinMaxPop = false;
        if (this.minmax) {
            int sizeC = this.reader.getSizeC();
            this.preGlobalMin = new Double[sizeC];
            this.preGlobalMax = new Double[sizeC];
            this.preKnownMin = new Double[sizeC];
            this.preKnownMax = new Double[sizeC];
            for (int c = 0; c < sizeC; ++c) {
                this.preGlobalMin[c] = this.minMaxCalc.getChannelGlobalMinimum(c);
                this.preGlobalMax[c] = this.minMaxCalc.getChannelGlobalMaximum(c);
                this.preKnownMin[c] = this.minMaxCalc.getChannelKnownMinimum(c);
                this.preKnownMax[c] = this.minMaxCalc.getChannelKnownMaximum(c);
            }
            this.prePlaneMin = this.minMaxCalc.getPlaneMinimum(0);
            this.prePlaneMax = this.minMaxCalc.getPlaneMaximum(0);
            this.preIsMinMaxPop = this.minMaxCalc.isMinMaxPopulated();
        }
    }

    public void printMinMaxValues() throws FormatException, IOException {
        int subC;
        int sizeC = this.reader.getSizeC();
        Double[] globalMin = new Double[sizeC];
        Double[] globalMax = new Double[sizeC];
        Double[] knownMin = new Double[sizeC];
        Double[] knownMax = new Double[sizeC];
        for (int c = 0; c < sizeC; ++c) {
            globalMin[c] = this.minMaxCalc.getChannelGlobalMinimum(c);
            globalMax[c] = this.minMaxCalc.getChannelGlobalMaximum(c);
            knownMin[c] = this.minMaxCalc.getChannelKnownMinimum(c);
            knownMax[c] = this.minMaxCalc.getChannelKnownMaximum(c);
        }
        Double[] planeMin = this.minMaxCalc.getPlaneMinimum(0);
        Double[] planeMax = this.minMaxCalc.getPlaneMaximum(0);
        boolean isMinMaxPop = this.minMaxCalc.isMinMaxPopulated();
        LogTools.println();
        LogTools.println("Min/max values:");
        for (int c = 0; c < sizeC; ++c) {
            LogTools.println("\tChannel " + c + ":");
            LogTools.println("\t\tGlobal minimum = " + globalMin[c] + " (initially " + this.preGlobalMin[c] + ")");
            LogTools.println("\t\tGlobal maximum = " + globalMax[c] + " (initially " + this.preGlobalMax[c] + ")");
            LogTools.println("\t\tKnown minimum = " + knownMin[c] + " (initially " + this.preKnownMin[c] + ")");
            LogTools.println("\t\tKnown maximum = " + knownMax[c] + " (initially " + this.preKnownMax[c] + ")");
        }
        LogTools.print("\tFirst plane minimum(s) =");
        if (planeMin == null) {
            LogTools.print(" none");
        } else {
            for (subC = 0; subC < planeMin.length; ++subC) {
                LogTools.print(" " + planeMin[subC]);
            }
        }
        LogTools.print(" (initially");
        if (this.prePlaneMin == null) {
            LogTools.print(" none");
        } else {
            for (subC = 0; subC < this.prePlaneMin.length; ++subC) {
                LogTools.print(" " + this.prePlaneMin[subC]);
            }
        }
        LogTools.println(")");
        LogTools.print("\tFirst plane maximum(s) =");
        if (planeMax == null) {
            LogTools.print(" none");
        } else {
            for (subC = 0; subC < planeMax.length; ++subC) {
                LogTools.print(" " + planeMax[subC]);
            }
        }
        LogTools.print(" (initially");
        if (this.prePlaneMax == null) {
            LogTools.print(" none");
        } else {
            for (subC = 0; subC < this.prePlaneMax.length; ++subC) {
                LogTools.print(" " + this.prePlaneMax[subC]);
            }
        }
        LogTools.println(")");
        LogTools.println("\tMin/max populated = " + isMinMaxPop + " (initially " + this.preIsMinMaxPop + ")");
    }

    public void readPixels() throws FormatException, IOException {
        String seriesLabel = this.reader.getSeriesCount() > 1 ? " series #" + this.series : "";
        LogTools.println();
        LogTools.print("Reading" + seriesLabel + " pixel data ");
        this.status.setVerbose(false);
        int num = this.reader.getImageCount();
        if (this.start < 0) {
            this.start = 0;
        }
        if (this.start >= num) {
            this.start = num - 1;
        }
        if (this.end < 0) {
            this.end = 0;
        }
        if (this.end >= num) {
            this.end = num - 1;
        }
        if (this.end < this.start) {
            this.end = this.start;
        }
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        int sizeC = this.reader.getSizeC();
        if (this.width == 0) {
            this.width = sizeX;
        }
        if (this.height == 0) {
            this.height = sizeY;
        }
        int pixelType = this.reader.getPixelType();
        LogTools.print("(" + this.start + "-" + this.end + ") ");
        BufferedImage[] images = new BufferedImage[this.end - this.start + 1];
        long s2 = System.currentTimeMillis();
        boolean mismatch = false;
        for (int i = this.start; i <= this.end; ++i) {
            int pixType;
            this.status.setEchoNext(true);
            if (!this.fastBlit) {
                images[i - this.start] = this.thumbs ? this.biReader.openThumbImage(i) : this.biReader.openImage(i, this.xCoordinate, this.yCoordinate, this.width, this.height);
            } else {
                byte[] b = this.thumbs ? this.reader.openThumbBytes(i) : this.reader.openBytes(i, this.xCoordinate, this.yCoordinate, this.width, this.height);
                Object pix = DataTools.makeDataArray(b, FormatTools.getBytesPerPixel(pixelType), FormatTools.isFloatingPoint(pixelType), this.reader.isLittleEndian());
                Double min = null;
                Double max = null;
                if (this.autoscale) {
                    Double[] planeMin = this.minMaxCalc.getPlaneMinimum(i);
                    Double[] planeMax = this.minMaxCalc.getPlaneMaximum(i);
                    if (planeMin != null && planeMax != null) {
                        min = planeMin[0];
                        max = planeMax[0];
                        for (int j = 1; j < planeMin.length; ++j) {
                            if (planeMin[j] < min) {
                                min = planeMin[j];
                            }
                            if (!(planeMax[j] > max)) continue;
                            max = planeMax[j];
                        }
                    }
                } else if (this.normalize) {
                    min = new Double(0.0);
                    max = new Double(1.0);
                }
                if (this.normalize) {
                    if (pix instanceof float[]) {
                        pix = DataTools.normalizeFloats((float[])pix);
                    } else if (pix instanceof double[]) {
                        pix = DataTools.normalizeDoubles((double[])pix);
                    }
                }
                images[i - this.start] = AWTImageTools.makeImage(ImageTools.make24Bits(pix, sizeX, sizeY, false, false, min, max), sizeX, sizeY, FormatTools.isSigned(pixelType));
            }
            if (this.reader.isIndexed() && this.reader.get8BitLookupTable() == null && this.reader.get16BitLookupTable() == null) {
                LogTools.println();
                LogTools.println("************ Warning: no LUT for plane #" + i + " ************");
            }
            if ((pixType = AWTImageTools.getPixelType(images[i - this.start])) != pixelType && pixType != pixelType + 1 && !this.fastBlit) {
                if (!mismatch) {
                    LogTools.println();
                    mismatch = true;
                }
                LogTools.println("\tPlane #" + i + ": pixel type mismatch: " + FormatTools.getPixelTypeString(pixType) + "/" + FormatTools.getPixelTypeString(pixelType));
                continue;
            }
            mismatch = false;
            LogTools.print(".");
        }
        long e2 = System.currentTimeMillis();
        if (!mismatch) {
            LogTools.print(" ");
        }
        LogTools.println("[done]");
        float sec2 = (float)(e2 - s2) / 1000.0f;
        float avg = (float)(e2 - s2) / (float)images.length;
        LogTools.println(sec2 + "s elapsed (" + avg + "ms per plane)");
        if (this.minmax) {
            this.printMinMaxValues();
        }
        LogTools.println();
        LogTools.println("Launching image viewer");
        ImageViewer viewer = new ImageViewer();
        viewer.setImages(this.reader, images);
        viewer.setVisible(true);
    }

    public void printGlobalMetadata() {
        String[] keys;
        LogTools.println();
        LogTools.println("Reading global metadata");
        Hashtable meta = this.reader.getGlobalMetadata();
        for (String key : keys = MetadataTools.keys(meta)) {
            LogTools.println(key + ": " + meta.get(key));
        }
    }

    public void printOriginalMetadata() {
        String seriesLabel = this.reader.getSeriesCount() > 1 ? " series #" + this.series : "";
        LogTools.println();
        LogTools.println("Reading" + seriesLabel + " metadata");
        Hashtable meta = this.reader.getSeriesMetadata();
        String[] keys = MetadataTools.keys(meta);
        for (int i = 0; i < keys.length; ++i) {
            LogTools.print(keys[i] + ": ");
            LogTools.println(meta.get(keys[i]));
        }
    }

    public void printOMEXML() {
        LogTools.println();
        MetadataStore ms = this.reader.getMetadataStore();
        String version = MetadataTools.getOMEXMLVersion(ms);
        if (version == null) {
            LogTools.println("Generating OME-XML");
        } else {
            LogTools.println("Generating OME-XML (schema version " + version + ")");
        }
        MetadataRetrieve mr = MetadataTools.asRetrieve(ms);
        if (mr != null) {
            String xml = MetadataTools.getOMEXML(mr);
            LogTools.println(XMLTools.indentXML(xml, true));
            MetadataTools.validateOMEXML(xml, true);
        } else {
            LogTools.println("The metadata could not be converted to OME-XML.");
            if (this.omexmlVersion == null) {
                LogTools.println("The OME-XML Java library is probably not available.");
            } else {
                LogTools.println(this.omexmlVersion + " is probably not a legal schema version.");
            }
        }
    }

    public boolean testRead(String[] args) throws FormatException, IOException {
        this.parseArgs(args);
        if (this.printVersion) {
            LogTools.println("Version: 4.1.1");
            LogTools.println("SVN revision: 5727");
            LogTools.println("Build date: 3 December 2009");
            return true;
        }
        if (LogTools.isDebug()) {
            LogTools.println("Debugging at level " + LogTools.getDebugLevel());
        }
        this.createReader();
        if (this.id == null) {
            this.printUsage();
            return false;
        }
        this.mapLocation();
        this.configureReaderPreInit();
        long s1 = System.currentTimeMillis();
        this.reader.setId(this.id);
        long e1 = System.currentTimeMillis();
        float sec1 = (float)(e1 - s1) / 1000.0f;
        LogTools.println("Initialization took " + sec1 + "s");
        this.configureReaderPostInit();
        this.checkWarnings();
        this.readCoreMetadata();
        this.reader.setSeries(this.series);
        this.initPreMinMaxValues();
        if (this.pixels) {
            this.readPixels();
        }
        if (this.doMeta) {
            this.printGlobalMetadata();
            this.printOriginalMetadata();
        }
        if (this.omexml) {
            this.printOMEXML();
        }
        return true;
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (!new ImageInfo().testRead(args)) {
            System.exit(1);
        }
    }
}

