/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import loci.formats.FormatTools;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.importer.MergeDialog;
import loci.plugins.util.ImagePlusTools;
import loci.plugins.util.LibraryChecker;
import loci.plugins.util.WindowTools;

public class Colorizer
implements PlugInFilter {
    public boolean canceled;
    private String arg;
    private ImagePlus imp;
    private String stackOrder;
    private boolean color;
    private boolean hyperstack;
    private byte[][][] lut;
    private String mergeOption;
    private int series = 0;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        if (!LibraryChecker.checkJava() || !LibraryChecker.checkImageJ()) {
            return;
        }
        this.stackOrder = "XYCZT";
        boolean doPrompt = false;
        if (this.arg == null || this.arg.trim().equals("")) {
            GenericDialog gd = new GenericDialog("Colorizing options...");
            gd.addCheckbox("Merge to RGB", false);
            gd.addCheckbox("Colorize", false);
            gd.addChoice("Stack order", new String[]{"XYCZT", "XYCTZ", "XYZCT", "XYZTC", "XYTCZ", "XYTZC"}, "XYCZT");
            gd.addCheckbox("Open as HyperStack", false);
            gd.showDialog();
            if (gd.wasCanceled()) {
                this.canceled = true;
                return;
            }
            this.color = gd.getNextBoolean();
            this.stackOrder = gd.getNextChoice();
            this.hyperstack = gd.getNextBoolean();
            if (this.color && this.lut == null) {
                doPrompt = true;
            }
        } else {
            this.series = Integer.parseInt(Macro.getValue((String)this.arg, (String)"series", (String)"0"));
            this.stackOrder = Macro.getValue((String)this.arg, (String)"stack_order", (String)"XYCZT");
            this.color = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"colorize", (String)"false"));
            int colorNdx = Integer.parseInt(Macro.getValue((String)this.arg, (String)"ndx", (String)"-1"));
            if (this.color) {
                if (colorNdx >= 0 && colorNdx < 3) {
                    this.lut = new byte[this.imp.getNChannels()][3][256];
                    for (int channel = 0; channel < this.lut.length && colorNdx + channel < this.lut[channel].length; ++channel) {
                        for (int q = 0; q < this.lut[channel][colorNdx + channel].length; ++q) {
                            this.lut[channel][colorNdx + channel][q] = (byte)q;
                        }
                    }
                } else if (this.lut == null) {
                    doPrompt = true;
                }
            }
            this.mergeOption = Macro.getValue((String)this.arg, (String)"merge_option", null);
            this.hyperstack = Boolean.valueOf(Macro.getValue((String)this.arg, (String)"hyper_stack", (String)"false"));
        }
        ImageStack stack = this.imp.getImageStack();
        if (stack.isVirtual()) {
            IJ.error((String)"Colorizer plugin cannot be used with virtual stacks.\nPlease convert the virtual stack using Image>Duplicate.");
            return;
        }
        Calibration calibration = this.imp.getCalibration();
        int nChannels = this.imp.getNChannels();
        int nTimes = this.imp.getNFrames();
        int nSlices = this.imp.getNSlices();
        IJ.showStatus((String)("Running colorizer on " + nTimes * nSlices + " images"));
        if (this.imp.isComposite() || stack.isRGB() || nChannels == 1 && !this.color) {
            return;
        }
        ImagePlus newImp = new ImagePlus();
        boolean closeOriginal = true;
        if (this.color) {
            if (nChannels > 1) {
                this.imp = ImagePlusTools.reorder(this.imp, this.stackOrder, "XYCZT");
                CompositeImage composite = new CompositeImage(this.imp, 2);
                for (int i = 0; i < nChannels; ++i) {
                    composite.setPosition(i + 1, 1, 1);
                    if (doPrompt) {
                        this.promptForColor(i);
                    }
                    if (this.lut == null) continue;
                    LUT channelLut = new LUT(this.lut[i][0], this.lut[i][1], this.lut[i][2]);
                    composite.setChannelLut(channelLut);
                }
                newImp = composite;
                newImp.setPosition(1, 1, 1);
            } else {
                ImageStack newStack = new ImageStack(stack.getWidth(), stack.getHeight());
                for (int i = 1; i <= stack.getSize(); ++i) {
                    newStack.addSlice(stack.getSliceLabel(i), stack.getProcessor(i));
                }
                if (doPrompt) {
                    this.promptForColor(0);
                }
                if (this.lut == null) {
                    return;
                }
                IndexColorModel model = new IndexColorModel(8, 256, this.lut[0][0], this.lut[0][1], this.lut[0][2]);
                newStack.setColorModel((ColorModel)model);
                newImp.setStack(this.imp.getTitle(), newStack);
            }
        } else {
            int type = this.imp.getType();
            if (nChannels < 4 && type == 0) {
                newImp = this.makeRGB(newImp, stack, nChannels);
            } else if (nChannels <= 7 && type != 3) {
                this.imp = ImagePlusTools.reorder(this.imp, this.stackOrder, "XYCZT");
                newImp = new CompositeImage(this.imp, 1);
            } else if (nChannels > 7) {
                int ndx;
                MergeDialog mergeDialog;
                int status;
                int[] num = new int[6];
                for (int i = 0; i < num.length; ++i) {
                    num[i] = stack.getSize() / (i + 2);
                    if (num[i] * (i + 2) >= stack.getSize()) continue;
                    int n = i;
                    num[n] = num[n] + 1;
                }
                ImporterOptions options = null;
                try {
                    options = new ImporterOptions();
                }
                catch (IOException exc) {
                    WindowTools.reportException(exc);
                }
                if (this.mergeOption == null && (status = (mergeDialog = new MergeDialog(options, num)).showDialog()) == 0) {
                    this.mergeOption = options.getMergeOption();
                }
                if (this.mergeOption != null && (ndx = this.mergeOption.indexOf("channels")) != -1) {
                    int n = Integer.parseInt(this.mergeOption.substring(ndx - 2, ndx - 1));
                    if (stack.getSize() % n != 0) {
                        int toAdd = n - stack.getSize() % n;
                        ImageProcessor blank = stack.getProcessor(stack.getSize()).duplicate();
                        blank.setValue(0.0);
                        blank.fill();
                        for (int i = 0; i < toAdd; ++i) {
                            stack.addSlice("", blank);
                        }
                        this.imp.setStack(this.imp.getTitle(), stack);
                    }
                    if (this.imp.getType() == 0 && n < 4) {
                        newImp = this.makeRGB(newImp, stack, n);
                    }
                    this.imp.setDimensions(n, this.imp.getNSlices() * num[n - 2], this.imp.getNFrames());
                    this.imp = ImagePlusTools.reorder(this.imp, this.stackOrder, "XYCZT");
                    newImp = new CompositeImage(this.imp, 1);
                }
            }
        }
        if (newImp != null) {
            newImp.setTitle(this.imp.getTitle());
            newImp.setProperty("Info", this.imp.getProperty("Info"));
            if (!newImp.isComposite()) {
                newImp.setDimensions(newImp.getStackSize() / (nSlices * nTimes), nSlices, nTimes);
            }
            newImp.setCalibration(calibration);
            newImp.setFileInfo(this.imp.getOriginalFileInfo());
            if (!newImp.isComposite()) {
                newImp.setOpenAsHyperStack(this.hyperstack);
            }
            newImp.show();
        }
        if (closeOriginal) {
            this.imp.close();
        }
        this.lut = null;
    }

    public void setLookupTable(byte[][] lut, int channel) {
        if (this.lut == null) {
            this.lut = new byte[this.imp.getNChannels()][][];
        }
        if (channel < this.lut.length) {
            this.lut[channel] = lut;
        }
    }

    private ImagePlus makeRGB(ImagePlus ip, ImageStack s, int c) {
        int i;
        ImageStack newStack = new ImageStack(s.getWidth(), s.getHeight());
        int z = this.imp.getNSlices();
        int t = this.imp.getNFrames();
        t *= this.imp.getNChannels() / c;
        int[][] indices = new int[c][s.getSize() / c];
        ImageProcessor[][] processors = new ImageProcessor[s.getSize() / c][c];
        int[] pt = new int[c];
        Arrays.fill(pt, 0);
        for (i = 0; i < s.getSize(); ++i) {
            int[] zct = FormatTools.getZCTCoords(this.stackOrder, z, c, t, s.getSize(), i);
            indices[zct[1]][pt[zct[1]]] = i + 1;
            int n = zct[1];
            int n2 = pt[n];
            pt[n] = n2 + 1;
            processors[n2][zct[1]] = s.getProcessor(i + 1);
        }
        for (i = 0; i < indices[0].length; ++i) {
            newStack.addSlice(s.getSliceLabel(indices[indices.length - 1][i]), ImagePlusTools.makeRGB(processors[i]).getProcessor());
            IJ.showProgress((double)((double)((i + 1) / indices[0].length) * 100.0));
        }
        ip.setStack(ip.getTitle(), newStack);
        return ip;
    }

    private void promptForColor(int channel) {
        CustomColorChooser chooser = new CustomColorChooser("Color Chooser - Channel " + channel, null, this.series, channel);
        Color color = chooser.getColor();
        if (color == null) {
            return;
        }
        double redIncrement = (double)color.getRed() / 255.0;
        double greenIncrement = (double)color.getGreen() / 255.0;
        double blueIncrement = (double)color.getBlue() / 255.0;
        if (this.lut == null) {
            this.lut = new byte[this.imp.getNChannels()][3][256];
        }
        for (int i = 0; i < 256; ++i) {
            this.lut[channel][0][i] = (byte)((double)i * redIncrement);
            this.lut[channel][1][i] = (byte)((double)i * greenIncrement);
            this.lut[channel][2][i] = (byte)((double)i * blueIncrement);
        }
    }

    static class ColorPanel
    extends Panel {
        private static final int WIDTH = 100;
        private static final int HEIGHT = 50;
        private Color c;

        public ColorPanel(Color c) {
            this.c = c;
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, 50);
        }

        void setColor(Color c) {
            this.c = c;
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 50);
        }

        public void paint(Graphics g) {
            g.setColor(this.c);
            g.fillRect(0, 0, 100, 50);
            g.setColor(Color.black);
            g.drawRect(0, 0, 99, 49);
        }
    }

    class CustomColorChooser
    implements TextListener {
        Vector colors;
        ColorPanel panel;
        Color initialColor;
        int red;
        int green;
        int blue;
        String title;
        private int series;
        private int channel;

        public CustomColorChooser(String title, Color initialColor, int series, int channel) {
            this.title = title;
            if (initialColor == null) {
                initialColor = Color.BLACK;
            }
            this.initialColor = initialColor;
            this.red = initialColor.getRed();
            this.green = initialColor.getGreen();
            this.blue = initialColor.getBlue();
            this.series = series;
            this.channel = channel;
        }

        public Color getColor() {
            GenericDialog gd = new GenericDialog(this.title);
            gd.addSlider(this.makeLabel("Red:"), 0.0, 255.0, (double)this.red);
            gd.addSlider(this.makeLabel("Green:"), 0.0, 255.0, (double)this.green);
            gd.addSlider(this.makeLabel("Blue:"), 0.0, 255.0, (double)this.blue);
            this.panel = new ColorPanel(this.initialColor);
            gd.addPanel((Panel)this.panel, 10, new Insets(10, 0, 0, 0));
            this.colors = gd.getNumericFields();
            for (int i = 0; i < this.colors.size(); ++i) {
                ((TextField)this.colors.elementAt(i)).addTextListener(this);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            int red = (int)gd.getNextNumber();
            int green = (int)gd.getNextNumber();
            int blue = (int)gd.getNextNumber();
            return new Color(red, green, blue);
        }

        public void textValueChanged(TextEvent e) {
            int red = this.getColorValue(0);
            int green = this.getColorValue(1);
            int blue = this.getColorValue(2);
            this.panel.setColor(new Color(red, green, blue));
            this.panel.repaint();
        }

        private int getColorValue(int index) {
            int color = (int)Tools.parseDouble((String)((TextField)this.colors.get(index)).getText());
            if (color < 0) {
                color = 0;
            }
            if (color > 255) {
                color = 255;
            }
            return color;
        }

        private String makeLabel(String baseLabel) {
            return "Series_" + this.series + "_Channel_" + this.channel + "_" + baseLabel;
        }
    }
}

