/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import ij.gui.GenericDialog;
import loci.common.Location;
import loci.formats.FilePattern;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;

public class FilePatternDialog
extends OptionsDialog {
    protected ImporterOptions options;

    public FilePatternDialog(ImporterOptions options) {
        super(options);
        this.options = options;
    }

    public int showDialog() {
        if (this.options.isWindowless()) {
            return 0;
        }
        Location idLoc = new Location(this.options.getId());
        String id = FilePattern.findPattern(idLoc);
        if (id == null && !this.options.isQuiet()) {
            IJ.showMessage((String)"Bio-Formats", (String)"Warning: Bio-Formats was unable to determine a grouping that\nincludes the file you chose. The most common reason for this\nsituation is that the folder contains extraneous files with similar\nnames and numbers that confuse the detection algorithm.\n \nFor example, if you have multiple datasets in the same folder\nnamed series1_z*_c*.tif, series2_z*_c*.tif, etc., Bio-Formats\nmay try to group all such files into a single series.\n \nFor best results, put each image series's files in their own folder,\nor type in a file pattern manually.\n");
            id = idLoc.getAbsolutePath();
        }
        GenericDialog gd = new GenericDialog("Bio-Formats File Stitching");
        int len = id.length() + 1;
        if (len > 80) {
            len = 80;
        }
        gd.addStringField("Pattern: ", id, len);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        id = gd.getNextString();
        this.options.setId(id);
        return 0;
    }
}

