/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import loci.common.Location;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;

public class IdDialog
extends OptionsDialog {
    protected ImporterOptions options;

    public IdDialog(ImporterOptions options) {
        super(options);
        this.options = options;
    }

    public int showDialogLocal() {
        Location idLoc;
        String id;
        String osVersion;
        if (this.options.isFirstTime() && IJ.isMacOSX() && !this.options.isQuiet() && ((osVersion = System.getProperty("os.version")) == null || osVersion.startsWith("10.4.") || osVersion.startsWith("10.3.") || osVersion.startsWith("10.2."))) {
            IJ.showMessage((String)"Bio-Formats", (String)"One-time warning: There is a bug in Java on Mac OS X with the native file chooser\nthat crashes ImageJ if you click on a file in CXD, IPW, OIB or ZVI format while in\ncolumn view mode. You can work around the problem in one of two ways:\n \n    1. Switch to list view (press Command+2)\n    2. Check \"Use JFileChooser to Open/Save\" under Edit>Options>Input/Output...");
        }
        if ((id = this.options.getId()) == null) {
            String idLabel = this.options.getLabel("id");
            OpenDialog od = new OpenDialog(idLabel, id);
            String dir = od.getDirectory();
            String name = od.getFileName();
            if (dir == null || name == null) {
                return 1;
            }
            id = dir + name;
        }
        Location location = idLoc = id == null ? null : new Location(id);
        if (idLoc == null) {
            if (!this.options.isQuiet()) {
                IJ.error((String)"Bio-Formats", (String)"No file was specified.");
            }
            return 2;
        }
        if (!idLoc.exists() && !id.toLowerCase().endsWith(".fake")) {
            if (!this.options.isQuiet()) {
                IJ.error((String)"Bio-Formats", (String)("The specified file (" + id + ") does not exist."));
            }
            return 2;
        }
        this.options.setId(id);
        return 0;
    }

    public int showDialogHTTP() {
        String id = this.options.getId();
        if (id == null) {
            GenericDialog gd = new GenericDialog("Bio-Formats URL");
            gd.addStringField("URL: ", "http://", 30);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return 1;
            }
            id = gd.getNextString();
        }
        if (id == null) {
            if (!this.options.isQuiet()) {
                IJ.error((String)"Bio-Formats", (String)"No URL was specified.");
            }
            return 2;
        }
        this.options.setId(id);
        return 0;
    }

    public int showDialogOME() {
        String id = this.options.getId();
        if (id == null) {
            IJ.runPlugIn((String)"loci.plugins.ome.OMEPlugin", (String)"");
            return 2;
        }
        return 0;
    }

    public int showDialog() {
        if (this.options.isLocal()) {
            return this.showDialogLocal();
        }
        if (this.options.isHTTP()) {
            return this.showDialogHTTP();
        }
        return this.showDialogOME();
    }
}

