/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.importer;

import ij.gui.GenericDialog;
import loci.plugins.importer.ImporterOptions;
import loci.plugins.prefs.OptionsDialog;

public class MergeDialog
extends OptionsDialog {
    protected ImporterOptions options;
    protected int[] nums;

    public MergeDialog(ImporterOptions options, int[] nums) {
        super(options);
        this.options = options;
        this.nums = nums;
    }

    public int showDialog() {
        if (this.options.isWindowless()) {
            return 0;
        }
        GenericDialog gd = new GenericDialog("Merging Options...");
        String mergeOptionLabel = this.options.getLabel("mergeOption");
        String mergeOptionDefault = this.options.getDefaultValue("mergeOption");
        String[] mergeOptions = new String[7];
        mergeOptions[6] = mergeOptionDefault;
        for (int i = 0; i < 6; ++i) {
            mergeOptions[i] = this.nums[i] + " planes, " + (i + 2) + " channels per plane";
        }
        gd.addMessage("How would you like to merge this data?");
        gd.addChoice(mergeOptionLabel, mergeOptions, mergeOptionDefault);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 1;
        }
        this.options.setMergeOption(mergeOptions[gd.getNextChoiceIndex()]);
        return 0;
    }
}

