/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.IJ;
import java.util.HashSet;
import java.util.Iterator;

public final class LibraryChecker {
    public static final String IMAGEJ_VERSION = "1.40";
    public static final String IMAGEJ_MSG = "Sorry, the LOCI plugins require ImageJ v1.40 or later.";

    private LibraryChecker() {
    }

    public static boolean checkClass(String className) {
        try {
            Class.forName(className);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void checkLibrary(Library library, HashSet missing) {
        switch (library) {
            case BIO_FORMATS: {
                LibraryChecker.checkLibrary("loci.common.RandomAccessInputStream", "loci-common.jar", missing);
                LibraryChecker.checkLibrary("loci.formats.FormatHandler", "bio-formats.jar", missing);
                LibraryChecker.checkLibrary("loci.poi.poifs.filesystem.POIFSDocument", "poi-loci.jar", missing);
                LibraryChecker.checkLibrary("mdbtools.libmdb.MdbFile", "mdbtools-java.jar", missing);
                break;
            }
            case OME_JAVA_XML: {
                LibraryChecker.checkLibrary("ome.xml.OMEXMLNode", "ome-xml.jar", missing);
                break;
            }
            case OME_JAVA_DS: {
                LibraryChecker.checkLibrary("org.openmicroscopy.ds.DataServer", "ome-java.jar", missing);
                LibraryChecker.checkLibrary("org.apache.xmlrpc.XmlRpcClient", "xmlrpc-1.2-b1.jar", missing);
                LibraryChecker.checkLibrary("org.apache.commons.httpclient.HttpClient", "commons-httpclient-2.0-rc2.jar", missing);
                LibraryChecker.checkLibrary("org.apache.commons.logging.Log", "commons-logging.jar", missing);
                break;
            }
            case FORMS: {
                LibraryChecker.checkLibrary("com.jgoodies.forms.layout.FormLayout", "forms-1.0.4.jar", missing);
            }
        }
    }

    public static void checkLibrary(String className, String jarFile, HashSet missing) {
        if (!LibraryChecker.checkClass(className)) {
            missing.add(jarFile);
        }
    }

    public static boolean checkJava() {
        String version = System.getProperty("java.version");
        double ver = Double.parseDouble(version.substring(0, 3));
        if (ver < 1.4) {
            IJ.error((String)"LOCI Plugins", (String)"Sorry, the LOCI plugins require Java 1.4 or later.\nYou can download ImageJ with JRE 5.0 from the ImageJ web site.");
            return false;
        }
        return true;
    }

    public static boolean checkImageJ() {
        return LibraryChecker.checkImageJ(IMAGEJ_VERSION, IMAGEJ_MSG);
    }

    public static boolean checkImageJ(String target, String msg) {
        return LibraryChecker.checkImageJ(target, msg, "LOCI Plugins");
    }

    public static boolean checkImageJ(String target, String msg, String title) {
        boolean success;
        try {
            String current = IJ.getVersion();
            success = current != null && current.compareTo(target) >= 0;
        }
        catch (NoSuchMethodError err) {
            success = false;
        }
        if (!success) {
            IJ.error((String)title, (String)msg);
        }
        return success;
    }

    public static boolean checkMissing(HashSet missing) {
        int num = missing.size();
        if (num == 0) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("The following librar");
        sb.append(num == 1 ? "y was" : "ies were");
        sb.append(" not found:");
        Iterator iter = missing.iterator();
        for (int i = 0; i < num; ++i) {
            sb.append("\n    " + iter.next());
        }
        String them = num == 1 ? "it" : "them";
        sb.append("\nPlease download ");
        sb.append(them);
        sb.append(" from the LOCI website at");
        sb.append("\n    http://www.loci.wisc.edu/software/");
        sb.append("\nand place ");
        sb.append(them);
        sb.append(" in the ImageJ plugins folder.");
        IJ.error((String)"LOCI Plugins", (String)sb.toString());
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Library {
        BIO_FORMATS,
        OME_JAVA_XML,
        OME_JAVA_DS,
        FORMS;

    }
}

