/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.frame.RoiManager;
import java.awt.Color;
import java.awt.Rectangle;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

public class ROIHandler {
    public static void openROIs(MetadataRetrieve retrieve, ImagePlus[] images) {
        int nextRoi = 0;
        RoiManager manager = RoiManager.getInstance();
        int imageCount = retrieve.getImageCount();
        for (int image = 0; image < imageCount; ++image) {
            int roiCount = retrieve.getROICount(image);
            if (roiCount > 0 && manager == null) {
                manager = new RoiManager();
            }
            for (int roiNum = 0; roiNum < roiCount; ++roiNum) {
                int shapeCount = retrieve.getShapeCount(image, roiNum);
                for (int shape = 0; shape < shapeCount; ++shape) {
                    String circle = retrieve.getCircleCx(image, roiNum, shape);
                    String ellipse = retrieve.getEllipseCx(image, roiNum, shape);
                    String line = retrieve.getLineX1(image, roiNum, shape);
                    String point = retrieve.getPointCx(image, roiNum, shape);
                    String polygon = retrieve.getPolygonPoints(image, roiNum, shape);
                    String polyline = retrieve.getPolylinePoints(image, roiNum, shape);
                    String rectangle = retrieve.getRectX(image, roiNum, shape);
                    OvalRoi roi = null;
                    if (circle != null) {
                        int cx = (int)Double.parseDouble(retrieve.getCircleCx(image, roiNum, shape));
                        int cy = (int)Double.parseDouble(retrieve.getCircleCy(image, roiNum, shape));
                        int r = (int)Double.parseDouble(retrieve.getCircleR(image, roiNum, shape));
                        roi = new OvalRoi(cx - r, cy - r, r * 2, r * 2);
                    } else if (ellipse != null) {
                        int cx = (int)Double.parseDouble(retrieve.getEllipseCx(image, roiNum, shape));
                        int cy = (int)Double.parseDouble(retrieve.getEllipseCy(image, roiNum, shape));
                        int rx = (int)Double.parseDouble(retrieve.getEllipseRx(image, roiNum, shape));
                        int ry = (int)Double.parseDouble(retrieve.getEllipseRy(image, roiNum, shape));
                        roi = new OvalRoi(cx - rx, cy - ry, rx * 2, ry * 2);
                    } else if (line != null) {
                        int x1 = (int)Double.parseDouble(retrieve.getLineX1(image, roiNum, shape));
                        int x2 = (int)Double.parseDouble(retrieve.getLineX2(image, roiNum, shape));
                        int y1 = (int)Double.parseDouble(retrieve.getLineY1(image, roiNum, shape));
                        int y2 = (int)Double.parseDouble(retrieve.getLineY2(image, roiNum, shape));
                        roi = new Line(x1, y1, x2, y2);
                    } else if (point != null) {
                        int x = (int)Double.parseDouble(retrieve.getPointCx(image, roiNum, shape));
                        int y = (int)Double.parseDouble(retrieve.getPointCy(image, roiNum, shape));
                        roi = new OvalRoi(x, y, 0, 0);
                    } else if (polygon != null) {
                        String points = retrieve.getPolygonPoints(image, roiNum, shape);
                        int[][] coordinates = ROIHandler.parsePoints(points);
                        roi = new PolygonRoi(coordinates[0], coordinates[1], coordinates[0].length, 2);
                    } else if (polyline != null) {
                        String points = retrieve.getPolylinePoints(image, roiNum, shape);
                        int[][] coordinates = ROIHandler.parsePoints(points);
                        roi = new PolygonRoi(coordinates[0], coordinates[1], coordinates[0].length, 6);
                    } else if (rectangle != null) {
                        int x = (int)Double.parseDouble(retrieve.getRectX(image, roiNum, shape));
                        int y = (int)Double.parseDouble(retrieve.getRectY(image, roiNum, shape));
                        int w = (int)Double.parseDouble(retrieve.getRectWidth(image, roiNum, shape));
                        int h = (int)Double.parseDouble(retrieve.getRectHeight(image, roiNum, shape));
                        roi = new Roi(x, y, w, h);
                    }
                    if (roi == null) continue;
                    Roi.setColor((Color)Color.WHITE);
                    roi.setImage(images[image]);
                    manager.add(images[image], roi, nextRoi++);
                }
            }
        }
    }

    public static void saveROIs(MetadataStore store, int imageIndex) {
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return;
        }
        Roi[] rois = manager.getRoisAsArray();
        for (int i = 0; i < rois.length; ++i) {
            if (rois[i] instanceof Line) {
                ROIHandler.storeLine((Line)rois[i], store, imageIndex, i, 0);
                continue;
            }
            if (rois[i] instanceof PolygonRoi) {
                ROIHandler.storePolygon((PolygonRoi)rois[i], store, imageIndex, i, 0);
                continue;
            }
            if (rois[i] instanceof ShapeRoi) {
                Roi[] subRois = ((ShapeRoi)rois[i]).getRois();
                for (int q = 0; q < subRois.length; ++q) {
                    if (subRois[q] instanceof Line) {
                        ROIHandler.storeLine((Line)subRois[q], store, imageIndex, i, q);
                        continue;
                    }
                    if (subRois[q] instanceof PolygonRoi) {
                        ROIHandler.storePolygon((PolygonRoi)subRois[q], store, imageIndex, i, q);
                        continue;
                    }
                    if (subRois[q] instanceof OvalRoi) {
                        ROIHandler.storeOval((OvalRoi)subRois[q], store, imageIndex, i, q);
                        continue;
                    }
                    ROIHandler.storeRectangle(subRois[q], store, imageIndex, i, q);
                }
                continue;
            }
            if (rois[i] instanceof OvalRoi) {
                ROIHandler.storeOval((OvalRoi)rois[i], store, imageIndex, i, 0);
                continue;
            }
            ROIHandler.storeRectangle(rois[i], store, imageIndex, i, 0);
        }
    }

    private static void storeLine(Line roi, MetadataStore store, int image, int roiNum, int shape) {
        store.setLineX1(String.valueOf(roi.x1), image, roiNum, shape);
        store.setLineX2(String.valueOf(roi.x2), image, roiNum, shape);
        store.setLineY1(String.valueOf(roi.y1), image, roiNum, shape);
        store.setLineY2(String.valueOf(roi.y2), image, roiNum, shape);
    }

    private static void storeRectangle(Roi roi, MetadataStore store, int image, int roiNum, int shape) {
        Rectangle bounds = roi.getBounds();
        store.setRectX(String.valueOf(bounds.x), image, roiNum, shape);
        store.setRectY(String.valueOf(bounds.y), image, roiNum, shape);
        store.setRectWidth(String.valueOf(bounds.width), image, roiNum, shape);
        store.setRectHeight(String.valueOf(bounds.height), image, roiNum, shape);
    }

    private static void storePolygon(PolygonRoi roi, MetadataStore store, int image, int roiNum, int shape) {
        Rectangle bounds = roi.getBounds();
        int[] xCoordinates = roi.getXCoordinates();
        int[] yCoordinates = roi.getYCoordinates();
        StringBuffer points = new StringBuffer();
        for (int i = 0; i < xCoordinates.length; ++i) {
            points.append(xCoordinates[i] + bounds.x);
            points.append(",");
            points.append(yCoordinates[i] + bounds.y);
            if (i >= xCoordinates.length - 1) continue;
            points.append(" ");
        }
        store.setPolygonPoints(points.toString(), image, roiNum, shape);
    }

    private static void storeOval(OvalRoi roi, MetadataStore store, int image, int roiNum, int shape) {
    }

    private static int[][] parsePoints(String points) {
        String[] pointList = points.split(" ");
        int[][] coordinates = new int[2][pointList.length];
        for (int q = 0; q < pointList.length; ++q) {
            pointList[q] = pointList[q].trim();
            int delim = pointList[q].indexOf(",");
            coordinates[0][q] = (int)Double.parseDouble(pointList[q].substring(0, delim));
            coordinates[1][q] = (int)Double.parseDouble(pointList[q].substring(delim + 1));
        }
        return coordinates;
    }
}

