/*
 * Decompiled with CFR 0.152.
 */
package ome.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import ome.xml.CustomNode;
import ome.xml.DOMUtil;
import org.w3c.dom.Element;

public abstract class OMEXMLNode {
    protected static final String[] NODE_PACKAGES = new String[]{".ome", ".spw", ".st", ""};
    protected static final String LEGACY_VERSION = "2003-FC";
    protected static Hashtable nextIds = new Hashtable();
    protected static String idPrefix = "openmicroscopy.org";
    protected static Hashtable nodeHash = new Hashtable();
    protected static Hashtable classHash = new Hashtable();
    protected static Hashtable constructorHash = new Hashtable();
    protected Element element;
    protected String basePackage;

    public OMEXMLNode(Element element) {
        String className;
        int dot;
        this.element = element;
        if (this.hasID() && this.getNodeID() == null) {
            this.setNodeID(this.makeID(this.getElementName()));
        }
        if ((dot = (className = this.getClass().getName()).lastIndexOf(".")) < 0) {
            dot = 0;
        }
        String pack = className.substring(0, dot);
        for (int i = 0; i < NODE_PACKAGES.length; ++i) {
            if (!pack.endsWith(NODE_PACKAGES[i])) continue;
            pack = pack.substring(0, pack.length() - NODE_PACKAGES[i].length());
            break;
        }
        this.basePackage = pack;
    }

    public static String getIDPrefix() {
        return idPrefix;
    }

    public static void setIDPrefix(String prefix) {
        String regex = "(\\S+\\.\\S+)+";
        if (!prefix.matches(regex)) {
            throw new IllegalArgumentException("Prefix does not match regular expression: " + regex);
        }
        idPrefix = prefix;
    }

    public static void clearCaches() {
        nextIds.clear();
        classHash.clear();
        nodeHash.clear();
        constructorHash.clear();
    }

    public Element getDOMElement() {
        return this.element;
    }

    public String getElementName() {
        return DOMUtil.getName(this.element);
    }

    public abstract boolean hasID();

    public String getNodeID() {
        return this.getAttribute("ID");
    }

    public void setNodeID(String id) {
        this.setAttribute("ID", id);
    }

    public String makeID(String nodeType) {
        Integer id = (Integer)nextIds.get(nodeType);
        int q = id == null ? 0 : id;
        nextIds.put(nodeType, new Integer(q + 1));
        String s = this.isLegacy() ? idPrefix + ":" + nodeType + ":" + q : nodeType + ":" + q;
        return s;
    }

    public String getCData() {
        return DOMUtil.getCharacterData(this.element);
    }

    public void setCData(String value) {
        DOMUtil.setCharacterData(value, this.element);
    }

    public boolean isLegacy() {
        return this.getVersion().equals(LEGACY_VERSION);
    }

    public String getVersion() {
        String numbers;
        int dot;
        String name = this.getClass().getName();
        if (name.startsWith("org.openmicroscopy.xml.")) {
            return LEGACY_VERSION;
        }
        String prefix = "ome.xml.r";
        if (name.startsWith(prefix) && (dot = name.indexOf(".", prefix.length())) >= 0 && (numbers = name.substring(prefix.length(), dot)).length() == 6) {
            return numbers.substring(0, 4) + "-" + numbers.substring(4, 6).toUpperCase();
        }
        return null;
    }

    protected int getChildCount(String name) {
        return this.getSize(DOMUtil.getChildElements(name, this.element));
    }

    public OMEXMLNode getChildNode(String name) {
        return this.getNode(DOMUtil.getChildElement(name, this.element));
    }

    protected OMEXMLNode getChildNode(String nodeType, String name) {
        return this.createNode(nodeType, DOMUtil.getChildElement(name, this.element));
    }

    public Vector getChildNodes(String name) {
        return this.getNodes(DOMUtil.getChildElements(name, this.element));
    }

    protected OMEXMLNode getChildNode(String name, int index) {
        return this.getNode(DOMUtil.getChildElement(name, this.element, index));
    }

    protected OMEXMLNode getAncestorNode(String name) {
        return this.getNode(this.getAncestorElement(name));
    }

    protected OMEXMLNode getReferencedNode(String nodeType, String refName) {
        Element ref = this.getChildElement(refName);
        if (ref == null) {
            return null;
        }
        Element el = this.findElement(nodeType, DOMUtil.getAttribute("ID", ref));
        return this.getNode(el);
    }

    protected Vector getReferencedNodes(String nodeType, String refName) {
        Vector refs = this.getChildElements(refName);
        if (refs == null) {
            return null;
        }
        Vector<Element> els = new Vector<Element>();
        for (int i = 0; i < refs.size(); ++i) {
            Element ref = (Element)refs.get(i);
            Element el = this.findElement(nodeType, DOMUtil.getAttribute("ID", ref));
            els.add(el);
        }
        return this.getNodes(els);
    }

    protected OMEXMLNode getAttrReferencedNode(String nodeType, String attrName) {
        Element el = this.findElement(nodeType, this.getAttribute(attrName));
        return this.getNode(el);
    }

    protected void setAttrReferencedNode(OMEXMLNode node2, String attrName) {
        if (node2 == null || attrName == null) {
            return;
        }
        String id = DOMUtil.getAttribute("ID", node2.getDOMElement());
        if (id != null) {
            this.setAttribute(attrName, id);
        }
    }

    protected int getReferringCount(String name) {
        return this.getReferringCount(name, this.getElementName() + "Ref");
    }

    protected int getReferringCount(String name, String refName) {
        return this.getSize(this.findReferringElements(name, refName, this.getNodeID()));
    }

    protected Vector getReferringNodes(String name) {
        return this.getReferringNodes(name, this.getElementName() + "Ref");
    }

    protected Vector getReferringNodes(String name, String refName) {
        return this.getNodes(this.findReferringElements(name, refName, this.getNodeID()));
    }

    protected int getAttrReferringCount(String name, String attrName) {
        return this.getSize(DOMUtil.findElementList(name, attrName, this.getNodeID(), this.element.getOwnerDocument()));
    }

    protected Vector getAttrReferringNodes(String name, String attrName) {
        return this.getNodes(DOMUtil.findElementList(name, attrName, this.getNodeID(), this.element.getOwnerDocument()));
    }

    protected void createReference(OMEXMLNode node2) {
        Element ref = DOMUtil.createChild(this.element, node2.getElementName() + "Ref");
        DOMUtil.setAttribute("ID", node2.getNodeID(), ref);
    }

    protected String getCData(String name) {
        return DOMUtil.getCharacterData(this.getChildElement(name));
    }

    protected String getStringCData(String name) {
        return this.getCData(name);
    }

    protected void setCData(String name, String value) {
        DOMUtil.setCharacterData(value, this.getChildElement(name, true));
    }

    protected void setCData(String name, Object value) {
        DOMUtil.setCharacterData(value, this.getChildElement(name, true));
    }

    protected Boolean getBooleanCData(String name) {
        return DOMUtil.getBooleanCharacterData(this.getChildElement(name));
    }

    protected Double getDoubleCData(String name) {
        return DOMUtil.getDoubleCharacterData(this.getChildElement(name));
    }

    protected Float getFloatCData(String name) {
        return DOMUtil.getFloatCharacterData(this.getChildElement(name));
    }

    protected Integer getIntegerCData(String name) {
        return DOMUtil.getIntegerCharacterData(this.getChildElement(name));
    }

    protected Long getLongCData(String name) {
        return DOMUtil.getLongCharacterData(this.getChildElement(name));
    }

    protected String[] getAttributeNames() {
        return DOMUtil.getAttributeNames(this.element);
    }

    protected String[] getAttributeValues() {
        return DOMUtil.getAttributeValues(this.element);
    }

    public void setAttribute(String name, String value) {
        DOMUtil.setAttribute(name, value, this.element);
    }

    protected void setAttribute(String name, Object value) {
        DOMUtil.setAttribute(name, value, this.element);
    }

    public String getAttribute(String name) {
        return DOMUtil.getAttribute(name, this.element);
    }

    protected Boolean getBooleanAttribute(String name) {
        return DOMUtil.getBooleanAttribute(name, this.element);
    }

    protected Double getDoubleAttribute(String name) {
        return DOMUtil.getDoubleAttribute(name, this.element);
    }

    protected Float getFloatAttribute(String name) {
        return DOMUtil.getFloatAttribute(name, this.element);
    }

    protected Integer getIntegerAttribute(String name) {
        return DOMUtil.getIntegerAttribute(name, this.element);
    }

    protected Long getLongAttribute(String name) {
        return DOMUtil.getLongAttribute(name, this.element);
    }

    protected String getStringAttribute(String name) {
        return DOMUtil.getAttribute(name, this.element);
    }

    protected OMEXMLNode getNode(Element el) {
        if (el == null) {
            return null;
        }
        OMEXMLNode node2 = (OMEXMLNode)nodeHash.get(el);
        if (node2 == null) {
            node2 = this.createNode(DOMUtil.getName(el), el);
            nodeHash.put(el, node2);
        }
        return node2;
    }

    private OMEXMLNode createNode(String nodeType, Element el) {
        if (nodeType == null || el == null) {
            return null;
        }
        Class c = this.getClass(nodeType);
        if (c == null) {
            return new CustomNode(el);
        }
        return this.createNode(c, el);
    }

    private OMEXMLNode createNode(Class nodeType, Element el) {
        if (nodeType == null || el == null) {
            return null;
        }
        try {
            Constructor con = (Constructor)constructorHash.get(nodeType);
            if (con == null) {
                con = nodeType.getConstructor(Element.class);
                constructorHash.put(nodeType, con);
            }
            return (OMEXMLNode)con.newInstance(el);
        }
        catch (IllegalAccessException exc) {
        }
        catch (InstantiationException exc) {
        }
        catch (InvocationTargetException exc) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private Vector getNodes(Vector els) {
        if (els == null) {
            return null;
        }
        int size = els.size();
        Vector<OMEXMLNode> nodes = new Vector<OMEXMLNode>(size);
        for (int i = 0; i < size; ++i) {
            Object o = els.elementAt(i);
            OMEXMLNode node2 = null;
            if (o instanceof Element) {
                Element el = (Element)o;
                node2 = this.getNode(el);
            }
            nodes.add(node2);
        }
        return nodes;
    }

    private Element getChildElement(String name) {
        return this.getChildElement(name, false);
    }

    private Element getChildElement(String name, boolean create) {
        Element el = DOMUtil.getChildElement(name, this.element);
        if (el == null && create) {
            el = DOMUtil.createChild(this.element, name);
        }
        return el;
    }

    private Vector getChildElements(String name) {
        return DOMUtil.getChildElements(name, this.element);
    }

    protected Element getAncestorElement(String name) {
        return DOMUtil.getAncestorElement(name, this.element);
    }

    private Element findElement(String name, String id) {
        if (name == null || id == null) {
            return null;
        }
        return DOMUtil.findElement(name, "ID", id, this.element.getOwnerDocument());
    }

    private Vector findReferringElements(String name, String refName, String id) {
        if (name == null || refName == null || id == null) {
            return null;
        }
        Vector possible = DOMUtil.findElementList(name, this.element.getOwnerDocument());
        if (possible == null) {
            return null;
        }
        Vector<Element> v = new Vector<Element>();
        int psize = possible.size();
        for (int i = 0; i < psize; ++i) {
            Element el = (Element)possible.elementAt(i);
            Vector refs = DOMUtil.getChildElements(refName, el);
            int rsize = refs.size();
            boolean match = false;
            for (int j = 0; j < rsize; ++j) {
                Element ref = (Element)refs.elementAt(j);
                if (!id.equals(DOMUtil.getAttribute("ID", ref))) continue;
                match = true;
                break;
            }
            if (!match) continue;
            v.add(el);
        }
        return v;
    }

    private Class getClass(String nodeName) {
        String hashName = this.basePackage + ":" + nodeName;
        Class<?> c = (Class<?>)classHash.get(hashName);
        if (c != null) {
            return c;
        }
        for (int i = 0; i < NODE_PACKAGES.length; ++i) {
            String subPack = this.basePackage + NODE_PACKAGES[i];
            String name = subPack + "." + nodeName + "Node";
            try {
                c = Class.forName(name);
                classHash.put(hashName, c);
                return c;
            }
            catch (ClassNotFoundException exc) {
                continue;
            }
            catch (NoClassDefFoundError err) {
                continue;
            }
            catch (RuntimeException exc) {
                String msg = exc.getMessage();
                if (msg == null || msg.indexOf("ClassNotFound") >= 0) continue;
                throw exc;
            }
        }
        return null;
    }

    private int getSize(Vector v) {
        return v == null ? 0 : v.size();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.element.equals(((OMEXMLNode)obj).element);
    }

    public String toString() {
        return this.element.toString();
    }

    public Vector getChildNodes() {
        return this.getNodes(DOMUtil.getChildElements(null, this.element));
    }
}

