/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import ucar.bufr.BufrData;
import ucar.bufr.BufrDataDescriptionSection;
import ucar.bufr.BufrDataSection;
import ucar.bufr.Descriptor;

final class TimeObservation {
    private boolean toExists = false;
    private ArrayList tdorder;
    private HashMap tbufrdatas;

    public TimeObservation(BufrDataDescriptionSection dds, BufrDataSection ds) {
        float[] second;
        ArrayList dorder = ds.getDorder();
        HashMap bufrdatas = ds.getBufrDatas();
        BufrData dyear = (BufrData)bufrdatas.get("0-4-1");
        if (dyear == null) {
            return;
        }
        BufrData dmonth = (BufrData)bufrdatas.get("0-4-2");
        if (dmonth == null) {
            return;
        }
        BufrData dday = (BufrData)bufrdatas.get("0-4-3");
        if (dday == null) {
            return;
        }
        BufrData dhour = (BufrData)bufrdatas.get("0-4-4");
        if (dhour == null) {
            return;
        }
        BufrData dminute = (BufrData)bufrdatas.get("0-4-5");
        if (dminute == null) {
            return;
        }
        BufrData dsecond = (BufrData)bufrdatas.get("0-4-6");
        float[] year = dyear.getFloatData();
        float[] month = dmonth.getFloatData();
        float[] day = dday.getFloatData();
        float[] hour = dhour.getFloatData();
        float[] minute = dminute.getFloatData();
        if (dsecond != null) {
            second = dsecond.getFloatData();
        } else {
            second = new float[minute.length];
            Arrays.fill(second, 0.0f);
        }
        this.toExists = true;
        Descriptor des = (Descriptor)BufrDataSection.tableB.get("0-4-250");
        des.setUnits("seconds since 1970-01-01");
        BufrData bd = new BufrData(des);
        bd.setAllocationLong(dds.getNumberDataSets());
        for (int i = 0; i < dds.getNumberDataSets(); ++i) {
            GregorianCalendar cal = new GregorianCalendar((int)year[i], (int)month[i] - 1, (int)day[i], (int)hour[i], (int)minute[i], (int)second[i]);
            cal.set(15, 0);
            cal.set(16, 0);
            long time = cal.getTimeInMillis();
            time = (long)((double)time * 0.001);
            bd.setValue(time);
        }
        bufrdatas.remove("0-4-1");
        bufrdatas.remove("0-4-2");
        bufrdatas.remove("0-4-3");
        bufrdatas.remove("0-4-4");
        bufrdatas.remove("0-4-5");
        bufrdatas.remove("0-4-6");
        bufrdatas.remove("0-0-7");
        bufrdatas.put("0-4-250", bd);
        dorder.remove(dorder.indexOf("0-4-1"));
        dorder.remove(dorder.indexOf("0-4-2"));
        dorder.remove(dorder.indexOf("0-4-3"));
        dorder.remove(dorder.indexOf("0-4-4"));
        dorder.remove(dorder.indexOf("0-4-5"));
        if (dorder.indexOf("0-4-6") > -1) {
            dorder.remove(dorder.indexOf("0-4-6"));
        }
        if (dorder.indexOf("0-0-7") > -1) {
            dorder.remove(dorder.indexOf("0-0-7"));
        }
        dorder.add(0, "0-4-250");
        this.tdorder = dorder;
        this.tbufrdatas = bufrdatas;
    }

    public final ArrayList getDorder() {
        return this.tdorder;
    }

    public final HashMap getBufrDatas() {
        return this.tbufrdatas;
    }
}

