/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Enumeration;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    protected NetcdfFile ncfile;
    protected Group parent;
    protected String name;
    protected String shortName;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Group> groups = new ArrayList<Group>();
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected List<Enumeration> enums = new ArrayList<Enumeration>();
    private boolean immutable = false;
    private volatile int hashCode = 0;

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public Group getParentGroup() {
        return this.parent;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable findVariable(String shortName) {
        if (shortName == null) {
            return null;
        }
        for (Variable v : this.variables) {
            if (!shortName.equals(v.getShortName())) continue;
            return v;
        }
        return null;
    }

    public Variable findVariableRecurse(String shortName) {
        if (shortName == null) {
            return null;
        }
        Variable v = this.findVariable(shortName);
        if (v == null && this.parent != null) {
            v = this.parent.findVariableRecurse(shortName);
        }
        return v;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Group findGroup(String shortName) {
        if (shortName == null) {
            return null;
        }
        for (Group group : this.groups) {
            if (!shortName.equals(group.getShortName())) continue;
            return group;
        }
        return null;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Dimension findDimension(String name) {
        Dimension d = this.findDimensionLocal(name);
        if (d != null) {
            return d;
        }
        if (this.parent != null) {
            return this.parent.findDimension(name);
        }
        return null;
    }

    public Dimension findDimensionLocal(String name) {
        for (Dimension d : this.dimensions) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute findAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public String getNameAndAttributes() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Group ");
        sbuff.append(this.getShortName());
        sbuff.append("\n");
        for (Attribute att : this.attributes) {
            sbuff.append("  ").append(this.getShortName()).append(":");
            sbuff.append(att.toString());
            sbuff.append(";");
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    protected void toString(PrintStream out, String indent) {
        this.writeCDL(out, indent, false);
    }

    protected void writeCDL(PrintStream out, String indent, boolean strict) {
        boolean hasA;
        boolean hasE = this.enums.size() > 0;
        boolean hasD = this.dimensions.size() > 0;
        boolean hasV = this.variables.size() > 0;
        boolean hasG = this.groups.size() > 0;
        boolean bl = hasA = this.attributes.size() > 0;
        if (hasE) {
            out.print(indent + " enums:\n");
        }
        for (Enumeration e : this.enums) {
            out.print(indent + e.writeCDL(strict));
            out.print(indent + "\n");
        }
        if (hasD) {
            out.print(indent + " dimensions:\n");
        }
        for (Dimension myd : this.dimensions) {
            out.print(indent + myd.writeCDL(strict));
            out.print(indent + "\n");
        }
        if (hasV) {
            out.print(indent + " variables:\n");
        }
        for (Variable v : this.variables) {
            out.print(v.writeCDL(indent + "   ", false, strict));
        }
        for (Group g : this.groups) {
            out.print("\n " + indent + "Group " + g.getShortName() + " {\n");
            g.toString(out, indent + "  ");
            out.print(indent + " }\n");
        }
        if (hasA && (hasE || hasD || hasV || hasG)) {
            out.print("\n");
        }
        if (hasA && strict) {
            out.print(indent + " // global attributes:\n");
        }
        for (Attribute att : this.attributes) {
            out.print(indent + " " + this.getShortName() + ":");
            out.print(att.toString());
            out.print(";");
            if (!strict && att.getDataType() != DataType.STRING) {
                out.print(" // " + att.getDataType());
            }
            out.print("\n");
        }
    }

    public Group(NetcdfFile ncfile, Group parent, String shortName) {
        this.ncfile = ncfile;
        this.parent = parent == null ? ncfile.getRootGroup() : parent;
        this.shortName = NetcdfFile.createValidNetcdfObjectName(shortName);
        this.name = parent == null ? shortName : parent.getName() + "/" + shortName;
    }

    public void setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.name = name;
    }

    public void addAttribute(Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!att.getName().equals(a.getName())) continue;
            this.attributes.set(i, att);
            return;
        }
        this.attributes.add(att);
    }

    public void addDimension(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findDimensionLocal(d.getName()) != null) {
            throw new IllegalArgumentException("Variable name (" + d.getName() + ") must be unique within Group " + this.getName());
        }
        this.dimensions.add(d);
        d.setGroup(this);
    }

    public void addGroup(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findGroup(g.getName()) != null) {
            throw new IllegalArgumentException("Variable name (" + g.getName() + ") must be unique within Group " + this.getName());
        }
        this.groups.add(g);
        g.parent = this;
    }

    public void addEnumeration(Enumeration e) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (e == null) {
            return;
        }
        this.enums.add(e);
    }

    public void addVariable(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (v == null) {
            return;
        }
        if (this.findVariable(v.getShortName()) != null) {
            throw new IllegalArgumentException("Variable name (" + v.getShortName() + ") must be unique within Group " + this.getName());
        }
        this.variables.add(v);
        v.setParentGroup(this);
    }

    public boolean remove(Attribute a) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return a != null && this.attributes.remove(a);
    }

    public boolean remove(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return d != null && this.dimensions.remove(d);
    }

    public boolean remove(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return g != null && this.groups.remove(g);
    }

    public boolean remove(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return v != null && this.variables.remove(v);
    }

    public boolean removeDimension(String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!dimName.equals(d.getName())) continue;
            this.dimensions.remove(d);
            return true;
        }
        return false;
    }

    public boolean removeVariable(String varName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = this.variables.get(i);
            if (!varName.equals(v.getShortName())) continue;
            this.variables.remove(v);
            return true;
        }
        return false;
    }

    public Group setImmutable() {
        this.immutable = true;
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.groups = Collections.unmodifiableList(this.groups);
        this.attributes = Collections.unmodifiableList(this.attributes);
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Group)) {
            return false;
        }
        Group og = (Group)oo;
        if (!this.getName().equals(og.getName())) {
            return false;
        }
        return this.getParentGroup() == null || this.getParentGroup().equals(og.getParentGroup());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            if (this.getParentGroup() != null) {
                result = 37 * result + this.getParentGroup().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

