/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.util.IO;

public class ODLparser {
    private static Logger log = LoggerFactory.getLogger(ODLparser.class);
    private Document doc;
    private boolean debug = true;

    void parseFile(String filename) throws IOException {
        String text = new String(IO.readFileToByteArray(filename));
        this.parseString(text);
    }

    Element parseString(String text) throws IOException {
        Element rootElem = new Element("odl");
        this.doc = new Document(rootElem);
        StringTokenizer stoke = new StringTokenizer(text, "= \t\n\r\f");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equals("GROUP")) {
                rootElem.addContent((Content)this.processGroup(stoke));
                continue;
            }
            if (toke.equals("END")) break;
            log.error("Not Group =" + toke);
        }
        if (this.debug) {
            this.showDoc();
        }
        return rootElem;
    }

    void showDoc() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        try {
            fmt.output(this.doc, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    Element processGroup(StringTokenizer stoke) {
        String name = stoke.nextToken();
        Element elem = new Element(name);
        if (this.debug) {
            System.out.println("Group " + name);
        }
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equals("GROUP")) {
                elem.addContent((Content)this.processGroup(stoke));
                continue;
            }
            if (toke.equals("END_GROUP")) {
                stoke.nextToken();
                return elem;
            }
            if (toke.equals("CLASS")) {
                elem.setAttribute("class", stoke.nextToken());
                continue;
            }
            if (toke.equals("OBJECT")) {
                elem.addContent((Content)this.processObject(stoke));
                continue;
            }
            if (toke.equals("GROUPTYPE")) {
                elem.setAttribute("type", stoke.nextToken());
                continue;
            }
            elem.addContent((Content)this.processContent(toke, stoke));
        }
        log.warn("No END_GROUP for " + name);
        return elem;
    }

    Element processObject(StringTokenizer stoke) {
        Element elem = new Element("object");
        String name = stoke.nextToken();
        elem.setAttribute("name", name);
        if (this.debug) {
            System.out.println("Object " + name);
        }
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equals("OBJECT")) {
                elem.addContent((Content)this.processObject(stoke));
                continue;
            }
            if (toke.equals("END_OBJECT")) {
                stoke.nextToken();
                return elem;
            }
            if (toke.equals("GROUP")) {
                elem.addContent((Content)this.processGroup(stoke));
                continue;
            }
            if (toke.equals("CLASS")) {
                elem.setAttribute("class", stoke.nextToken());
                continue;
            }
            if (toke.equals("NUM_VAL")) {
                elem.addContent((Content)new Element("num_val").addContent(stoke.nextToken()));
                continue;
            }
            if (toke.equals("VALUE")) {
                elem.addContent((Content)this.processValue(stoke));
                continue;
            }
            if (toke.equals("DataType")) continue;
            elem.addContent((Content)this.processContent(toke, stoke));
        }
        log.warn("No END_OBJECT for " + name);
        return elem;
    }

    Element processContent(String name, StringTokenizer stoke) {
        String toke;
        Element elem = new Element(name);
        if (this.debug) {
            System.out.println("content= " + name);
        }
        if ((toke = stoke.nextToken()).startsWith("\"")) {
            elem.addContent(this.processString(toke, stoke, "\""));
        } else if (toke.startsWith("(")) {
            String s = this.processString(toke, stoke, ")");
            this.processStrings(s, elem);
        } else {
            elem.addContent(this.stripQuotes(toke));
        }
        return elem;
    }

    Element processValue(StringTokenizer stoke) {
        Element elem = new Element("value");
        String toke = stoke.nextToken();
        if (toke.startsWith("\"")) {
            elem.addContent(this.processString(toke, stoke, "\""));
        } else if (toke.startsWith("(")) {
            String s = this.processString(toke, stoke, ")");
            this.processStrings(s, elem);
        } else {
            elem.addContent(this.stripQuotes(toke));
        }
        return elem;
    }

    String processString(String start, StringTokenizer stoke, String delim) {
        StringBuffer sbuff = new StringBuffer(start);
        sbuff.deleteCharAt(0);
        if (start.endsWith(delim)) {
            sbuff.deleteCharAt(sbuff.length() - 1);
            return sbuff.toString();
        }
        sbuff.append(" ");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            sbuff.append(toke);
            if (toke.endsWith(delim)) {
                sbuff.deleteCharAt(sbuff.length() - 1);
                return sbuff.toString();
            }
            sbuff.append(" ");
        }
        log.warn("No final \" for " + start);
        return sbuff.toString();
    }

    void processStrings(String s, Element e) {
        StringTokenizer stoke = new StringTokenizer(s, "\",");
        while (stoke.hasMoreTokens()) {
            e.addContent((Content)new Element("value").addContent(stoke.nextToken()));
        }
    }

    String stripQuotes(String name) {
        if (name.startsWith("\"")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void main(String[] args) throws IOException {
        ODLparser p = new ODLparser();
        p.parseFile("c:/temp/odl.struct.txt");
    }
}

