/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class VTfromExistingData
extends VerticalTransformImpl {
    public static final String existingDataField = "existingDataField";
    private VariableDS existingData;

    public VTfromExistingData(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        super(timeDim);
        String vname = vCT.findParameterIgnoreCase(existingDataField).getStringValue();
        this.existingData = (VariableDS)ds.findVariable(vname);
        this.units = this.existingData.getUnitsString();
    }

    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array data = this.readArray(this.existingData, timeIndex);
        int[] shape = data.getShape();
        ArrayDouble.D3 ddata = (ArrayDouble.D3)Array.factory(Double.TYPE, shape);
        MAMath.copyDouble(ddata, data);
        return ddata;
    }
}

