/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.Channel;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Filter;
import ome.xml.model.FilterRef;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.OTF;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSet
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSet.class);
    private String id;
    private List<Filter> excitationFilterList = new ArrayList<Filter>();
    private Dichroic dichroic;
    private List<Filter> emissionFilterList = new ArrayList<Filter>();
    private List<Channel> channel_BackReferenceList = new ArrayList<Channel>();
    private List<OTF> otf_backReferenceList = new ArrayList<OTF>();

    public FilterSet() {
    }

    public FilterSet(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"FilterSet".equals(tagName)) {
            LOGGER.debug("Expecting node name of FilterSet got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("FilterSet missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> ExcitationFilterRef_nodeList = FilterSet.getChildrenByTagName(element, "ExcitationFilterRef");
        for (Element ExcitationFilterRef_element : ExcitationFilterRef_nodeList) {
            ExcitationFilterRef excitationFilterList_reference = new ExcitationFilterRef();
            excitationFilterList_reference.setID(ExcitationFilterRef_element.getAttribute("ID"));
            model.addReference(this, excitationFilterList_reference);
        }
        List<Element> DichroicRef_nodeList = FilterSet.getChildrenByTagName(element, "DichroicRef");
        for (Element DichroicRef_element : DichroicRef_nodeList) {
            DichroicRef dichroic_reference = new DichroicRef();
            dichroic_reference.setID(DichroicRef_element.getAttribute("ID"));
            model.addReference(this, dichroic_reference);
        }
        List<Element> EmissionFilterRef_nodeList = FilterSet.getChildrenByTagName(element, "EmissionFilterRef");
        for (Element EmissionFilterRef_element : EmissionFilterRef_nodeList) {
            EmissionFilterRef emissionFilterList_reference = new EmissionFilterRef();
            emissionFilterList_reference.setID(EmissionFilterRef_element.getAttribute("ID"));
            model.addReference(this, emissionFilterList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof ExcitationFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkFilterSet(this);
            this.excitationFilterList.add(o_casted);
            return true;
        }
        if (reference instanceof DichroicRef) {
            Dichroic o_casted = (Dichroic)o;
            o_casted.linkFilterSet(this);
            this.dichroic = o_casted;
            return true;
        }
        if (reference instanceof EmissionFilterRef) {
            Filter o_casted = (Filter)o;
            o_casted.linkFilterSet(this);
            this.emissionFilterList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedExcitationFilterList() {
        return this.excitationFilterList.size();
    }

    public List<Filter> copyLinkedExcitationFilterList() {
        return new ArrayList<Filter>(this.excitationFilterList);
    }

    public Filter getLinkedExcitationFilter(int index) {
        return this.excitationFilterList.get(index);
    }

    public Filter setLinkedExcitationFilter(int index, Filter o) {
        return this.excitationFilterList.set(index, o);
    }

    public boolean linkExcitationFilter(Filter o) {
        o.linkFilterSet(this);
        return this.excitationFilterList.add(o);
    }

    public boolean unlinkExcitationFilter(Filter o) {
        o.unlinkFilterSet(this);
        return this.excitationFilterList.remove(o);
    }

    public Dichroic getLinkedDichroic() {
        return this.dichroic;
    }

    public void linkDichroic(Dichroic o) {
        this.dichroic = o;
    }

    public void unlinkDichroic(Dichroic o) {
        if (this.dichroic == o) {
            this.dichroic = null;
        }
    }

    public int sizeOfLinkedEmissionFilterList() {
        return this.emissionFilterList.size();
    }

    public List<Filter> copyLinkedEmissionFilterList() {
        return new ArrayList<Filter>(this.emissionFilterList);
    }

    public Filter getLinkedEmissionFilter(int index) {
        return this.emissionFilterList.get(index);
    }

    public Filter setLinkedEmissionFilter(int index, Filter o) {
        return this.emissionFilterList.set(index, o);
    }

    public boolean linkEmissionFilter(Filter o) {
        o.linkFilterSet(this);
        return this.emissionFilterList.add(o);
    }

    public boolean unlinkEmissionFilter(Filter o) {
        o.unlinkFilterSet(this);
        return this.emissionFilterList.remove(o);
    }

    public int sizeOfLinkedChannelList() {
        return this.channel_BackReferenceList.size();
    }

    public List<Channel> copyLinkedChannelList() {
        return new ArrayList<Channel>(this.channel_BackReferenceList);
    }

    public Channel getLinkedChannel(int index) {
        return this.channel_BackReferenceList.get(index);
    }

    public Channel setLinkedChannel(int index, Channel o) {
        return this.channel_BackReferenceList.set(index, o);
    }

    public boolean linkChannel(Channel o) {
        return this.channel_BackReferenceList.add(o);
    }

    public boolean unlinkChannel(Channel o) {
        return this.channel_BackReferenceList.remove(o);
    }

    public int sizeOfLinkedOTFList() {
        return this.otf_backReferenceList.size();
    }

    public List<OTF> copyLinkedOTFList() {
        return new ArrayList<OTF>(this.otf_backReferenceList);
    }

    public OTF getLinkedOTF(int index) {
        return this.otf_backReferenceList.get(index);
    }

    public OTF setLinkedOTF(int index, OTF o) {
        return this.otf_backReferenceList.set(index, o);
    }

    public boolean linkOTF(OTF o) {
        return this.otf_backReferenceList.add(o);
    }

    public boolean unlinkOTF(OTF o) {
        return this.otf_backReferenceList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element FilterSet_element) {
        FilterRef o;
        if (FilterSet_element == null) {
            FilterSet_element = document.createElementNS(NAMESPACE, "FilterSet");
        }
        if (this.id != null) {
            FilterSet_element.setAttribute("ID", this.id.toString());
        }
        if (this.excitationFilterList != null) {
            for (Filter excitationFilterList_value : this.excitationFilterList) {
                o = new ExcitationFilterRef();
                o.setID(excitationFilterList_value.getID());
                FilterSet_element.appendChild(((ExcitationFilterRef)o).asXMLElement(document));
            }
        }
        if (this.dichroic != null) {
            DichroicRef o2 = new DichroicRef();
            o2.setID(this.dichroic.getID());
            FilterSet_element.appendChild(o2.asXMLElement(document));
        }
        if (this.emissionFilterList != null) {
            for (Filter emissionFilterList_value : this.emissionFilterList) {
                o = new EmissionFilterRef();
                o.setID(emissionFilterList_value.getID());
                FilterSet_element.appendChild(((EmissionFilterRef)o).asXMLElement(document));
            }
        }
        if (this.channel_BackReferenceList != null) {
            // empty if block
        }
        if (this.otf_backReferenceList != null) {
            // empty if block
        }
        return super.asXMLElement(document, FilterSet_element);
    }
}

