/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterStationObsDataset {
    private static final String recordDimName = "record";
    private static final String stationDimName = "station";
    private static final String latName = "latitude";
    private static final String lonName = "longitude";
    private static final String altName = "altitude";
    private static final String timeName = "time";
    private static final String idName = "station_id";
    private static final String descName = "station_description";
    private static final String wmoName = "wmo_id";
    private static final String firstChildName = "firstChild";
    private static final String lastChildName = "lastChild";
    private static final String numChildName = "numChildren";
    private static final String nextChildName = "nextChild";
    private static final String prevChildName = "prevChild";
    private static final String parentName = "parent_index";
    private DateFormatter dateFormatter = new DateFormatter();
    private int name_strlen;
    private int desc_strlen;
    private int wmo_strlen;
    private NetcdfFileWriteable ncfile;
    private String title;
    private Set<Dimension> dimSet = new HashSet<Dimension>();
    private List<Dimension> recordDims = new ArrayList<Dimension>();
    private List<Dimension> stationDims = new ArrayList<Dimension>();
    private List<Station> stnList;
    private Date minDate = null;
    private Date maxDate = null;
    private boolean useAlt = false;
    private boolean useWmoId = false;
    private boolean debug = false;
    private HashMap<String, StationTracker> stationMap;
    private int recno = 0;
    private ArrayObject.D1 timeArray = new ArrayObject.D1(String.class, 1);
    private ArrayInt.D1 prevArray = new ArrayInt.D1(1);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1);
    private int[] origin = new int[1];
    private int[] originTime = new int[2];

    public WriterStationObsDataset(String fileOut, String title) {
        this.ncfile = NetcdfFileWriteable.createNew(fileOut);
        this.ncfile.setFill(false);
        this.title = title;
    }

    public void setLength(long size) {
        this.ncfile.setLength(size);
    }

    public void writeHeader(List<Station> stns, List<VariableSimpleIF> vars) throws IOException {
        this.createGlobalAttributes();
        this.createStations(stns);
        this.ncfile.addGlobalAttribute("time_coverage_start", this.dateFormatter.toDateTimeStringISO(new Date()));
        this.ncfile.addGlobalAttribute("time_coverage_end", this.dateFormatter.toDateTimeStringISO(new Date()));
        this.createDataVariables(vars);
        this.ncfile.create();
        this.writeStationData(stns);
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
    }

    private void createGlobalAttributes() {
        this.ncfile.addGlobalAttribute("Conventions", "Unidata Observation Dataset v1.0");
        this.ncfile.addGlobalAttribute("cdm_datatype", "Station");
        this.ncfile.addGlobalAttribute("title", this.title);
        this.ncfile.addGlobalAttribute("desc", "Extracted by THREDDS/Netcdf Subset Service");
    }

    private void createStations(List<Station> stnList) throws IOException {
        int i;
        int nstns = stnList.size();
        for (i = 0; i < nstns; ++i) {
            Station stn = stnList.get(i);
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() == null || stn.getWmoId().trim().length() <= 0) continue;
            this.useWmoId = true;
        }
        for (i = 0; i < nstns; ++i) {
            Station station = stnList.get(i);
            this.name_strlen = Math.max(this.name_strlen, station.getName().length());
            this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            if (!this.useWmoId) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getName().length());
        }
        LatLonRect llbb = this.getBoundingBox(stnList);
        this.ncfile.addGlobalAttribute("geospatial_lat_min", Double.toString(llbb.getLowerLeftPoint().getLatitude()));
        this.ncfile.addGlobalAttribute("geospatial_lat_max", Double.toString(llbb.getUpperRightPoint().getLatitude()));
        this.ncfile.addGlobalAttribute("geospatial_lon_min", Double.toString(llbb.getLowerLeftPoint().getLongitude()));
        this.ncfile.addGlobalAttribute("geospatial_lon_max", Double.toString(llbb.getUpperRightPoint().getLongitude()));
        Dimension recordDim = this.ncfile.addUnlimitedDimension(recordDimName);
        this.recordDims.add(recordDim);
        Dimension stationDim = this.ncfile.addDimension(stationDimName, nstns);
        this.stationDims.add(stationDim);
        Variable v = this.ncfile.addVariable(latName, DataType.DOUBLE, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_north"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station latitude"));
        v = this.ncfile.addVariable(lonName, DataType.DOUBLE, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_east"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station longitude"));
        if (this.useAlt) {
            v = this.ncfile.addVariable(altName, DataType.DOUBLE, stationDimName);
            this.ncfile.addVariableAttribute(v, new Attribute("units", "meters"));
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station altitude"));
        }
        v = this.ncfile.addStringVariable(idName, this.stationDims, this.name_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station identifier"));
        v = this.ncfile.addStringVariable(descName, this.stationDims, this.desc_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station description"));
        if (this.useWmoId) {
            v = this.ncfile.addStringVariable(wmoName, this.stationDims, this.wmo_strlen);
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station WMO id"));
        }
        v = this.ncfile.addVariable(numChildName, DataType.INT, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "number of children in linked list for this station"));
        v = this.ncfile.addVariable(lastChildName, DataType.INT, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "record number of last child in linked list for this station"));
        v = this.ncfile.addVariable(firstChildName, DataType.INT, stationDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "record number of first child in linked list for this station"));
        Variable timeVar = this.ncfile.addStringVariable(timeName, this.recordDims, 20);
        this.ncfile.addVariableAttribute(timeVar, new Attribute("long_name", "ISO-8601 Date"));
        v = this.ncfile.addVariable(prevChildName, DataType.INT, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "record number of previous child in linked list"));
        v = this.ncfile.addVariable(parentName, DataType.INT, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "index of parent station"));
        v = this.ncfile.addVariable(nextChildName, DataType.INT, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "record number of next child in linked list"));
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        List<Dimension> dims;
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.ncfile.addDimension(d.getName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuffer dimNames = new StringBuffer(recordDimName);
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getName());
            }
            Variable newVar = this.ncfile.addVariable(oldVar.getName(), oldVar.getDataType(), dimNames.toString());
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                this.ncfile.addVariableAttribute(newVar, att);
            }
        }
    }

    private void writeStationData(List<Station> stnList) throws IOException {
        this.stnList = stnList;
        int nstns = stnList.size();
        this.stationMap = new HashMap(2 * nstns);
        if (this.debug) {
            System.out.println("stationMap created");
        }
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 altArray = new ArrayDouble.D1(nstns);
        ArrayObject.D1 idArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 descArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 wmoArray = new ArrayObject.D1(String.class, nstns);
        for (int i = 0; i < stnList.size(); ++i) {
            Station stn = stnList.get(i);
            this.stationMap.put(stn.getName(), new StationTracker(i));
            latArray.set(i, stn.getLatitude());
            lonArray.set(i, stn.getLongitude());
            if (this.useAlt) {
                altArray.set(i, stn.getAltitude());
            }
            idArray.set(i, stn.getName());
            descArray.set(i, stn.getDescription());
            if (!this.useWmoId) continue;
            wmoArray.set(i, stn.getWmoId());
        }
        try {
            this.ncfile.write(latName, latArray);
            this.ncfile.write(lonName, lonArray);
            if (this.useAlt) {
                this.ncfile.write(altName, altArray);
            }
            this.ncfile.writeStringData(idName, idArray);
            this.ncfile.writeStringData(descName, descArray);
            if (this.useWmoId) {
                this.ncfile.writeStringData(wmoName, wmoArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private void writeDataFinish() throws IOException {
        ArrayInt.D1 nextChildArray = new ArrayInt.D1(this.recno);
        int nstns = this.stnList.size();
        ArrayInt.D1 firstArray = new ArrayInt.D1(nstns);
        ArrayInt.D1 lastArray = new ArrayInt.D1(nstns);
        ArrayInt.D1 numArray = new ArrayInt.D1(nstns);
        for (int i = 0; i < this.stnList.size(); ++i) {
            Station stn = this.stnList.get(i);
            StationTracker tracker = this.stationMap.get(stn.getName());
            lastArray.set(i, tracker.lastChild);
            numArray.set(i, tracker.numChildren);
            int first = tracker.link.size() > 0 ? tracker.link.get(0) : -1;
            firstArray.set(i, first);
            if (tracker.link.size() <= 0) continue;
            List<Integer> nextList = tracker.link;
            for (int j = 0; j < nextList.size() - 1; ++j) {
                Integer curr = nextList.get(j);
                Integer next = nextList.get(j + 1);
                nextChildArray.set(curr, (int)next);
            }
            Integer curr = nextList.get(nextList.size() - 1);
            nextChildArray.set(curr, -1);
        }
        try {
            this.ncfile.write(firstChildName, firstArray);
            this.ncfile.write(lastChildName, lastArray);
            this.ncfile.write(numChildName, numArray);
            this.ncfile.write(nextChildName, nextChildArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        if (this.minDate == null) {
            this.minDate = new Date();
        }
        if (this.maxDate == null) {
            this.maxDate = new Date();
        }
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_start", this.dateFormatter.toDateTimeStringISO(this.minDate)));
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_end", this.dateFormatter.toDateTimeStringISO(this.maxDate)));
    }

    public void writeRecord(StationObsDatatype sobs, StructureData sdata) throws IOException {
        if (this.debug) {
            System.out.println("sobs= " + sobs + "; station = " + sobs.getStation());
        }
        this.writeRecord(sobs.getStation().getName(), sobs.getObservationTimeAsDate(), sdata);
    }

    public void writeRecord(String stnName, Date obsDate, StructureData sdata) throws IOException {
        StationTracker tracker = this.stationMap.get(stnName);
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        if (this.minDate == null || this.minDate.after(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.before(obsDate)) {
            this.maxDate = obsDate;
        }
        this.timeArray.set(0, this.dateFormatter.toDateTimeStringISO(obsDate));
        this.prevArray.set(0, tracker.lastChild);
        this.parentArray.set(0, tracker.parent_index);
        tracker.link.add(this.recno);
        tracker.lastChild = this.recno;
        ++tracker.numChildren;
        this.origin[0] = this.recno;
        this.originTime[0] = this.recno++;
        try {
            this.ncfile.write(recordDimName, this.origin, sArray);
            this.ncfile.writeStringData(timeName, this.originTime, this.timeArray);
            this.ncfile.write(prevChildName, this.originTime, this.prevArray);
            this.ncfile.write(parentName, this.originTime, this.parentArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void finish() throws IOException {
        this.writeDataFinish();
        this.ncfile.close();
    }

    private LatLonRect getBoundingBox(List stnList) {
        Station s = (Station)stnList.get(0);
        LatLonPointImpl llpt = new LatLonPointImpl();
        llpt.set(s.getLatitude(), s.getLongitude());
        LatLonRect rect = new LatLonRect(llpt, 0.001, 0.001);
        for (int i = 1; i < stnList.size(); ++i) {
            s = (Station)stnList.get(i);
            llpt.set(s.getLatitude(), s.getLongitude());
            rect.extend(llpt);
        }
        return rect;
    }

    private void write(StationObsDataset sobsDataset) throws IOException {
        this.createGlobalAttributes();
        this.createStations(sobsDataset.getStations());
        this.ncfile.addGlobalAttribute("time_coverage_start", this.dateFormatter.toDateTimeStringISO(sobsDataset.getStartDate()));
        this.ncfile.addGlobalAttribute("time_coverage_end", this.dateFormatter.toDateTimeStringISO(sobsDataset.getEndDate()));
        this.createDataVariables(sobsDataset.getDataVariables());
        List<Attribute> gatts = sobsDataset.getGlobalAttributes();
        for (int i = 0; i < gatts.size(); ++i) {
            Attribute att = gatts.get(i);
            this.ncfile.addGlobalAttribute(att);
        }
        this.ncfile.create();
        this.writeStationData(sobsDataset.getStations());
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
        int[] origin = new int[1];
        int[] originTime = new int[2];
        int recno = 0;
        ArrayStructureW sArray = null;
        ArrayObject.D1 timeArray = new ArrayObject.D1(String.class, 1);
        DataIterator diter = sobsDataset.getDataIterator(1000000);
        while (diter.hasNext()) {
            StationObsDatatype sobs = (StationObsDatatype)diter.nextData();
            StructureData recordData = sobs.getData();
            if (sArray == null) {
                sArray = new ArrayStructureW(recordData.getStructureMembers(), new int[]{1});
            }
            sArray.setStructureData(recordData, 0);
            timeArray.set(0, this.dateFormatter.toDateTimeStringISO(sobs.getObservationTimeAsDate()));
            origin[0] = recno;
            originTime[0] = recno++;
            try {
                this.ncfile.write(recordDimName, origin, sArray);
                this.ncfile.writeStringData(timeName, originTime, timeArray);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
        this.ncfile.close();
    }

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        String location = "C:/data/metars/Surface_METAR_20070513_0000.nc";
        StringBuffer errlog = new StringBuffer();
        StationObsDataset sobs = (StationObsDataset)TypedDatasetFactory.open(thredds.catalog.DataType.STATION, location, null, errlog);
        String fileOut = "C:/temp/Surface_METAR_20070513_0000.rewrite.nc";
        WriterStationObsDataset writer = new WriterStationObsDataset(fileOut, "test");
        List<Station> stns = sobs.getStations();
        ArrayList<Station> stnList = new ArrayList<Station>();
        Station s = stns.get(0);
        stnList.add(s);
        ArrayList<VariableSimpleIF> varList = new ArrayList<VariableSimpleIF>();
        varList.add(sobs.getDataVariable("wind_speed"));
        writer.writeHeader(stnList, varList);
        DataIterator iter = sobs.getDataIterator(s);
        while (iter.hasNext()) {
            StationObsDatatype sobsData = (StationObsDatatype)iter.nextData();
            StructureData data = sobsData.getData();
            writer.writeRecord(sobsData, data);
        }
        writer.finish();
        long took = System.currentTimeMillis() - start;
        System.out.println("That took = " + took);
    }

    public static void rewrite(String fileIn, String fileOut) throws IOException {
        long start = System.currentTimeMillis();
        NetcdfFile ncfile = NetcdfFile.openInMemory(fileIn);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        StringBuffer errlog = new StringBuffer();
        StationObsDataset sobs = (StationObsDataset)TypedDatasetFactory.open(thredds.catalog.DataType.STATION, ncd, null, errlog);
        List<Station> stns = sobs.getStations();
        List<VariableSimpleIF> vars = sobs.getDataVariables();
        WriterStationObsDataset writer = new WriterStationObsDataset(fileOut, "rewrite " + fileIn);
        File f = new File(fileIn);
        writer.setLength(f.length());
        writer.writeHeader(stns, vars);
        for (Station s : stns) {
            DataIterator iter = sobs.getDataIterator(s);
            while (iter.hasNext()) {
                StationObsDatatype sobsData = (StationObsDatatype)iter.nextData();
                StructureData data = sobsData.getData();
                writer.writeRecord(sobsData, data);
            }
        }
        writer.finish();
        long took = System.currentTimeMillis() - start;
        System.out.println("Rewrite " + fileIn + " to " + fileOut + " took = " + took);
    }

    public static void main2(String[] args) throws IOException {
        File[] files;
        long start = System.currentTimeMillis();
        String toLocation = "C:/temp2/";
        String fromLocation = "C:/data/metars/";
        if (args.length > 1) {
            fromLocation = args[0];
            toLocation = args[1];
        }
        System.out.println("Rewrite .nc files from " + fromLocation + " to " + toLocation);
        File dir = new File(fromLocation);
        for (File file2 : files = dir.listFiles()) {
            if (!file2.getName().endsWith(".nc")) continue;
            WriterStationObsDataset.rewrite(file2.getAbsolutePath(), toLocation + file2.getName());
        }
        long took = System.currentTimeMillis() - start;
        System.out.println("That took = " + took);
    }

    private class StationTracker {
        int numChildren = 0;
        int lastChild = -1;
        int parent_index;
        List<Integer> link = new ArrayList<Integer>();

        StationTracker(int parent_index) {
            this.parent_index = parent_index;
        }
    }
}

