/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import loci.common.DataTools;

public class Index16ColorModel
extends ColorModel {
    private short[] redShort;
    private short[] greenShort;
    private short[] blueShort;
    private short[] alphaShort;
    private int pixelBits;
    private boolean littleEndian;

    public Index16ColorModel(int bits, int size, short[][] table, boolean littleEndian) throws IOException {
        super(bits);
        this.littleEndian = littleEndian;
        if (table == null) {
            throw new IOException("LUT cannot be null");
        }
        for (int i = 0; i < table.length; ++i) {
            if (table[i].length >= size) continue;
            throw new IOException("LUT " + i + " too small");
        }
        if (table.length > 0) {
            this.redShort = table[0];
        }
        if (table.length > 1) {
            this.greenShort = table[1];
        }
        if (table.length > 2) {
            this.blueShort = table[2];
        }
        if (table.length > 3) {
            this.alphaShort = table[3];
        }
        this.pixelBits = bits;
    }

    public short[] getReds() {
        return this.redShort;
    }

    public short[] getGreens() {
        return this.greenShort;
    }

    public short[] getBlues() {
        return this.blueShort;
    }

    public short[] getAlphas() {
        return this.alphaShort;
    }

    public synchronized Object getDataElements(int rgb, Object pixel) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        short[] p = pixel == null ? new short[3] : (short[])pixel;
        p[0] = (short)red;
        p[1] = (short)green;
        p[2] = (short)blue;
        return p;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return raster.getNumBands() == 1;
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return Raster.createInterleavedRaster(1, w, h, 1, null);
    }

    public int getAlpha(int pixel) {
        if (this.alphaShort != null) {
            return this.alphaShort[pixel] & 0xFFFF;
        }
        return 65535;
    }

    public int getBlue(int pixel) {
        if (this.blueShort == null) {
            return 0;
        }
        int blue = this.blueShort[pixel] & 0xFFFF;
        return this.littleEndian ? DataTools.swap(blue) : blue;
    }

    public int getGreen(int pixel) {
        if (this.greenShort == null) {
            return 0;
        }
        int green = this.greenShort[pixel] & 0xFFFF;
        return this.littleEndian ? DataTools.swap(green) : green;
    }

    public int getRed(int pixel) {
        if (this.redShort == null) {
            return 0;
        }
        int red = this.redShort[pixel] & 0xFFFF;
        return this.littleEndian ? DataTools.swap(red) : red;
    }
}

