/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public final class MetadataConverter {
    private MetadataConverter() {
    }

    public static void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        int excitationFilterRefIndex;
        int emissionFilterRefIndex;
        int annotationRefIndex;
        try {
            int booleanAnnotationCount = src.getBooleanAnnotationCount();
            for (int booleanAnnotationIndex = 0; booleanAnnotationIndex < booleanAnnotationCount; ++booleanAnnotationIndex) {
                try {
                    String booleanAnnotationIDValue = src.getBooleanAnnotationID(booleanAnnotationIndex);
                    if (booleanAnnotationIDValue != null) {
                        dest.setBooleanAnnotationID(booleanAnnotationIDValue, booleanAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String booleanAnnotationNamespaceValue = src.getBooleanAnnotationNamespace(booleanAnnotationIndex);
                    if (booleanAnnotationNamespaceValue != null) {
                        dest.setBooleanAnnotationNamespace(booleanAnnotationNamespaceValue, booleanAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Boolean booleanAnnotationValueValue = src.getBooleanAnnotationValue(booleanAnnotationIndex);
                    if (booleanAnnotationValueValue == null) continue;
                    dest.setBooleanAnnotationValue(booleanAnnotationValueValue, booleanAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int datasetCount = src.getDatasetCount();
            for (int datasetIndex = 0; datasetIndex < datasetCount; ++datasetIndex) {
                try {
                    String datasetIDValue = src.getDatasetID(datasetIndex);
                    if (datasetIDValue != null) {
                        dest.setDatasetID(datasetIDValue, datasetIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    for (int annotationRefIndex2 = 0; annotationRefIndex2 < src.getDatasetAnnotationRefCount(datasetIndex); ++annotationRefIndex2) {
                        String datasetAnnotationRefValue = src.getDatasetAnnotationRef(datasetIndex, annotationRefIndex2);
                        if (datasetAnnotationRefValue == null) continue;
                        dest.setDatasetAnnotationRef(datasetAnnotationRefValue, datasetIndex, annotationRefIndex2);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String datasetDescriptionValue = src.getDatasetDescription(datasetIndex);
                    if (datasetDescriptionValue != null) {
                        dest.setDatasetDescription(datasetDescriptionValue, datasetIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String datasetExperimenterRefValue = src.getDatasetExperimenterRef(datasetIndex);
                    if (datasetExperimenterRefValue != null) {
                        dest.setDatasetExperimenterRef(datasetExperimenterRefValue, datasetIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String datasetGroupRefValue = src.getDatasetGroupRef(datasetIndex);
                    if (datasetGroupRefValue != null) {
                        dest.setDatasetGroupRef(datasetGroupRefValue, datasetIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String datasetNameValue = src.getDatasetName(datasetIndex);
                    if (datasetNameValue != null) {
                        dest.setDatasetName(datasetNameValue, datasetIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int projectRefCount = src.getProjectRefCount(datasetIndex);
                    for (int projectRefIndex = 0; projectRefIndex < projectRefCount; ++projectRefIndex) {
                        String datasetProjectRefValue = src.getDatasetProjectRef(datasetIndex, projectRefIndex);
                        if (datasetProjectRefValue == null) continue;
                        dest.setDatasetProjectRef(datasetProjectRefValue, datasetIndex, projectRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int annotationRefCount = src.getDatasetAnnotationRefCount(datasetIndex);
                    for (int annotationRefIndex3 = 0; annotationRefIndex3 < annotationRefCount; ++annotationRefIndex3) {
                        String annotationValue = src.getDatasetAnnotationRef(datasetIndex, annotationRefIndex3);
                        if (annotationValue == null) continue;
                        dest.setDatasetAnnotationRef(annotationValue, datasetIndex, annotationRefIndex3);
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int doubleAnnotationCount = src.getDoubleAnnotationCount();
            for (int doubleAnnotationIndex = 0; doubleAnnotationIndex < doubleAnnotationCount; ++doubleAnnotationIndex) {
                try {
                    String doubleAnnotationIDValue = src.getDoubleAnnotationID(doubleAnnotationIndex);
                    if (doubleAnnotationIDValue != null) {
                        dest.setDoubleAnnotationID(doubleAnnotationIDValue, doubleAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String doubleAnnotationNamespaceValue = src.getDoubleAnnotationNamespace(doubleAnnotationIndex);
                    if (doubleAnnotationNamespaceValue != null) {
                        dest.setDoubleAnnotationNamespace(doubleAnnotationNamespaceValue, doubleAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double doubleAnnotationValueValue = src.getDoubleAnnotationValue(doubleAnnotationIndex);
                    if (doubleAnnotationValueValue == null) continue;
                    dest.setDoubleAnnotationValue(doubleAnnotationValueValue, doubleAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int experimentCount = src.getExperimentCount();
            for (int experimentIndex = 0; experimentIndex < experimentCount; ++experimentIndex) {
                try {
                    String experimentDescriptionValue = src.getExperimentDescription(experimentIndex);
                    if (experimentDescriptionValue != null) {
                        dest.setExperimentDescription(experimentDescriptionValue, experimentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimentExperimenterRefValue = src.getExperimentExperimenterRef(experimentIndex);
                    if (experimentExperimenterRefValue != null) {
                        dest.setExperimentExperimenterRef(experimentExperimenterRefValue, experimentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimentIDValue = src.getExperimentID(experimentIndex);
                    if (experimentIDValue != null) {
                        dest.setExperimentID(experimentIDValue, experimentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    ExperimentType experimentTypeValue = src.getExperimentType(experimentIndex);
                    if (experimentTypeValue != null) {
                        dest.setExperimentType(experimentTypeValue, experimentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int microbeamManipulationCount = src.getMicrobeamManipulationCount(experimentIndex);
                    for (int microbeamManipulationIndex = 0; microbeamManipulationIndex < microbeamManipulationCount; ++microbeamManipulationIndex) {
                        try {
                            String microbeamManipulationExperimenterRefValue = src.getMicrobeamManipulationExperimenterRef(experimentIndex, microbeamManipulationIndex);
                            if (microbeamManipulationExperimenterRefValue != null) {
                                dest.setMicrobeamManipulationExperimenterRef(microbeamManipulationExperimenterRefValue, experimentIndex, microbeamManipulationIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String microbeamManipulationIDValue = src.getMicrobeamManipulationID(experimentIndex, microbeamManipulationIndex);
                            if (microbeamManipulationIDValue != null) {
                                dest.setMicrobeamManipulationID(microbeamManipulationIDValue, experimentIndex, microbeamManipulationIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int roiRefCount = src.getMicrobeamManipulationROIRefCount(experimentIndex, microbeamManipulationIndex);
                            for (int roiRefIndex = 0; roiRefIndex < roiRefCount; ++roiRefIndex) {
                                String microbeamManipulationROIRefValue = src.getMicrobeamManipulationROIRef(experimentIndex, microbeamManipulationIndex, roiRefIndex);
                                if (microbeamManipulationROIRefValue == null) continue;
                                dest.setMicrobeamManipulationROIRef(microbeamManipulationROIRefValue, experimentIndex, microbeamManipulationIndex, roiRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            MicrobeamManipulationType microbeamManipulationTypeValue = src.getMicrobeamManipulationType(experimentIndex, microbeamManipulationIndex);
                            if (microbeamManipulationTypeValue != null) {
                                dest.setMicrobeamManipulationType(microbeamManipulationTypeValue, experimentIndex, microbeamManipulationIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int lightSourceSettingsCount = src.getMicrobeamManipulationLightSourceSettingsCount(experimentIndex, microbeamManipulationIndex);
                            for (int lightSourceSettingsIndex = 0; lightSourceSettingsIndex < lightSourceSettingsCount; ++lightSourceSettingsIndex) {
                                try {
                                    PercentFraction microbeamManipulationLightSourceSettingsAttenuationValue = src.getMicrobeamManipulationLightSourceSettingsAttenuation(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
                                    if (microbeamManipulationLightSourceSettingsAttenuationValue != null) {
                                        dest.setMicrobeamManipulationLightSourceSettingsAttenuation(microbeamManipulationLightSourceSettingsAttenuationValue, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    String microbeamManipulationLightSourceSettingsIDValue = src.getMicrobeamManipulationLightSourceSettingsID(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
                                    if (microbeamManipulationLightSourceSettingsIDValue != null) {
                                        dest.setMicrobeamManipulationLightSourceSettingsID(microbeamManipulationLightSourceSettingsIDValue, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    PositiveInteger microbeamManipulationLightSourceSettingsWavelengthValue = src.getMicrobeamManipulationLightSourceSettingsWavelength(experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
                                    if (microbeamManipulationLightSourceSettingsWavelengthValue == null) continue;
                                    dest.setMicrobeamManipulationLightSourceSettingsWavelength(microbeamManipulationLightSourceSettingsWavelengthValue, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
                                    continue;
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int experimenterCount = src.getExperimenterCount();
            for (int experimenterIndex = 0; experimenterIndex < experimenterCount; ++experimenterIndex) {
                int groupRefIndex;
                int annotationRefIndex4;
                try {
                    int annotationRefCount = src.getExperimenterAnnotationRefCount(experimenterIndex);
                    for (annotationRefIndex4 = 0; annotationRefIndex4 < annotationRefCount; ++annotationRefIndex4) {
                        String experimenterAnnotationRefValue = src.getExperimenterAnnotationRef(experimenterIndex, annotationRefIndex4);
                        if (experimenterAnnotationRefValue == null) continue;
                        dest.setExperimenterAnnotationRef(experimenterAnnotationRefValue, experimenterIndex, annotationRefIndex4);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterDisplayNameValue = src.getExperimenterDisplayName(experimenterIndex);
                    if (experimenterDisplayNameValue != null) {
                        dest.setExperimenterDisplayName(experimenterDisplayNameValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterEmailValue = src.getExperimenterEmail(experimenterIndex);
                    if (experimenterEmailValue != null) {
                        dest.setExperimenterEmail(experimenterEmailValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterFirstNameValue = src.getExperimenterFirstName(experimenterIndex);
                    if (experimenterFirstNameValue != null) {
                        dest.setExperimenterFirstName(experimenterFirstNameValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int groupRefCount = src.getExperimenterGroupRefCount(experimenterIndex);
                    for (groupRefIndex = 0; groupRefIndex < groupRefCount; ++groupRefIndex) {
                        String experimenterGroupRefValue = src.getExperimenterGroupRef(experimenterIndex, groupRefIndex);
                        if (experimenterGroupRefValue == null) continue;
                        dest.setExperimenterGroupRef(experimenterGroupRefValue, experimenterIndex, groupRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterIDValue = src.getExperimenterID(experimenterIndex);
                    if (experimenterIDValue != null) {
                        dest.setExperimenterID(experimenterIDValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterInstitutionValue = src.getExperimenterInstitution(experimenterIndex);
                    if (experimenterInstitutionValue != null) {
                        dest.setExperimenterInstitution(experimenterInstitutionValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterLastNameValue = src.getExperimenterLastName(experimenterIndex);
                    if (experimenterLastNameValue != null) {
                        dest.setExperimenterLastName(experimenterLastNameValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterMiddleNameValue = src.getExperimenterMiddleName(experimenterIndex);
                    if (experimenterMiddleNameValue != null) {
                        dest.setExperimenterMiddleName(experimenterMiddleNameValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String experimenterUserNameValue = src.getExperimenterUserName(experimenterIndex);
                    if (experimenterUserNameValue != null) {
                        dest.setExperimenterUserName(experimenterUserNameValue, experimenterIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int annotationRefCount = src.getExperimenterAnnotationRefCount(experimenterIndex);
                    for (annotationRefIndex4 = 0; annotationRefIndex4 < annotationRefCount; ++annotationRefIndex4) {
                        String annotationRef = src.getExperimenterAnnotationRef(experimenterIndex, annotationRefIndex4);
                        if (annotationRef == null) continue;
                        dest.setExperimenterAnnotationRef(annotationRef, experimenterIndex, annotationRefIndex4);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int groupRefCount = src.getExperimenterGroupRefCount(experimenterIndex);
                    for (groupRefIndex = 0; groupRefIndex < groupRefCount; ++groupRefIndex) {
                        String groupRef = src.getExperimenterGroupRef(experimenterIndex, groupRefIndex);
                        if (groupRef == null) continue;
                        dest.setExperimenterGroupRef(groupRef, experimenterIndex, groupRefIndex);
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int fileAnnotationCount = src.getFileAnnotationCount();
            for (int fileAnnotationIndex = 0; fileAnnotationIndex < fileAnnotationCount; ++fileAnnotationIndex) {
                try {
                    String fileAnnotationBinaryFileFileNameValue = src.getFileAnnotationBinaryFileFileName(fileAnnotationIndex);
                    if (fileAnnotationBinaryFileFileNameValue != null) {
                        dest.setFileAnnotationBinaryFileFileName(fileAnnotationBinaryFileFileNameValue, fileAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String fileAnnotationBinaryFileMIMETypeValue = src.getFileAnnotationBinaryFileMIMEType(fileAnnotationIndex);
                    if (fileAnnotationBinaryFileMIMETypeValue != null) {
                        dest.setFileAnnotationBinaryFileMIMEType(fileAnnotationBinaryFileMIMETypeValue, fileAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NonNegativeLong fileAnnotationBinaryFileSizeValue = src.getFileAnnotationBinaryFileSize(fileAnnotationIndex);
                    if (fileAnnotationBinaryFileSizeValue != null) {
                        dest.setFileAnnotationBinaryFileSize(fileAnnotationBinaryFileSizeValue, fileAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String fileAnnotationIDValue = src.getFileAnnotationID(fileAnnotationIndex);
                    if (fileAnnotationIDValue != null) {
                        dest.setFileAnnotationID(fileAnnotationIDValue, fileAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String fileAnnotationNamespaceValue = src.getFileAnnotationNamespace(fileAnnotationIndex);
                    if (fileAnnotationNamespaceValue == null) continue;
                    dest.setFileAnnotationNamespace(fileAnnotationNamespaceValue, fileAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int groupCount = src.getGroupCount();
            for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
                try {
                    String groupIDValue = src.getGroupID(groupIndex);
                    if (groupIDValue != null) {
                        dest.setGroupID(groupIDValue, groupIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String groupContactValue = src.getGroupContact(groupIndex);
                    if (groupContactValue != null) {
                        dest.setGroupContact(groupContactValue, groupIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String groupDescriptionValue = src.getGroupDescription(groupIndex);
                    if (groupDescriptionValue != null) {
                        dest.setGroupDescription(groupDescriptionValue, groupIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String groupLeaderValue = src.getGroupLeader(groupIndex);
                    if (groupLeaderValue != null) {
                        dest.setGroupLeader(groupLeaderValue, groupIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String groupNameValue = src.getGroupName(groupIndex);
                    if (groupNameValue == null) continue;
                    dest.setGroupName(groupNameValue, groupIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int imageCount = src.getImageCount();
            for (int imageIndex = 0; imageIndex < imageCount; ++imageIndex) {
                try {
                    String imageAcquiredDateValue = src.getImageAcquiredDate(imageIndex);
                    if (imageAcquiredDateValue != null) {
                        dest.setImageAcquiredDate(imageAcquiredDateValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int annotationRefCount = src.getImageAnnotationRefCount(imageIndex);
                    for (int annotationRefIndex5 = 0; annotationRefIndex5 < annotationRefCount; ++annotationRefIndex5) {
                        String imageAnnotationRefValue = src.getImageAnnotationRef(imageIndex, annotationRefIndex5);
                        if (imageAnnotationRefValue == null) continue;
                        dest.setImageAnnotationRef(imageAnnotationRefValue, imageIndex, annotationRefIndex5);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int datasetRefCount = src.getDatasetRefCount(imageIndex);
                    for (int datasetRefIndex = 0; datasetRefIndex < datasetRefCount; ++datasetRefIndex) {
                        String imageDatasetRefValue = src.getImageDatasetRef(imageIndex, datasetRefIndex);
                        if (imageDatasetRefValue == null) continue;
                        dest.setImageDatasetRef(imageDatasetRefValue, imageIndex, datasetRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageDescriptionValue = src.getImageDescription(imageIndex);
                    if (imageDescriptionValue != null) {
                        dest.setImageDescription(imageDescriptionValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageExperimentRefValue = src.getImageExperimentRef(imageIndex);
                    if (imageExperimentRefValue != null) {
                        dest.setImageExperimentRef(imageExperimentRefValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageExperimenterRefValue = src.getImageExperimenterRef(imageIndex);
                    if (imageExperimenterRefValue != null) {
                        dest.setImageExperimenterRef(imageExperimenterRefValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageGroupRefValue = src.getImageGroupRef(imageIndex);
                    if (imageGroupRefValue != null) {
                        dest.setImageGroupRef(imageGroupRefValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageIDValue = src.getImageID(imageIndex);
                    if (imageIDValue != null) {
                        dest.setImageID(imageIDValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageInstrumentRefValue = src.getImageInstrumentRef(imageIndex);
                    if (imageInstrumentRefValue != null) {
                        dest.setImageInstrumentRef(imageInstrumentRefValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int microbeamManipulationRefCount = src.getMicrobeamManipulationRefCount(imageIndex);
                    for (int microbeamManipulationRefIndex = 0; microbeamManipulationRefIndex < microbeamManipulationRefCount; ++microbeamManipulationRefIndex) {
                        String imageMicrobeamManipulationRefValue = src.getImageMicrobeamManipulationRef(imageIndex, microbeamManipulationRefIndex);
                        if (imageMicrobeamManipulationRefValue == null) continue;
                        dest.setImageMicrobeamManipulationRef(imageMicrobeamManipulationRefValue, imageIndex, microbeamManipulationRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageNameValue = src.getImageName(imageIndex);
                    if (imageNameValue != null) {
                        dest.setImageName(imageNameValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double imageObjectiveSettingsCorrectionCollarValue = src.getImageObjectiveSettingsCorrectionCollar(imageIndex);
                    if (imageObjectiveSettingsCorrectionCollarValue != null) {
                        dest.setImageObjectiveSettingsCorrectionCollar(imageObjectiveSettingsCorrectionCollarValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String imageObjectiveSettingsIDValue = src.getImageObjectiveSettingsID(imageIndex);
                    if (imageObjectiveSettingsIDValue != null) {
                        dest.setImageObjectiveSettingsID(imageObjectiveSettingsIDValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Medium imageObjectiveSettingsMediumValue = src.getImageObjectiveSettingsMedium(imageIndex);
                    if (imageObjectiveSettingsMediumValue != null) {
                        dest.setImageObjectiveSettingsMedium(imageObjectiveSettingsMediumValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double imageObjectiveSettingsRefractiveIndexValue = src.getImageObjectiveSettingsRefractiveIndex(imageIndex);
                    if (imageObjectiveSettingsRefractiveIndexValue != null) {
                        dest.setImageObjectiveSettingsRefractiveIndex(imageObjectiveSettingsRefractiveIndexValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int roiRefCount = src.getImageROIRefCount(imageIndex);
                    for (int roiRefIndex = 0; roiRefIndex < roiRefCount; ++roiRefIndex) {
                        String imageROIRefValue = src.getImageROIRef(imageIndex, roiRefIndex);
                        if (imageROIRefValue == null) continue;
                        dest.setImageROIRef(imageROIRefValue, imageIndex, roiRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int channelCount = src.getChannelCount(imageIndex);
                    for (int channelIndex = 0; channelIndex < channelCount; ++channelIndex) {
                        try {
                            AcquisitionMode channelAcquisitionModeValue = src.getChannelAcquisitionMode(imageIndex, channelIndex);
                            if (channelAcquisitionModeValue != null) {
                                dest.setChannelAcquisitionMode(channelAcquisitionModeValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int annotationRefCount = src.getChannelAnnotationRefCount(imageIndex, channelIndex);
                            for (annotationRefIndex = 0; annotationRefIndex < annotationRefCount; ++annotationRefIndex) {
                                String channelAnnotationRefValue = src.getChannelAnnotationRef(imageIndex, channelIndex, annotationRefIndex);
                                if (channelAnnotationRefValue == null) continue;
                                dest.setChannelAnnotationRef(channelAnnotationRefValue, imageIndex, channelIndex, annotationRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Integer channelColorValue = src.getChannelColor(imageIndex, channelIndex);
                            if (channelColorValue != null) {
                                dest.setChannelColor(channelColorValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            ContrastMethod channelContrastMethodValue = src.getChannelContrastMethod(imageIndex, channelIndex);
                            if (channelContrastMethodValue != null) {
                                dest.setChannelContrastMethod(channelContrastMethodValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger channelEmissionWavelengthValue = src.getChannelEmissionWavelength(imageIndex, channelIndex);
                            if (channelEmissionWavelengthValue != null) {
                                dest.setChannelEmissionWavelength(channelEmissionWavelengthValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger channelExcitationWavelengthValue = src.getChannelExcitationWavelength(imageIndex, channelIndex);
                            if (channelExcitationWavelengthValue != null) {
                                dest.setChannelExcitationWavelength(channelExcitationWavelengthValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelFilterSetRefValue = src.getChannelFilterSetRef(imageIndex, channelIndex);
                            if (channelFilterSetRefValue != null) {
                                dest.setChannelFilterSetRef(channelFilterSetRefValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelFluorValue = src.getChannelFluor(imageIndex, channelIndex);
                            if (channelFluorValue != null) {
                                dest.setChannelFluor(channelFluorValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelIDValue = src.getChannelID(imageIndex, channelIndex);
                            if (channelIDValue != null) {
                                dest.setChannelID(channelIDValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            IlluminationType channelIlluminationTypeValue = src.getChannelIlluminationType(imageIndex, channelIndex);
                            if (channelIlluminationTypeValue != null) {
                                dest.setChannelIlluminationType(channelIlluminationTypeValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PercentFraction channelLightSourceSettingsAttenuationValue = src.getChannelLightSourceSettingsAttenuation(imageIndex, channelIndex);
                            if (channelLightSourceSettingsAttenuationValue != null) {
                                dest.setChannelLightSourceSettingsAttenuation(channelLightSourceSettingsAttenuationValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelLightSourceSettingsIDValue = src.getChannelLightSourceSettingsID(imageIndex, channelIndex);
                            if (channelLightSourceSettingsIDValue != null) {
                                dest.setChannelLightSourceSettingsID(channelLightSourceSettingsIDValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger channelLightSourceSettingsWavelengthValue = src.getChannelLightSourceSettingsWavelength(imageIndex, channelIndex);
                            if (channelLightSourceSettingsWavelengthValue != null) {
                                dest.setChannelLightSourceSettingsWavelength(channelLightSourceSettingsWavelengthValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double channelNDFilterValue = src.getChannelNDFilter(imageIndex, channelIndex);
                            if (channelNDFilterValue != null) {
                                dest.setChannelNDFilter(channelNDFilterValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelNameValue = src.getChannelName(imageIndex, channelIndex);
                            if (channelNameValue != null) {
                                dest.setChannelName(channelNameValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String channelOTFRefValue = src.getChannelOTFRef(imageIndex, channelIndex);
                            if (channelOTFRefValue != null) {
                                dest.setChannelOTFRef(channelOTFRefValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double channelPinholeSizeValue = src.getChannelPinholeSize(imageIndex, channelIndex);
                            if (channelPinholeSizeValue != null) {
                                dest.setChannelPinholeSize(channelPinholeSizeValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Integer channelPockelCellSettingValue = src.getChannelPockelCellSetting(imageIndex, channelIndex);
                            if (channelPockelCellSettingValue != null) {
                                dest.setChannelPockelCellSetting(channelPockelCellSettingValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger channelSamplesPerPixelValue = src.getChannelSamplesPerPixel(imageIndex, channelIndex);
                            if (channelSamplesPerPixelValue != null) {
                                dest.setChannelSamplesPerPixel(channelSamplesPerPixelValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Binning detectorSettingsBinningValue = src.getDetectorSettingsBinning(imageIndex, channelIndex);
                            if (detectorSettingsBinningValue != null) {
                                dest.setDetectorSettingsBinning(detectorSettingsBinningValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorSettingsGainValue = src.getDetectorSettingsGain(imageIndex, channelIndex);
                            if (detectorSettingsGainValue != null) {
                                dest.setDetectorSettingsGain(detectorSettingsGainValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorSettingsIDValue = src.getDetectorSettingsID(imageIndex, channelIndex);
                            if (detectorSettingsIDValue != null) {
                                dest.setDetectorSettingsID(detectorSettingsIDValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorSettingsOffsetValue = src.getDetectorSettingsOffset(imageIndex, channelIndex);
                            if (detectorSettingsOffsetValue != null) {
                                dest.setDetectorSettingsOffset(detectorSettingsOffsetValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorSettingsReadOutRateValue = src.getDetectorSettingsReadOutRate(imageIndex, channelIndex);
                            if (detectorSettingsReadOutRateValue != null) {
                                dest.setDetectorSettingsReadOutRate(detectorSettingsReadOutRateValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorSettingsVoltageValue = src.getDetectorSettingsVoltage(imageIndex, channelIndex);
                            if (detectorSettingsVoltageValue != null) {
                                dest.setDetectorSettingsVoltage(detectorSettingsVoltageValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String lightPathDichroicRefValue = src.getLightPathDichroicRef(imageIndex, channelIndex);
                            if (lightPathDichroicRefValue != null) {
                                dest.setLightPathDichroicRef(lightPathDichroicRefValue, imageIndex, channelIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int emissionFilterRefCount = src.getLightPathEmissionFilterRefCount(imageIndex, channelIndex);
                            for (emissionFilterRefIndex = 0; emissionFilterRefIndex < emissionFilterRefCount; ++emissionFilterRefIndex) {
                                String lightPathEmissionFilterRefValue = src.getLightPathEmissionFilterRef(imageIndex, channelIndex, emissionFilterRefIndex);
                                if (lightPathEmissionFilterRefValue == null) continue;
                                dest.setLightPathEmissionFilterRef(lightPathEmissionFilterRefValue, imageIndex, channelIndex, emissionFilterRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int excitationFilterRefCount = src.getLightPathExcitationFilterRefCount(imageIndex, channelIndex);
                            for (excitationFilterRefIndex = 0; excitationFilterRefIndex < excitationFilterRefCount; ++excitationFilterRefIndex) {
                                String lightPathExcitationFilterRefValue = src.getLightPathExcitationFilterRef(imageIndex, channelIndex, excitationFilterRefIndex);
                                if (lightPathExcitationFilterRefValue == null) continue;
                                dest.setLightPathExcitationFilterRef(lightPathExcitationFilterRefValue, imageIndex, channelIndex, excitationFilterRefIndex);
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int datasetRefCount = src.getDatasetRefCount(imageIndex);
                    for (int datasetRefIndex = 0; datasetRefIndex < datasetRefCount; ++datasetRefIndex) {
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double imagingEnvironmentAirPressureValue = src.getImagingEnvironmentAirPressure(imageIndex);
                    if (imagingEnvironmentAirPressureValue != null) {
                        dest.setImagingEnvironmentAirPressure(imagingEnvironmentAirPressureValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PercentFraction imagingEnvironmentCO2PercentValue = src.getImagingEnvironmentCO2Percent(imageIndex);
                    if (imagingEnvironmentCO2PercentValue != null) {
                        dest.setImagingEnvironmentCO2Percent(imagingEnvironmentCO2PercentValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PercentFraction imagingEnvironmentHumidityValue = src.getImagingEnvironmentHumidity(imageIndex);
                    if (imagingEnvironmentHumidityValue != null) {
                        dest.setImagingEnvironmentHumidity(imagingEnvironmentHumidityValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double imagingEnvironmentTemperatureValue = src.getImagingEnvironmentTemperature(imageIndex);
                    if (imagingEnvironmentTemperatureValue != null) {
                        dest.setImagingEnvironmentTemperature(imagingEnvironmentTemperatureValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int microbeamManipulationRefCount = src.getMicrobeamManipulationRefCount(imageIndex);
                    for (int microbeamManipulationRefIndex = 0; microbeamManipulationRefIndex < microbeamManipulationRefCount; ++microbeamManipulationRefIndex) {
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int annotationRefCount = src.getPixelsAnnotationRefCount(imageIndex);
                    for (int annotationRefIndex6 = 0; annotationRefIndex6 < annotationRefCount; ++annotationRefIndex6) {
                        String pixelsAnnotationRefValue = src.getPixelsAnnotationRef(imageIndex, annotationRefIndex6);
                        if (pixelsAnnotationRefValue == null) continue;
                        dest.setPixelsAnnotationRef(pixelsAnnotationRefValue, imageIndex, annotationRefIndex6);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    DimensionOrder pixelsDimensionOrderValue = src.getPixelsDimensionOrder(imageIndex);
                    if (pixelsDimensionOrderValue != null) {
                        dest.setPixelsDimensionOrder(pixelsDimensionOrderValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String pixelsIDValue = src.getPixelsID(imageIndex);
                    if (pixelsIDValue != null) {
                        dest.setPixelsID(pixelsIDValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveFloat pixelsPhysicalSizeXValue = src.getPixelsPhysicalSizeX(imageIndex);
                    if (pixelsPhysicalSizeXValue != null) {
                        dest.setPixelsPhysicalSizeX(pixelsPhysicalSizeXValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveFloat pixelsPhysicalSizeYValue = src.getPixelsPhysicalSizeY(imageIndex);
                    if (pixelsPhysicalSizeYValue != null) {
                        dest.setPixelsPhysicalSizeY(pixelsPhysicalSizeYValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveFloat pixelsPhysicalSizeZValue = src.getPixelsPhysicalSizeZ(imageIndex);
                    if (pixelsPhysicalSizeZValue != null) {
                        dest.setPixelsPhysicalSizeZ(pixelsPhysicalSizeZValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger pixelsSizeCValue = src.getPixelsSizeC(imageIndex);
                    if (pixelsSizeCValue != null) {
                        dest.setPixelsSizeC(pixelsSizeCValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger pixelsSizeTValue = src.getPixelsSizeT(imageIndex);
                    if (pixelsSizeTValue != null) {
                        dest.setPixelsSizeT(pixelsSizeTValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger pixelsSizeXValue = src.getPixelsSizeX(imageIndex);
                    if (pixelsSizeXValue != null) {
                        dest.setPixelsSizeX(pixelsSizeXValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger pixelsSizeYValue = src.getPixelsSizeY(imageIndex);
                    if (pixelsSizeYValue != null) {
                        dest.setPixelsSizeY(pixelsSizeYValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger pixelsSizeZValue = src.getPixelsSizeZ(imageIndex);
                    if (pixelsSizeZValue != null) {
                        dest.setPixelsSizeZ(pixelsSizeZValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double pixelsTimeIncrementValue = src.getPixelsTimeIncrement(imageIndex);
                    if (pixelsTimeIncrementValue != null) {
                        dest.setPixelsTimeIncrement(pixelsTimeIncrementValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PixelType pixelsTypeValue = src.getPixelsType(imageIndex);
                    if (pixelsTypeValue != null) {
                        dest.setPixelsType(pixelsTypeValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int binDataCount = src.getPixelsBinDataCount(imageIndex);
                    for (int binDataIndex = 0; binDataIndex < binDataCount; ++binDataIndex) {
                        try {
                            Boolean pixelsBinDataBigEndianValue = src.getPixelsBinDataBigEndian(imageIndex, binDataIndex);
                            if (pixelsBinDataBigEndianValue == null) continue;
                            dest.setPixelsBinDataBigEndian(pixelsBinDataBigEndianValue, imageIndex, binDataIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int planeCount = src.getPlaneCount(imageIndex);
                    for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                        try {
                            int planeAnnotationRefCount = src.getPlaneAnnotationRefCount(imageIndex, planeIndex);
                            for (annotationRefIndex = 0; annotationRefIndex < planeAnnotationRefCount; ++annotationRefIndex) {
                                String planeAnnotationRefValue = src.getPlaneAnnotationRef(imageIndex, planeIndex, annotationRefIndex);
                                if (planeAnnotationRefValue == null) continue;
                                dest.setPlaneAnnotationRef(planeAnnotationRefValue, imageIndex, planeIndex, annotationRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double planeDeltaTValue = src.getPlaneDeltaT(imageIndex, planeIndex);
                            if (planeDeltaTValue != null) {
                                dest.setPlaneDeltaT(planeDeltaTValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double planeExposureTimeValue = src.getPlaneExposureTime(imageIndex, planeIndex);
                            if (planeExposureTimeValue != null) {
                                dest.setPlaneExposureTime(planeExposureTimeValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String planeHashSHA1Value = src.getPlaneHashSHA1(imageIndex, planeIndex);
                            if (planeHashSHA1Value != null) {
                                dest.setPlaneHashSHA1(planeHashSHA1Value, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double planePositionXValue = src.getPlanePositionX(imageIndex, planeIndex);
                            if (planePositionXValue != null) {
                                dest.setPlanePositionX(planePositionXValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double planePositionYValue = src.getPlanePositionY(imageIndex, planeIndex);
                            if (planePositionYValue != null) {
                                dest.setPlanePositionY(planePositionYValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double planePositionZValue = src.getPlanePositionZ(imageIndex, planeIndex);
                            if (planePositionZValue != null) {
                                dest.setPlanePositionZ(planePositionZValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger planeTheCValue = src.getPlaneTheC(imageIndex, planeIndex);
                            if (planeTheCValue != null) {
                                dest.setPlaneTheC(planeTheCValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger planeTheTValue = src.getPlaneTheT(imageIndex, planeIndex);
                            if (planeTheTValue != null) {
                                dest.setPlaneTheT(planeTheTValue, imageIndex, planeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger planeTheZValue = src.getPlaneTheZ(imageIndex, planeIndex);
                            if (planeTheZValue == null) continue;
                            dest.setPlaneTheZ(planeTheZValue, imageIndex, planeIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String stageLabelNameValue = src.getStageLabelName(imageIndex);
                    if (stageLabelNameValue != null) {
                        dest.setStageLabelName(stageLabelNameValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double stageLabelXValue = src.getStageLabelX(imageIndex);
                    if (stageLabelXValue != null) {
                        dest.setStageLabelX(stageLabelXValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double stageLabelYValue = src.getStageLabelY(imageIndex);
                    if (stageLabelYValue != null) {
                        dest.setStageLabelY(stageLabelYValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double stageLabelZValue = src.getStageLabelZ(imageIndex);
                    if (stageLabelZValue != null) {
                        dest.setStageLabelZ(stageLabelZValue, imageIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int tiffDataCount = src.getTiffDataCount(imageIndex);
                    for (int tiffDataIndex = 0; tiffDataIndex < tiffDataCount; ++tiffDataIndex) {
                        try {
                            NonNegativeInteger tiffDataFirstCValue = src.getTiffDataFirstC(imageIndex, tiffDataIndex);
                            if (tiffDataFirstCValue != null) {
                                dest.setTiffDataFirstC(tiffDataFirstCValue, imageIndex, tiffDataIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger tiffDataFirstTValue = src.getTiffDataFirstT(imageIndex, tiffDataIndex);
                            if (tiffDataFirstTValue != null) {
                                dest.setTiffDataFirstT(tiffDataFirstTValue, imageIndex, tiffDataIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger tiffDataFirstZValue = src.getTiffDataFirstZ(imageIndex, tiffDataIndex);
                            if (tiffDataFirstZValue != null) {
                                dest.setTiffDataFirstZ(tiffDataFirstZValue, imageIndex, tiffDataIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger tiffDataIFDValue = src.getTiffDataIFD(imageIndex, tiffDataIndex);
                            if (tiffDataIFDValue != null) {
                                dest.setTiffDataIFD(tiffDataIFDValue, imageIndex, tiffDataIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger tiffDataPlaneCountValue = src.getTiffDataPlaneCount(imageIndex, tiffDataIndex);
                            if (tiffDataPlaneCountValue != null) {
                                dest.setTiffDataPlaneCount(tiffDataPlaneCountValue, imageIndex, tiffDataIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String uuidFileNameValue = src.getUUIDFileName(imageIndex, tiffDataIndex);
                            if (uuidFileNameValue != null) {
                                dest.setUUIDFileName(uuidFileNameValue, imageIndex, tiffDataIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String uuidValueValue = src.getUUIDValue(imageIndex, tiffDataIndex);
                            if (uuidValueValue == null) continue;
                            dest.setUUIDValue(uuidValueValue, imageIndex, tiffDataIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int instrumentCount = src.getInstrumentCount();
            for (int instrumentIndex = 0; instrumentIndex < instrumentCount; ++instrumentIndex) {
                try {
                    String instrumentIDValue = src.getInstrumentID(instrumentIndex);
                    if (instrumentIDValue != null) {
                        dest.setInstrumentID(instrumentIDValue, instrumentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int detectorCount = src.getDetectorCount(instrumentIndex);
                    for (int detectorIndex = 0; detectorIndex < detectorCount; ++detectorIndex) {
                        try {
                            Double detectorAmplificationGainValue = src.getDetectorAmplificationGain(instrumentIndex, detectorIndex);
                            if (detectorAmplificationGainValue != null) {
                                dest.setDetectorAmplificationGain(detectorAmplificationGainValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorGainValue = src.getDetectorGain(instrumentIndex, detectorIndex);
                            if (detectorGainValue != null) {
                                dest.setDetectorGain(detectorGainValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorIDValue = src.getDetectorID(instrumentIndex, detectorIndex);
                            if (detectorIDValue != null) {
                                dest.setDetectorID(detectorIDValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorLotNumberValue = src.getDetectorLotNumber(instrumentIndex, detectorIndex);
                            if (detectorLotNumberValue != null) {
                                dest.setDetectorLotNumber(detectorLotNumberValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorManufacturerValue = src.getDetectorManufacturer(instrumentIndex, detectorIndex);
                            if (detectorManufacturerValue != null) {
                                dest.setDetectorManufacturer(detectorManufacturerValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorModelValue = src.getDetectorModel(instrumentIndex, detectorIndex);
                            if (detectorModelValue != null) {
                                dest.setDetectorModel(detectorModelValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorOffsetValue = src.getDetectorOffset(instrumentIndex, detectorIndex);
                            if (detectorOffsetValue != null) {
                                dest.setDetectorOffset(detectorOffsetValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String detectorSerialNumberValue = src.getDetectorSerialNumber(instrumentIndex, detectorIndex);
                            if (detectorSerialNumberValue != null) {
                                dest.setDetectorSerialNumber(detectorSerialNumberValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            DetectorType detectorTypeValue = src.getDetectorType(instrumentIndex, detectorIndex);
                            if (detectorTypeValue != null) {
                                dest.setDetectorType(detectorTypeValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorVoltageValue = src.getDetectorVoltage(instrumentIndex, detectorIndex);
                            if (detectorVoltageValue != null) {
                                dest.setDetectorVoltage(detectorVoltageValue, instrumentIndex, detectorIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double detectorZoomValue = src.getDetectorZoom(instrumentIndex, detectorIndex);
                            if (detectorZoomValue == null) continue;
                            dest.setDetectorZoom(detectorZoomValue, instrumentIndex, detectorIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int dichroicCount = src.getDichroicCount(instrumentIndex);
                    for (int dichroicIndex = 0; dichroicIndex < dichroicCount; ++dichroicIndex) {
                        try {
                            String dichroicIDValue = src.getDichroicID(instrumentIndex, dichroicIndex);
                            if (dichroicIDValue != null) {
                                dest.setDichroicID(dichroicIDValue, instrumentIndex, dichroicIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String dichroicLotNumberValue = src.getDichroicLotNumber(instrumentIndex, dichroicIndex);
                            if (dichroicLotNumberValue != null) {
                                dest.setDichroicLotNumber(dichroicLotNumberValue, instrumentIndex, dichroicIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String dichroicManufacturerValue = src.getDichroicManufacturer(instrumentIndex, dichroicIndex);
                            if (dichroicManufacturerValue != null) {
                                dest.setDichroicManufacturer(dichroicManufacturerValue, instrumentIndex, dichroicIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String dichroicModelValue = src.getDichroicModel(instrumentIndex, dichroicIndex);
                            if (dichroicModelValue != null) {
                                dest.setDichroicModel(dichroicModelValue, instrumentIndex, dichroicIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String dichroicSerialNumberValue = src.getDichroicSerialNumber(instrumentIndex, dichroicIndex);
                            if (dichroicSerialNumberValue == null) continue;
                            dest.setDichroicSerialNumber(dichroicSerialNumberValue, instrumentIndex, dichroicIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int filterCount = src.getFilterCount(instrumentIndex);
                    for (int filterIndex = 0; filterIndex < filterCount; ++filterIndex) {
                        try {
                            String filterFilterWheelValue = src.getFilterFilterWheel(instrumentIndex, filterIndex);
                            if (filterFilterWheelValue != null) {
                                dest.setFilterFilterWheel(filterFilterWheelValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterIDValue = src.getFilterID(instrumentIndex, filterIndex);
                            if (filterIDValue != null) {
                                dest.setFilterID(filterIDValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterLotNumberValue = src.getFilterLotNumber(instrumentIndex, filterIndex);
                            if (filterLotNumberValue != null) {
                                dest.setFilterLotNumber(filterLotNumberValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterManufacturerValue = src.getFilterManufacturer(instrumentIndex, filterIndex);
                            if (filterManufacturerValue != null) {
                                dest.setFilterManufacturer(filterManufacturerValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterModelValue = src.getFilterModel(instrumentIndex, filterIndex);
                            if (filterModelValue != null) {
                                dest.setFilterModel(filterModelValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSerialNumberValue = src.getFilterSerialNumber(instrumentIndex, filterIndex);
                            if (filterSerialNumberValue != null) {
                                dest.setFilterSerialNumber(filterSerialNumberValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            FilterType filterTypeValue = src.getFilterType(instrumentIndex, filterIndex);
                            if (filterTypeValue != null) {
                                dest.setFilterType(filterTypeValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger transmittanceRangeCutInValue = src.getTransmittanceRangeCutIn(instrumentIndex, filterIndex);
                            if (transmittanceRangeCutInValue != null) {
                                dest.setTransmittanceRangeCutIn(transmittanceRangeCutInValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger transmittanceRangeCutInToleranceValue = src.getTransmittanceRangeCutInTolerance(instrumentIndex, filterIndex);
                            if (transmittanceRangeCutInToleranceValue != null) {
                                dest.setTransmittanceRangeCutInTolerance(transmittanceRangeCutInToleranceValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger transmittanceRangeCutOutValue = src.getTransmittanceRangeCutOut(instrumentIndex, filterIndex);
                            if (transmittanceRangeCutOutValue != null) {
                                dest.setTransmittanceRangeCutOut(transmittanceRangeCutOutValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger transmittanceRangeCutOutToleranceValue = src.getTransmittanceRangeCutOutTolerance(instrumentIndex, filterIndex);
                            if (transmittanceRangeCutOutToleranceValue != null) {
                                dest.setTransmittanceRangeCutOutTolerance(transmittanceRangeCutOutToleranceValue, instrumentIndex, filterIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PercentFraction transmittanceRangeTransmittanceValue = src.getTransmittanceRangeTransmittance(instrumentIndex, filterIndex);
                            if (transmittanceRangeTransmittanceValue == null) continue;
                            dest.setTransmittanceRangeTransmittance(transmittanceRangeTransmittanceValue, instrumentIndex, filterIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int filterSetCount = src.getFilterSetCount(instrumentIndex);
                    for (int filterSetIndex = 0; filterSetIndex < filterSetCount; ++filterSetIndex) {
                        try {
                            String filterSetIDValue = src.getFilterSetID(instrumentIndex, filterSetIndex);
                            if (filterSetIDValue != null) {
                                dest.setFilterSetID(filterSetIDValue, instrumentIndex, filterSetIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSetLotNumberValue = src.getFilterSetLotNumber(instrumentIndex, filterSetIndex);
                            if (filterSetLotNumberValue != null) {
                                dest.setFilterSetLotNumber(filterSetLotNumberValue, instrumentIndex, filterSetIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSetManufacturerValue = src.getFilterSetManufacturer(instrumentIndex, filterSetIndex);
                            if (filterSetManufacturerValue != null) {
                                dest.setFilterSetManufacturer(filterSetManufacturerValue, instrumentIndex, filterSetIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSetModelValue = src.getFilterSetModel(instrumentIndex, filterSetIndex);
                            if (filterSetModelValue != null) {
                                dest.setFilterSetModel(filterSetModelValue, instrumentIndex, filterSetIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSetSerialNumberValue = src.getFilterSetSerialNumber(instrumentIndex, filterSetIndex);
                            if (filterSetSerialNumberValue != null) {
                                dest.setFilterSetSerialNumber(filterSetSerialNumberValue, instrumentIndex, filterSetIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String filterSetDichroicRefValue = src.getFilterSetDichroicRef(instrumentIndex, filterSetIndex);
                            if (filterSetDichroicRefValue != null) {
                                dest.setFilterSetDichroicRef(filterSetDichroicRefValue, instrumentIndex, filterSetIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int emissionFilterRefCount = src.getFilterSetEmissionFilterRefCount(instrumentIndex, filterSetIndex);
                            for (emissionFilterRefIndex = 0; emissionFilterRefIndex < emissionFilterRefCount; ++emissionFilterRefIndex) {
                                String filterSetEmissionFilterRefValue = src.getFilterSetEmissionFilterRef(instrumentIndex, filterSetIndex, emissionFilterRefIndex);
                                if (filterSetEmissionFilterRefValue == null) continue;
                                dest.setFilterSetEmissionFilterRef(filterSetEmissionFilterRefValue, instrumentIndex, filterSetIndex, emissionFilterRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int excitationFilterRefCount = src.getFilterSetExcitationFilterRefCount(instrumentIndex, filterSetIndex);
                            for (excitationFilterRefIndex = 0; excitationFilterRefIndex < excitationFilterRefCount; ++excitationFilterRefIndex) {
                                String filterSetExcitationFilterRefValue = src.getFilterSetExcitationFilterRef(instrumentIndex, filterSetIndex, excitationFilterRefIndex);
                                if (filterSetExcitationFilterRefValue == null) continue;
                                dest.setFilterSetExcitationFilterRef(filterSetExcitationFilterRefValue, instrumentIndex, filterSetIndex, excitationFilterRefIndex);
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String microscopeLotNumberValue = src.getMicroscopeLotNumber(instrumentIndex);
                    if (microscopeLotNumberValue != null) {
                        dest.setMicroscopeLotNumber(microscopeLotNumberValue, instrumentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String microscopeManufacturerValue = src.getMicroscopeManufacturer(instrumentIndex);
                    if (microscopeManufacturerValue != null) {
                        dest.setMicroscopeManufacturer(microscopeManufacturerValue, instrumentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String microscopeModelValue = src.getMicroscopeModel(instrumentIndex);
                    if (microscopeModelValue != null) {
                        dest.setMicroscopeModel(microscopeModelValue, instrumentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String microscopeSerialNumberValue = src.getMicroscopeSerialNumber(instrumentIndex);
                    if (microscopeSerialNumberValue != null) {
                        dest.setMicroscopeSerialNumber(microscopeSerialNumberValue, instrumentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    MicroscopeType microscopeTypeValue = src.getMicroscopeType(instrumentIndex);
                    if (microscopeTypeValue != null) {
                        dest.setMicroscopeType(microscopeTypeValue, instrumentIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int otfCount = src.getOTFCount(instrumentIndex);
                    for (int otfIndex = 0; otfIndex < otfCount; ++otfIndex) {
                        try {
                            String otfBinaryFileFileNameValue = src.getOTFBinaryFileFileName(instrumentIndex, otfIndex);
                            if (otfBinaryFileFileNameValue != null) {
                                dest.setOTFBinaryFileFileName(otfBinaryFileFileNameValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String otfBinaryFileMIMETypeValue = src.getOTFBinaryFileMIMEType(instrumentIndex, otfIndex);
                            if (otfBinaryFileMIMETypeValue != null) {
                                dest.setOTFBinaryFileMIMEType(otfBinaryFileMIMETypeValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeLong otfBinaryFileSizeValue = src.getOTFBinaryFileSize(instrumentIndex, otfIndex);
                            if (otfBinaryFileSizeValue != null) {
                                dest.setOTFBinaryFileSize(otfBinaryFileSizeValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String otfFilterSetRefValue = src.getOTFFilterSetRef(instrumentIndex, otfIndex);
                            if (otfFilterSetRefValue != null) {
                                dest.setOTFFilterSetRef(otfFilterSetRefValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String otfidValue = src.getOTFID(instrumentIndex, otfIndex);
                            if (otfidValue != null) {
                                dest.setOTFID(otfidValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double otfObjectiveSettingsCorrectionCollarValue = src.getOTFObjectiveSettingsCorrectionCollar(instrumentIndex, otfIndex);
                            if (otfObjectiveSettingsCorrectionCollarValue != null) {
                                dest.setOTFObjectiveSettingsCorrectionCollar(otfObjectiveSettingsCorrectionCollarValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String otfObjectiveSettingsIDValue = src.getOTFObjectiveSettingsID(instrumentIndex, otfIndex);
                            if (otfObjectiveSettingsIDValue != null) {
                                dest.setOTFObjectiveSettingsID(otfObjectiveSettingsIDValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Medium otfObjectiveSettingsMediumValue = src.getOTFObjectiveSettingsMedium(instrumentIndex, otfIndex);
                            if (otfObjectiveSettingsMediumValue != null) {
                                dest.setOTFObjectiveSettingsMedium(otfObjectiveSettingsMediumValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double otfObjectiveSettingsRefractiveIndexValue = src.getOTFObjectiveSettingsRefractiveIndex(instrumentIndex, otfIndex);
                            if (otfObjectiveSettingsRefractiveIndexValue != null) {
                                dest.setOTFObjectiveSettingsRefractiveIndex(otfObjectiveSettingsRefractiveIndexValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Boolean otfOpticalAxisAveragedValue = src.getOTFOpticalAxisAveraged(instrumentIndex, otfIndex);
                            if (otfOpticalAxisAveragedValue != null) {
                                dest.setOTFOpticalAxisAveraged(otfOpticalAxisAveragedValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger otfSizeXValue = src.getOTFSizeX(instrumentIndex, otfIndex);
                            if (otfSizeXValue != null) {
                                dest.setOTFSizeX(otfSizeXValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger otfSizeYValue = src.getOTFSizeY(instrumentIndex, otfIndex);
                            if (otfSizeYValue != null) {
                                dest.setOTFSizeY(otfSizeYValue, instrumentIndex, otfIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PixelType otfTypeValue = src.getOTFType(instrumentIndex, otfIndex);
                            if (otfTypeValue == null) continue;
                            dest.setOTFType(otfTypeValue, instrumentIndex, otfIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int objectiveCount = src.getObjectiveCount(instrumentIndex);
                    for (int objectiveIndex = 0; objectiveIndex < objectiveCount; ++objectiveIndex) {
                        try {
                            Double objectiveCalibratedMagnificationValue = src.getObjectiveCalibratedMagnification(instrumentIndex, objectiveIndex);
                            if (objectiveCalibratedMagnificationValue != null) {
                                dest.setObjectiveCalibratedMagnification(objectiveCalibratedMagnificationValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Correction objectiveCorrectionValue = src.getObjectiveCorrection(instrumentIndex, objectiveIndex);
                            if (objectiveCorrectionValue != null) {
                                dest.setObjectiveCorrection(objectiveCorrectionValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String objectiveIDValue = src.getObjectiveID(instrumentIndex, objectiveIndex);
                            if (objectiveIDValue != null) {
                                dest.setObjectiveID(objectiveIDValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Immersion objectiveImmersionValue = src.getObjectiveImmersion(instrumentIndex, objectiveIndex);
                            if (objectiveImmersionValue != null) {
                                dest.setObjectiveImmersion(objectiveImmersionValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Boolean objectiveIrisValue = src.getObjectiveIris(instrumentIndex, objectiveIndex);
                            if (objectiveIrisValue != null) {
                                dest.setObjectiveIris(objectiveIrisValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double objectiveLensNAValue = src.getObjectiveLensNA(instrumentIndex, objectiveIndex);
                            if (objectiveLensNAValue != null) {
                                dest.setObjectiveLensNA(objectiveLensNAValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String objectiveLotNumberValue = src.getObjectiveLotNumber(instrumentIndex, objectiveIndex);
                            if (objectiveLotNumberValue != null) {
                                dest.setObjectiveLotNumber(objectiveLotNumberValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String objectiveManufacturerValue = src.getObjectiveManufacturer(instrumentIndex, objectiveIndex);
                            if (objectiveManufacturerValue != null) {
                                dest.setObjectiveManufacturer(objectiveManufacturerValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String objectiveModelValue = src.getObjectiveModel(instrumentIndex, objectiveIndex);
                            if (objectiveModelValue != null) {
                                dest.setObjectiveModel(objectiveModelValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger objectiveNominalMagnificationValue = src.getObjectiveNominalMagnification(instrumentIndex, objectiveIndex);
                            if (objectiveNominalMagnificationValue != null) {
                                dest.setObjectiveNominalMagnification(objectiveNominalMagnificationValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String objectiveSerialNumberValue = src.getObjectiveSerialNumber(instrumentIndex, objectiveIndex);
                            if (objectiveSerialNumberValue != null) {
                                dest.setObjectiveSerialNumber(objectiveSerialNumberValue, instrumentIndex, objectiveIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Double objectiveWorkingDistanceValue = src.getObjectiveWorkingDistance(instrumentIndex, objectiveIndex);
                            if (objectiveWorkingDistanceValue == null) continue;
                            dest.setObjectiveWorkingDistance(objectiveWorkingDistanceValue, instrumentIndex, objectiveIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                MetadataConverter.convertLightSources(src, dest, instrumentIndex);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int listAnnotationCount = src.getListAnnotationCount();
            for (int listAnnotationIndex = 0; listAnnotationIndex < listAnnotationCount; ++listAnnotationIndex) {
                try {
                    String listAnnotationIDValue = src.getListAnnotationID(listAnnotationIndex);
                    if (listAnnotationIDValue != null) {
                        dest.setListAnnotationID(listAnnotationIDValue, listAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String listAnnotationNamespaceValue = src.getListAnnotationNamespace(listAnnotationIndex);
                    if (listAnnotationNamespaceValue == null) continue;
                    dest.setListAnnotationNamespace(listAnnotationNamespaceValue, listAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int longAnnotationCount = src.getLongAnnotationCount();
            for (int longAnnotationIndex = 0; longAnnotationIndex < longAnnotationCount; ++longAnnotationIndex) {
                try {
                    String longAnnotationIDValue = src.getLongAnnotationID(longAnnotationIndex);
                    if (longAnnotationIDValue != null) {
                        dest.setLongAnnotationID(longAnnotationIDValue, longAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String longAnnotationNamespaceValue = src.getLongAnnotationNamespace(longAnnotationIndex);
                    if (longAnnotationNamespaceValue != null) {
                        dest.setLongAnnotationNamespace(longAnnotationNamespaceValue, longAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Long longAnnotationValueValue = src.getLongAnnotationValue(longAnnotationIndex);
                    if (longAnnotationValueValue == null) continue;
                    dest.setLongAnnotationValue(longAnnotationValueValue, longAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int plateCount = src.getPlateCount();
            for (int plateIndex = 0; plateIndex < plateCount; ++plateIndex) {
                try {
                    int annotationRefCount = src.getPlateAnnotationRefCount(plateIndex);
                    for (int annotationRefIndex7 = 0; annotationRefIndex7 < annotationRefCount; ++annotationRefIndex7) {
                        String plateAnnotationRefValue = src.getPlateAnnotationRef(plateIndex, annotationRefIndex7);
                        if (plateAnnotationRefValue == null) continue;
                        dest.setPlateAnnotationRef(plateAnnotationRefValue, plateIndex, annotationRefIndex7);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NamingConvention plateColumnNamingConventionValue = src.getPlateColumnNamingConvention(plateIndex);
                    if (plateColumnNamingConventionValue != null) {
                        dest.setPlateColumnNamingConvention(plateColumnNamingConventionValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger plateColumnsValue = src.getPlateColumns(plateIndex);
                    if (plateColumnsValue != null) {
                        dest.setPlateColumns(plateColumnsValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String plateDescriptionValue = src.getPlateDescription(plateIndex);
                    if (plateDescriptionValue != null) {
                        dest.setPlateDescription(plateDescriptionValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String plateExternalIdentifierValue = src.getPlateExternalIdentifier(plateIndex);
                    if (plateExternalIdentifierValue != null) {
                        dest.setPlateExternalIdentifier(plateExternalIdentifierValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String plateIDValue = src.getPlateID(plateIndex);
                    if (plateIDValue != null) {
                        dest.setPlateID(plateIDValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String plateNameValue = src.getPlateName(plateIndex);
                    if (plateNameValue != null) {
                        dest.setPlateName(plateNameValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    NamingConvention plateRowNamingConventionValue = src.getPlateRowNamingConvention(plateIndex);
                    if (plateRowNamingConventionValue != null) {
                        dest.setPlateRowNamingConvention(plateRowNamingConventionValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger plateRowsValue = src.getPlateRows(plateIndex);
                    if (plateRowsValue != null) {
                        dest.setPlateRows(plateRowsValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int screenRefCount = src.getScreenRefCount(plateIndex);
                    for (int screenRefIndex = 0; screenRefIndex < screenRefCount; ++screenRefIndex) {
                        String plateScreenRefValue = src.getPlateScreenRef(plateIndex, screenRefIndex);
                        if (plateScreenRefValue == null) continue;
                        dest.setPlateScreenRef(plateScreenRefValue, plateIndex, screenRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String plateStatusValue = src.getPlateStatus(plateIndex);
                    if (plateStatusValue != null) {
                        dest.setPlateStatus(plateStatusValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double plateWellOriginXValue = src.getPlateWellOriginX(plateIndex);
                    if (plateWellOriginXValue != null) {
                        dest.setPlateWellOriginX(plateWellOriginXValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double plateWellOriginYValue = src.getPlateWellOriginY(plateIndex);
                    if (plateWellOriginYValue != null) {
                        dest.setPlateWellOriginY(plateWellOriginYValue, plateIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int plateAcquisitionCount = src.getPlateAcquisitionCount(plateIndex);
                    for (int plateAcquisitionIndex = 0; plateAcquisitionIndex < plateAcquisitionCount; ++plateAcquisitionIndex) {
                        try {
                            int annotationRefCount = src.getPlateAcquisitionAnnotationRefCount(plateIndex, plateAcquisitionIndex);
                            for (annotationRefIndex = 0; annotationRefIndex < annotationRefCount; ++annotationRefIndex) {
                                String plateAcquisitionAnnotationRefValue = src.getPlateAcquisitionAnnotationRef(plateIndex, plateAcquisitionIndex, annotationRefIndex);
                                if (plateAcquisitionAnnotationRefValue == null) continue;
                                dest.setPlateAcquisitionAnnotationRef(plateAcquisitionAnnotationRefValue, plateIndex, plateAcquisitionIndex, annotationRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String plateAcquisitionDescriptionValue = src.getPlateAcquisitionDescription(plateIndex, plateAcquisitionIndex);
                            if (plateAcquisitionDescriptionValue != null) {
                                dest.setPlateAcquisitionDescription(plateAcquisitionDescriptionValue, plateIndex, plateAcquisitionIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String plateAcquisitionEndTimeValue = src.getPlateAcquisitionEndTime(plateIndex, plateAcquisitionIndex);
                            if (plateAcquisitionEndTimeValue != null) {
                                dest.setPlateAcquisitionEndTime(plateAcquisitionEndTimeValue, plateIndex, plateAcquisitionIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String plateAcquisitionIDValue = src.getPlateAcquisitionID(plateIndex, plateAcquisitionIndex);
                            if (plateAcquisitionIDValue != null) {
                                dest.setPlateAcquisitionID(plateAcquisitionIDValue, plateIndex, plateAcquisitionIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            PositiveInteger plateAcquisitionMaximumFieldCountValue = src.getPlateAcquisitionMaximumFieldCount(plateIndex, plateAcquisitionIndex);
                            if (plateAcquisitionMaximumFieldCountValue != null) {
                                dest.setPlateAcquisitionMaximumFieldCount(plateAcquisitionMaximumFieldCountValue, plateIndex, plateAcquisitionIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String plateAcquisitionNameValue = src.getPlateAcquisitionName(plateIndex, plateAcquisitionIndex);
                            if (plateAcquisitionNameValue != null) {
                                dest.setPlateAcquisitionName(plateAcquisitionNameValue, plateIndex, plateAcquisitionIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String plateAcquisitionStartTimeValue = src.getPlateAcquisitionStartTime(plateIndex, plateAcquisitionIndex);
                            if (plateAcquisitionStartTimeValue != null) {
                                dest.setPlateAcquisitionStartTime(plateAcquisitionStartTimeValue, plateIndex, plateAcquisitionIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int wellSampleRefCount = src.getWellSampleRefCount(plateIndex, plateAcquisitionIndex);
                            for (int wellSampleRefIndex = 0; wellSampleRefIndex < wellSampleRefCount; ++wellSampleRefIndex) {
                                String plateAcquisitionWellSampleRefValue = src.getPlateAcquisitionWellSampleRef(plateIndex, plateAcquisitionIndex, wellSampleRefIndex);
                                if (plateAcquisitionWellSampleRefValue == null) continue;
                                dest.setPlateAcquisitionWellSampleRef(plateAcquisitionWellSampleRefValue, plateIndex, plateAcquisitionIndex, wellSampleRefIndex);
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int wellCount = src.getWellCount(plateIndex);
                    for (int wellIndex = 0; wellIndex < wellCount; ++wellIndex) {
                        try {
                            int annotationRefCount = src.getWellAnnotationRefCount(plateIndex, wellIndex);
                            for (annotationRefIndex = 0; annotationRefIndex < annotationRefCount; ++annotationRefIndex) {
                                String wellAnnotationRefValue = src.getWellAnnotationRef(plateIndex, wellIndex, annotationRefIndex);
                                if (wellAnnotationRefValue == null) continue;
                                dest.setWellAnnotationRef(wellAnnotationRefValue, plateIndex, wellIndex, annotationRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            Integer wellColorValue = src.getWellColor(plateIndex, wellIndex);
                            if (wellColorValue != null) {
                                dest.setWellColor(wellColorValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger wellColumnValue = src.getWellColumn(plateIndex, wellIndex);
                            if (wellColumnValue != null) {
                                dest.setWellColumn(wellColumnValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String wellExternalDescriptionValue = src.getWellExternalDescription(plateIndex, wellIndex);
                            if (wellExternalDescriptionValue != null) {
                                dest.setWellExternalDescription(wellExternalDescriptionValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String wellExternalIdentifierValue = src.getWellExternalIdentifier(plateIndex, wellIndex);
                            if (wellExternalIdentifierValue != null) {
                                dest.setWellExternalIdentifier(wellExternalIdentifierValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String wellIDValue = src.getWellID(plateIndex, wellIndex);
                            if (wellIDValue != null) {
                                dest.setWellID(wellIDValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String wellReagentRefValue = src.getWellReagentRef(plateIndex, wellIndex);
                            if (wellReagentRefValue != null) {
                                dest.setWellReagentRef(wellReagentRefValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger wellRowValue = src.getWellRow(plateIndex, wellIndex);
                            if (wellRowValue != null) {
                                dest.setWellRow(wellRowValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String wellStatusValue = src.getWellStatus(plateIndex, wellIndex);
                            if (wellStatusValue != null) {
                                dest.setWellStatus(wellStatusValue, plateIndex, wellIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            int wellSampleCount = src.getWellSampleCount(plateIndex, wellIndex);
                            for (int wellSampleIndex = 0; wellSampleIndex < wellSampleCount; ++wellSampleIndex) {
                                try {
                                    int annotationRefCount = src.getWellSampleAnnotationRefCount(plateIndex, wellIndex, wellSampleIndex);
                                    for (int annotationRefIndex8 = 0; annotationRefIndex8 < annotationRefCount; ++annotationRefIndex8) {
                                        String wellSampleAnnotationRefValue = src.getWellSampleAnnotationRef(plateIndex, wellIndex, wellSampleIndex, annotationRefIndex8);
                                        if (wellSampleAnnotationRefValue == null) continue;
                                        dest.setWellSampleAnnotationRef(wellSampleAnnotationRefValue, plateIndex, wellIndex, wellSampleIndex, annotationRefIndex8);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    String wellSampleIDValue = src.getWellSampleID(plateIndex, wellIndex, wellSampleIndex);
                                    if (wellSampleIDValue != null) {
                                        dest.setWellSampleID(wellSampleIDValue, plateIndex, wellIndex, wellSampleIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    String wellSampleImageRefValue = src.getWellSampleImageRef(plateIndex, wellIndex, wellSampleIndex);
                                    if (wellSampleImageRefValue != null) {
                                        dest.setWellSampleImageRef(wellSampleImageRefValue, plateIndex, wellIndex, wellSampleIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    NonNegativeInteger wellSampleIndexValue = src.getWellSampleIndex(plateIndex, wellIndex, wellSampleIndex);
                                    if (wellSampleIndexValue != null) {
                                        dest.setWellSampleIndex(wellSampleIndexValue, plateIndex, wellIndex, wellSampleIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    Double wellSamplePositionXValue = src.getWellSamplePositionX(plateIndex, wellIndex, wellSampleIndex);
                                    if (wellSamplePositionXValue != null) {
                                        dest.setWellSamplePositionX(wellSamplePositionXValue, plateIndex, wellIndex, wellSampleIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    Double wellSamplePositionYValue = src.getWellSamplePositionY(plateIndex, wellIndex, wellSampleIndex);
                                    if (wellSamplePositionYValue != null) {
                                        dest.setWellSamplePositionY(wellSamplePositionYValue, plateIndex, wellIndex, wellSampleIndex);
                                    }
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                                try {
                                    String wellSampleTimepointValue = src.getWellSampleTimepoint(plateIndex, wellIndex, wellSampleIndex);
                                    if (wellSampleTimepointValue == null) continue;
                                    dest.setWellSampleTimepoint(wellSampleTimepointValue, plateIndex, wellIndex, wellSampleIndex);
                                    continue;
                                }
                                catch (NullPointerException e) {
                                    // empty catch block
                                }
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int projectCount = src.getProjectCount();
            for (int projectIndex = 0; projectIndex < projectCount; ++projectIndex) {
                try {
                    String projectIDValue = src.getProjectID(projectIndex);
                    if (projectIDValue != null) {
                        dest.setProjectID(projectIDValue, projectIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int annotationRefCount = src.getProjectAnnotationRefCount(projectIndex);
                    for (int annotationRefIndex9 = 0; annotationRefIndex9 < annotationRefCount; ++annotationRefIndex9) {
                        String projectAnnotationRefValue = src.getProjectAnnotationRef(projectIndex, annotationRefIndex9);
                        if (projectAnnotationRefValue == null) continue;
                        dest.setProjectAnnotationRef(projectAnnotationRefValue, projectIndex, annotationRefIndex9);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String projectDescriptionValue = src.getProjectDescription(projectIndex);
                    if (projectDescriptionValue != null) {
                        dest.setProjectDescription(projectDescriptionValue, projectIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String projectExperimenterRefValue = src.getProjectExperimenterRef(projectIndex);
                    if (projectExperimenterRefValue != null) {
                        dest.setProjectExperimenterRef(projectExperimenterRefValue, projectIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String projectGroupRefValue = src.getProjectGroupRef(projectIndex);
                    if (projectGroupRefValue != null) {
                        dest.setProjectGroupRef(projectGroupRefValue, projectIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String projectNameValue = src.getProjectName(projectIndex);
                    if (projectNameValue == null) continue;
                    dest.setProjectName(projectNameValue, projectIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int roiCount = src.getROICount();
            for (int roiIndex = 0; roiIndex < roiCount; ++roiIndex) {
                try {
                    int annotationRefCount = src.getROIAnnotationRefCount(roiIndex);
                    for (int annotationRefIndex10 = 0; annotationRefIndex10 < annotationRefCount; ++annotationRefIndex10) {
                        String roiAnnotationRefValue = src.getROIAnnotationRef(roiIndex, annotationRefIndex10);
                        if (roiAnnotationRefValue == null) continue;
                        dest.setROIAnnotationRef(roiAnnotationRefValue, roiIndex, annotationRefIndex10);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String roiDescriptionValue = src.getROIDescription(roiIndex);
                    if (roiDescriptionValue != null) {
                        dest.setROIDescription(roiDescriptionValue, roiIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String roiidValue = src.getROIID(roiIndex);
                    if (roiidValue != null) {
                        dest.setROIID(roiidValue, roiIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String roiNameValue = src.getROIName(roiIndex);
                    if (roiNameValue != null) {
                        dest.setROIName(roiNameValue, roiIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String roiNamespaceValue = src.getROINamespace(roiIndex);
                    if (roiNamespaceValue != null) {
                        dest.setROINamespace(roiNamespaceValue, roiIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int shapeCount = src.getShapeCount(roiIndex);
                    for (int shapeIndex = 0; shapeIndex < shapeCount; ++shapeIndex) {
                        try {
                            String ellipseDescriptionValue = src.getEllipseDescription(roiIndex, shapeIndex);
                            if (ellipseDescriptionValue != null) {
                                dest.setEllipseDescription(ellipseDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer ellipseFillValue = src.getEllipseFill(roiIndex, shapeIndex);
                            if (ellipseFillValue != null) {
                                dest.setEllipseFill(ellipseFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger ellipseFontSizeValue = src.getEllipseFontSize(roiIndex, shapeIndex);
                            if (ellipseFontSizeValue != null) {
                                dest.setEllipseFontSize(ellipseFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String ellipseIDValue = src.getEllipseID(roiIndex, shapeIndex);
                            if (ellipseIDValue != null) {
                                dest.setEllipseID(ellipseIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String ellipseLabelValue = src.getEllipseLabel(roiIndex, shapeIndex);
                            if (ellipseLabelValue != null) {
                                dest.setEllipseLabel(ellipseLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String ellipseNameValue = src.getEllipseName(roiIndex, shapeIndex);
                            if (ellipseNameValue != null) {
                                dest.setEllipseName(ellipseNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double ellipseRadiusXValue = src.getEllipseRadiusX(roiIndex, shapeIndex);
                            if (ellipseRadiusXValue != null) {
                                dest.setEllipseRadiusX(ellipseRadiusXValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double ellipseRadiusYValue = src.getEllipseRadiusY(roiIndex, shapeIndex);
                            if (ellipseRadiusYValue != null) {
                                dest.setEllipseRadiusY(ellipseRadiusYValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer ellipseStrokeValue = src.getEllipseStroke(roiIndex, shapeIndex);
                            if (ellipseStrokeValue != null) {
                                dest.setEllipseStroke(ellipseStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String ellipseStrokeDashArrayValue = src.getEllipseStrokeDashArray(roiIndex, shapeIndex);
                            if (ellipseStrokeDashArrayValue != null) {
                                dest.setEllipseStrokeDashArray(ellipseStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double ellipseStrokeWidthValue = src.getEllipseStrokeWidth(roiIndex, shapeIndex);
                            if (ellipseStrokeWidthValue != null) {
                                dest.setEllipseStrokeWidth(ellipseStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger ellipseTheCValue = src.getEllipseTheC(roiIndex, shapeIndex);
                            if (ellipseTheCValue != null) {
                                dest.setEllipseTheC(ellipseTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger ellipseTheTValue = src.getEllipseTheT(roiIndex, shapeIndex);
                            if (ellipseTheTValue != null) {
                                dest.setEllipseTheT(ellipseTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger ellipseTheZValue = src.getEllipseTheZ(roiIndex, shapeIndex);
                            if (ellipseTheZValue != null) {
                                dest.setEllipseTheZ(ellipseTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String ellipseTransformValue = src.getEllipseTransform(roiIndex, shapeIndex);
                            if (ellipseTransformValue != null) {
                                dest.setEllipseTransform(ellipseTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double ellipseXValue = src.getEllipseX(roiIndex, shapeIndex);
                            if (ellipseXValue != null) {
                                dest.setEllipseX(ellipseXValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double ellipseYValue = src.getEllipseY(roiIndex, shapeIndex);
                            if (ellipseYValue != null) {
                                dest.setEllipseY(ellipseYValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String lineDescriptionValue = src.getLineDescription(roiIndex, shapeIndex);
                            if (lineDescriptionValue != null) {
                                dest.setLineDescription(lineDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer lineFillValue = src.getLineFill(roiIndex, shapeIndex);
                            if (lineFillValue != null) {
                                dest.setLineFill(lineFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger lineFontSizeValue = src.getLineFontSize(roiIndex, shapeIndex);
                            if (lineFontSizeValue != null) {
                                dest.setLineFontSize(lineFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String lineIDValue = src.getLineID(roiIndex, shapeIndex);
                            if (lineIDValue != null) {
                                dest.setLineID(lineIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String lineLabelValue = src.getLineLabel(roiIndex, shapeIndex);
                            if (lineLabelValue != null) {
                                dest.setLineLabel(lineLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String lineNameValue = src.getLineName(roiIndex, shapeIndex);
                            if (lineNameValue != null) {
                                dest.setLineName(lineNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer lineStrokeValue = src.getLineStroke(roiIndex, shapeIndex);
                            if (lineStrokeValue != null) {
                                dest.setLineStroke(lineStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String lineStrokeDashArrayValue = src.getLineStrokeDashArray(roiIndex, shapeIndex);
                            if (lineStrokeDashArrayValue != null) {
                                dest.setLineStrokeDashArray(lineStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double lineStrokeWidthValue = src.getLineStrokeWidth(roiIndex, shapeIndex);
                            if (lineStrokeWidthValue != null) {
                                dest.setLineStrokeWidth(lineStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger lineTheCValue = src.getLineTheC(roiIndex, shapeIndex);
                            if (lineTheCValue != null) {
                                dest.setLineTheC(lineTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger lineTheTValue = src.getLineTheT(roiIndex, shapeIndex);
                            if (lineTheTValue != null) {
                                dest.setLineTheT(lineTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger lineTheZValue = src.getLineTheZ(roiIndex, shapeIndex);
                            if (lineTheZValue != null) {
                                dest.setLineTheZ(lineTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String lineTransformValue = src.getLineTransform(roiIndex, shapeIndex);
                            if (lineTransformValue != null) {
                                dest.setLineTransform(lineTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double lineX1Value = src.getLineX1(roiIndex, shapeIndex);
                            if (lineX1Value != null) {
                                dest.setLineX1(lineX1Value, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double lineX2Value = src.getLineX2(roiIndex, shapeIndex);
                            if (lineX2Value != null) {
                                dest.setLineX2(lineX2Value, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double lineY1Value = src.getLineY1(roiIndex, shapeIndex);
                            if (lineY1Value != null) {
                                dest.setLineY1(lineY1Value, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double lineY2Value = src.getLineY2(roiIndex, shapeIndex);
                            if (lineY2Value != null) {
                                dest.setLineY2(lineY2Value, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String maskDescriptionValue = src.getMaskDescription(roiIndex, shapeIndex);
                            if (maskDescriptionValue != null) {
                                dest.setMaskDescription(maskDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer maskFillValue = src.getMaskFill(roiIndex, shapeIndex);
                            if (maskFillValue != null) {
                                dest.setMaskFill(maskFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger maskFontSizeValue = src.getMaskFontSize(roiIndex, shapeIndex);
                            if (maskFontSizeValue != null) {
                                dest.setMaskFontSize(maskFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String maskIDValue = src.getMaskID(roiIndex, shapeIndex);
                            if (maskIDValue != null) {
                                dest.setMaskID(maskIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String maskLabelValue = src.getMaskLabel(roiIndex, shapeIndex);
                            if (maskLabelValue != null) {
                                dest.setMaskLabel(maskLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String maskNameValue = src.getMaskName(roiIndex, shapeIndex);
                            if (maskNameValue != null) {
                                dest.setMaskName(maskNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer maskStrokeValue = src.getMaskStroke(roiIndex, shapeIndex);
                            if (maskStrokeValue != null) {
                                dest.setMaskStroke(maskStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String maskStrokeDashArrayValue = src.getMaskStrokeDashArray(roiIndex, shapeIndex);
                            if (maskStrokeDashArrayValue != null) {
                                dest.setMaskStrokeDashArray(maskStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double maskStrokeWidthValue = src.getMaskStrokeWidth(roiIndex, shapeIndex);
                            if (maskStrokeWidthValue != null) {
                                dest.setMaskStrokeWidth(maskStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger maskTheCValue = src.getMaskTheC(roiIndex, shapeIndex);
                            if (maskTheCValue != null) {
                                dest.setMaskTheC(maskTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger maskTheTValue = src.getMaskTheT(roiIndex, shapeIndex);
                            if (maskTheTValue != null) {
                                dest.setMaskTheT(maskTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger maskTheZValue = src.getMaskTheZ(roiIndex, shapeIndex);
                            if (maskTheZValue != null) {
                                dest.setMaskTheZ(maskTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String maskTransformValue = src.getMaskTransform(roiIndex, shapeIndex);
                            if (maskTransformValue != null) {
                                dest.setMaskTransform(maskTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double maskXValue = src.getMaskX(roiIndex, shapeIndex);
                            if (maskXValue != null) {
                                dest.setMaskX(maskXValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double maskYValue = src.getMaskY(roiIndex, shapeIndex);
                            if (maskYValue != null) {
                                dest.setMaskY(maskYValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathDefinitionValue = src.getPathDefinition(roiIndex, shapeIndex);
                            if (pathDefinitionValue != null) {
                                dest.setPathDefinition(pathDefinitionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathDescriptionValue = src.getPathDescription(roiIndex, shapeIndex);
                            if (pathDescriptionValue != null) {
                                dest.setPathDescription(pathDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer pathFillValue = src.getPathFill(roiIndex, shapeIndex);
                            if (pathFillValue != null) {
                                dest.setPathFill(pathFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pathFontSizeValue = src.getPathFontSize(roiIndex, shapeIndex);
                            if (pathFontSizeValue != null) {
                                dest.setPathFontSize(pathFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathIDValue = src.getPathID(roiIndex, shapeIndex);
                            if (pathIDValue != null) {
                                dest.setPathID(pathIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathLabelValue = src.getPathLabel(roiIndex, shapeIndex);
                            if (pathLabelValue != null) {
                                dest.setPathLabel(pathLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathNameValue = src.getPathName(roiIndex, shapeIndex);
                            if (pathNameValue != null) {
                                dest.setPathName(pathNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer pathStrokeValue = src.getPathStroke(roiIndex, shapeIndex);
                            if (pathStrokeValue != null) {
                                dest.setPathStroke(pathStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathStrokeDashArrayValue = src.getPathStrokeDashArray(roiIndex, shapeIndex);
                            if (pathStrokeDashArrayValue != null) {
                                dest.setPathStrokeDashArray(pathStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double pathStrokeWidthValue = src.getPathStrokeWidth(roiIndex, shapeIndex);
                            if (pathStrokeWidthValue != null) {
                                dest.setPathStrokeWidth(pathStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pathTheCValue = src.getPathTheC(roiIndex, shapeIndex);
                            if (pathTheCValue != null) {
                                dest.setPathTheC(pathTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pathTheTValue = src.getPathTheT(roiIndex, shapeIndex);
                            if (pathTheTValue != null) {
                                dest.setPathTheT(pathTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pathTheZValue = src.getPathTheZ(roiIndex, shapeIndex);
                            if (pathTheZValue != null) {
                                dest.setPathTheZ(pathTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pathTransformValue = src.getPathTransform(roiIndex, shapeIndex);
                            if (pathTransformValue != null) {
                                dest.setPathTransform(pathTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pointDescriptionValue = src.getPointDescription(roiIndex, shapeIndex);
                            if (pointDescriptionValue != null) {
                                dest.setPointDescription(pointDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer pointFillValue = src.getPointFill(roiIndex, shapeIndex);
                            if (pointFillValue != null) {
                                dest.setPointFill(pointFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pointFontSizeValue = src.getPointFontSize(roiIndex, shapeIndex);
                            if (pointFontSizeValue != null) {
                                dest.setPointFontSize(pointFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pointIDValue = src.getPointID(roiIndex, shapeIndex);
                            if (pointIDValue != null) {
                                dest.setPointID(pointIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pointLabelValue = src.getPointLabel(roiIndex, shapeIndex);
                            if (pointLabelValue != null) {
                                dest.setPointLabel(pointLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pointNameValue = src.getPointName(roiIndex, shapeIndex);
                            if (pointNameValue != null) {
                                dest.setPointName(pointNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer pointStrokeValue = src.getPointStroke(roiIndex, shapeIndex);
                            if (pointStrokeValue != null) {
                                dest.setPointStroke(pointStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pointStrokeDashArrayValue = src.getPointStrokeDashArray(roiIndex, shapeIndex);
                            if (pointStrokeDashArrayValue != null) {
                                dest.setPointStrokeDashArray(pointStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double pointStrokeWidthValue = src.getPointStrokeWidth(roiIndex, shapeIndex);
                            if (pointStrokeWidthValue != null) {
                                dest.setPointStrokeWidth(pointStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pointTheCValue = src.getPointTheC(roiIndex, shapeIndex);
                            if (pointTheCValue != null) {
                                dest.setPointTheC(pointTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pointTheTValue = src.getPointTheT(roiIndex, shapeIndex);
                            if (pointTheTValue != null) {
                                dest.setPointTheT(pointTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger pointTheZValue = src.getPointTheZ(roiIndex, shapeIndex);
                            if (pointTheZValue != null) {
                                dest.setPointTheZ(pointTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String pointTransformValue = src.getPointTransform(roiIndex, shapeIndex);
                            if (pointTransformValue != null) {
                                dest.setPointTransform(pointTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double pointXValue = src.getPointX(roiIndex, shapeIndex);
                            if (pointXValue != null) {
                                dest.setPointX(pointXValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double pointYValue = src.getPointY(roiIndex, shapeIndex);
                            if (pointYValue != null) {
                                dest.setPointY(pointYValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Boolean polylineClosedValue = src.getPolylineClosed(roiIndex, shapeIndex);
                            if (polylineClosedValue != null) {
                                dest.setPolylineClosed(polylineClosedValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylineDescriptionValue = src.getPolylineDescription(roiIndex, shapeIndex);
                            if (polylineDescriptionValue != null) {
                                dest.setPolylineDescription(polylineDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer polylineFillValue = src.getPolylineFill(roiIndex, shapeIndex);
                            if (polylineFillValue != null) {
                                dest.setPolylineFill(polylineFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger polylineFontSizeValue = src.getPolylineFontSize(roiIndex, shapeIndex);
                            if (polylineFontSizeValue != null) {
                                dest.setPolylineFontSize(polylineFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylineIDValue = src.getPolylineID(roiIndex, shapeIndex);
                            if (polylineIDValue != null) {
                                dest.setPolylineID(polylineIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylineLabelValue = src.getPolylineLabel(roiIndex, shapeIndex);
                            if (polylineLabelValue != null) {
                                dest.setPolylineLabel(polylineLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylineNameValue = src.getPolylineName(roiIndex, shapeIndex);
                            if (polylineNameValue != null) {
                                dest.setPolylineName(polylineNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylinePointsValue = src.getPolylinePoints(roiIndex, shapeIndex);
                            if (polylinePointsValue != null) {
                                dest.setPolylinePoints(polylinePointsValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer polylineStrokeValue = src.getPolylineStroke(roiIndex, shapeIndex);
                            if (polylineStrokeValue != null) {
                                dest.setPolylineStroke(polylineStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylineStrokeDashArrayValue = src.getPolylineStrokeDashArray(roiIndex, shapeIndex);
                            if (polylineStrokeDashArrayValue != null) {
                                dest.setPolylineStrokeDashArray(polylineStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double polylineStrokeWidthValue = src.getPolylineStrokeWidth(roiIndex, shapeIndex);
                            if (polylineStrokeWidthValue != null) {
                                dest.setPolylineStrokeWidth(polylineStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger polylineTheCValue = src.getPolylineTheC(roiIndex, shapeIndex);
                            if (polylineTheCValue != null) {
                                dest.setPolylineTheC(polylineTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger polylineTheTValue = src.getPolylineTheT(roiIndex, shapeIndex);
                            if (polylineTheTValue != null) {
                                dest.setPolylineTheT(polylineTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger polylineTheZValue = src.getPolylineTheZ(roiIndex, shapeIndex);
                            if (polylineTheZValue != null) {
                                dest.setPolylineTheZ(polylineTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String polylineTransformValue = src.getPolylineTransform(roiIndex, shapeIndex);
                            if (polylineTransformValue != null) {
                                dest.setPolylineTransform(polylineTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String rectangleDescriptionValue = src.getRectangleDescription(roiIndex, shapeIndex);
                            if (rectangleDescriptionValue != null) {
                                dest.setRectangleDescription(rectangleDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer rectangleFillValue = src.getRectangleFill(roiIndex, shapeIndex);
                            if (rectangleFillValue != null) {
                                dest.setRectangleFill(rectangleFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger rectangleFontSizeValue = src.getRectangleFontSize(roiIndex, shapeIndex);
                            if (rectangleFontSizeValue != null) {
                                dest.setRectangleFontSize(rectangleFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double rectangleHeightValue = src.getRectangleHeight(roiIndex, shapeIndex);
                            if (rectangleHeightValue != null) {
                                dest.setRectangleHeight(rectangleHeightValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String rectangleIDValue = src.getRectangleID(roiIndex, shapeIndex);
                            if (rectangleIDValue != null) {
                                dest.setRectangleID(rectangleIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String rectangleLabelValue = src.getRectangleLabel(roiIndex, shapeIndex);
                            if (rectangleLabelValue != null) {
                                dest.setRectangleLabel(rectangleLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String rectangleNameValue = src.getRectangleName(roiIndex, shapeIndex);
                            if (rectangleNameValue != null) {
                                dest.setRectangleName(rectangleNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer rectangleStrokeValue = src.getRectangleStroke(roiIndex, shapeIndex);
                            if (rectangleStrokeValue != null) {
                                dest.setRectangleStroke(rectangleStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String rectangleStrokeDashArrayValue = src.getRectangleStrokeDashArray(roiIndex, shapeIndex);
                            if (rectangleStrokeDashArrayValue != null) {
                                dest.setRectangleStrokeDashArray(rectangleStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double rectangleStrokeWidthValue = src.getRectangleStrokeWidth(roiIndex, shapeIndex);
                            if (rectangleStrokeWidthValue != null) {
                                dest.setRectangleStrokeWidth(rectangleStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger rectangleTheCValue = src.getRectangleTheC(roiIndex, shapeIndex);
                            if (rectangleTheCValue != null) {
                                dest.setRectangleTheC(rectangleTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger rectangleTheTValue = src.getRectangleTheT(roiIndex, shapeIndex);
                            if (rectangleTheTValue != null) {
                                dest.setRectangleTheT(rectangleTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger rectangleTheZValue = src.getRectangleTheZ(roiIndex, shapeIndex);
                            if (rectangleTheZValue != null) {
                                dest.setRectangleTheZ(rectangleTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String rectangleTransformValue = src.getRectangleTransform(roiIndex, shapeIndex);
                            if (rectangleTransformValue != null) {
                                dest.setRectangleTransform(rectangleTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double rectangleWidthValue = src.getRectangleWidth(roiIndex, shapeIndex);
                            if (rectangleWidthValue != null) {
                                dest.setRectangleWidth(rectangleWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double rectangleXValue = src.getRectangleX(roiIndex, shapeIndex);
                            if (rectangleXValue != null) {
                                dest.setRectangleX(rectangleXValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double rectangleYValue = src.getRectangleY(roiIndex, shapeIndex);
                            if (rectangleYValue != null) {
                                dest.setRectangleY(rectangleYValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textDescriptionValue = src.getTextDescription(roiIndex, shapeIndex);
                            if (textDescriptionValue != null) {
                                dest.setTextDescription(textDescriptionValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer textFillValue = src.getTextFill(roiIndex, shapeIndex);
                            if (textFillValue != null) {
                                dest.setTextFill(textFillValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger textFontSizeValue = src.getTextFontSize(roiIndex, shapeIndex);
                            if (textFontSizeValue != null) {
                                dest.setTextFontSize(textFontSizeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textIDValue = src.getTextID(roiIndex, shapeIndex);
                            if (textIDValue != null) {
                                dest.setTextID(textIDValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textLabelValue = src.getTextLabel(roiIndex, shapeIndex);
                            if (textLabelValue != null) {
                                dest.setTextLabel(textLabelValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textNameValue = src.getTextName(roiIndex, shapeIndex);
                            if (textNameValue != null) {
                                dest.setTextName(textNameValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Integer textStrokeValue = src.getTextStroke(roiIndex, shapeIndex);
                            if (textStrokeValue != null) {
                                dest.setTextStroke(textStrokeValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textStrokeDashArrayValue = src.getTextStrokeDashArray(roiIndex, shapeIndex);
                            if (textStrokeDashArrayValue != null) {
                                dest.setTextStrokeDashArray(textStrokeDashArrayValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double textStrokeWidthValue = src.getTextStrokeWidth(roiIndex, shapeIndex);
                            if (textStrokeWidthValue != null) {
                                dest.setTextStrokeWidth(textStrokeWidthValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger textTheCValue = src.getTextTheC(roiIndex, shapeIndex);
                            if (textTheCValue != null) {
                                dest.setTextTheC(textTheCValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger textTheTValue = src.getTextTheT(roiIndex, shapeIndex);
                            if (textTheTValue != null) {
                                dest.setTextTheT(textTheTValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            NonNegativeInteger textTheZValue = src.getTextTheZ(roiIndex, shapeIndex);
                            if (textTheZValue != null) {
                                dest.setTextTheZ(textTheZValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textTransformValue = src.getTextTransform(roiIndex, shapeIndex);
                            if (textTransformValue != null) {
                                dest.setTextTransform(textTransformValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            String textValueValue = src.getTextValue(roiIndex, shapeIndex);
                            if (textValueValue != null) {
                                dest.setTextValue(textValueValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double textXValue = src.getTextX(roiIndex, shapeIndex);
                            if (textXValue != null) {
                                dest.setTextX(textXValue, roiIndex, shapeIndex);
                            }
                        }
                        catch (NullPointerException e) {
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                        try {
                            Double textYValue = src.getTextY(roiIndex, shapeIndex);
                            if (textYValue == null) continue;
                            dest.setTextY(textYValue, roiIndex, shapeIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                        catch (ClassCastException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int screenCount = src.getScreenCount();
            for (int screenIndex = 0; screenIndex < screenCount; ++screenIndex) {
                try {
                    int annotationRefCount = src.getScreenAnnotationRefCount(screenIndex);
                    for (int annotationRefIndex11 = 0; annotationRefIndex11 < annotationRefCount; ++annotationRefIndex11) {
                        String screenAnnotationRefValue = src.getScreenAnnotationRef(screenIndex, annotationRefIndex11);
                        if (screenAnnotationRefValue == null) continue;
                        dest.setScreenAnnotationRef(screenAnnotationRefValue, screenIndex, annotationRefIndex11);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenDescriptionValue = src.getScreenDescription(screenIndex);
                    if (screenDescriptionValue != null) {
                        dest.setScreenDescription(screenDescriptionValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenIDValue = src.getScreenID(screenIndex);
                    if (screenIDValue != null) {
                        dest.setScreenID(screenIDValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenNameValue = src.getScreenName(screenIndex);
                    if (screenNameValue != null) {
                        dest.setScreenName(screenNameValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int plateRefCount = src.getPlateRefCount(screenIndex);
                    for (int plateRefIndex = 0; plateRefIndex < plateRefCount; ++plateRefIndex) {
                        String screenPlateRefValue = src.getScreenPlateRef(screenIndex, plateRefIndex);
                        if (screenPlateRefValue == null) continue;
                        dest.setScreenPlateRef(screenPlateRefValue, screenIndex, plateRefIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenProtocolDescriptionValue = src.getScreenProtocolDescription(screenIndex);
                    if (screenProtocolDescriptionValue != null) {
                        dest.setScreenProtocolDescription(screenProtocolDescriptionValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenProtocolIdentifierValue = src.getScreenProtocolIdentifier(screenIndex);
                    if (screenProtocolIdentifierValue != null) {
                        dest.setScreenProtocolIdentifier(screenProtocolIdentifierValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenReagentSetDescriptionValue = src.getScreenReagentSetDescription(screenIndex);
                    if (screenReagentSetDescriptionValue != null) {
                        dest.setScreenReagentSetDescription(screenReagentSetDescriptionValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenReagentSetIdentifierValue = src.getScreenReagentSetIdentifier(screenIndex);
                    if (screenReagentSetIdentifierValue != null) {
                        dest.setScreenReagentSetIdentifier(screenReagentSetIdentifierValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String screenTypeValue = src.getScreenType(screenIndex);
                    if (screenTypeValue != null) {
                        dest.setScreenType(screenTypeValue, screenIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    int reagentCount = src.getReagentCount(screenIndex);
                    for (int reagentIndex = 0; reagentIndex < reagentCount; ++reagentIndex) {
                        try {
                            int annotationRefCount = src.getReagentAnnotationRefCount(screenIndex, reagentIndex);
                            for (annotationRefIndex = 0; annotationRefIndex < annotationRefCount; ++annotationRefIndex) {
                                String reagentAnnotationRefValue = src.getReagentAnnotationRef(screenIndex, reagentIndex, annotationRefIndex);
                                if (reagentAnnotationRefValue == null) continue;
                                dest.setReagentAnnotationRef(reagentAnnotationRefValue, screenIndex, reagentIndex, annotationRefIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String reagentDescriptionValue = src.getReagentDescription(screenIndex, reagentIndex);
                            if (reagentDescriptionValue != null) {
                                dest.setReagentDescription(reagentDescriptionValue, screenIndex, reagentIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String reagentIDValue = src.getReagentID(screenIndex, reagentIndex);
                            if (reagentIDValue != null) {
                                dest.setReagentID(reagentIDValue, screenIndex, reagentIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String reagentNameValue = src.getReagentName(screenIndex, reagentIndex);
                            if (reagentNameValue != null) {
                                dest.setReagentName(reagentNameValue, screenIndex, reagentIndex);
                            }
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                        try {
                            String reagentReagentIdentifierValue = src.getReagentReagentIdentifier(screenIndex, reagentIndex);
                            if (reagentReagentIdentifierValue == null) continue;
                            dest.setReagentReagentIdentifier(reagentReagentIdentifierValue, screenIndex, reagentIndex);
                            continue;
                        }
                        catch (NullPointerException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int commentAnnotationCount = src.getCommentAnnotationCount();
            for (int stringAnnotationIndex = 0; stringAnnotationIndex < commentAnnotationCount; ++stringAnnotationIndex) {
                try {
                    String stringAnnotationIDValue = src.getCommentAnnotationID(stringAnnotationIndex);
                    if (stringAnnotationIDValue != null) {
                        dest.setCommentAnnotationID(stringAnnotationIDValue, stringAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String stringAnnotationNamespaceValue = src.getCommentAnnotationNamespace(stringAnnotationIndex);
                    if (stringAnnotationNamespaceValue != null) {
                        dest.setCommentAnnotationNamespace(stringAnnotationNamespaceValue, stringAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String stringAnnotationValueValue = src.getCommentAnnotationValue(stringAnnotationIndex);
                    if (stringAnnotationValueValue == null) continue;
                    dest.setCommentAnnotationValue(stringAnnotationValueValue, stringAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int timestampAnnotationCount = src.getTimestampAnnotationCount();
            for (int timestampAnnotationIndex = 0; timestampAnnotationIndex < timestampAnnotationCount; ++timestampAnnotationIndex) {
                try {
                    String timestampAnnotationIDValue = src.getTimestampAnnotationID(timestampAnnotationIndex);
                    if (timestampAnnotationIDValue != null) {
                        dest.setTimestampAnnotationID(timestampAnnotationIDValue, timestampAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String timestampAnnotationNamespaceValue = src.getTimestampAnnotationNamespace(timestampAnnotationIndex);
                    if (timestampAnnotationNamespaceValue != null) {
                        dest.setTimestampAnnotationNamespace(timestampAnnotationNamespaceValue, timestampAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String timestampAnnotationValueValue = src.getTimestampAnnotationValue(timestampAnnotationIndex);
                    if (timestampAnnotationValueValue == null) continue;
                    dest.setTimestampAnnotationValue(timestampAnnotationValueValue, timestampAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int xmlAnnotationCount = src.getXMLAnnotationCount();
            for (int xmlAnnotationIndex = 0; xmlAnnotationIndex < xmlAnnotationCount; ++xmlAnnotationIndex) {
                try {
                    String xmlAnnotationIDValue = src.getXMLAnnotationID(xmlAnnotationIndex);
                    if (xmlAnnotationIDValue != null) {
                        dest.setXMLAnnotationID(xmlAnnotationIDValue, xmlAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String xmlAnnotationNamespaceValue = src.getXMLAnnotationNamespace(xmlAnnotationIndex);
                    if (xmlAnnotationNamespaceValue != null) {
                        dest.setXMLAnnotationNamespace(xmlAnnotationNamespaceValue, xmlAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String xmlAnnotationValueValue = src.getXMLAnnotationValue(xmlAnnotationIndex);
                    if (xmlAnnotationValueValue == null) continue;
                    dest.setXMLAnnotationValue(xmlAnnotationValueValue, xmlAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int tagAnnotationCount = src.getTagAnnotationCount();
            for (int tagAnnotationIndex = 0; tagAnnotationIndex < tagAnnotationCount; ++tagAnnotationIndex) {
                try {
                    String tagAnnotationIDValue = src.getTagAnnotationID(tagAnnotationIndex);
                    if (tagAnnotationIDValue != null) {
                        dest.setTagAnnotationID(tagAnnotationIDValue, tagAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String tagAnnotationNamespaceValue = src.getTagAnnotationNamespace(tagAnnotationIndex);
                    if (tagAnnotationNamespaceValue != null) {
                        dest.setTagAnnotationNamespace(tagAnnotationNamespaceValue, tagAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String tagAnnotationValueValue = src.getTagAnnotationValue(tagAnnotationIndex);
                    if (tagAnnotationValueValue == null) continue;
                    dest.setTagAnnotationValue(tagAnnotationValueValue, tagAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            int termAnnotationCount = src.getTermAnnotationCount();
            for (int termAnnotationIndex = 0; termAnnotationIndex < termAnnotationCount; ++termAnnotationIndex) {
                try {
                    String termAnnotationIDValue = src.getTermAnnotationID(termAnnotationIndex);
                    if (termAnnotationIDValue != null) {
                        dest.setTermAnnotationID(termAnnotationIDValue, termAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String termAnnotationNamespaceValue = src.getTermAnnotationNamespace(termAnnotationIndex);
                    if (termAnnotationNamespaceValue != null) {
                        dest.setTermAnnotationNamespace(termAnnotationNamespaceValue, termAnnotationIndex);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String termAnnotationValueValue = src.getTermAnnotationValue(termAnnotationIndex);
                    if (termAnnotationValueValue == null) continue;
                    dest.setTermAnnotationValue(termAnnotationValueValue, termAnnotationIndex);
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void convertLightSources(MetadataRetrieve src, MetadataStore dest, int instrumentIndex) {
        int lightSourceCount = src.getLightSourceCount(instrumentIndex);
        for (int lightSource = 0; lightSource < lightSourceCount; ++lightSource) {
            String serialNumber;
            Double power;
            String model;
            String manufacturer;
            String lotNumber;
            String id;
            String type = src.getLightSourceType(instrumentIndex, lightSource);
            if (type.equals("Arc")) {
                try {
                    id = src.getArcID(instrumentIndex, lightSource);
                    if (id != null) {
                        dest.setArcID(id, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    lotNumber = src.getArcLotNumber(instrumentIndex, lightSource);
                    if (lotNumber != null) {
                        dest.setArcLotNumber(lotNumber, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    manufacturer = src.getArcManufacturer(instrumentIndex, lightSource);
                    if (manufacturer != null) {
                        dest.setArcManufacturer(manufacturer, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    model = src.getArcModel(instrumentIndex, lightSource);
                    if (model != null) {
                        dest.setArcModel(model, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    power = src.getArcPower(instrumentIndex, lightSource);
                    if (power != null) {
                        dest.setArcPower(power, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    serialNumber = src.getArcSerialNumber(instrumentIndex, lightSource);
                    if (serialNumber != null) {
                        dest.setArcSerialNumber(serialNumber, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    ArcType arcType = src.getArcType(instrumentIndex, lightSource);
                    if (arcType == null) continue;
                    dest.setArcType(arcType, instrumentIndex, lightSource);
                }
                catch (NullPointerException e) {}
                continue;
            }
            if (type.equals("Filament")) {
                try {
                    id = src.getFilamentID(instrumentIndex, lightSource);
                    if (id != null) {
                        dest.setFilamentID(id, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    lotNumber = src.getFilamentLotNumber(instrumentIndex, lightSource);
                    if (lotNumber != null) {
                        dest.setFilamentLotNumber(lotNumber, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    manufacturer = src.getFilamentManufacturer(instrumentIndex, lightSource);
                    if (manufacturer != null) {
                        dest.setFilamentManufacturer(manufacturer, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    model = src.getFilamentModel(instrumentIndex, lightSource);
                    if (model != null) {
                        dest.setFilamentModel(model, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    power = src.getFilamentPower(instrumentIndex, lightSource);
                    if (power != null) {
                        dest.setFilamentPower(power, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    serialNumber = src.getFilamentSerialNumber(instrumentIndex, lightSource);
                    if (serialNumber != null) {
                        dest.setFilamentSerialNumber(serialNumber, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    FilamentType filamentType = src.getFilamentType(instrumentIndex, lightSource);
                    if (filamentType == null) continue;
                    dest.setFilamentType(filamentType, instrumentIndex, lightSource);
                }
                catch (NullPointerException e) {}
                continue;
            }
            if (type.equals("Laser")) {
                try {
                    id = src.getLaserID(instrumentIndex, lightSource);
                    if (id != null) {
                        dest.setLaserID(id, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    lotNumber = src.getLaserLotNumber(instrumentIndex, lightSource);
                    if (lotNumber != null) {
                        dest.setLaserLotNumber(lotNumber, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    manufacturer = src.getLaserManufacturer(instrumentIndex, lightSource);
                    if (manufacturer != null) {
                        dest.setLaserManufacturer(manufacturer, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    model = src.getLaserModel(instrumentIndex, lightSource);
                    if (model != null) {
                        dest.setLaserModel(model, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    power = src.getLaserPower(instrumentIndex, lightSource);
                    if (power != null) {
                        dest.setLaserPower(power, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    serialNumber = src.getLaserSerialNumber(instrumentIndex, lightSource);
                    if (serialNumber != null) {
                        dest.setLaserSerialNumber(serialNumber, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    LaserType laserType = src.getLaserType(instrumentIndex, lightSource);
                    if (laserType != null) {
                        dest.setLaserType(laserType, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger frequencyMultiplication = src.getLaserFrequencyMultiplication(instrumentIndex, lightSource);
                    if (frequencyMultiplication != null) {
                        dest.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    LaserMedium medium = src.getLaserLaserMedium(instrumentIndex, lightSource);
                    if (medium != null) {
                        dest.setLaserLaserMedium(medium, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Boolean pockelCell = src.getLaserPockelCell(instrumentIndex, lightSource);
                    if (pockelCell != null) {
                        dest.setLaserPockelCell(pockelCell, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Pulse pulse = src.getLaserPulse(instrumentIndex, lightSource);
                    if (pulse != null) {
                        dest.setLaserPulse(pulse, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    String pump = src.getLaserPump(instrumentIndex, lightSource);
                    if (pump != null) {
                        dest.setLaserPump(pump, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Double repetitionRate = src.getLaserRepetitionRate(instrumentIndex, lightSource);
                    if (repetitionRate != null) {
                        dest.setLaserRepetitionRate(repetitionRate, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    Boolean tuneable = src.getLaserTuneable(instrumentIndex, lightSource);
                    if (tuneable != null) {
                        dest.setLaserTuneable(tuneable, instrumentIndex, lightSource);
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    PositiveInteger wavelength = src.getLaserWavelength(instrumentIndex, lightSource);
                    if (wavelength == null) continue;
                    dest.setLaserWavelength(wavelength, instrumentIndex, lightSource);
                }
                catch (NullPointerException e) {}
                continue;
            }
            if (!type.equals("LightEmittingDiode")) continue;
            try {
                id = src.getLightEmittingDiodeID(instrumentIndex, lightSource);
                if (id != null) {
                    dest.setLightEmittingDiodeID(id, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                lotNumber = src.getLightEmittingDiodeLotNumber(instrumentIndex, lightSource);
                if (lotNumber != null) {
                    dest.setLightEmittingDiodeLotNumber(lotNumber, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                manufacturer = src.getLightEmittingDiodeManufacturer(instrumentIndex, lightSource);
                if (manufacturer != null) {
                    dest.setLightEmittingDiodeManufacturer(manufacturer, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                model = src.getLightEmittingDiodeModel(instrumentIndex, lightSource);
                if (model != null) {
                    dest.setLightEmittingDiodeModel(model, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                power = src.getLightEmittingDiodePower(instrumentIndex, lightSource);
                if (power != null) {
                    dest.setLightEmittingDiodePower(power, instrumentIndex, lightSource);
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                serialNumber = src.getLightEmittingDiodeSerialNumber(instrumentIndex, lightSource);
                if (serialNumber == null) continue;
                dest.setLightEmittingDiodeSerialNumber(serialNumber, instrumentIndex, lightSource);
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

